/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.llm;

import com.intellij.jupyter.core.core.api.actions.NotebookCellLinesEditHelper;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellLinesDocumentUtils;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellLinesEditorUtils;
import com.intellij.jupyter.core.jupyter.actions.ActionDestination;
import com.intellij.notebooks.jupyter.core.jupyter.CellType;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tJ\"\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJJ\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0016H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jupyter/core/core/impl/llm/NotebookCellLinesLLmActionUtil;", "", "<init>", "()V", "insertCodeCellBelow", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "editor", "Lcom/intellij/openapi/editor/Editor;", "text", "", "insertCellBelow", "cellType", "Lcom/intellij/notebooks/jupyter/core/jupyter/CellType;", "changeCellText", "", "newText", "interval", "insertCell", "direction", "Lcom/intellij/jupyter/core/jupyter/actions/ActionDestination;", "customHeader", "keepEmptyCell", "", "selectNewCell", "intellij.jupyter.core"})
public final class NotebookCellLinesLLmActionUtil {
    @NotNull
    public static final NotebookCellLinesLLmActionUtil INSTANCE = new NotebookCellLinesLLmActionUtil();

    private NotebookCellLinesLLmActionUtil() {
    }

    @Nullable
    public final NotebookCellLines.Interval insertCodeCellBelow(@NotNull Editor editor, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.insertCellBelow(editor, text, CellType.CODE);
    }

    public static /* synthetic */ NotebookCellLines.Interval insertCodeCellBelow$default(NotebookCellLinesLLmActionUtil notebookCellLinesLLmActionUtil, Editor editor, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return notebookCellLinesLLmActionUtil.insertCodeCellBelow(editor, string);
    }

    @Nullable
    public final NotebookCellLines.Interval insertCellBelow(@NotNull Editor editor, @NotNull String text, @NotNull CellType cellType) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)cellType, (String)"cellType");
        return NotebookCellLinesLLmActionUtil.insertCell$default(this, editor, text, ActionDestination.DOWN, cellType, null, true, false, 64, null);
    }

    public static /* synthetic */ NotebookCellLines.Interval insertCellBelow$default(NotebookCellLinesLLmActionUtil notebookCellLinesLLmActionUtil, Editor editor, String string, CellType cellType, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return notebookCellLinesLLmActionUtil.insertCellBelow(editor, string, cellType);
    }

    public final void changeCellText(@NotNull Editor editor, @NotNull String newText, @NotNull NotebookCellLines.Interval interval, @NotNull CellType cellType) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        Intrinsics.checkNotNullParameter((Object)cellType, (String)"cellType");
        NotebookCellLines cellLines = NotebookCellLines.Companion.get(editor);
        NotebookCellLinesEditHelper notebookCellLinesEditHelper = NotebookCellLinesEditHelper.Companion.getOrNull(editor);
        if (notebookCellLinesEditHelper == null) {
            return;
        }
        NotebookCellLinesEditHelper editHelper = notebookCellLinesEditHelper;
        String string = NotebookCellLinesEditHelper.makeCell$default(editHelper, newText, cellType, null, 4, null);
        if (string == null) {
            return;
        }
        String newCellText = string;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        NotebookCellLinesDocumentUtils.INSTANCE.replaceCell(document, cellLines, interval, newCellText);
    }

    private final NotebookCellLines.Interval insertCell(Editor editor, String text, ActionDestination direction, CellType cellType, String customHeader, boolean keepEmptyCell, boolean selectNewCell) {
        if (!(editor instanceof EditorImpl)) {
            return null;
        }
        if (!NotebookCellSelectionModelProviderKt.getHasCellSelectionModelSupport((Editor)editor)) {
            return null;
        }
        NotebookCellLines cellLines = NotebookCellLines.Companion.get(editor);
        NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)editor);
        if (notebookCellSelectionModel == null) {
            return null;
        }
        NotebookCellSelectionModel cellSelection = notebookCellSelectionModel;
        int targetOrdinal = switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> cellSelection.getPrimarySelectedCell().getOrdinal();
            case 2 -> cellSelection.getPrimarySelectedCell().getOrdinal() + 1;
            default -> throw new NoWhenBranchMatchedException();
        };
        Object object = NotebookCellLinesEditHelper.Companion.getOrNull(editor);
        if (object == null || (object = object.makeCell(text, cellType, customHeader)) == null) {
            return null;
        }
        Object cellText = object;
        DocumentEx documentEx = ((EditorImpl)editor).getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        List<NotebookCellLines.Interval> cells = NotebookCellLinesDocumentUtils.INSTANCE.insertCells((Document)documentEx, cellLines, (String)cellText, targetOrdinal, keepEmptyCell);
        NotebookCellLines.Interval cell = (NotebookCellLines.Interval)CollectionsKt.firstOrNull(cells);
        if (cell == null) {
            return null;
        }
        if (selectNewCell) {
            cellSelection.selectSingleCell(cell);
            NotebookCellLinesEditorUtils.INSTANCE.scrollTo(editor, cell.getLines().getFirst(), ScrollType.MAKE_VISIBLE);
        }
        return cell;
    }

    static /* synthetic */ NotebookCellLines.Interval insertCell$default(NotebookCellLinesLLmActionUtil notebookCellLinesLLmActionUtil, Editor editor, String string, ActionDestination actionDestination, CellType cellType, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            bl2 = true;
        }
        return notebookCellLinesLLmActionUtil.insertCell(editor, string, actionDestination, cellType, string2, bl, bl2);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ActionDestination.values().length];
            try {
                nArray[ActionDestination.UP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionDestination.DOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

