/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Key;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.EventDispatcher;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 !2\u00020\u0001:\u0002 !B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u001cJ\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u001cJ\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookGraphicsConfigurationManager;", "Lcom/intellij/openapi/Disposable;", "component", "Ljava/awt/Container;", "<init>", "(Ljava/awt/Container;)V", "listeners", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookGraphicsConfigurationManager$ScreenScaleChangedListener;", "getListeners", "()Lcom/intellij/util/EventDispatcher;", "value", "", "screenScale", "getScreenScale", "()F", "", "hiDpi", "getHiDpi", "()Z", "propertyChangeListener", "Ljava/beans/PropertyChangeListener;", "dispose", "", "scaleUpRect", "Ljava/awt/Rectangle;", "rectangle", "scaleDownHiDPIAware", "", "scaleUpHiDPIAware", "scaleUp", "scaleDown", "ScreenScaleChangedListener", "Companion", "intellij.jupyter.core"})
public final class NotebookGraphicsConfigurationManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Container component;
    @NotNull
    private final EventDispatcher<ScreenScaleChangedListener> listeners;
    private float screenScale;
    private boolean hiDpi;
    @NotNull
    private final PropertyChangeListener propertyChangeListener;
    @NotNull
    private static final Key<NotebookGraphicsConfigurationManager> KEY = new Key("NotebookGraphicsConfigurationManager");

    private NotebookGraphicsConfigurationManager(Container component2) {
        this.component = component2;
        EventDispatcher eventDispatcher = EventDispatcher.create(ScreenScaleChangedListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.listeners = eventDispatcher;
        this.screenScale = JBUIScale.sysScale((GraphicsConfiguration)this.component.getGraphicsConfiguration());
        this.hiDpi = JreHiDpiUtil.isJreHiDPI((GraphicsConfiguration)this.component.getGraphicsConfiguration());
        this.propertyChangeListener = arg_0 -> NotebookGraphicsConfigurationManager.propertyChangeListener$lambda$0(this, arg_0);
        this.component.addPropertyChangeListener("graphicsConfiguration", this.propertyChangeListener);
    }

    @NotNull
    public final EventDispatcher<ScreenScaleChangedListener> getListeners() {
        return this.listeners;
    }

    public final float getScreenScale() {
        return this.screenScale;
    }

    public final boolean getHiDpi() {
        return this.hiDpi;
    }

    public void dispose() {
        this.component.removePropertyChangeListener(this.propertyChangeListener);
    }

    @NotNull
    public final Rectangle scaleUpRect(@NotNull Rectangle rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        return new Rectangle(this.scaleUp(rectangle.x), this.scaleUp(rectangle.y), this.scaleUp(rectangle.width), this.scaleUp(rectangle.height));
    }

    public final int scaleDownHiDPIAware(int value) {
        return this.hiDpi ? value : this.scaleDown(value);
    }

    public final int scaleUpHiDPIAware(int value) {
        return this.hiDpi ? value : this.scaleUp(value);
    }

    public final int scaleUp(int value) {
        return (int)Math.ceil((float)value * this.screenScale);
    }

    public final int scaleDown(int value) {
        return MathKt.roundToInt((float)((float)value / this.screenScale));
    }

    private static final void propertyChangeListener$lambda$0(NotebookGraphicsConfigurationManager this$0, PropertyChangeEvent it) {
        float newScale = JBUIScale.sysScale((GraphicsConfiguration)this$0.component.getGraphicsConfiguration());
        boolean newHiDpi = JreHiDpiUtil.isJreHiDPI((GraphicsConfiguration)this$0.component.getGraphicsConfiguration());
        if (!(this$0.screenScale == newScale) || newHiDpi != this$0.hiDpi) {
            this$0.screenScale = newScale;
            this$0.hiDpi = newHiDpi;
            ((ScreenScaleChangedListener)this$0.listeners.getMulticaster()).screenScaleChanged(newScale);
        }
    }

    public /* synthetic */ NotebookGraphicsConfigurationManager(Container component2, DefaultConstructorMarker $constructor_marker) {
        this(component2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookGraphicsConfigurationManager$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookGraphicsConfigurationManager;", "get", "editor", "Lcom/intellij/openapi/editor/Editor;", "getScreenScale", "", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NotebookGraphicsConfigurationManager get(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            NotebookGraphicsConfigurationManager manager = (NotebookGraphicsConfigurationManager)editor.getUserData(KEY);
            if (manager == null) {
                JComponent jComponent = editor.getContentComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
                manager = new NotebookGraphicsConfigurationManager(jComponent, null);
                editor.putUserData(KEY, (Object)manager);
            }
            return manager;
        }

        public final float getScreenScale(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return this.get(editor).getScreenScale();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookGraphicsConfigurationManager$ScreenScaleChangedListener;", "Ljava/util/EventListener;", "screenScaleChanged", "", "newScale", "", "intellij.jupyter.core"})
    public static interface ScreenScaleChangedListener
    extends EventListener {
        public void screenScaleChanged(float var1);
    }
}

