/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.messages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.jupyter.messages.processors.JupyterMessageProcessor;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 '2\u00020\u0001:\u0001'B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0014H\u0007\u00a2\u0006\u0002\u0010\u0015J!\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0016H\u0007\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\u00192\u0010\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001bJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u00c6\u0003J7\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u00c6\u0001J\u0014\u0010\"\u001a\u00020\u00192\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010$\u001a\u00020%H\u00d6\u0081\u0004J\n\u0010&\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006("}, d2={"Lcom/intellij/jupyter/core/jupyter/messages/JupyterMessageWrapper;", "", "type", "", "data", "Lcom/fasterxml/jackson/databind/JsonNode;", "metadata", "buffers", "", "<init>", "(Ljava/lang/String;Lcom/fasterxml/jackson/databind/JsonNode;Lcom/fasterxml/jackson/databind/JsonNode;Ljava/util/List;)V", "getType", "()Ljava/lang/String;", "getData", "()Lcom/fasterxml/jackson/databind/JsonNode;", "getMetadata", "getBuffers", "()Ljava/util/List;", "getAsMessage", "T", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "Lcom/fasterxml/jackson/core/type/TypeReference;", "(Lcom/fasterxml/jackson/core/type/TypeReference;)Ljava/lang/Object;", "process", "", "processors", "", "Lcom/intellij/jupyter/core/jupyter/messages/processors/JupyterMessageProcessor;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterMessageWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterMessageWrapper.kt\ncom/intellij/jupyter/core/jupyter/messages/JupyterMessageWrapper\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n23#2:58\n296#3,2:59\n*S KotlinDebug\n*F\n+ 1 JupyterMessageWrapper.kt\ncom/intellij/jupyter/core/jupyter/messages/JupyterMessageWrapper\n*L\n42#1:58\n53#1:59,2\n*E\n"})
public final class JupyterMessageWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String type;
    @NotNull
    private final JsonNode data;
    @NotNull
    private final JsonNode metadata;
    @NotNull
    private final List<String> buffers;

    public JupyterMessageWrapper(@NotNull String type, @NotNull JsonNode data, @NotNull JsonNode metadata, @NotNull List<String> buffers) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter(buffers, (String)"buffers");
        this.type = type;
        this.data = data;
        this.metadata = metadata;
        this.buffers = buffers;
    }

    public /* synthetic */ JupyterMessageWrapper(String string, JsonNode jsonNode, JsonNode jsonNode2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            jsonNode2 = (JsonNode)new ObjectNode(new JsonNodeFactory(false));
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, jsonNode, jsonNode2, list);
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final JsonNode getData() {
        return this.data;
    }

    @NotNull
    public final JsonNode getMetadata() {
        return this.metadata;
    }

    @NotNull
    public final List<String> getBuffers() {
        return this.buffers;
    }

    @JsonIgnore
    public final <T> T getAsMessage(@NotNull Class<T> type) {
        Object object;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        try {
            object = JupyterJsonKt.getJackson().convertValue((Object)this.data, type);
        }
        catch (IllegalArgumentException e) {
            JupyterMessageWrapper $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterMessageWrapper.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Can't deserialize " + this.data + " of type " + this.type + " to " + type);
            throw e;
        }
        return (T)object;
    }

    @JsonIgnore
    public final <T> T getAsMessage(@NotNull TypeReference<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return (T)JupyterJsonKt.getJackson().convertValue((Object)this.data, type);
    }

    public final boolean process(@NotNull Iterable<? extends JupyterMessageProcessor<?>> processors) {
        JupyterMessageProcessor<?> jupyterMessageProcessor;
        block1: {
            Intrinsics.checkNotNullParameter(processors, (String)"processors");
            Iterable<JupyterMessageProcessor<?>> $this$firstOrNull$iv = processors;
            boolean $i$f$firstOrNull = false;
            Iterator<JupyterMessageProcessor<?>> iterator = $this$firstOrNull$iv.iterator();
            while (iterator.hasNext()) {
                JupyterMessageProcessor<?> element$iv;
                JupyterMessageProcessor<?> it = element$iv = iterator.next();
                boolean bl = false;
                if (!it.process(this)) continue;
                jupyterMessageProcessor = element$iv;
                break block1;
            }
            jupyterMessageProcessor = null;
        }
        boolean isSuccess = jupyterMessageProcessor != null;
        return isSuccess;
    }

    @NotNull
    public final String component1() {
        return this.type;
    }

    @NotNull
    public final JsonNode component2() {
        return this.data;
    }

    @NotNull
    public final JsonNode component3() {
        return this.metadata;
    }

    @NotNull
    public final List<String> component4() {
        return this.buffers;
    }

    @NotNull
    public final JupyterMessageWrapper copy(@NotNull String type, @NotNull JsonNode data, @NotNull JsonNode metadata, @NotNull List<String> buffers) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter(buffers, (String)"buffers");
        return new JupyterMessageWrapper(type, data, metadata, buffers);
    }

    public static /* synthetic */ JupyterMessageWrapper copy$default(JupyterMessageWrapper jupyterMessageWrapper, String string, JsonNode jsonNode, JsonNode jsonNode2, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = jupyterMessageWrapper.type;
        }
        if ((n & 2) != 0) {
            jsonNode = jupyterMessageWrapper.data;
        }
        if ((n & 4) != 0) {
            jsonNode2 = jupyterMessageWrapper.metadata;
        }
        if ((n & 8) != 0) {
            list = jupyterMessageWrapper.buffers;
        }
        return jupyterMessageWrapper.copy(string, jsonNode, jsonNode2, list);
    }

    @NotNull
    public String toString() {
        return "JupyterMessageWrapper(type=" + this.type + ", data=" + this.data + ", metadata=" + this.metadata + ", buffers=" + this.buffers + ")";
    }

    public int hashCode() {
        int result2 = this.type.hashCode();
        result2 = result2 * 31 + this.data.hashCode();
        result2 = result2 * 31 + this.metadata.hashCode();
        result2 = result2 * 31 + ((Object)this.buffers).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JupyterMessageWrapper)) {
            return false;
        }
        JupyterMessageWrapper jupyterMessageWrapper = (JupyterMessageWrapper)other;
        if (!Intrinsics.areEqual((Object)this.type, (Object)jupyterMessageWrapper.type)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.data, (Object)jupyterMessageWrapper.data)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.metadata, (Object)jupyterMessageWrapper.metadata)) {
            return false;
        }
        return Intrinsics.areEqual(this.buffers, jupyterMessageWrapper.buffers);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/jupyter/messages/JupyterMessageWrapper$Companion;", "", "<init>", "()V", "fromString", "Lcom/intellij/jupyter/core/jupyter/messages/JupyterMessageWrapper;", "string", "", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JupyterMessageWrapper fromString(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            Object object = JupyterJsonKt.getJackson().readValue(string, JupyterMessageWrapper.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
            return (JupyterMessageWrapper)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

