/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.connections.actions;

import com.intellij.icons.AllIcons;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.JupyterRemoteBundle;
import com.intellij.jupyter.core.jupyter.connections.action.JupyterConnectionActionExtensionsKt;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterKernelState;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessagesKt;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerStarted;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerState;
import com.intellij.jupyter.core.jupyter.connections.settings.JupyterConnectionSettingsManager;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterConfiguredServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterManagedServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterServerConfig;
import com.intellij.jupyter.core.jupyter.helper.JupyterAnActionEventExtensionsKt;
import com.intellij.jupyter.core.jupyter.remote.vfs.JupyterRemoteVirtualFile;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerController;
import com.intellij.jupyter.py.connections.actions.JupyterSwitchServerAction;
import com.intellij.jupyter.py.connections.managed.server.JupyterServerExtensionsKt;
import com.intellij.jupyter.py.helper.JupyterPyExtensionsKt;
import com.intellij.jupyter.py.utils.JupyterPyBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.sdk.PySdkPopupFactory;
import com.jetbrains.python.sdk.configuration.PythonSdkCreationWaiter;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jupyter/py/connections/actions/JupyterServerChooserAction;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$BackendOnly;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getTextForConfig", "", "serverConfig", "Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterServerConfig;", "isDropdown", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "createPopupActionGroup", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterServerChooserAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterServerChooserAction.kt\ncom/intellij/jupyter/py/connections/actions/JupyterServerChooserAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n777#2:192\n873#2,2:193\n1586#2:195\n1661#2,3:196\n*S KotlinDebug\n*F\n+ 1 JupyterServerChooserAction.kt\ncom/intellij/jupyter/py/connections/actions/JupyterServerChooserAction\n*L\n148#1:192\n148#1:193,2\n157#1:195\n157#1:196,3\n*E\n"})
public final class JupyterServerChooserAction
extends DefaultActionGroup
implements DumbAware,
ActionRemoteBehaviorSpecification.BackendOnly {
    public JupyterServerChooserAction() {
        Presentation presentation;
        Presentation $this$_init__u24lambda_u240 = presentation = this.getTemplatePresentation();
        boolean bl = false;
        $this$_init__u24lambda_u240.putClientProperty(ActionUtil.SHOW_TEXT_IN_TOOLBAR, (Object)true);
        $this$_init__u24lambda_u240.putClientProperty(ActionUtil.USE_SMALL_FONT_IN_TOOLBAR, (Object)true);
        $this$_init__u24lambda_u240.setPerformGroup(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        InputEvent inputEvent = e.getInputEvent();
        Object object = inputEvent != null ? inputEvent.getSource() : null;
        Component component = object instanceof Component ? (Component)object : null;
        if (component == null) {
            return;
        }
        Component component2 = component;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Module module = JupyterPyExtensionsKt.getSuggestedModule(dataContext);
        if (module == null) {
            return;
        }
        Module module2 = module;
        DataContext dataContext2 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        Sdk pythonSdk = JupyterPyExtensionsKt.getPythonSdk(dataContext2);
        if (pythonSdk == null) {
            PySdkPopupFactory pySdkPopupFactory = new PySdkPopupFactory(module2);
            DataContext dataContext3 = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext3, (String)"getDataContext(...)");
            pySdkPopupFactory.createPopup(dataContext3).showUnderneathOf(component2);
            return;
        }
        DefaultActionGroup defaultActionGroup = this.createPopupActionGroup(e);
        if (defaultActionGroup == null) {
            return;
        }
        DefaultActionGroup actionGroup = defaultActionGroup;
        JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)actionGroup, e.getDataContext(), null, true, null).showUnderneathOf(component2);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(false);
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        if (JupyterPyExtensionsKt.isKotlinNotebook(dataContext)) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        BackedNotebookVirtualFile notebookFile = JupyterAnActionEventExtensionsKt.getNotebookFile((AnActionEvent)e);
        BackedNotebookVirtualFile backedNotebookVirtualFile = notebookFile;
        if (backedNotebookVirtualFile == null || (backedNotebookVirtualFile = backedNotebookVirtualFile.getFile()) == null) {
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
        DataContext dataContext2 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        Module module = JupyterPyExtensionsKt.getSuggestedModule(dataContext2);
        if (module == null) {
            e.getPresentation().setText(JupyterRemoteBundle.message((String)"action.JupyterServerChooserAction.text.no.module", (Object[])new Object[0]));
            e.getPresentation().setEnabled(false);
            return;
        }
        if (PythonSdkCreationWaiter.INSTANCE.isCreatingSdk(module)) {
            e.getPresentation().setText(JupyterPyBundle.message("progress.text.creating.python.sdk.label", new Object[0]));
            e.getPresentation().setIcon((Icon)new AnimatedIcon.Default());
            return;
        }
        DataContext dataContext3 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext3, (String)"getDataContext(...)");
        Sdk pythonSdk = JupyterPyExtensionsKt.getPythonSdk(dataContext3);
        if (pythonSdk == null) {
            e.getPresentation().setText(JupyterRemoteBundle.message((String)"Jupyter.managed.server.sdk.is.not.selected", (Object[])new Object[0]));
            e.getPresentation().setIcon(AllIcons.General.Warning);
            return;
        }
        JupyterKernelState kernelState = JupyterConnectionActionExtensionsKt.getKernelState((AnActionEvent)e);
        e.getPresentation().setIcon(JupyterMessagesKt.getIconForKernelState((JupyterKernelState)kernelState));
        JupyterServerConfig savedSettings = JupyterConnectionSettingsManager.Companion.getInstance().getConfigForVirtualFileOrDefault(notebookFile, project2);
        e.getPresentation().setText(JupyterServerChooserAction.getTextForConfig$default(this, savedSettings, e, false, 4, null));
    }

    @NlsActions.ActionText
    private final String getTextForConfig(JupyterServerConfig serverConfig, AnActionEvent e, boolean isDropdown) {
        JupyterServerState state;
        String baseText;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Sdk sdk = JupyterPyExtensionsKt.getPythonSdk(dataContext);
        if (sdk == null) {
            return JupyterRemoteBundle.message((String)"Jupyter.managed.server.sdk.is.not.selected", (Object[])new Object[0]);
        }
        Sdk pythonSdk = sdk;
        JupyterServerController managedServerConfiguration = JupyterServerExtensionsKt.getJupyterManagedServerExecution(e);
        String string = pythonSdk.getVersionString();
        if (string == null) {
            String string2 = pythonSdk.getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        }
        String pythonSdkName = string;
        String name = serverConfig.getName();
        JupyterServerConfig jupyterServerConfig = serverConfig;
        String type = jupyterServerConfig instanceof JupyterManagedServerConfig ? ((JupyterManagedServerConfig)serverConfig).getPythonExecutionMode().getOptionName() : (jupyterServerConfig instanceof JupyterConfiguredServerConfig ? ((JupyterConfiguredServerConfig)serverConfig).getAuthType().getTitle() : null);
        String string3 = baseText = type != null ? name + " (" + type + ")" : name;
        if (!isDropdown) {
            return baseText;
        }
        JupyterServerController jupyterServerController = managedServerConfiguration;
        Object object = state = jupyterServerController != null ? jupyterServerController.getState() : null;
        if (!(state instanceof JupyterServerStarted) || !Intrinsics.areEqual((Object)((JupyterServerStarted)state).getConnectionParameters().getConfig(), (Object)serverConfig)) {
            return baseText;
        }
        String string4 = ((JupyterServerStarted)state).getConnectionParameters().getUri().toString();
        Intrinsics.checkNotNull((Object)string4);
        String hostLine = string4;
        String infoText = pythonSdkName + ": " + hostLine;
        String infoColorHex = "#" + ColorUtil.toHex((Color)UIUtil.getLabelInfoForeground());
        Object[] objectArray = new Object[]{baseText, infoColorHex, infoText};
        return JupyterBundle.message((String)"Jupyter.server.chooser.dropdown.entry.html", (Object[])objectArray);
    }

    static /* synthetic */ String getTextForConfig$default(JupyterServerChooserAction jupyterServerChooserAction, JupyterServerConfig jupyterServerConfig, AnActionEvent anActionEvent, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return jupyterServerChooserAction.getTextForConfig(jupyterServerConfig, anActionEvent, bl);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    /*
     * WARNING - void declaration
     */
    private final DefaultActionGroup createPopupActionGroup(AnActionEvent e) {
        Object[] objectArray;
        void $this$mapTo$iv$iv;
        List list;
        Object it;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterAnActionEventExtensionsKt.getNotebookFile((AnActionEvent)e);
        if (backedNotebookVirtualFile == null) {
            return null;
        }
        BackedNotebookVirtualFile notebookFile = backedNotebookVirtualFile;
        VirtualFile virtualFile = notebookFile.getFile();
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        JupyterConnectionSettingsManager settingsManager = JupyterConnectionSettingsManager.Companion.getInstance();
        if (!(virtualFile instanceof JupyterRemoteVirtualFile)) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = settingsManager.getAll();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (JupyterServerConfig)element$iv$iv;
                boolean bl = false;
                if (!(it instanceof JupyterConfiguredServerConfig || it instanceof JupyterManagedServerConfig)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List connections = list;
        JupyterServerConfig selectedConnection = settingsManager.getConfigForVirtualFileOrDefault(notebookFile, project2);
        Iterable $this$map$iv = connections;
        boolean $i$f$map = false;
        Iterable $i$f$filterTo = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void config;
            objectArray = (Object[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String name = this.getTextForConfig((JupyterServerConfig)config, e, true);
            collection.add(new JupyterSwitchServerAction(project2, notebookFile, (JupyterServerConfig)config, selectedConnection, name));
        }
        List selectConnectionActions = (List)destination$iv$iv;
        AnAction openSettingsAction = ActionManager.getInstance().getAction("OpenJupyterSettingsAction");
        AnAction shutdownNotebookAction = ActionManager.getInstance().getAction("JupyterShutdownNotebookAction");
        AnAction switchKernelAction = ActionManager.getInstance().getAction("JupyterKernelManagementAction");
        AnAction connectToServer2 = ActionManager.getInstance().getAction("JupyterConnectToServerAction");
        it = new AnAction[]{Separator.create((String)JupyterRemoteBundle.message((String)"separator.server.actions", (Object[])new Object[0])), connectToServer2, switchKernelAction, shutdownNotebookAction};
        List kernelActions = CollectionsKt.listOfNotNull((Object[])it);
        Object[] objectArray2 = this.getChildren(e);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"getChildren(...)");
        Object[] children = objectArray2;
        objectArray = new AnAction[]{Separator.create(), openSettingsAction};
        List actionList = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)kernelActions, (Object)Separator.create((String)JupyterRemoteBundle.message((String)"separator.config.actions", (Object[])new Object[0]))), (Iterable)selectConnectionActions), (Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)), (Object[])children);
        return new DefaultActionGroup(actionList);
    }
}

