/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.ir.ast;

import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.ir.ast.IrCloner;
import com.intellij.rml.dfa.ir.ast.IrConstant;
import com.intellij.rml.dfa.ir.ast.IrConstantsVisitor;
import com.intellij.rml.dfa.ir.ast.IrType;
import com.intellij.rml.dfa.ir.ast.IrVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0019\u001a\u00020\u0003H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lcom/intellij/rml/dfa/ir/ast/IrStringConstant;", "Lcom/intellij/rml/dfa/ir/ast/IrConstant;", "value", "", "type", "Lcom/intellij/rml/dfa/ir/ast/IrType;", "<init>", "(Ljava/lang/String;Lcom/intellij/rml/dfa/ir/ast/IrType;)V", "getValue", "()Ljava/lang/String;", "getType", "()Lcom/intellij/rml/dfa/ir/ast/IrType;", "accept", "", "visitor", "Lcom/intellij/rml/dfa/ir/ast/IrConstantsVisitor;", "acceptChildren", "Lcom/intellij/rml/dfa/ir/ast/IrVisitor;", "clone", "cloner", "Lcom/intellij/rml/dfa/ir/ast/IrCloner;", "attr", "Lcom/intellij/rml/dfa/attributes/Attribute;", "getAttr", "()Lcom/intellij/rml/dfa/attributes/Attribute;", "toString", "intellij.rml.dfa"})
public final class IrStringConstant
implements IrConstant {
    @NotNull
    private final String value;
    @Nullable
    private final IrType type;
    @NotNull
    private final Attribute attr;

    public IrStringConstant(@NotNull String value, @Nullable IrType type) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
        this.type = type;
        this.attr = new Attribute("\"" + this.value + "\"");
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @Nullable
    public final IrType getType() {
        return this.type;
    }

    @Override
    public void accept(@NotNull IrConstantsVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        visitor.visitStringConstant(this);
    }

    @Override
    public void acceptChildren(@NotNull IrVisitor visitor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
            IrType irType = this.type;
            if (irType == null) break block0;
            irType.accept(visitor);
        }
    }

    @Override
    @NotNull
    public IrConstant clone(@NotNull IrCloner cloner) {
        Intrinsics.checkNotNullParameter((Object)cloner, (String)"cloner");
        return cloner.cloneStringConstant(this);
    }

    @Override
    @NotNull
    public Attribute getAttr() {
        return this.attr;
    }

    @NotNull
    public String toString() {
        return this.value;
    }
}

