/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.findUsagesMl;

import com.intellij.findUsagesMl.FindUsagesFileRankerFeatures;
import com.intellij.findUsagesMl.FindUsagesRankingFileInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.mlapi.feature.Feature;
import com.jetbrains.mlapi.feature.FeatureContainer;
import com.jetbrains.mlapi.feature.FeatureProvider;
import com.jetbrains.mlapi.feature.FeatureSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.text.similarity.JaroWinklerSimilarity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0014J(\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00062\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/findUsagesMl/FindUsagesFileRankerFeatureProvider;", "Lcom/jetbrains/mlapi/feature/FeatureProvider;", "Lcom/intellij/findUsagesMl/FindUsagesRankingFileInfo;", "<init>", "()V", "computeFeatures", "", "Lcom/jetbrains/mlapi/feature/Feature;", "instance", "requiredOutput", "Lcom/jetbrains/mlapi/feature/FeatureSet;", "calculateDirectoryDistance", "", "queryFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "candidateFile", "projectPath", "", "computeNormalizedDistance", "queryFile", "getRecentFilesIndex", "", "recentFilesList", "intellij.findUsagesMl"})
@SourceDebugExtension(value={"SMAP\nFeatureProviders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureProviders.kt\ncom/intellij/findUsagesMl/FindUsagesFileRankerFeatureProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1#2:99\n975#3,7:100\n1586#3:107\n1661#3,3:108\n*S KotlinDebug\n*F\n+ 1 FeatureProviders.kt\ncom/intellij/findUsagesMl/FindUsagesFileRankerFeatureProvider\n*L\n80#1:100,7\n48#1:107\n48#1:108,3\n*E\n"})
public final class FindUsagesFileRankerFeatureProvider
extends FeatureProvider<FindUsagesRankingFileInfo> {
    public FindUsagesFileRankerFeatureProvider() {
        super((FeatureContainer)FindUsagesFileRankerFeatures.INSTANCE, null, 2, null);
    }

    @NotNull
    protected List<Feature> computeFeatures(@NotNull FindUsagesRankingFileInfo instance, @NotNull FeatureSet requiredOutput) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        Intrinsics.checkNotNullParameter((Object)requiredOutput, (String)"requiredOutput");
        return FeatureProvider.Companion.buildLazyFeaturesList(requiredOutput, arg_0 -> FindUsagesFileRankerFeatureProvider.computeFeatures$lambda$0(instance, this, arg_0));
    }

    private final double calculateDirectoryDistance(List<? extends VirtualFile> queryFiles, VirtualFile candidateFile, String projectPath) {
        Double d;
        Iterator iterator = ((Iterable)queryFiles).iterator();
        if (!iterator.hasNext()) {
            d = null;
        } else {
            VirtualFile queryFile = (VirtualFile)iterator.next();
            boolean bl = false;
            double d2 = this.computeNormalizedDistance(queryFile, candidateFile, projectPath);
            while (iterator.hasNext()) {
                VirtualFile queryFile2 = (VirtualFile)iterator.next();
                $i$a$-minOfOrNull-FindUsagesFileRankerFeatureProvider$calculateDirectoryDistance$1 = false;
                double d3 = this.computeNormalizedDistance(queryFile2, candidateFile, projectPath);
                d2 = Math.min(d2, d3);
            }
            d = d2;
        }
        return d != null ? d : 1.0;
    }

    static /* synthetic */ double calculateDirectoryDistance$default(FindUsagesFileRankerFeatureProvider findUsagesFileRankerFeatureProvider, List list, VirtualFile virtualFile, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        return findUsagesFileRankerFeatureProvider.calculateDirectoryDistance(list, virtualFile, string);
    }

    /*
     * WARNING - void declaration
     */
    private final double computeNormalizedDistance(VirtualFile queryFile, VirtualFile candidateFile, String projectPath) {
        void $this$takeWhile$iv;
        String string = queryFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String queryPath = StringsKt.removePrefix((String)StringsKt.removePrefix((String)string, (CharSequence)projectPath), (CharSequence)"/");
        String string2 = candidateFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        String candidatePath = StringsKt.removePrefix((String)StringsKt.removePrefix((String)string2, (CharSequence)projectPath), (CharSequence)"/");
        char[] cArray = new char[]{'/'};
        List queryPathComponents = StringsKt.split$default((CharSequence)queryPath, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        char[] cArray2 = new char[]{'/'};
        List candidatePathComponents = StringsKt.split$default((CharSequence)candidatePath, (char[])cArray2, (boolean)false, (int)0, (int)6, null);
        int maxDistance = queryPathComponents.size() + candidatePathComponents.size();
        Iterable iterable = CollectionsKt.zip((Iterable)queryPathComponents, (Iterable)candidatePathComponents);
        boolean $i$f$takeWhile = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            String b;
            Pair pair = (Pair)item$iv;
            boolean bl = false;
            String a = (String)pair.component1();
            if (!Intrinsics.areEqual((Object)a, (Object)(b = (String)pair.component2()))) break;
            list$iv.add(item$iv);
        }
        int commonPrefixLength = ((Collection)list$iv).size();
        int distance = maxDistance - 2 * commonPrefixLength;
        return maxDistance != 0 ? (double)distance / (double)maxDistance : 0.0;
    }

    private final int getRecentFilesIndex(List<? extends VirtualFile> recentFilesList, VirtualFile candidateFile) {
        int fileIndex = recentFilesList.indexOf(candidateFile);
        if (fileIndex == -1) {
            return fileIndex;
        }
        return recentFilesList.size() - fileIndex;
    }

    private static final Double computeFeatures$lambda$0$0(FindUsagesRankingFileInfo $instance) {
        Double d;
        Iterator iterator = ((Iterable)$instance.getQueryNames()).iterator();
        if (!iterator.hasNext()) {
            d = null;
        } else {
            String it = (String)iterator.next();
            boolean bl = false;
            Double d2 = new JaroWinklerSimilarity().apply((CharSequence)it, (CharSequence)$instance.getCandidateFile().getNameWithoutExtension());
            Intrinsics.checkNotNullExpressionValue((Object)d2, (String)"apply(...)");
            double d3 = ((Number)d2).doubleValue();
            while (iterator.hasNext()) {
                String it2 = (String)iterator.next();
                $i$a$-maxOfOrNull-FindUsagesFileRankerFeatureProvider$computeFeatures$1$1$1 = false;
                Double d4 = new JaroWinklerSimilarity().apply((CharSequence)it2, (CharSequence)$instance.getCandidateFile().getNameWithoutExtension());
                Intrinsics.checkNotNullExpressionValue((Object)d4, (String)"apply(...)");
                double d5 = ((Number)d4).doubleValue();
                d3 = Math.max(d3, d5);
            }
            d = d3;
        }
        return d != null ? d : 0.0;
    }

    private static final Double computeFeatures$lambda$0$1(FindUsagesRankingFileInfo $instance) {
        Double d;
        Iterator iterator = ((Iterable)$instance.getQueryFiles()).iterator();
        if (!iterator.hasNext()) {
            d = null;
        } else {
            VirtualFile it = (VirtualFile)iterator.next();
            boolean bl = false;
            Double d2 = new JaroWinklerSimilarity().apply((CharSequence)it.getNameWithoutExtension(), (CharSequence)$instance.getCandidateFile().getNameWithoutExtension());
            Intrinsics.checkNotNullExpressionValue((Object)d2, (String)"apply(...)");
            double d3 = ((Number)d2).doubleValue();
            while (iterator.hasNext()) {
                VirtualFile it2 = (VirtualFile)iterator.next();
                $i$a$-maxOfOrNull-FindUsagesFileRankerFeatureProvider$computeFeatures$1$2$1 = false;
                Double d4 = new JaroWinklerSimilarity().apply((CharSequence)it2.getNameWithoutExtension(), (CharSequence)$instance.getCandidateFile().getNameWithoutExtension());
                Intrinsics.checkNotNullExpressionValue((Object)d4, (String)"apply(...)");
                double d5 = ((Number)d4).doubleValue();
                d3 = Math.max(d3, d5);
            }
            d = d3;
        }
        return d != null ? d : 0.0;
    }

    private static final String computeFeatures$lambda$0$2(FindUsagesRankingFileInfo $instance) {
        return $instance.getQueryFiles().iterator().next().getFileType().getName();
    }

    private static final String computeFeatures$lambda$0$3(FindUsagesRankingFileInfo $instance) {
        return $instance.getCandidateFile().getFileType().getName();
    }

    private static final Long computeFeatures$lambda$0$4(FindUsagesRankingFileInfo $instance) {
        return $instance.getCandidateFile().getLength();
    }

    /*
     * WARNING - void declaration
     */
    private static final Boolean computeFeatures$lambda$0$5(FindUsagesRankingFileInfo $instance) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $instance.getQueryFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Intrinsics.areEqual((Object)it.getFileType(), (Object)$instance.getCandidateFile().getFileType()));
        }
        return CollectionsKt.any((Iterable)((List)destination$iv$iv));
    }

    private static final Integer computeFeatures$lambda$0$6(FindUsagesRankingFileInfo $instance) {
        return $instance.getQueryNames().size();
    }

    private static final Long computeFeatures$lambda$0$7(FindUsagesRankingFileInfo $instance) {
        Iterator iterator = ((Iterable)$instance.getQueryFiles()).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        VirtualFile it = (VirtualFile)iterator.next();
        boolean bl = false;
        Comparable comparable = Long.valueOf(it.getTimeStamp() - $instance.getCandidateFile().getTimeStamp());
        while (iterator.hasNext()) {
            VirtualFile it2 = (VirtualFile)iterator.next();
            $i$a$-minOf-FindUsagesFileRankerFeatureProvider$computeFeatures$1$8$1 = false;
            Comparable comparable2 = Long.valueOf(it2.getTimeStamp() - $instance.getCandidateFile().getTimeStamp());
            if (comparable.compareTo(comparable2) <= 0) continue;
            comparable = comparable2;
        }
        return (Long)comparable;
    }

    private static final Long computeFeatures$lambda$0$8(FindUsagesRankingFileInfo $instance) {
        return $instance.getTimeStamp() - $instance.getCandidateFile().getTimeStamp();
    }

    private static final Integer computeFeatures$lambda$0$9(FindUsagesFileRankerFeatureProvider this$0, FindUsagesRankingFileInfo $instance) {
        return this$0.getRecentFilesIndex($instance.getRecentFilesList(), $instance.getCandidateFile());
    }

    private static final Double computeFeatures$lambda$0$10(FindUsagesFileRankerFeatureProvider this$0, FindUsagesRankingFileInfo $instance) {
        return this$0.calculateDirectoryDistance($instance.getQueryFiles(), $instance.getCandidateFile(), $instance.getProjectPath());
    }

    private static final Unit computeFeatures$lambda$0(FindUsagesRankingFileInfo $instance, FindUsagesFileRankerFeatureProvider this$0, FeatureProvider.Companion.ListFiller $this$buildLazyFeaturesList) {
        Intrinsics.checkNotNullParameter((Object)$this$buildLazyFeaturesList, (String)"$this$buildLazyFeaturesList");
        if ($instance.getCandidateFile() != null) {
            $this$buildLazyFeaturesList.add(FindUsagesFileRankerFeatures.INSTANCE.getQUERY_JARO_WINKLER_SIMILARITY(), () -> FindUsagesFileRankerFeatureProvider.computeFeatures$lambda$0$0($instance));
            $this$buildLazyFeaturesList.add(FindUsagesFileRankerFeatures.INSTANCE.getFILENAME_JARO_WINKLER_SIMILARITY(), () -> FindUsagesFileRankerFeatureProvider.computeFeatures$lambda$0$1($instance));
            $this$buildLazyFeaturesList.add(FindUsagesFileRankerFeatures.INSTANCE.getQUERY_FILE_TYPE(), () -> FindUsagesFileRankerFeatureProvider.computeFeatures$lambda$0$2($instance));
            $this$buildLazyFeaturesList.add(FindUsagesFileRankerFeatures.INSTANCE.getCANDIDATE_TYPE(), () -> FindUsagesFileRankerFeatureProvider.computeFeatures$lambda$0$3($instance));
            $this$buildLazyFeaturesList.add(FindUsagesFileRankerFeatures.INSTANCE.getCANDIDATE_LENGTH(), () -> FindUsagesFileRankerFeatureProvider.computeFeatures$lambda$0$4($instance));
            $this$buildLazyFeaturesList.add(FindUsagesFileRankerFeatures.INSTANCE.getFILE_TYPE_SAME(), () -> FindUsagesFileRankerFeatureProvider.computeFeatures$lambda$0$5($instance));
            $this$buildLazyFeaturesList.add(FindUsagesFileRankerFeatures.INSTANCE.getQUERY_COUNT(), () -> FindUsagesFileRankerFeatureProvider.computeFeatures$lambda$0$6($instance));
            $this$buildLazyFeaturesList.add(FindUsagesFileRankerFeatures.INSTANCE.getTIME_MODIFIED_DIFFERENCE_MS(), () -> FindUsagesFileRankerFeatureProvider.computeFeatures$lambda$0$7($instance));
            $this$buildLazyFeaturesList.add(FindUsagesFileRankerFeatures.INSTANCE.getTIME_SINCE_LAST_MODIFIED_MS(), () -> FindUsagesFileRankerFeatureProvider.computeFeatures$lambda$0$8($instance));
            $this$buildLazyFeaturesList.add(FindUsagesFileRankerFeatures.INSTANCE.getRECENT_FILES_INDEX(), () -> FindUsagesFileRankerFeatureProvider.computeFeatures$lambda$0$9(this$0, $instance));
            $this$buildLazyFeaturesList.add(FindUsagesFileRankerFeatures.INSTANCE.getDIRECTORY_DISTANCE(), () -> FindUsagesFileRankerFeatureProvider.computeFeatures$lambda$0$10(this$0, $instance));
        }
        return Unit.INSTANCE;
    }
}

