/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.liquibase.ns;

import com.intellij.jpa.jpb.model.liquibase.ns.ImplicitNamingStrategy;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityAttributePsi;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.util.AttributeUtil;
import com.intellij.jpa.jpb.model.util.annotation.JoinColumn;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J3\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\r\u0010\u0015\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\u0016H\u0002J \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lcom/intellij/jpa/jpb/model/liquibase/ns/SpringImplicitNamingStrategy;", "Lcom/intellij/jpa/jpb/model/liquibase/ns/ImplicitNamingStrategy;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "determineJoinTableName", "", "entity", "Lcom/intellij/jpa/jpb/model/model/Entity;", "attribute", "Lcom/intellij/jpa/jpb/model/model/EntityAttribute;", "determineJoinColumnName", "", "Lcom/intellij/jpa/jpb/model/util/annotation/JoinColumn;", "determineJoinColumnNames", "", "ownerEntity", "idAttributes", "ownerName", "Lorg/jetbrains/annotations/Nullable;", "determineInverseJoinColumn", "determineCollectionTableName", "ownerAttrName", "idAttrName", "Companion", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nSpringImplicitNamingStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringImplicitNamingStrategy.kt\ncom/intellij/jpa/jpb/model/liquibase/ns/SpringImplicitNamingStrategy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1642#2,10:97\n1915#2:107\n1916#2:109\n1652#2:110\n1915#2,2:111\n1#3:108\n*S KotlinDebug\n*F\n+ 1 SpringImplicitNamingStrategy.kt\ncom/intellij/jpa/jpb/model/liquibase/ns/SpringImplicitNamingStrategy\n*L\n55#1:97,10\n55#1:107\n55#1:109\n55#1:110\n64#1:111,2\n55#1:108\n*E\n"})
public final class SpringImplicitNamingStrategy
implements ImplicitNamingStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public SpringImplicitNamingStrategy(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public String determineJoinTableName(@NotNull Entity entity, @NotNull EntityAttribute attribute) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        return entity.getTable() + "_" + attribute.getName();
    }

    @Override
    @NotNull
    public List<JoinColumn> determineJoinColumnName(@NotNull Entity entity, @NotNull EntityAttribute attribute) {
        EntityAttribute inverseAttr;
        EntityAttribute entityAttribute;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        String entityName = entity.getName();
        if (StringUtil.isEmpty((String)entityName)) {
            entityName = entity.getClassName();
        }
        List<EntityAttribute> idAttributes = entity.getIdAttributes();
        String attrName = attribute.getName();
        Datatype datatype = attribute.getType();
        Object object = datatype instanceof Entity ? (Entity)datatype : null;
        if (object != null && (object = ((Entity)object).getAllAttributes()) != null) {
            Object v1;
            block4: {
                Iterable iterable = (Iterable)object;
                for (Object t : iterable) {
                    EntityAttribute it = (EntityAttribute)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getMappedBy(), (Object)attrName)) continue;
                    v1 = t;
                    break block4;
                }
                v1 = null;
            }
            entityAttribute = v1;
        } else {
            entityAttribute = null;
        }
        EntityAttribute entityAttribute2 = inverseAttr = entityAttribute;
        String ownerName = entityAttribute2 == null ? entityName : entityAttribute2.getName();
        Intrinsics.checkNotNull(idAttributes);
        return this.determineJoinColumnNames(entity, idAttributes, ownerName);
    }

    /*
     * WARNING - void declaration
     */
    private final List<JoinColumn> determineJoinColumnNames(Entity ownerEntity, List<? extends EntityAttribute> idAttributes, String ownerName) {
        List result = new ArrayList();
        if (idAttributes.isEmpty()) {
            result.add(new JoinColumn(this.determineJoinColumnName(ownerName, "id"), "id"));
        } else {
            Datatype idType;
            Datatype datatype = idType = idAttributes.size() == 1 ? ((EntityAttribute)CollectionsKt.first(idAttributes)).getType() : null;
            if (idType instanceof Entity) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                List<EntityAttribute> list = ((Entity)idType).getAttributes();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getAttributes(...)");
                Iterable iterable = list;
                List list2 = result;
                boolean $i$f$mapNotNull = false;
                void var8_11 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    JoinColumn it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    EntityAttribute embAttr = (EntityAttribute)element$iv$iv;
                    boolean bl2 = false;
                    String embColumnName = embAttr.getEmbeddedColumnName((EntityAttribute)CollectionsKt.first(idAttributes));
                    CharSequence charSequence = embColumnName;
                    if ((charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : new JoinColumn(this.determineJoinColumnName(ownerName, embColumnName), embColumnName)) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list2.addAll((List)destination$iv$iv);
            } else {
                Iterable $this$forEach$iv = idAttributes;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    EntityAttribute idAttr = (EntityAttribute)element$iv;
                    boolean bl = false;
                    String idColumnName = ownerEntity.getColumnName(this.project, idAttr);
                    Intrinsics.checkNotNull((Object)idColumnName);
                    result.add(new JoinColumn(this.determineJoinColumnName(ownerName, idColumnName), idColumnName));
                }
            }
        }
        return result;
    }

    @Override
    @NotNull
    public List<JoinColumn> determineInverseJoinColumn(@Nullable Entity entity, @NotNull EntityAttribute attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Datatype datatype = attribute.isGenericType() && attribute instanceof EntityAttributePsi && entity instanceof EntityPsi ? AttributeUtil.getResolvedGenericAttrType(((EntityPsi)entity).getPsiClass(), ((EntityAttributePsi)attribute).getMember()) : attribute.getType();
        Entity entity2 = datatype instanceof Entity ? (Entity)datatype : null;
        if (entity2 == null) {
            return CollectionsKt.emptyList();
        }
        Entity attrType = entity2;
        List<EntityAttribute> attrTypeIdAttributes = attrType.getIdAttributes();
        Intrinsics.checkNotNull(attrTypeIdAttributes);
        return this.determineJoinColumnNames(attrType, attrTypeIdAttributes, attribute.getName());
    }

    @Override
    @NotNull
    public String determineCollectionTableName(@NotNull Entity entity, @NotNull EntityAttribute attribute) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        String entityName = entity.getName();
        if (StringUtil.isEmpty((String)entityName)) {
            entityName = entity.getClassName();
        }
        return entityName + "_" + attribute.getName();
    }

    @Override
    @NotNull
    public String determineJoinColumnName(@Nullable String ownerAttrName, @NotNull String idAttrName) {
        Intrinsics.checkNotNullParameter((Object)idAttrName, (String)"idAttrName");
        return ownerAttrName + "_" + idAttrName;
    }

    @JvmStatic
    @NotNull
    public static final SpringImplicitNamingStrategy getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jpa/jpb/model/liquibase/ns/SpringImplicitNamingStrategy$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jpa/jpb/model/liquibase/ns/SpringImplicitNamingStrategy;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javaee.jpa.jpb.model"})
    @SourceDebugExtension(value={"SMAP\nSpringImplicitNamingStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringImplicitNamingStrategy.kt\ncom/intellij/jpa/jpb/model/liquibase/ns/SpringImplicitNamingStrategy$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,96:1\n30#2,2:97\n*S KotlinDebug\n*F\n+ 1 SpringImplicitNamingStrategy.kt\ncom/intellij/jpa/jpb/model/liquibase/ns/SpringImplicitNamingStrategy$Companion\n*L\n22#1:97,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SpringImplicitNamingStrategy getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<SpringImplicitNamingStrategy> serviceClass$iv = SpringImplicitNamingStrategy.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (SpringImplicitNamingStrategy)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

