/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.component;

import com.intellij.jpa.jpb.model.core.model.AbstractRdbmsStore;
import com.intellij.jpa.jpb.model.core.model.DataStore;
import com.intellij.jpa.jpb.model.core.model.dbprop.DbProperties;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.model.CustomDataStore;
import com.intellij.jpa.jpb.model.util.JpaUiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.Insets;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J:\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0014J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0019H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/jpa/jpb/model/ui/component/DataSourceCellRenderEx;", "Lcom/intellij/ui/ColoredListCellRenderer;", "Lcom/intellij/jpa/jpb/model/core/model/DataStore;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "URL_MAX_LENGTH", "", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "value", "index", "selected", "", "hasFocus", "customizeSchemaCellRender", "Lcom/intellij/jpa/jpb/model/model/CustomDataStore;", "customSchemaName", "", "customizeRdmsCellRender", "Lcom/intellij/jpa/jpb/model/core/model/AbstractRdbmsStore;", "intellij.javaee.jpa.jpb.model"})
public final class DataSourceCellRenderEx
extends ColoredListCellRenderer<DataStore> {
    @NotNull
    private final Project project;
    private final int URL_MAX_LENGTH;

    public DataSourceCellRenderEx(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.URL_MAX_LENGTH = 50;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    protected void customizeCellRenderer(@NotNull JList<? extends DataStore> list, @Nullable DataStore value, int index, boolean selected, boolean hasFocus) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        int leftRightIpad = UIUtil.isUnderWin10LookAndFeel() ? 0 : JBUIScale.scale((int)UIUtil.getListCellHPadding());
        this.setIpad((Insets)JBInsets.create((int)1, (int)leftRightIpad));
        if (value instanceof AbstractRdbmsStore) {
            this.customizeRdmsCellRender((AbstractRdbmsStore)value);
        } else if (value == null) {
            SimpleColoredComponent simpleColoredComponent = this.append("<" + JpaModelBundle.message("database.connection.not.selected", new Object[0]) + ">");
            Intrinsics.checkNotNull((Object)simpleColoredComponent);
        } else {
            SimpleColoredComponent simpleColoredComponent = this.append(value.toString());
            Intrinsics.checkNotNull((Object)simpleColoredComponent);
        }
    }

    private final void customizeSchemaCellRender(CustomDataStore value, String customSchemaName) {
        String dbName = value.getIdeaDbName();
        CharSequence charSequence = dbName;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            this.append("db: ");
            this.append(dbName, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            this.append(", ");
        }
        this.append("schema: ");
        this.append(customSchemaName, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
    }

    private final void customizeRdmsCellRender(AbstractRdbmsStore value) {
        Object url;
        this.append(value.getName());
        Object object = value.getDbProperties();
        if (object == null || (object = ((DbProperties)object).getUrl()) == null) {
            object = "";
        }
        if (((String)(url = object)).length() > this.URL_MAX_LENGTH) {
            String string = ((String)url).substring(0, this.URL_MAX_LENGTH);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            url = string + "...";
        }
        this.append(" (" + (String)url + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
        this.setIcon(JpaUiUtil.getDbTypeIcon(value.getDbProperties().getType()));
    }
}

