/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.util;

import com.intellij.ide.structureView.logical.impl.LogicalStructureViewTreeElement;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jpa.jpb.model.orm.toolwindow.node.LogicalElementSection;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.psi.PsiFile;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0007H\u0007J-\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0007\u00a2\u0006\u0002\u0010\u0016J \u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J7\u0010\u001a\u001a\u0004\u0018\u0001H\u001b\"\u0004\b\u0000\u0010\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001f2\b\b\u0002\u0010 \u001a\u00020!\u00a2\u0006\u0002\u0010\"\u00a8\u0006#"}, d2={"Lcom/intellij/jpa/jpb/model/util/ActionUtils;", "", "<init>", "()V", "isActionInPlace", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "place", "", "getPsiFile", "Lcom/intellij/psi/PsiFile;", "event", "addShortcutToNotifyListeners", "", "focusComponent", "Ljavax/swing/JComponent;", "listeners", "", "Ljava/awt/event/ActionListener;", "keyStroke", "Ljavax/swing/KeyStroke;", "(Ljavax/swing/JComponent;[Ljava/awt/event/ActionListener;Ljavax/swing/KeyStroke;)V", "addShortcutWithTooltipToNotifyListeners", "actionButton", "Ljavax/swing/JButton;", "findStructureNodeLogicalModelByType", "T", "structureNode", "Lcom/intellij/ide/util/treeView/NodeDescriptor;", "clazz", "Ljava/lang/Class;", "maxDeep", "", "(Lcom/intellij/ide/util/treeView/NodeDescriptor;Ljava/lang/Class;I)Ljava/lang/Object;", "intellij.javaee.jpa.jpb.model"})
public final class ActionUtils {
    @NotNull
    public static final ActionUtils INSTANCE = new ActionUtils();

    private ActionUtils() {
    }

    @JvmStatic
    public static final boolean isActionInPlace(@NotNull AnActionEvent e, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        String string = e.getPlace();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlace(...)");
        String eventPlace = string;
        return Intrinsics.areEqual((Object)eventPlace, (Object)place) || Intrinsics.areEqual((Object)eventPlace, (Object)ActionPlaces.getActionGroupPopupPlace((String)place));
    }

    @JvmStatic
    @Nullable
    public static final PsiFile getPsiFile(@Nullable AnActionEvent event) {
        AnActionEvent anActionEvent = event;
        if (anActionEvent == null || (anActionEvent = anActionEvent.getDataContext()) == null) {
            return null;
        }
        AnActionEvent dataContext = anActionEvent;
        return (PsiFile)CommonDataKeys.PSI_FILE.getData((DataContext)dataContext);
    }

    @JvmStatic
    public static final void addShortcutToNotifyListeners(@NotNull JComponent focusComponent, @NotNull ActionListener[] listeners, @NotNull KeyStroke keyStroke) {
        Intrinsics.checkNotNullParameter((Object)focusComponent, (String)"focusComponent");
        Intrinsics.checkNotNullParameter((Object)listeners, (String)"listeners");
        Intrinsics.checkNotNullParameter((Object)keyStroke, (String)"keyStroke");
        new DumbAwareAction(focusComponent, listeners){
            final /* synthetic */ JComponent $focusComponent;
            final /* synthetic */ ActionListener[] $listeners;
            {
                this.$focusComponent = $focusComponent;
                this.$listeners = $listeners;
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ActionEvent event = new ActionEvent(this.$focusComponent, 1001, "action");
                for (ActionListener listener : this.$listeners) {
                    listener.actionPerformed(event);
                }
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(keyStroke), focusComponent);
    }

    @JvmStatic
    public static final void addShortcutWithTooltipToNotifyListeners(@NotNull JComponent focusComponent, @NotNull JButton actionButton, @NotNull KeyStroke keyStroke) {
        Intrinsics.checkNotNullParameter((Object)focusComponent, (String)"focusComponent");
        Intrinsics.checkNotNullParameter((Object)actionButton, (String)"actionButton");
        Intrinsics.checkNotNullParameter((Object)keyStroke, (String)"keyStroke");
        String string = KeymapUtil.getKeystrokeText((KeyStroke)keyStroke);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKeystrokeText(...)");
        String keystrokeText = string;
        CharSequence charSequence = actionButton.getToolTipText();
        actionButton.setToolTipText((String)(!(charSequence == null || charSequence.length() == 0) ? actionButton.getToolTipText() + " (" + keystrokeText + ")" : keystrokeText));
        ActionListener[] actionListenerArray = actionButton.getActionListeners();
        Intrinsics.checkNotNullExpressionValue((Object)actionListenerArray, (String)"getActionListeners(...)");
        ActionUtils.addShortcutToNotifyListeners(focusComponent, actionListenerArray, keyStroke);
    }

    @Nullable
    public final <T> T findStructureNodeLogicalModelByType(@NotNull NodeDescriptor<?> structureNode, @NotNull Class<T> clazz, int maxDeep) {
        Intrinsics.checkNotNullParameter(structureNode, (String)"structureNode");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        LogicalElementSection logicalElementSection = structureNode instanceof LogicalElementSection ? (LogicalElementSection)structureNode : null;
        if (logicalElementSection == null || (logicalElementSection = logicalElementSection.getViewTreeElement()) == null) {
            return null;
        }
        LogicalElementSection viewTreeElement = logicalElementSection;
        LogicalStructureViewTreeElement logicalStructureViewTreeElement = viewTreeElement instanceof LogicalStructureViewTreeElement ? (LogicalStructureViewTreeElement)viewTreeElement : null;
        if (logicalStructureViewTreeElement == null || (logicalStructureViewTreeElement = logicalStructureViewTreeElement.getLogicalAssembledModel()) == null) {
            return null;
        }
        LogicalStructureViewTreeElement assembledModel = logicalStructureViewTreeElement;
        int i = 0;
        if (i <= maxDeep) {
            while (true) {
                if (assembledModel.getModel() != null) {
                    Object model2;
                    if (clazz.isAssignableFrom(model2.getClass())) {
                        return (T)model2;
                    }
                    if (assembledModel.getParent() == null) {
                        return null;
                    }
                }
                if (i == maxDeep) break;
                ++i;
            }
        }
        return null;
    }

    public static /* synthetic */ Object findStructureNodeLogicalModelByType$default(ActionUtils actionUtils, NodeDescriptor nodeDescriptor, Class clazz, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 10;
        }
        return actionUtils.findStructureNodeLogicalModelByType(nodeDescriptor, clazz, n);
    }
}

