/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.ui.sunburst;

import com.intellij.profiler.ui.sunburst.Sunburst;
import com.intellij.ui.components.Magnificator;
import com.intellij.ui.components.ZoomableViewport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0010\u001a\u00020\u0004H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\fH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/profiler/ultimate/hprof/ui/sunburst/SunburstZoomableViewport;", "T", "Ljavax/swing/JComponent;", "Lcom/intellij/ui/components/ZoomableViewport;", "Lcom/intellij/ui/components/Magnificator;", "sunburst", "Lcom/intellij/profiler/ui/sunburst/Sunburst;", "<init>", "(Lcom/intellij/profiler/ui/sunburst/Sunburst;)V", "getSunburst", "()Lcom/intellij/profiler/ui/sunburst/Sunburst;", "point", "Ljava/awt/Point;", "thickness", "", "shift", "getMagnificator", "magnificationStarted", "", "at", "magnificationFinished", "magnification", "magnify", "scale", "intellij.profiler.ultimate"})
final class SunburstZoomableViewport<T>
extends JComponent
implements ZoomableViewport,
Magnificator {
    @NotNull
    private final Sunburst<T> sunburst;
    @Nullable
    private Point point;
    private double thickness;
    @Nullable
    private Point shift;

    public SunburstZoomableViewport(@NotNull Sunburst<T> sunburst) {
        Intrinsics.checkNotNullParameter(sunburst, (String)"sunburst");
        this.sunburst = sunburst;
        this.thickness = Double.NaN;
        this.setLayout(new BorderLayout());
        this.add((Component)this.sunburst);
    }

    @NotNull
    public final Sunburst<T> getSunburst() {
        return this.sunburst;
    }

    @NotNull
    public Magnificator getMagnificator() {
        return this;
    }

    public void magnificationStarted(@NotNull Point at) {
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        this.point = at;
        this.shift = this.sunburst.shift();
        this.thickness = this.sunburst.getThickness();
    }

    public void magnificationFinished(double magnification) {
        this.magnify(magnification);
        this.point = null;
        this.shift = null;
        this.thickness = Double.NaN;
    }

    public void magnify(double magnification) {
        double scale = magnification < 0.0 ? (double)1.0f / (1.0 - magnification) : 1.0 + magnification;
        Point point = this.point;
        Intrinsics.checkNotNull((Object)point);
        this.magnify(scale, point);
    }

    @NotNull
    public Point magnify(double scale, @NotNull Point at) {
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        this.sunburst.setThickness(this.thickness * scale);
        double sx = (double)this.sunburst.getWidth() / 2.0 - (double)at.x;
        double sy = (double)this.sunburst.getHeight() / 2.0 - (double)at.y;
        sx -= sx * scale;
        sy -= sy * scale;
        Point point = this.shift;
        Intrinsics.checkNotNull((Object)point);
        int n = MathKt.roundToInt((double)((double)point.x * scale + sx));
        Point point2 = this.shift;
        Intrinsics.checkNotNull((Object)point2);
        this.sunburst.shift(n, MathKt.roundToInt((double)((double)point2.y * scale + sy)));
        return at;
    }
}

