/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr.ui;

import com.intellij.profiler.model.ThreadInfo;
import com.intellij.profiler.ui.threadview.ThreadTimelineModel;
import com.intellij.profiler.ui.threadview.UIVisibleThreadInfo;
import com.intellij.profiler.ui.timeline.ChartController;
import com.intellij.profiler.ui.timeline.DefaultNode;
import com.intellij.profiler.ui.timeline.TimelineModel;
import com.intellij.profiler.ultimate.jfr.ui.HeavyJfrTimelineEvent;
import com.intellij.profiler.ultimate.jfr.ui.JFRTimelineEvent;
import com.intellij.profiler.ultimate.jfr.ui.LightJfrTimelineEvent;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001BO\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u0012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00070\u0005\u0012\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\"\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00110\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016J\"\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00110\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/profiler/ultimate/jfr/ui/JFRThreadTimelineModel;", "Lcom/intellij/profiler/ui/threadview/ThreadTimelineModel;", "Lcom/intellij/profiler/ui/threadview/UIVisibleThreadInfo;", "Lcom/intellij/profiler/ultimate/jfr/ui/JFRTimelineEvent;", "lightIntervals", "", "Lcom/intellij/profiler/model/ThreadInfo;", "", "Lcom/intellij/profiler/ultimate/jfr/ui/LightJfrTimelineEvent;", "heavyIntervals", "Lcom/intellij/profiler/ultimate/jfr/ui/HeavyJfrTimelineEvent;", "charts", "", "Lcom/intellij/profiler/ui/timeline/ChartController;", "<init>", "(Ljava/util/Map;Ljava/util/Map;[Lcom/intellij/profiler/ui/timeline/ChartController;)V", "getIntervals", "Lcom/intellij/profiler/ui/timeline/TimelineModel$TimelineInterval;", "node", "Lcom/intellij/profiler/ui/timeline/DefaultNode;", "getIntervalsFast", "intellij.profiler.ultimate"})
public final class JFRThreadTimelineModel
extends ThreadTimelineModel<UIVisibleThreadInfo, JFRTimelineEvent> {
    @NotNull
    private final Map<ThreadInfo, Iterable<LightJfrTimelineEvent>> lightIntervals;

    public JFRThreadTimelineModel(@NotNull Map<ThreadInfo, ? extends Iterable<? extends LightJfrTimelineEvent>> lightIntervals, @NotNull Map<UIVisibleThreadInfo, ? extends Iterable<HeavyJfrTimelineEvent>> heavyIntervals2, ChartController ... charts) {
        Intrinsics.checkNotNullParameter(lightIntervals, (String)"lightIntervals");
        Intrinsics.checkNotNullParameter(heavyIntervals2, (String)"heavyIntervals");
        Intrinsics.checkNotNullParameter((Object)charts, (String)"charts");
        super(heavyIntervals2, Arrays.copyOf(charts, charts.length));
        this.lightIntervals = lightIntervals;
    }

    @NotNull
    public Iterable<TimelineModel.TimelineInterval<JFRTimelineEvent>> getIntervals(@NotNull DefaultNode<UIVisibleThreadInfo> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        return super.getIntervals(node);
    }

    @NotNull
    public Iterable<TimelineModel.TimelineInterval<JFRTimelineEvent>> getIntervalsFast(@NotNull DefaultNode<UIVisibleThreadInfo> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        UIVisibleThreadInfo uIVisibleThreadInfo = (UIVisibleThreadInfo)node.getData();
        if (uIVisibleThreadInfo == null || (uIVisibleThreadInfo = uIVisibleThreadInfo.getThreadInfo()) == null) {
            return CollectionsKt.emptyList();
        }
        UIVisibleThreadInfo thread = uIVisibleThreadInfo;
        return (Iterable)MapsKt.getValue(this.lightIntervals, (Object)thread);
    }
}

