/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.common.carets;

import com.intellij.codeWithMe.ClientId;
import com.intellij.cwm.plugin.common.carets.RemoteCaret;
import com.intellij.cwm.plugin.common.carets.RemoteCaretRenderingUtil;
import com.intellij.cwm.plugin.common.control.CodeWithMeColors;
import com.intellij.cwm.plugin.common.users.UserManagerKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.CustomHighlighterOrder;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.ui.scale.JBUIScale;
import com.jetbrains.codeWithMe.model.RemoteCaretData;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/intellij/cwm/plugin/common/carets/RemoteCaretHighlighterRenderer;", "Lcom/intellij/openapi/editor/markup/CustomHighlighterRenderer;", "remoteCaretData", "Lcom/jetbrains/codeWithMe/model/RemoteCaretData;", "<init>", "(Lcom/jetbrains/codeWithMe/model/RemoteCaretData;)V", "getRemoteCaretData", "()Lcom/jetbrains/codeWithMe/model/RemoteCaretData;", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "g", "Ljava/awt/Graphics;", "shouldShow", "", "getOrder", "Lcom/intellij/openapi/editor/markup/CustomHighlighterOrder;", "intellij.cwm.plugin.common"})
public final class RemoteCaretHighlighterRenderer
implements CustomHighlighterRenderer {
    @NotNull
    private final RemoteCaretData remoteCaretData;

    public RemoteCaretHighlighterRenderer(@NotNull RemoteCaretData remoteCaretData) {
        Intrinsics.checkNotNullParameter((Object)remoteCaretData, (String)"remoteCaretData");
        this.remoteCaretData = remoteCaretData;
    }

    @NotNull
    public final RemoteCaretData getRemoteCaretData() {
        return this.remoteCaretData;
    }

    public void paint(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (!this.shouldShow() || !(g instanceof Graphics2D)) {
            return;
        }
        RemoteCaret caret = new RemoteCaret((Editor)((EditorImpl)editor), highlighter, this.remoteCaretData);
        ((Graphics2D)g).setColor(CodeWithMeColors.INSTANCE.getMarkerAttributes(this.remoteCaretData.getUser(), editor).getBackgroundColor());
        Rectangle2D.Double caretRectangle = RemoteCaretRenderingUtil.INSTANCE.calculateCaretRectangle(caret, JBUIScale.sysScale((Graphics2D)((Graphics2D)g)));
        Rectangle2D.Double pinRectangle = RemoteCaretRenderingUtil.INSTANCE.calculatePinRectangle(caretRectangle);
        ((Graphics2D)g).fill(caretRectangle);
        ((Graphics2D)g).fill(pinRectangle);
    }

    public final boolean shouldShow() {
        return !Intrinsics.areEqual((Object)UserManagerKt.getClientId(this.remoteCaretData.getUser()), (Object)ClientId.Companion.getLocalId());
    }

    @NotNull
    public CustomHighlighterOrder getOrder() {
        return CustomHighlighterOrder.AFTER_TEXT;
    }
}

