/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.inline.completion.split;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.codeInsight.inline.completion.InlineCompletionEvent;
import com.intellij.codeInsight.inline.completion.split.InlineCompletionManualCallEventId;
import com.intellij.codeInsight.inline.completion.split.InlineCompletionManualCallEventSupportKt;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/codeInsight/inline/completion/split/EventsStorage;", "", "<init>", "()V", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/intellij/codeInsight/inline/completion/split/InlineCompletionManualCallEventId;", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEvent$ManualCall;", "put", "", "event", "getOrNull", "id", "remove", "intellij.platform.inline.completion.split"})
final class EventsStorage {
    @NotNull
    private final Cache<InlineCompletionManualCallEventId, InlineCompletionEvent.ManualCall> cache;

    public EventsStorage() {
        Cache cache = Caffeine.newBuilder().maximumSize(10L).expireAfterWrite(30L, TimeUnit.SECONDS).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.cache = cache;
    }

    public final void put(@NotNull InlineCompletionEvent.ManualCall event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        InlineCompletionManualCallEventId inlineCompletionManualCallEventId = InlineCompletionManualCallEventSupportKt.getId(event);
        if (inlineCompletionManualCallEventId == null) {
            return;
        }
        InlineCompletionManualCallEventId id = inlineCompletionManualCallEventId;
        this.cache.put((Object)id, (Object)event);
    }

    @Nullable
    public final InlineCompletionEvent.ManualCall getOrNull(@NotNull InlineCompletionManualCallEventId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return (InlineCompletionEvent.ManualCall)this.cache.getIfPresent((Object)id);
    }

    public final void remove(@NotNull InlineCompletionManualCallEventId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.cache.invalidate((Object)id);
    }
}

