/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.css.util.CssPsiUtilCore;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssAttribute;
import com.intellij.psi.css.CssAttributeRSide;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssNamedItemPresentation;
import com.intellij.psi.css.impl.stubs.CssAttributeStub;
import com.intellij.psi.css.impl.stubs.base.CssNamedStubElement;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.stubs.StubBuildCachedValuesManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssAttributeImpl
extends CssNamedStubElement<CssAttributeStub>
implements CssAttribute {
    private static final StubBuildCachedValuesManager.StubBuildCachedValueProvider<String, CssAttributeImpl> ATTRIBUTE_NAME_PROVIDER_NEW = new StubBuildCachedValuesManager.StubBuildCachedValueProvider("css.attribute.name.cached", psiElement -> CachedValueProvider.Result.create((Object)CssPsiUtilCore.getTokenText(psiElement.getAttributeNameIdentifier()), (Object[])new Object[]{psiElement}));
    private static final StubBuildCachedValuesManager.StubBuildCachedValueProvider<String, CssAttributeImpl> ATTRIBUTE_VALUE_PROVIDER_NEW = new StubBuildCachedValuesManager.StubBuildCachedValueProvider("css.attribute.value.cached", psiElement -> {
        CssAttributeRSide rSide = psiElement.getRSide();
        return CachedValueProvider.Result.create((Object)(rSide != null ? rSide.getValue() : ""), (Object[])new Object[]{psiElement});
    });
    private static final StubBuildCachedValuesManager.StubBuildCachedValueProvider<CssAttribute.OperatorType, CssAttributeImpl> OPERATOR_TYPE_PROVIDER_NEW = new StubBuildCachedValuesManager.StubBuildCachedValueProvider("css.operator.type.cached", psiElement -> {
        CssAttributeRSide rSide = psiElement.getRSide();
        CssAttribute.OperatorType result = CssAttribute.OperatorType.NONE;
        if (rSide != null) {
            IElementType tokenType;
            PsiElement operatorElement = rSide.getPrevSibling();
            IElementType iElementType = tokenType = operatorElement != null ? operatorElement.getNode().getElementType() : null;
            if (tokenType != null && (CssElementTypes.ATTRIBUTE_OPERATORS.contains(tokenType) || tokenType == CssElementTypes.CSS_JQUERY_NOT_EQUALS)) {
                if (tokenType == CssElementTypes.CSS_EQ) {
                    result = CssAttribute.OperatorType.EQUALS;
                } else if (tokenType == CssElementTypes.CSS_INCLUDES) {
                    result = CssAttribute.OperatorType.CONTAINS_WORD;
                } else if (tokenType == CssElementTypes.CSS_BEGINS_WITH) {
                    result = CssAttribute.OperatorType.STARTS_WITH;
                } else if (tokenType == CssElementTypes.CSS_CONTAINS) {
                    result = CssAttribute.OperatorType.CONTAINS;
                } else if (tokenType == CssElementTypes.CSS_ENDS_WITH) {
                    result = CssAttribute.OperatorType.ENDS_WITH;
                } else if (tokenType == CssElementTypes.CSS_DASHMATCH) {
                    result = CssAttribute.OperatorType.STARTS_WITH_BEFORE_DASH;
                } else if (tokenType == CssElementTypes.CSS_JQUERY_NOT_EQUALS) {
                    result = CssAttribute.OperatorType.JQUERY_NOT_EQUALS;
                } else {
                    throw new IllegalArgumentException("Cannot find operator for element type: " + String.valueOf(tokenType));
                }
            }
        }
        return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{psiElement});
    });

    public CssAttributeImpl(@NotNull CssAttributeStub stub, @NotNull IElementType nodeType) {
        if (stub == null) {
            CssAttributeImpl.$$$reportNull$$$0(0);
        }
        if (nodeType == null) {
            CssAttributeImpl.$$$reportNull$$$0(1);
        }
        super(stub, nodeType);
    }

    public CssAttributeImpl(@NotNull ASTNode node) {
        if (node == null) {
            CssAttributeImpl.$$$reportNull$$$0(2);
        }
        super(node);
    }

    @NotNull
    public String getAttributeName() {
        CssAttributeStub stub = (CssAttributeStub)this.getStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                CssAttributeImpl.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = (String)StubBuildCachedValuesManager.getCachedValueStubBuildOptimized((PsiElement)this, ATTRIBUTE_NAME_PROVIDER_NEW);
        if (string == null) {
            CssAttributeImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public PsiElement getAttributeNameIdentifier() {
        return this.findChildByType(CssElementTypes.CSS_IDENT);
    }

    @NotNull
    public CssSelectorSuffixType getType() {
        String name = this.getAttributeName();
        if (Comparing.strEqual((String)"class", (String)name, (boolean)false)) {
            CssSelectorSuffixType cssSelectorSuffixType = CssSelectorSuffixType.CLASS;
            if (cssSelectorSuffixType == null) {
                CssAttributeImpl.$$$reportNull$$$0(5);
            }
            return cssSelectorSuffixType;
        }
        if (Comparing.strEqual((String)"id", (String)name, (boolean)false)) {
            CssSelectorSuffixType cssSelectorSuffixType = CssSelectorSuffixType.ID;
            if (cssSelectorSuffixType == null) {
                CssAttributeImpl.$$$reportNull$$$0(6);
            }
            return cssSelectorSuffixType;
        }
        CssSelectorSuffixType cssSelectorSuffixType = CssSelectorSuffixType.UNKNOWN;
        if (cssSelectorSuffixType == null) {
            CssAttributeImpl.$$$reportNull$$$0(7);
        }
        return cssSelectorSuffixType;
    }

    @NotNull
    public String getAttributeValue() {
        CssAttributeStub stub = (CssAttributeStub)this.getStub();
        if (stub != null) {
            String string = stub.getValue();
            if (string == null) {
                CssAttributeImpl.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = (String)StubBuildCachedValuesManager.getCachedValueStubBuildOptimized((PsiElement)this, ATTRIBUTE_VALUE_PROVIDER_NEW);
        if (string == null) {
            CssAttributeImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public CssAttribute.OperatorType getOperatorType() {
        CssAttributeStub stub = (CssAttributeStub)this.getStub();
        if (stub != null) {
            CssAttribute.OperatorType operatorType = stub.getOperatorType();
            if (operatorType == null) {
                CssAttributeImpl.$$$reportNull$$$0(10);
            }
            return operatorType;
        }
        CssAttribute.OperatorType operatorType = (CssAttribute.OperatorType)StubBuildCachedValuesManager.getCachedValueStubBuildOptimized((PsiElement)this, OPERATOR_TYPE_PROVIDER_NEW);
        if (operatorType == null) {
            CssAttributeImpl.$$$reportNull$$$0(11);
        }
        return operatorType;
    }

    @Nullable
    public String getName() {
        return this.getType() != CssSelectorSuffixType.UNKNOWN ? this.getAttributeValue() : null;
    }

    public CssAttribute setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        CssAttributeRSide rSide;
        if (name == null) {
            CssAttributeImpl.$$$reportNull$$$0(12);
        }
        if (this.getType() != CssSelectorSuffixType.UNKNOWN && (rSide = this.getRSide()) != null) {
            rSide.setValue(name);
        }
        return this;
    }

    @Nullable
    public CssRuleset getRuleset() {
        return (CssRuleset)this.getStubOrPsiParentOfType(CssRuleset.class);
    }

    @Nullable
    public CssAttributeRSide getRSide() {
        return (CssAttributeRSide)this.findChildByClass(CssAttributeRSide.class);
    }

    public ItemPresentation getPresentation() {
        CssAttribute.OperatorType operatorType = this.getOperatorType();
        if (this.getIcon(0) != null && this.getOperatorType() == CssAttribute.OperatorType.EQUALS) {
            return new CssNamedItemPresentation((PsiNamedElement)this, "[\"" + this.getAttributeValue() + "\"]");
        }
        if (this.getOperatorType() == CssAttribute.OperatorType.NONE) {
            return new CssNamedItemPresentation((PsiNamedElement)this, "[" + this.getAttributeName() + "]");
        }
        return new CssNamedItemPresentation((PsiNamedElement)this, "[" + this.getAttributeName() + operatorType.getPresentation() + "\"" + this.getAttributeValue() + "\"]");
    }

    @Nullable
    public Icon getIcon(int flags) {
        return this.getType().getIcon();
    }

    public int getTextOffset() {
        CssAttributeRSide rSide;
        if (this.getType() != CssSelectorSuffixType.UNKNOWN && (rSide = this.getRSide()) != null) {
            return super.getTextOffset() + rSide.getStartOffsetInParent();
        }
        return super.getTextOffset();
    }

    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this);
        if (psiReferenceArray == null) {
            CssAttributeImpl.$$$reportNull$$$0(13);
        }
        return psiReferenceArray;
    }

    public PsiReference getReference() {
        return (PsiReference)ArrayUtil.getFirstElement((Object[])this.getReferences());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/CssAttributeImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/CssAttributeImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeName";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeValue";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperatorType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 13 -> new IllegalStateException(string);
        };
    }
}

