/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportModuleStatement;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001#B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0007J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0007J\u0015\u0010\u0013\u001a\u00020\u00052\u000b\u0010\u0014\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0015H\u0007J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001bH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/codeInsight/DumbAwareAnnotationUtil;", "", "<init>", "()V", "JAVA_LANG_PACKAGE", "", "KNOWN_ANNOTATIONS", "", "KNOWN_MODULE_TO_ANNOTATIONS_MAP", "", "hasAnnotation", "", "owner", "Lcom/intellij/psi/PsiModifierListOwner;", "fqn", "isAnnotationMatchesFqn", "annotation", "Lcom/intellij/psi/PsiAnnotation;", "annotationFqn", "getFormattedReferenceFqn", "referenceText", "Lcom/intellij/openapi/util/NlsSafe;", "getImportedKnownAnnotations", "file", "Lcom/intellij/psi/PsiJavaFile;", "isAnnotationInImportList", "importList", "Lcom/intellij/psi/PsiImportList;", "isAnnotationInModuleImportList", "moduleList", "getAnnotationImportInfo", "Lcom/intellij/codeInsight/DumbAwareAnnotationUtil$AnnotationImportInfo;", "getCanonicalTextOfTheReference", "reference", "Lcom/intellij/psi/PsiJavaCodeReferenceElement;", "AnnotationImportInfo", "intellij.java.psi"})
@SourceDebugExtension(value={"SMAP\nDumbAwareAnnotationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumbAwareAnnotationUtil.kt\ncom/intellij/codeInsight/DumbAwareAnnotationUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n13225#2,2:116\n13225#2,2:118\n777#3:120\n873#3,2:121\n1642#3,10:123\n1915#3:133\n1916#3:135\n1652#3:136\n1#4:134\n*S KotlinDebug\n*F\n+ 1 DumbAwareAnnotationUtil.kt\ncom/intellij/codeInsight/DumbAwareAnnotationUtil\n*L\n89#1:116,2\n98#1:118,2\n81#1:120\n81#1:121,2\n82#1:123,10\n82#1:133\n82#1:135\n82#1:136\n82#1:134\n*E\n"})
public final class DumbAwareAnnotationUtil {
    @NotNull
    public static final DumbAwareAnnotationUtil INSTANCE = new DumbAwareAnnotationUtil();
    @NotNull
    private static final String JAVA_LANG_PACKAGE = "java.lang";
    @NotNull
    private static final Set<String> KNOWN_ANNOTATIONS;
    @NotNull
    private static final Map<String, Set<String>> KNOWN_MODULE_TO_ANNOTATIONS_MAP;

    private DumbAwareAnnotationUtil() {
    }

    @JvmStatic
    public static final boolean hasAnnotation(@NotNull PsiModifierListOwner owner, @NotNull String fqn) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
        PsiAnnotation[] psiAnnotationArray = owner.getAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"getAnnotations(...)");
        for (PsiAnnotation annotation : psiAnnotationArray) {
            Intrinsics.checkNotNull((Object)annotation);
            if (!DumbAwareAnnotationUtil.isAnnotationMatchesFqn(annotation, fqn)) continue;
            return true;
        }
        return false;
    }

    @JvmStatic
    public static final boolean isAnnotationMatchesFqn(@NotNull PsiAnnotation annotation, @NotNull String annotationFqn) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)annotationFqn, (String)"annotationFqn");
        PsiFile psiFile = annotation.getContainingFile();
        PsiJavaFile psiJavaFile = psiFile instanceof PsiJavaFile ? (PsiJavaFile)psiFile : null;
        if (psiJavaFile == null) {
            return false;
        }
        PsiJavaFile file = psiJavaFile;
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = annotation.getNameReferenceElement();
        if (psiJavaCodeReferenceElement == null) {
            return false;
        }
        PsiJavaCodeReferenceElement referenceElement = psiJavaCodeReferenceElement;
        if (referenceElement.isQualified() && Intrinsics.areEqual((Object)INSTANCE.getCanonicalTextOfTheReference(referenceElement), (Object)annotationFqn)) {
            return true;
        }
        PsiElement psiElement = referenceElement.getReferenceNameElement();
        if (psiElement == null) {
            return false;
        }
        PsiElement nameElement = psiElement;
        AnnotationImportInfo importInfo = INSTANCE.getAnnotationImportInfo(annotationFqn);
        if (Intrinsics.areEqual((Object)importInfo.getPackageName(), (Object)JAVA_LANG_PACKAGE) && Intrinsics.areEqual((Object)importInfo.getClassName(), (Object)nameElement.getText())) {
            return true;
        }
        return INSTANCE.getImportedKnownAnnotations(file).contains(nameElement.getText()) && Intrinsics.areEqual((Object)importInfo.getClassName(), (Object)nameElement.getText());
    }

    @JvmStatic
    @NotNull
    public static final String getFormattedReferenceFqn(@NotNull String referenceText) {
        Intrinsics.checkNotNullParameter((Object)referenceText, (String)"referenceText");
        String[] stringArray = new String[]{"."};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)referenceText, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)".", null, null, (int)0, null, DumbAwareAnnotationUtil::getFormattedReferenceFqn$lambda$0, (int)30, null);
    }

    private final Set<String> getImportedKnownAnnotations(PsiJavaFile file) {
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file), () -> DumbAwareAnnotationUtil.getImportedKnownAnnotations$lambda$0(file));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Set)object;
    }

    private final boolean isAnnotationInImportList(String annotationFqn, PsiImportList importList) {
        boolean bl;
        block1: {
            String string = StringUtil.getPackageName((String)annotationFqn);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
            String packageName = string;
            PsiImportStatement[] psiImportStatementArray = importList.getImportStatements();
            Intrinsics.checkNotNullExpressionValue((Object)psiImportStatementArray, (String)"getImportStatements(...)");
            Object[] $this$any$iv = psiImportStatementArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiJavaCodeReferenceElement referenceElement;
                String referenceElementText;
                PsiImportStatement statement = (PsiImportStatement)element$iv;
                boolean bl2 = false;
                if (!(statement.getImportReference() == null ? false : Intrinsics.areEqual((Object)(referenceElementText = INSTANCE.getCanonicalTextOfTheReference(referenceElement)), (Object)annotationFqn) || statement.isOnDemand() && StringsKt.startsWith$default((String)referenceElementText, (String)packageName, (boolean)false, (int)2, null))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isAnnotationInModuleImportList(String annotationFqn, PsiImportList moduleList) {
        boolean bl;
        block2: {
            if (!PsiUtil.isAvailable(JavaFeature.MODULE_IMPORT_DECLARATIONS, moduleList)) {
                return false;
            }
            PsiImportModuleStatement[] psiImportModuleStatementArray = moduleList.getImportModuleStatements();
            Intrinsics.checkNotNullExpressionValue((Object)psiImportModuleStatementArray, (String)"getImportModuleStatements(...)");
            Object[] $this$any$iv = psiImportModuleStatementArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                String referenceName;
                String formattedReferenceName;
                PsiImportModuleStatement statement = (PsiImportModuleStatement)element$iv;
                boolean bl2 = false;
                if (!(statement.getReferenceName() == null ? false : (!KNOWN_MODULE_TO_ANNOTATIONS_MAP.containsKey(formattedReferenceName = DumbAwareAnnotationUtil.getFormattedReferenceFqn(referenceName)) ? false : ((Set)MapsKt.getValue(KNOWN_MODULE_TO_ANNOTATIONS_MAP, (Object)formattedReferenceName)).contains(annotationFqn)))) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    private final AnnotationImportInfo getAnnotationImportInfo(String annotationFqn) {
        String string = StringUtil.getPackageName((String)annotationFqn);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
        String packageName = string;
        String string2 = StringUtil.getShortName((String)annotationFqn);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getShortName(...)");
        String className = string2;
        return new AnnotationImportInfo(packageName, className);
    }

    private final String getCanonicalTextOfTheReference(PsiJavaCodeReferenceElement reference) {
        String string = reference.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return DumbAwareAnnotationUtil.getFormattedReferenceFqn(string);
    }

    private static final CharSequence getFormattedReferenceFqn$lambda$0(String pathPart) {
        Intrinsics.checkNotNullParameter((Object)pathPart, (String)"pathPart");
        return ((Object)StringsKt.trim((CharSequence)pathPart)).toString();
    }

    /*
     * WARNING - void declaration
     */
    private static final CachedValueProvider.Result getImportedKnownAnnotations$lambda$0(PsiJavaFile $file) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        PsiImportList psiImportList = $file.getImportList();
        if (psiImportList == null) {
            Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
            return new CachedValueProvider.Result((Object)SetsKt.emptySet(), objectArray);
        }
        PsiImportList importList = psiImportList;
        Iterable $this$filter$iv = KNOWN_ANNOTATIONS;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(INSTANCE.isAnnotationInImportList(it, importList) || INSTANCE.isAnnotationInModuleImportList(it, importList))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String fqn = (String)element$iv$iv;
            boolean bl2 = false;
            String[] stringArray = new String[]{"."};
            if ((String)CollectionsKt.lastOrNull((List)StringsKt.split$default((CharSequence)fqn, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set filteredAnnotations = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        return CachedValueProvider.Result.create((Object)filteredAnnotations, (Object[])objectArray);
    }

    static {
        Object[] objectArray = new String[]{"org.jetbrains.annotations.NotNull", "org.jetbrains.annotations.Nullable", "org.jetbrains.annotations.NonNls", "org.jspecify.annotations.NonNull", "org.jspecify.annotations.Nullable"};
        KNOWN_ANNOTATIONS = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[2];
        Object[] objectArray2 = new String[]{"org.jetbrains.annotations.NotNull", "org.jetbrains.annotations.Nullable", "org.jetbrains.annotations.NonNls"};
        objectArray[0] = TuplesKt.to((Object)"org.jetbrains.annotations", (Object)SetsKt.setOf((Object[])objectArray2));
        objectArray2 = new String[]{"org.jspecify.annotations.NonNull", "org.jspecify.annotations.Nullable"};
        objectArray[1] = TuplesKt.to((Object)"org.jspecify", (Object)SetsKt.setOf((Object[])objectArray2));
        KNOWN_MODULE_TO_ANNOTATIONS_MAP = MapsKt.mapOf((Pair[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004J\n\u0010\u0012\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/codeInsight/DumbAwareAnnotationUtil$AnnotationImportInfo;", "", "packageName", "", "className", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getPackageName", "()Ljava/lang/String;", "getClassName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.java.psi"})
    private static final class AnnotationImportInfo {
        @NotNull
        private final String packageName;
        @NotNull
        private final String className;

        public AnnotationImportInfo(@NotNull String packageName, @NotNull String className) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            this.packageName = packageName;
            this.className = className;
        }

        @NotNull
        public final String getPackageName() {
            return this.packageName;
        }

        @NotNull
        public final String getClassName() {
            return this.className;
        }

        @NotNull
        public final String component1() {
            return this.packageName;
        }

        @NotNull
        public final String component2() {
            return this.className;
        }

        @NotNull
        public final AnnotationImportInfo copy(@NotNull String packageName, @NotNull String className) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            return new AnnotationImportInfo(packageName, className);
        }

        public static /* synthetic */ AnnotationImportInfo copy$default(AnnotationImportInfo annotationImportInfo, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = annotationImportInfo.packageName;
            }
            if ((n & 2) != 0) {
                string2 = annotationImportInfo.className;
            }
            return annotationImportInfo.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "AnnotationImportInfo(packageName=" + this.packageName + ", className=" + this.className + ')';
        }

        public int hashCode() {
            int result = this.packageName.hashCode();
            result = result * 31 + this.className.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnnotationImportInfo)) {
                return false;
            }
            AnnotationImportInfo annotationImportInfo = (AnnotationImportInfo)other;
            if (!Intrinsics.areEqual((Object)this.packageName, (Object)annotationImportInfo.packageName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.className, (Object)annotationImportInfo.className);
        }
    }
}

