/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.JavaTypingTokenSets;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.TypedHandlerUtil;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.core.JavaPsiBundle;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractBasicJavaFile;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaTypedHandlerBase
extends TypedHandlerDelegate {
    private boolean myJavaLTTyped;

    protected JavaTypedHandlerBase() {
    }

    private static boolean isJavaFile(@NotNull PsiFile file) {
        if (file == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(0);
        }
        return file instanceof AbstractBasicJavaFile;
    }

    private static boolean isJspFile(@NotNull PsiFile file) {
        if (file == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(1);
        }
        return file.getLanguage() instanceof XMLLanguage;
    }

    protected void autoPopupMemberLookup(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(3);
        }
    }

    protected void autoPopupJavadocLookup(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(5);
        }
    }

    private static boolean isLanguageLevel5OrHigher(@NotNull PsiFile file) {
        if (file == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(6);
        }
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @NotNull
    private static TypedHandlerDelegate.Result processWhileAndIfStatementBody(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(8);
        }
        if (file == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(9);
        }
        CommandProcessor.getInstance().executeCommand(project, () -> new JavaSmartEnterProcessor().process(project, editor, file), JavaPsiBundle.message("command.name.insert.block.statement", new Object[0]), null);
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
        if (result == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(10);
        }
        return result;
    }

    public boolean handleEquality(Project project, Editor editor, PsiFile file, int offsetBefore) {
        return false;
    }

    protected boolean handleQuestionMark(Project project, Editor editor, PsiFile file, int offsetBefore) {
        return false;
    }

    protected boolean handleAnnotationParameter(Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(11);
        }
        if (file == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(12);
        }
        return false;
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        HighlighterIterator iterator;
        int offset;
        if (project == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(13);
        }
        if (editor == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(14);
        }
        if (file == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(15);
        }
        if (fileType == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(16);
        }
        if (!JavaTypedHandlerBase.isJavaFile(file)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                JavaTypedHandlerBase.$$$reportNull$$$0(17);
            }
            return result;
        }
        if (c == '@') {
            this.autoPopupJavadocLookup(project, editor);
        } else if (c == '#' || c == '.') {
            this.autoPopupMemberLookup(project, editor);
        }
        int offsetBefore = editor.getCaretModel().getOffset();
        boolean bl = this.myJavaLTTyped = '<' == c && !JavaTypedHandlerBase.isJspFile(file) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && JavaTypedHandlerBase.isLanguageLevel5OrHigher(file) && TypedHandlerUtil.isAfterClassLikeIdentifierOrDot((int)offsetBefore, (Editor)editor, (IElementType)JavaTokenType.DOT, (IElementType)JavaTokenType.IDENTIFIER, (boolean)true);
        if ('>' == c && !JavaTypedHandlerBase.isJspFile(file) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && JavaTypedHandlerBase.isLanguageLevel5OrHigher(file) && TypedHandlerUtil.handleGenericGT((Editor)editor, (IElementType)JavaTokenType.LT, (IElementType)JavaTokenType.GT, (TokenSet)JavaTypingTokenSets.INVALID_INSIDE_REFERENCE)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                JavaTypedHandlerBase.$$$reportNull$$$0(18);
            }
            return result;
        }
        if (c == '?' && this.handleQuestionMark(project, editor, file, offsetBefore)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                JavaTypedHandlerBase.$$$reportNull$$$0(19);
            }
            return result;
        }
        if (c == '=' && this.handleEquality(project, editor, file, offsetBefore)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                JavaTypedHandlerBase.$$$reportNull$$$0(20);
            }
            return result;
        }
        if (c == ';' && JavaTypedHandlerBase.handleSemicolon(project, editor, file, fileType)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                JavaTypedHandlerBase.$$$reportNull$$$0(21);
            }
            return result;
        }
        if (fileType instanceof JavaFileType && c == '}') {
            offset = editor.getCaretModel().getOffset();
            iterator = editor.getHighlighter().createIterator(offset);
            CharSequence sequence = editor.getDocument().getCharsSequence();
            if (!(iterator.atEnd() || iterator.getStart() != offset || iterator.getTokenType() != JavaTokenType.STRING_TEMPLATE_END && iterator.getTokenType() != JavaTokenType.TEXT_BLOCK_TEMPLATE_END && iterator.getTokenType() != JavaTokenType.STRING_TEMPLATE_MID && iterator.getTokenType() != JavaTokenType.TEXT_BLOCK_TEMPLATE_MID || sequence.length() <= offset || sequence.charAt(offset) != '}')) {
                editor.getCaretModel().moveToOffset(offset + 1);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    JavaTypedHandlerBase.$$$reportNull$$$0(22);
                }
                return result;
            }
        }
        if (fileType instanceof JavaFileType && c == '{') {
            TypedHandlerDelegate.Result stop;
            PsiElement prev;
            CharSequence sequence;
            offset = editor.getCaretModel().getOffset();
            if (offset == 0) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    JavaTypedHandlerBase.$$$reportNull$$$0(23);
                }
                return result;
            }
            iterator = editor.getHighlighter().createIterator(offset - 1);
            while (!iterator.atEnd() && iterator.getTokenType() == TokenType.WHITE_SPACE) {
                iterator.retreat();
            }
            if (iterator.atEnd() || iterator.getTokenType() == JavaTokenType.RBRACKET || iterator.getTokenType() == JavaTokenType.EQ) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    JavaTypedHandlerBase.$$$reportNull$$$0(24);
                }
                return result;
            }
            Document doc = editor.getDocument();
            if (!(iterator.atEnd() || iterator.getTokenType() != StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN && iterator.getTokenType() != StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN || !CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET || (sequence = doc.getCharsSequence()).charAt(offset - 1) != '\\' || sequence.length() != offset && sequence.charAt(offset) == '}')) {
                doc.insertString(offset, (CharSequence)"{}");
                editor.getCaretModel().moveToOffset(offset + 1);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    JavaTypedHandlerBase.$$$reportNull$$$0(25);
                }
                return result;
            }
            PsiDocumentManager.getInstance((Project)project).commitDocument(doc);
            PsiElement leaf = file.findElementAt(offset);
            if (PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiArrayInitializerExpression.class, (boolean)false, (Class[])new Class[]{PsiCodeBlock.class, PsiMember.class}) != null) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    JavaTypedHandlerBase.$$$reportNull$$$0(26);
                }
                return result;
            }
            PsiElement st = leaf != null ? leaf.getParent() : null;
            PsiElement psiElement = prev = offset > 1 ? file.findElementAt(offset - 1) : null;
            if (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && JavaTypedHandlerBase.isRparenth(leaf) && (st instanceof PsiWhileStatement || st instanceof PsiIfStatement) && JavaTypedHandlerBase.shouldInsertStatementBody(st, doc, prev)) {
                return JavaTypedHandlerBase.processWhileAndIfStatementBody(project, editor, file);
            }
            if (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && JavaTypedHandlerBase.afterArrowInCase(leaf) && iterator.getTokenType() != JavaTokenType.LBRACKET && (stop = JavaTypedHandlerBase.processOpenBraceInOneLineCaseRule(project, editor, file, leaf)) != null) {
                TypedHandlerDelegate.Result result = stop;
                if (result == null) {
                    JavaTypedHandlerBase.$$$reportNull$$$0(27);
                }
                return result;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiCodeBlock.class, (boolean)false, (Class[])new Class[]{PsiMember.class}) != null && !JavaTypedHandlerBase.shouldInsertPairedBrace(leaf)) {
                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)"{");
                TypedHandler.indentOpenedBrace((Project)project, (Editor)editor);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    JavaTypedHandlerBase.$$$reportNull$$$0(28);
                }
                return result;
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(29);
        }
        return result;
    }

    @Nullable
    private static TypedHandlerDelegate.Result processOpenBraceInOneLineCaseRule(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement leaf) {
        PsiElement rule;
        if (project == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(30);
        }
        if (editor == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(31);
        }
        if (file == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(32);
        }
        if (leaf == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(33);
        }
        if ((rule = PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiSwitchLabeledRuleStatement.class)) != null) {
            while (true) {
                PsiElement next;
                if ((next = rule.getNextSibling()) instanceof PsiWhiteSpace) {
                    next = next.getNextSibling();
                }
                if (!(next instanceof PsiThrowStatement) && !(next instanceof PsiExpressionStatement)) break;
                rule = next;
            }
        }
        if (rule != null) {
            String text;
            int firstOffset = editor.getCaretModel().getOffset();
            editor.getDocument().insertString(firstOffset, (CharSequence)"{");
            boolean hasFirstBreakLine = true;
            int expectedIndex = firstOffset - leaf.getTextRange().getStartOffset();
            if (expectedIndex >= 0 && expectedIndex < leaf.getText().length() && !(text = leaf.getText().substring(expectedIndex)).contains("\n") && !text.contains("\r")) {
                hasFirstBreakLine = false;
                editor.getDocument().insertString(firstOffset + 1, (CharSequence)"\n");
            }
            editor.getCaretModel().moveToOffset(firstOffset + 1);
            int secondOffset = rule.getTextRange().getEndOffset() + (hasFirstBreakLine ? 1 : 2);
            editor.getDocument().insertString(secondOffset, (CharSequence)"\n}");
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, secondOffset + 1);
            if (!hasFirstBreakLine) {
                CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, firstOffset + 2);
            }
            return TypedHandlerDelegate.Result.STOP;
        }
        return null;
    }

    private static boolean afterArrowInCase(@Nullable PsiElement leaf) {
        PsiElement body;
        if (leaf == null) {
            return false;
        }
        IElementType leafElementType = leaf.getNode().getElementType();
        if (leafElementType == JavaTokenType.STRING_LITERAL || leafElementType == JavaTokenType.TEXT_BLOCK_LITERAL || leafElementType == JavaTokenType.CHARACTER_LITERAL) {
            return false;
        }
        PsiElement prevLeaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)leaf);
        if (prevLeaf == null) {
            return false;
        }
        if (prevLeaf.getNode().getElementType() != JavaTokenType.ARROW) {
            return false;
        }
        PsiElement parent = prevLeaf.getParent();
        if (parent == null) {
            return false;
        }
        if (!(parent instanceof PsiSwitchLabeledRuleStatement)) {
            return false;
        }
        if (StringUtil.isEmptyOrSpaces((String)leaf.getText())) {
            leaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)leaf);
        }
        PsiElement psiElement = body = leaf instanceof PsiExpressionStatement || leaf instanceof PsiThrowStatement ? leaf : PsiTreeUtil.getParentOfType((PsiElement)leaf, (Class[])new Class[]{PsiExpressionStatement.class, PsiThrowStatement.class});
        if (body == null) {
            return false;
        }
        return PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)body, (boolean)false);
    }

    private static boolean shouldInsertPairedBrace(@NotNull PsiElement leaf) {
        PsiElement prevLeaf;
        if (leaf == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(34);
        }
        if ((prevLeaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)leaf)) != null && prevLeaf.getNode().getElementType() == JavaTokenType.ARROW) {
            return true;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)prevLeaf, PsiNewExpression.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class, PsiMember.class}) != null) {
            return true;
        }
        if (prevLeaf instanceof PsiIdentifier && prevLeaf.getParent() instanceof PsiClass) {
            return true;
        }
        return PsiUtil.isJavaToken(prevLeaf, JavaTokenType.RPARENTH) && prevLeaf.getParent() instanceof PsiRecordHeader;
    }

    private static boolean shouldInsertStatementBody(@NotNull PsiElement statement, @NotNull Document doc, @Nullable PsiElement prev) {
        if (statement == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(35);
        }
        if (doc == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(36);
        }
        PsiStatement block = statement instanceof PsiWhileStatement ? ((PsiWhileStatement)statement).getBody() : ((PsiIfStatement)statement).getThenBranch();
        PsiExpression condition = (PsiExpression)PsiTreeUtil.getChildOfType((PsiElement)statement, PsiExpression.class);
        PsiExpression latestExpression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)prev, PsiExpression.class);
        if (latestExpression instanceof PsiNewExpression && ((PsiNewExpression)latestExpression).getAnonymousClass() == null) {
            return false;
        }
        return !(block instanceof PsiBlockStatement) && (block == null || JavaTypedHandlerBase.startLine(doc, block) != JavaTypedHandlerBase.startLine(doc, statement) || condition == null);
    }

    private static boolean isRparenth(@Nullable PsiElement leaf) {
        if (leaf == null) {
            return false;
        }
        if (leaf.getNode().getElementType() == JavaTokenType.RPARENTH) {
            return true;
        }
        PsiElement next = PsiTreeUtil.nextVisibleLeaf((PsiElement)leaf);
        if (next == null) {
            return false;
        }
        return next.getNode().getElementType() == JavaTokenType.RPARENTH;
    }

    private static int startLine(@NotNull Document doc, @NotNull PsiElement psiElement) {
        if (doc == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(37);
        }
        if (psiElement == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(38);
        }
        return doc.getLineNumber(psiElement.getTextRange().getStartOffset());
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(39);
        }
        if (editor == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(40);
        }
        if (file == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(41);
        }
        if (!JavaTypedHandlerBase.isJavaFile(file)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                JavaTypedHandlerBase.$$$reportNull$$$0(42);
            }
            return result;
        }
        if (this.myJavaLTTyped) {
            this.myJavaLTTyped = false;
            TypedHandlerUtil.handleAfterGenericLT((Editor)editor, (IElementType)JavaTokenType.LT, (IElementType)JavaTokenType.GT, (TokenSet)JavaTypingTokenSets.INVALID_INSIDE_REFERENCE);
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                JavaTypedHandlerBase.$$$reportNull$$$0(43);
            }
            return result;
        }
        if (c == ':') {
            if (JavaTypedHandlerBase.autoIndentCase(editor, project, file)) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    JavaTypedHandlerBase.$$$reportNull$$$0(44);
                }
                return result;
            }
        } else {
            if (c == ',' && this.handleAnnotationParameter(project, editor, file)) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    JavaTypedHandlerBase.$$$reportNull$$$0(45);
                }
                return result;
            }
            if (c == '.' && JavaTypedHandlerBase.handleDotTyped(project, editor, file)) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    JavaTypedHandlerBase.$$$reportNull$$$0(46);
                }
                return result;
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(47);
        }
        return result;
    }

    private static boolean handleDotTyped(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        int offset;
        if (project == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(48);
        }
        if (editor == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(49);
        }
        if (file == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(50);
        }
        if ((offset = editor.getCaretModel().getOffset() - 1) >= 0) {
            Document document = editor.getDocument();
            int line = document.getLineNumber(offset);
            int lineStart = document.getLineStartOffset(line);
            if (StringUtil.isEmptyOrSpaces((CharSequence)document.getCharsSequence().subSequence(lineStart, offset))) {
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, offset);
                return true;
            }
        }
        return false;
    }

    private static boolean handleSemicolon(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(51);
        }
        if (editor == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(52);
        }
        if (file == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(53);
        }
        if (fileType == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(54);
        }
        if (!(fileType instanceof JavaFileType)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == editor.getDocument().getTextLength()) {
            return false;
        }
        if (JavaTypedHandlerBase.moveSemicolonAtRParen(project, editor, file, offset)) {
            return true;
        }
        char charAt = editor.getDocument().getCharsSequence().charAt(offset);
        if (charAt != ';') {
            return false;
        }
        HighlighterIterator hi = editor.getHighlighter().createIterator(offset);
        if (hi.atEnd() || hi.getTokenType() != JavaTokenType.SEMICOLON) {
            return false;
        }
        EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
        return true;
    }

    private static boolean moveSemicolonAtRParen(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, int caretOffset) {
        if (project == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(55);
        }
        if (editor == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(56);
        }
        if (file == null) {
            JavaTypedHandlerBase.$$$reportNull$$$0(57);
        }
        if (!Registry.is((String)"editor.move.semicolon.after.paren")) {
            return false;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        HighlighterIterator it = editor.getHighlighter().createIterator(caretOffset);
        int afterLastParenOffset = -1;
        while (!it.atEnd() && !JavaTypedHandlerBase.isAtLineEnd(it) && it.getTokenType() != JavaTokenType.RBRACE) {
            if (it.getTokenType() == JavaTokenType.RPARENTH) {
                afterLastParenOffset = it.getEnd();
            } else if (it.getTokenType() != TokenType.WHITE_SPACE) {
                return false;
            }
            it.advance();
        }
        if (!it.atEnd() && afterLastParenOffset >= 0 && afterLastParenOffset >= caretOffset) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiElement curElement = file.findElementAt(caretOffset);
            PsiStatement curStmt = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)curElement, PsiStatement.class);
            if (curStmt != null) {
                int stmtEndOffset;
                if (curStmt instanceof PsiTryStatement) {
                    return false;
                }
                if (curStmt instanceof PsiForStatement) {
                    return false;
                }
                if (PsiTreeUtil.getDeepestLast((PsiElement)curStmt) instanceof PsiErrorElement && ((stmtEndOffset = curStmt.getTextRange().getEndOffset()) == afterLastParenOffset || stmtEndOffset == it.getStart())) {
                    editor.getDocument().insertString(stmtEndOffset, (CharSequence)";");
                    editor.getCaretModel().moveToOffset(stmtEndOffset + 1);
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isAtLineEnd(HighlighterIterator it) {
        if (it.getTokenType() == TokenType.WHITE_SPACE) {
            CharSequence tokenText = it.getDocument().getImmutableCharSequence().subSequence(it.getStart(), it.getEnd());
            return CharArrayUtil.containLineBreaks((CharSequence)tokenText);
        }
        return false;
    }

    private static boolean autoIndentCase(Editor editor, Project project, PsiFile file) {
        PsiElement parent;
        int offset = editor.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        PsiElement currElement = file.findElementAt(offset - 1);
        if (currElement != null && (parent = currElement.getParent()) instanceof PsiSwitchLabelStatement) {
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, parent.getTextOffset());
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 42, 43, 44, 45, 46, 47 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 13: 
            case 30: 
            case 39: 
            case 48: 
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 31: 
            case 40: 
            case 49: 
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/JavaTypedHandlerBase";
                break;
            }
            case 16: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaf";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/JavaTypedHandlerBase";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "processWhileAndIfStatementBody";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isJavaFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isJspFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "autoPopupMemberLookup";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "autoPopupJavadocLookup";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevel5OrHigher";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processWhileAndIfStatementBody";
                break;
            }
            case 10: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "handleAnnotationParameter";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processOpenBraceInOneLineCaseRule";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "shouldInsertPairedBrace";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "shouldInsertStatementBody";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "startLine";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "handleDotTyped";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "handleSemicolon";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "moveSemicolonAtRParen";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 42, 43, 44, 45, 46, 47 -> new IllegalStateException(string);
        };
    }
}

