/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CatchDeclarationFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            CatchDeclarationFixer.$$$reportNull$$$0(0);
        }
        if (psiElement instanceof PsiCatchSection) {
            PsiCatchSection catchSection = (PsiCatchSection)psiElement;
            Document doc = editor.getDocument();
            int catchStart = catchSection.getTextRange().getStartOffset();
            int stopOffset = doc.getLineEndOffset(doc.getLineNumber(catchStart));
            PsiCodeBlock catchBlock = catchSection.getCatchBlock();
            if (catchBlock != null) {
                stopOffset = Math.min(stopOffset, catchBlock.getTextRange().getStartOffset());
            }
            stopOffset = Math.min(stopOffset, catchSection.getTextRange().getEndOffset());
            PsiJavaToken lParenth = catchSection.getLParenth();
            if (lParenth == null) {
                doc.replaceString(catchStart, stopOffset, (CharSequence)"catch ()");
                processor.registerUnresolvedError(catchStart + "catch (".length());
            } else {
                if (catchSection.getParameter() == null) {
                    processor.registerUnresolvedError(lParenth.getTextRange().getEndOffset());
                }
                if (catchSection.getRParenth() == null) {
                    doc.insertString(stopOffset, (CharSequence)")");
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInsight/editorActions/smartEnter/CatchDeclarationFixer", "apply"));
    }
}

