/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.DeclarationRangeHandler;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceList;
import org.jetbrains.annotations.NotNull;

public final class ClassDeclarationRangeHandler
implements DeclarationRangeHandler {
    @NotNull
    public TextRange getDeclarationRange(@NotNull PsiElement container) {
        PsiClass aClass;
        if (container == null) {
            ClassDeclarationRangeHandler.$$$reportNull$$$0(0);
        }
        if ((aClass = (PsiClass)container) instanceof PsiAnonymousClass) {
            PsiConstructorCall call = (PsiConstructorCall)aClass.getParent();
            int startOffset = call.getTextRange().getStartOffset();
            int endOffset = call.getArgumentList().getTextRange().getEndOffset();
            return new TextRange(startOffset, endOffset);
        }
        PsiModifierList modifierList = aClass.getModifierList();
        int startOffset = modifierList == null ? aClass.getTextRange().getStartOffset() : modifierList.getTextRange().getStartOffset();
        PsiReferenceList implementsList = aClass.getImplementsList();
        int endOffset = implementsList == null ? aClass.getTextRange().getEndOffset() : implementsList.getTextRange().getEndOffset();
        return new TextRange(startOffset, endOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/codeInsight/hint/ClassDeclarationRangeHandler", "getDeclarationRange"));
    }
}

