/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.core.JavaPsiBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.BitUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class ReferenceParser {
    public static final int EAT_LAST_DOT = 1;
    public static final int ELLIPSIS = 2;
    public static final int WILDCARD = 4;
    public static final int DIAMONDS = 8;
    public static final int DISJUNCTIONS = 16;
    public static final int CONJUNCTIONS = 32;
    public static final int INCOMPLETE_ANNO = 64;
    public static final int VAR_TYPE = 128;
    private static final TokenSet WILDCARD_KEYWORD_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.EXTENDS_KEYWORD, JavaTokenType.SUPER_KEYWORD});
    private final JavaParser myParser;

    @Nullable
    public PsiBuilder.Marker parseType(PsiBuilder builder, int flags) {
        TypeInfo typeInfo = this.parseTypeInfo(builder, flags);
        return typeInfo != null ? typeInfo.marker : null;
    }

    @Nullable
    private TypeInfo parseTypeInfo(PsiBuilder builder, int flags, boolean badWildcard) {
        if (builder.getTokenType() == null) {
            return null;
        }
        TypeInfo typeInfo = new TypeInfo();
        PsiBuilder.Marker type = builder.mark();
        PsiBuilder.Marker anno = this.myParser.getDeclarationParser().parseAnnotations(builder);
        IElementType tokenType = builder.getTokenType();
        if (tokenType == JavaTokenType.IDENTIFIER && BitUtil.isSet((int)flags, (int)128) && builder.lookAhead(1) != JavaTokenType.DOT && builder.lookAhead(1) != JavaTokenType.COLON && "var".equals(builder.getTokenText()) && JavaFeature.LVTI.isSufficient(JavaParserUtil.getLanguageLevel(builder))) {
            tokenType = JavaTokenType.VAR_KEYWORD;
            builder.remapCurrentToken(tokenType);
        } else if (tokenType == JavaTokenType.VAR_KEYWORD && !BitUtil.isSet((int)flags, (int)128)) {
            tokenType = JavaTokenType.IDENTIFIER;
            builder.remapCurrentToken(tokenType);
        }
        if (PsiBuilderUtil.expect((PsiBuilder)builder, (TokenSet)ElementType.PRIMITIVE_TYPE_BIT_SET)) {
            typeInfo.isPrimitive = true;
        } else {
            if ((BitUtil.isSet((int)flags, (int)4) || badWildcard) && tokenType == JavaTokenType.QUEST) {
                builder.advanceLexer();
                this.completeWildcardType(builder, BitUtil.isSet((int)flags, (int)4), type);
                typeInfo.marker = type;
                return typeInfo;
            }
            if (tokenType == JavaTokenType.IDENTIFIER) {
                this.parseJavaCodeReference(builder, BitUtil.isSet((int)flags, (int)1), true, false, false, false, BitUtil.isSet((int)flags, (int)8), typeInfo);
            } else {
                if (tokenType == JavaTokenType.VAR_KEYWORD) {
                    builder.advanceLexer();
                    type.done(JavaElementType.TYPE);
                    typeInfo.marker = type;
                    return typeInfo;
                }
                if (BitUtil.isSet((int)flags, (int)8) && tokenType == JavaTokenType.GT) {
                    if (anno == null) {
                        JavaParserUtil.emptyElement(builder, JavaElementType.DIAMOND_TYPE);
                    } else {
                        JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                        typeInfo.hasErrors = true;
                    }
                    type.done(JavaElementType.TYPE);
                    typeInfo.marker = type;
                    return typeInfo;
                }
                type.drop();
                if (anno != null && BitUtil.isSet((int)flags, (int)64)) {
                    JavaParserUtil.error(builder, JavaPsiBundle.message("expected.type", new Object[0]));
                    typeInfo.marker = anno;
                    typeInfo.hasErrors = true;
                    return typeInfo;
                }
                return null;
            }
        }
        type.done(JavaElementType.TYPE);
        while (true) {
            this.myParser.getDeclarationParser().parseAnnotations(builder);
            PsiBuilder.Marker bracket = builder.mark();
            if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.LBRACKET)) {
                bracket.drop();
                break;
            }
            if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RBRACKET)) {
                bracket.rollbackTo();
                break;
            }
            bracket.drop();
            typeInfo.isArray = true;
        }
        if (BitUtil.isSet((int)flags, (int)2) && builder.getTokenType() == JavaTokenType.ELLIPSIS) {
            builder.advanceLexer();
            typeInfo.isVarArg = true;
        }
        if (typeInfo.isVarArg || typeInfo.isArray) {
            type = type.precede();
            type.done(JavaElementType.TYPE);
        }
        typeInfo.marker = type;
        return typeInfo;
    }

    private void completeWildcardType(PsiBuilder builder, boolean wildcard, PsiBuilder.Marker type) {
        if (PsiBuilderUtil.expect((PsiBuilder)builder, (TokenSet)WILDCARD_KEYWORD_SET) && this.parseTypeInfo(builder, 1) == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.type", new Object[0]));
        }
        if (wildcard) {
            type.done(JavaElementType.TYPE);
        } else {
            type.error(JavaPsiBundle.message("error.message.wildcard.not.expected", new Object[0]));
        }
    }

    @Nullable
    public PsiBuilder.Marker parseJavaCodeReference(PsiBuilder builder, boolean eatLastDot, boolean parameterList, boolean isNew, boolean diamonds) {
        return this.parseJavaCodeReference(builder, eatLastDot, parameterList, false, false, isNew, diamonds, new TypeInfo());
    }

    public boolean parseImportCodeReference(PsiBuilder builder, boolean isStatic) {
        TypeInfo typeInfo = new TypeInfo();
        this.parseJavaCodeReference(builder, true, false, true, isStatic, false, false, typeInfo);
        return !typeInfo.hasErrors;
    }

    @Nullable
    private PsiBuilder.Marker parseJavaCodeReference(PsiBuilder builder, boolean eatLastDot, boolean parameterList, boolean isImport, boolean isStaticImport, boolean isNew, boolean diamonds, TypeInfo typeInfo) {
        PsiBuilder.Marker refElement = builder.mark();
        this.myParser.getDeclarationParser().parseAnnotations(builder);
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER)) {
            refElement.rollbackTo();
            if (isImport) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
            }
            typeInfo.hasErrors = true;
            return null;
        }
        if (parameterList) {
            typeInfo.isParameterized = this.parseReferenceParameterList(builder, true, diamonds);
        } else if (!isStaticImport) {
            JavaParserUtil.emptyElement(builder, JavaElementType.REFERENCE_PARAMETER_LIST);
        }
        while (builder.getTokenType() == JavaTokenType.DOT) {
            refElement.done(JavaElementType.JAVA_CODE_REFERENCE);
            if (isNew && !diamonds && typeInfo.isParameterized) {
                return refElement;
            }
            PsiBuilder.Marker dotPos = builder.mark();
            builder.advanceLexer();
            this.myParser.getDeclarationParser().parseAnnotations(builder);
            if (isImport && PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.ASTERISK)) {
                dotPos.drop();
                return refElement;
            }
            if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER)) {
                if (!eatLastDot) {
                    dotPos.rollbackTo();
                    return refElement;
                }
                typeInfo.hasErrors = true;
                if (isImport) {
                    JavaParserUtil.error(builder, JavaPsiBundle.message("import.statement.identifier.or.asterisk.expected.", new Object[0]));
                } else {
                    JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                }
                dotPos.drop();
                return refElement;
            }
            dotPos.drop();
            refElement = refElement.precede();
            if (parameterList) {
                typeInfo.isParameterized = this.parseReferenceParameterList(builder, true, diamonds);
                continue;
            }
            JavaParserUtil.emptyElement(builder, JavaElementType.REFERENCE_PARAMETER_LIST);
        }
        if (isStaticImport) {
            refElement.done(JavaElementType.IMPORT_STATIC_REFERENCE);
        } else {
            refElement.done(JavaElementType.JAVA_CODE_REFERENCE);
        }
        return refElement;
    }

    public boolean parseReferenceParameterList(PsiBuilder builder, boolean wildcard, boolean diamonds) {
        PsiBuilder.Marker list = builder.mark();
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.LT)) {
            list.done(JavaElementType.REFERENCE_PARAMETER_LIST);
            return false;
        }
        int flags = BitUtil.set((int)BitUtil.set((int)1, (int)4, (boolean)wildcard), (int)8, (boolean)diamonds);
        boolean isOk = true;
        while (true) {
            if (this.parseTypeInfo(builder, flags, true) == null) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
            } else {
                IElementType tokenType = builder.getTokenType();
                if (WILDCARD_KEYWORD_SET.contains(tokenType)) {
                    this.parseReferenceList(builder, tokenType, null, JavaTokenType.AND);
                }
            }
            if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.GT)) break;
            if (!JavaParserUtil.expectOrError(builder, JavaTokenType.COMMA, "expected.gt.or.comma")) {
                isOk = false;
                break;
            }
            flags = BitUtil.set((int)flags, (int)8, (boolean)false);
        }
        list.done(JavaElementType.REFERENCE_PARAMETER_LIST);
        return isOk;
    }

    @NotNull
    public PsiBuilder.Marker parseTypeParameters(PsiBuilder builder) {
        PsiBuilder.Marker list = builder.mark();
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.LT)) {
            list.done(JavaElementType.TYPE_PARAMETER_LIST);
            PsiBuilder.Marker marker = list;
            if (marker == null) {
                ReferenceParser.$$$reportNull$$$0(0);
            }
            return marker;
        }
        do {
            PsiBuilder.Marker param;
            if ((param = this.parseTypeParameter(builder)) != null) continue;
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.type.parameter", new Object[0]));
        } while (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.COMMA));
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.GT)) {
            if (builder.getTokenType() == JavaTokenType.IDENTIFIER) {
                if (builder.lookAhead(1) == JavaTokenType.GT) {
                    PsiBuilder.Marker errorElement = builder.mark();
                    builder.advanceLexer();
                    errorElement.error(JavaPsiBundle.message("unexpected.identifier", new Object[0]));
                    builder.advanceLexer();
                } else {
                    JavaParserUtil.error(builder, JavaPsiBundle.message("expected.gt", new Object[0]));
                }
            } else {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.gt", new Object[0]));
            }
        }
        list.done(JavaElementType.TYPE_PARAMETER_LIST);
        PsiBuilder.Marker marker = list;
        if (marker == null) {
            ReferenceParser.$$$reportNull$$$0(1);
        }
        return marker;
    }

    @Nullable
    public PsiBuilder.Marker parseTypeParameter(PsiBuilder builder) {
        PsiBuilder.Marker param = builder.mark();
        this.myParser.getDeclarationParser().parseAnnotations(builder);
        boolean wild = PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.QUEST);
        if (!wild && !PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER)) {
            param.rollbackTo();
            return null;
        }
        this.parseReferenceList(builder, JavaTokenType.EXTENDS_KEYWORD, JavaElementType.EXTENDS_BOUND_LIST, JavaTokenType.AND);
        if (!wild) {
            param.done(JavaElementType.TYPE_PARAMETER);
        } else {
            param.error(JavaPsiBundle.message("error.message.wildcard.not.expected", new Object[0]));
        }
        return param;
    }

    public boolean parseReferenceList(PsiBuilder builder, IElementType start, @Nullable IElementType type, IElementType delimiter) {
        PsiBuilder.Marker element = builder.mark();
        boolean endsWithError = false;
        if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)start)) {
            do {
                endsWithError = false;
                PsiBuilder.Marker classReference = this.parseJavaCodeReference(builder, false, true, false, false);
                if (classReference != null) continue;
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                endsWithError = true;
            } while (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)delimiter));
        }
        if (type != null) {
            element.done(type);
        } else {
            element.error(JavaPsiBundle.message("bound.not.expected", new Object[0]));
        }
        return endsWithError;
    }

    @Nullable
    public TypeInfo parseTypeInfo(PsiBuilder builder, int flags) {
        TypeInfo typeInfo;
        TypeInfo typeInfo1 = this.parseTypeInfo(builder, flags, false);
        if (typeInfo1 != null) {
            IElementType operator;
            assert (!BitUtil.isSet((int)flags, (int)16) || !BitUtil.isSet((int)flags, (int)32)) : "don't set both flags simultaneously";
            Object object = BitUtil.isSet((int)flags, (int)16) ? JavaTokenType.OR : (operator = BitUtil.isSet((int)flags, (int)32) ? JavaTokenType.AND : null);
            if (operator != null && builder.getTokenType() == operator) {
                typeInfo1.marker = typeInfo1.marker.precede();
                while (builder.getTokenType() == operator) {
                    builder.advanceLexer();
                    IElementType tokenType = builder.getTokenType();
                    if (tokenType != JavaTokenType.IDENTIFIER && tokenType != JavaTokenType.AT) {
                        JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                    }
                    this.parseTypeInfo(builder, flags, false);
                }
                typeInfo1.marker.done(JavaElementType.TYPE);
            }
        }
        if ((typeInfo = typeInfo1) == null) {
            return null;
        }
        TypeInfo info = new TypeInfo();
        info.isPrimitive = typeInfo.isPrimitive;
        info.isParameterized = typeInfo.isParameterized;
        info.isArray = typeInfo.isArray;
        info.isVarArg = typeInfo.isVarArg;
        info.hasErrors = typeInfo.hasErrors;
        info.marker = typeInfo.marker;
        return info;
    }

    public ReferenceParser(@NotNull JavaParser javaParser) {
        if (javaParser == null) {
            ReferenceParser.$$$reportNull$$$0(2);
        }
        this.myParser = javaParser;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/parser/ReferenceParser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/parser/ReferenceParser";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TypeInfo {
        public boolean isPrimitive;
        public boolean isParameterized;
        public boolean isArray;
        public boolean isVarArg;
        public boolean hasErrors;
        public PsiBuilder.Marker marker;
    }
}

