/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.ui;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.AuthType;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.ui.AuthTypeDescription;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.ui.dsl.listCellRenderer.LcrRow;
import com.intellij.ui.dsl.listCellRenderer.LcrTextInitParams;
import com.intellij.util.SystemProperties;
import java.io.File;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u000e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0007\u001a\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0006\u0010\b\u001a\u00020\t\u001a\b\u0010\n\u001a\u00020\u000bH\u0000\u00a8\u0006\f"}, d2={"createAuthTypeRenderer", "Ljavax/swing/ListCellRenderer;", "Lcom/intellij/remote/AuthType;", "createBrowseListenerForPrivateKey", "Lcom/intellij/openapi/ui/ComponentWithBrowseButton$BrowseFolderActionListener;", "Ljavax/swing/JTextField;", "privateKeyFileField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "manageSshConfiguration", "", "isSshLegallyAvailable", "", "intellij.platform.ssh.ui"})
@JvmName(name="SshUIUtil")
public final class SshUIUtil {
    @ApiStatus.Internal
    @NotNull
    public static final ListCellRenderer<AuthType> createAuthTypeRenderer() {
        return BuilderKt.listCellRenderer(SshUIUtil::H);
    }

    @NotNull
    public static final ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> createBrowseListenerForPrivateKey(@NotNull TextFieldWithBrowseButton privateKeyFileField) {
        Intrinsics.checkNotNullParameter((Object)privateKeyFileField, (String)"privateKeyFileField");
        FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, false, false, true, true, false).withTitle(SshBundle.message("choose.private.key", new Object[0])).withHideIgnored(false).withShowHiddenFiles(true);
        TextComponentAccessor textComponentAccessor = TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT;
        return (ComponentWithBrowseButton.BrowseFolderActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(privateKeyFileField, fileChooserDescriptor, (TextComponentAccessor<JTextField>)textComponentAccessor){

            private final VirtualFile H() {
                String string = SystemProperties.getUserHome();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserHome(...)");
                String string2 = string;
                if (StringUtil.isEmpty((String)string2)) {
                    return null;
                }
                File file = Ssh.getHomeSshDirectory().toFile();
                if (!file.exists()) {
                    return null;
                }
                return LocalFileSystem.getInstance().findFileByIoFile(file);
            }

            protected VirtualFile getInitialFile() {
                VirtualFile virtualFile = super.getInitialFile();
                VirtualFile virtualFile2 = virtualFile;
                if (virtualFile2 == null) {
                    virtualFile2 = this.H();
                }
                return virtualFile2;
            }
        };
    }

    public static final void manageSshConfiguration() {
        ShowSettingsUtil.getInstance().showSettingsDialog(ProjectManager.getInstance().getDefaultProject(), SshBundle.message("ssh.configurable.title", new Object[0]));
    }

    public static final boolean isSshLegallyAvailable() {
        return !PluginManagerCore.isDisabled((PluginId)PluginManagerCore.ULTIMATE_PLUGIN_ID);
    }

    private static final Unit H(LcrTextInitParams lcrTextInitParams) {
        Intrinsics.checkNotNullParameter((Object)lcrTextInitParams, (String)"$this$text");
        lcrTextInitParams.setAttributes(SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
        return Unit.INSTANCE;
    }

    private static final Unit H(LcrRow lcrRow) {
        Intrinsics.checkNotNullParameter((Object)lcrRow, (String)"$this$listCellRenderer");
        AuthTypeDescription authTypeDescription = AuthTypeDescription.Companion.get((AuthType)lcrRow.getValue());
        LcrRow.text$default((LcrRow)lcrRow, (String)authTypeDescription.getLabel(), null, (int)2, null);
        if (authTypeDescription.getNote() != null) {
            String string = authTypeDescription.getNote();
            Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type kotlin.String");
            lcrRow.text(string, SshUIUtil::H);
        }
        return Unit.INSTANCE;
    }
}

