import type * as ts from "typescript/lib/tsserverlibrary"

export interface LspIdeTypeScriptCommandRequest {
  ideCommand: string,
  args: TypeScriptCustomCommandArguments,
}

export interface TypeScriptCustomCommandArguments {
  file: string,
  range?: Range
}

export type GetCompletionSymbolsArguments = {
  file: string;
  position: Position,
  projectFileName?: string;
};

export type GetCompletionSymbolsResponse = {
  response: object;
  responseRequired: true
} | undefined;

export type GetElementTypeArguments = {
  file: string;
  range: Range;
  typeRequestKind: TypeRequestKind;
  projectFileName?: string;
  forceReturnType: boolean;
}

export type GetElementTypeResponse = {
  response: object;
  responseRequired: true
} | undefined;

export type GetSymbolTypeArguments = {
  ideTypeCheckerId: number;
  ideProjectId: number;
  originalRequestUri: string;
  symbolId: number;
}

export type GetSymbolTypeResponse = {
  response: object;
  responseRequired: true
} | undefined;

export type GetTypeTextArguments = {
  ideTypeCheckerId: number;
  ideProjectId: number;
  originalRequestUri: string;
  symbolId: number;
  flags?: number;
};

export type GetTypeTextResponse = {
  response: object;
  responseRequired: true;
} | undefined;

export type GetTypePropertiesArguments = {
  ideTypeCheckerId: number;
  ideProjectId: number;
  originalRequestUri: string;
  typeId: number;
}

export type GetTypePropertyArguments = {
  ideTypeCheckerId: number;
  ideProjectId: number;
  originalRequestUri: string;
  typeId: number;
  propertyName: string;
}

export type AreTypesMutuallyAssignableArguments = {
  ideTypeCheckerId: number;
  ideProjectId: number;
  originalRequestUri: string;
  type1Id: number;
  type2Id: number;
}

export type GetResolvedSignatureArguments = {
  file: string;
  range: Range;
  projectFileName?: string;
}

export type GetResolvedSignatureResponse = {
  response: object;
  responseRequired: true
} | undefined;

export type AreTypesMutuallyAssignableResponse = {
  response: {
    areMutuallyAssignable: boolean,
  };
  responseRequired?: boolean;
} | undefined

export type TestSleepArguments = {
  durationMs: number;
  cancellable: boolean;
}

export type TestSleepResponse = {
  response: {
    cancelled: boolean;
  };
  responseRequired: true;
}

/**
 * @see https://microsoft.github.io/language-server-protocol/specifications/lsp/3.17/specification/#range
 */
export interface Range {
  start: Position;
  end: Position;
}

/**
 * @see https://microsoft.github.io/language-server-protocol/specifications/lsp/3.17/specification/#position
 */
export interface Position extends ts.LineAndCharacter {
}

export type TypeRequestKind =
/** getTypeAtLocation */ "Default" |
  /** ContextFlags.None */ "Contextual" |
  /** ContextFlags.Completions */ "ContextualCompletions";

export type SymbolResponse = {
  response: object | undefined;
  responseRequired: true
} | undefined;