"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.tryHandleCustomTsServerCommandLsp = exports.tryHandleTsServerCommand = exports.initCommandNamesForSessionProvider = exports.registerProtocolHandlers = void 0;
const get_element_type_ts_server_1 = require("./get-element-type-ts-server");
const ide_get_element_type_1 = require("./ide-get-element-type");
const utils_1 = require("./utils");
const customHandlers = {
    "ideGetCompletionSymbols": [get_element_type_ts_server_1.getCompletionSymbolsTsServer, getCompletionSymbolsLsp],
    "ideGetElementType": [get_element_type_ts_server_1.getElementTypeTsServer, getElementTypeLsp],
    "ideGetSymbolType": [get_element_type_ts_server_1.getSymbolTypeTsServer, getSymbolTypeLsp],
    "ideGetTypeProperties": [get_element_type_ts_server_1.getTypePropertiesTsServer, getTypePropertiesLsp],
    "ideGetTypeProperty": [get_element_type_ts_server_1.getTypePropertyTsServer, getTypePropertyLsp],
    "ideGetTypeText": [get_element_type_ts_server_1.getTypeTextTsServer, getTypeTextLsp],
    "ideAreTypesMutuallyAssignable": [get_element_type_ts_server_1.areTypesMutuallyAssignableTsServer, areTypesMutuallyAssignableLsp],
    "ideGetResolvedSignature": [get_element_type_ts_server_1.getResolvedSignatureTsServer, getResolvedSignatureLsp],
    "ideCloseSafely": [closeSafelyTsServer, undefined /* not supported on LSP */],
    "ideEnsureFileAndProjectOpenedCommand": [ensureFileAndProjectOpenedTsServer, undefined /* not supported on LSP */],
    "ideTestSleep": [testSleepTsServer, testSleepLsp], // Test-only command that puts the server to busy waiting
};
/** This method is used to register handlers for TS 5+ */
function registerProtocolHandlers(session, ts, projectService) {
    for (let command in customHandlers) {
        session.addProtocolHandler(command, (request) => {
            try {
                return customHandlers[command][0](ts, projectService, request.arguments) || emptyDoneResponse();
            }
            catch (e) {
                return processError(e);
            }
        });
    }
}
exports.registerProtocolHandlers = registerProtocolHandlers;
/** This method is used by the old session provider logic for TS <5 **/
function initCommandNamesForSessionProvider(TypeScriptCommandNames) {
    for (let command in customHandlers) {
        TypeScriptCommandNames[command] = command;
    }
}
exports.initCommandNamesForSessionProvider = initCommandNamesForSessionProvider;
/** This method is used by the old session provider logic for TS <5  **/
function tryHandleTsServerCommand(ts_impl, projectService, request) {
    var _a, _b;
    try {
        return (_b = (_a = customHandlers[request.command]) === null || _a === void 0 ? void 0 : _a[0]) === null || _b === void 0 ? void 0 : _b.call(_a, ts_impl, projectService, request.arguments);
    }
    catch (e) {
        return processError(e);
    }
}
exports.tryHandleTsServerCommand = tryHandleTsServerCommand;
function tryHandleCustomTsServerCommandLsp(ts, commandName, requestArguments, context) {
    var _a, _b;
    return __awaiter(this, void 0, void 0, function* () {
        try {
            return yield ((_b = (_a = customHandlers[commandName]) === null || _a === void 0 ? void 0 : _a[1]) === null || _b === void 0 ? void 0 : _b.call(_a, ts, requestArguments, context));
        }
        catch (e) {
            return processError(e);
        }
    });
}
exports.tryHandleCustomTsServerCommandLsp = tryHandleCustomTsServerCommandLsp;
function closeSafelyTsServer(_ts, projectService, requestArguments) {
    projectService.ideProjectService.closeClientFileSafely(requestArguments.file);
    return notRequiredResponse();
}
function ensureFileAndProjectOpenedTsServer(_ts, projectService, requestArguments) {
    // Ensure that there is a project opened for the file
    projectService.ideProjectService.getProjectAndSourceFile(requestArguments.file, requestArguments.projectFileName);
    return emptyDoneResponse();
}
let lastIdeProjectId = 0;
function getIdeProjectId(context) {
    var _a;
    return (_a = context.languageService.ideProjectId) !== null && _a !== void 0 ? _a : (context.languageService.ideProjectId = lastIdeProjectId++);
}
function getCompletionSymbolsLsp(ts, requestArgument, lspSupport) {
    return lspSupport.process(requestArgument.file, undefined, context => {
        const { line, character } = requestArgument.position;
        let position = ts.getPositionOfLineAndCharacter(context.sourceFile, line, character);
        return (0, ide_get_element_type_1.getCompletionSymbols)({
            ls: context.languageService,
            ts,
            program: context.program,
            sourceFileName: context.sourceFile.fileName,
            position,
            cancellationToken: context.cancellationToken,
            reverseMapper: context.reverseMapper,
        });
    });
}
function getElementTypeLsp(ts, requestArgument, lspSupport) {
    return lspSupport.process(requestArgument.file, requestArgument.range, context => {
        const ideProjectId = getIdeProjectId(context);
        const range = context.range;
        if (!range)
            return undefined;
        // TODO consider using languageService.webStormGetElementType
        return (0, ide_get_element_type_1.getElementType)({
            ts,
            ideProjectId,
            program: context.program,
            sourceFile: context.sourceFile,
            range,
            typeRequestKind: requestArgument.typeRequestKind,
            forceReturnType: requestArgument.forceReturnType,
            cancellationToken: context.cancellationToken,
            reverseMapper: context.reverseMapper,
        });
    });
}
function getSymbolTypeLsp(ts, requestArgument, lspSupport) {
    return lspSupport.process(requestArgument.originalRequestUri, undefined, context => {
        var _a;
        if (context.languageService.ideProjectId !== requestArgument.ideProjectId
            || ((_a = context.program.getTypeChecker().webStormCacheInfo) === null || _a === void 0 ? void 0 : _a.ideTypeCheckerId) !== requestArgument.ideTypeCheckerId) {
            return undefined;
        }
        return (0, ide_get_element_type_1.getSymbolType)({
            ts,
            program: context.program,
            symbolId: requestArgument.symbolId,
            cancellationToken: context.cancellationToken,
            reverseMapper: context.reverseMapper,
        });
    });
}
function getTypePropertiesLsp(ts, requestArgument, lspSupport) {
    return lspSupport.process(requestArgument.originalRequestUri, undefined, context => {
        if (!isCorrectProjectIdAndTypeCheckerId(context, requestArgument.ideProjectId, requestArgument.ideTypeCheckerId))
            return undefined;
        return (0, ide_get_element_type_1.getTypeProperties)({
            ts,
            program: context.program,
            typeId: requestArgument.typeId,
            cancellationToken: context.cancellationToken,
            reverseMapper: context.reverseMapper,
        });
    });
}
function getTypePropertyLsp(ts, requestArgument, lspSupport) {
    return lspSupport.process(requestArgument.originalRequestUri, undefined, context => {
        if (!isCorrectProjectIdAndTypeCheckerId(context, requestArgument.ideProjectId, requestArgument.ideTypeCheckerId))
            return undefined;
        return (0, ide_get_element_type_1.getTypeProperty)({
            ts,
            program: context.program,
            typeId: requestArgument.typeId,
            propertyName: requestArgument.propertyName,
            cancellationToken: context.cancellationToken,
            reverseMapper: context.reverseMapper,
        });
    });
}
function getTypeTextLsp(ts, requestArgument, lspSupport) {
    return lspSupport.process(requestArgument.originalRequestUri, undefined, context => {
        if (!isCorrectProjectIdAndTypeCheckerId(context, requestArgument.ideProjectId, requestArgument.ideTypeCheckerId))
            return undefined;
        return (0, ide_get_element_type_1.getTypeText)({
            ts,
            program: context.program,
            symbolId: requestArgument.symbolId,
            flags: requestArgument.flags,
        });
    });
}
function areTypesMutuallyAssignableLsp(ts, requestArgument, lspSupport) {
    return lspSupport.process(requestArgument.originalRequestUri, undefined, context => {
        if (!isCorrectProjectIdAndTypeCheckerId(context, requestArgument.ideProjectId, requestArgument.ideTypeCheckerId))
            return undefined;
        return (0, ide_get_element_type_1.areTypesMutuallyAssignable)({
            ts,
            program: context.program,
            type1Id: requestArgument.type1Id,
            type2Id: requestArgument.type2Id,
            cancellationToken: context.cancellationToken,
        });
    });
}
function getResolvedSignatureLsp(ts, requestArgument, lspSupport) {
    return lspSupport.process(requestArgument.file, requestArgument.range, context => {
        const ideProjectId = getIdeProjectId(context);
        if (!context.range)
            return undefined;
        return (0, ide_get_element_type_1.getResolvedSignature)({
            ts,
            ideProjectId,
            program: context.program,
            sourceFile: context.sourceFile,
            range: context.range,
            cancellationToken: context.cancellationToken,
            reverseMapper: context.reverseMapper,
        });
    });
}
function isCorrectProjectIdAndTypeCheckerId(context, ideProjectId, ideTypeCheckerId) {
    var _a;
    if (context.languageService.ideProjectId !== ideProjectId)
        return undefined;
    if (((_a = context.program.getTypeChecker().webStormCacheInfo) === null || _a === void 0 ? void 0 : _a.ideTypeCheckerId) !== ideTypeCheckerId) {
        (0, utils_1.throwIdeError)("OutdatedTypeCheckerIdException");
    }
}
function testSleepTsServer(_ts, projectService, _requestArguments) {
    return testSleep(_requestArguments, projectService.cancellationToken);
}
function testSleep(requestArguments, cancellationToken) {
    const start = Date.now();
    while (!requestArguments.cancellable || !cancellationToken.isCancellationRequested()) {
        if (Date.now() - start > requestArguments.durationMs) {
            return timeoutResponse();
        }
    }
    return cancelledResponse();
}
function processError(e) {
    let ideErrorKind = e.ideKind;
    if (!ideErrorKind)
        throw e;
    switch (ideErrorKind) {
        case "OperationCancelledException":
            return cancelledResponse();
        default:
            return {
                responseRequired: true,
                response: {
                    error: ideErrorKind
                }
            };
    }
}
function testSleepLsp(_ts, _requestArguments, lspSupport) {
    return __awaiter(this, void 0, void 0, function* () {
        return testSleep(_requestArguments, lspSupport.cancellationToken);
    });
}
function notRequiredResponse() {
    return {
        responseRequired: false
    };
}
function emptyDoneResponse() {
    return {
        responseRequired: true,
        response: null
    };
}
function cancelledResponse() {
    return {
        responseRequired: true,
        response: {
            cancelled: true
        }
    };
}
function timeoutResponse() {
    return {
        responseRequired: true,
        response: {
            cancelled: false
        }
    };
}
//# sourceMappingURL=ide-commands.js.map