/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.orm;

import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.jpa.jpb.model.core.pg.PgKeepClassMembers;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001dBA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0013\u001a\u00020\u0003J\u0018\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/intellij/liquibase/orm/FormatterTemplate;", "Lcom/intellij/jpa/jpb/model/core/pg/PgKeepClassMembers;", "content", "", "attributes", "", "", "dirPath", "existFileNames", "", "<init>", "(Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;Ljava/util/Collection;)V", "getContent", "()Ljava/lang/String;", "getAttributes", "()Ljava/util/Map;", "getDirPath", "getExistFileNames", "()Ljava/util/Collection;", "run", "processIncrementPattern", "completeName", "templateFormatter", "Lcom/intellij/liquibase/orm/FormatterTemplate$TemplateFormatter;", "replaceIncrementValue", "changeLogName", "value", "", "pattern", "TemplateFormatter", "intellij.liquibase.orm"})
@SourceDebugExtension(value={"SMAP\nFormatterTemplate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormatterTemplate.kt\ncom/intellij/liquibase/orm/FormatterTemplate\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,87:1\n13225#2,2:88\n*S KotlinDebug\n*F\n+ 1 FormatterTemplate.kt\ncom/intellij/liquibase/orm/FormatterTemplate\n*L\n56#1:88,2\n*E\n"})
public class FormatterTemplate
implements PgKeepClassMembers {
    @NotNull
    private final String content;
    @NotNull
    private final Map<String, Object> attributes;
    @Nullable
    private final String dirPath;
    @NotNull
    private final Collection<String> existFileNames;

    public FormatterTemplate(@NotNull String content, @NotNull Map<String, ? extends Object> attributes, @Nullable String dirPath, @NotNull Collection<String> existFileNames) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(existFileNames, (String)"existFileNames");
        this.content = content;
        this.attributes = attributes;
        this.dirPath = dirPath;
        this.existFileNames = existFileNames;
    }

    public /* synthetic */ FormatterTemplate(String string, Map map, String string2, Collection collection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            collection = CollectionsKt.emptyList();
        }
        this(string, map, string2, collection);
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    @NotNull
    public final Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Nullable
    public final String getDirPath() {
        return this.dirPath;
    }

    @NotNull
    public final Collection<String> getExistFileNames() {
        return this.existFileNames;
    }

    @NotNull
    public final String run() {
        String templateWithMacros = "#macro( date $dateFormat)\n$formatter.date($dateFormat)#end\n#macro( increment $start $step $pattern)\n$formatter.increment($start, $step, $pattern)#end\n" + this.content;
        Map params = new LinkedHashMap();
        TemplateFormatter templateFormatter = new TemplateFormatter(null, 1, null);
        params.put("formatter", templateFormatter);
        params.putAll(this.attributes);
        String string = FileTemplateUtil.mergeTemplate((Map)params, (String)templateWithMacros, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mergeTemplate(...)");
        String completeName = ((Object)StringsKt.trim((CharSequence)string)).toString();
        return this.processIncrementPattern(completeName, templateFormatter);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String processIncrementPattern(@NotNull String completeName, @NotNull TemplateFormatter templateFormatter) {
        Intrinsics.checkNotNullParameter((Object)completeName, (String)"completeName");
        Intrinsics.checkNotNullParameter((Object)templateFormatter, (String)"templateFormatter");
        if (!StringsKt.contains$default((CharSequence)completeName, (CharSequence)"$INCREMENT_LOCATION$", (boolean)false, (int)2, null)) {
            return completeName;
        }
        double incrementBy = templateFormatter.getIncrementBy().doubleValue();
        double incrementValue = templateFormatter.getIncrementStart().doubleValue();
        String processedFileName = null;
        processedFileName = this.replaceIncrementValue(completeName, incrementValue, templateFormatter.getIncrementPattern());
        while (this.existFileNames.contains(processedFileName)) {
            processedFileName = this.replaceIncrementValue(completeName, incrementValue += incrementBy, templateFormatter.getIncrementPattern());
        }
        if (this.dirPath == null) {
            return processedFileName;
        }
        VirtualFile virtualFile = VfsUtil.findFile((Path)Paths.get(this.dirPath, new String[0]), (boolean)true);
        if (virtualFile == null) {
            return processedFileName;
        }
        VirtualFile changeLogDir = virtualFile;
        while (true) {
            boolean bl;
            block6: {
                void $this$any$iv;
                VirtualFile[] virtualFileArray = VfsUtil.getChildren((VirtualFile)changeLogDir);
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
                Object[] objectArray = virtualFileArray;
                boolean $i$f$any = false;
                for (void element$iv : $this$any$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getNameWithoutExtension(), (Object)processedFileName)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
            if (!bl) break;
            processedFileName = this.replaceIncrementValue(completeName, incrementValue += incrementBy, templateFormatter.getIncrementPattern());
        }
        return processedFileName;
    }

    @NotNull
    protected final String replaceIncrementValue(@NotNull String changeLogName, @NotNull Number value, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)changeLogName, (String)"changeLogName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        String string = new DecimalFormat(pattern, DecimalFormatSymbols.getInstance(Locale.US)).format(value);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return StringsKt.replace((String)changeLogName, (String)"$INCREMENT_LOCATION$", (String)string, (boolean)false);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0004\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0002\u001a\u00020\u00122\b\b\u0002\u0010\u0017\u001a\u00020\u0012J\u001e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/liquibase/orm/FormatterTemplate$TemplateFormatter;", "Lcom/intellij/jpa/jpb/model/core/pg/PgKeepClassMembers;", "date", "Ljava/util/Date;", "<init>", "(Ljava/util/Date;)V", "getDate", "()Ljava/util/Date;", "incrementStart", "", "getIncrementStart", "()Ljava/lang/Number;", "setIncrementStart", "(Ljava/lang/Number;)V", "incrementBy", "getIncrementBy", "setIncrementBy", "incrementPattern", "", "getIncrementPattern", "()Ljava/lang/String;", "setIncrementPattern", "(Ljava/lang/String;)V", "dateFormat", "increment", "start", "step", "pattern", "intellij.liquibase.orm"})
    public static final class TemplateFormatter
    implements PgKeepClassMembers {
        @NotNull
        private final Date date;
        @NotNull
        private Number incrementStart;
        @NotNull
        private Number incrementBy;
        @NotNull
        private String incrementPattern;

        public TemplateFormatter(@NotNull Date date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            this.date = date;
            this.incrementStart = 1.0;
            this.incrementBy = 0.1;
            this.incrementPattern = "#.0";
        }

        public /* synthetic */ TemplateFormatter(Date date, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                date = new Date();
            }
            this(date);
        }

        @NotNull
        public final Date getDate() {
            return this.date;
        }

        @NotNull
        public final Number getIncrementStart() {
            return this.incrementStart;
        }

        public final void setIncrementStart(@NotNull Number number) {
            Intrinsics.checkNotNullParameter((Object)number, (String)"<set-?>");
            this.incrementStart = number;
        }

        @NotNull
        public final Number getIncrementBy() {
            return this.incrementBy;
        }

        public final void setIncrementBy(@NotNull Number number) {
            Intrinsics.checkNotNullParameter((Object)number, (String)"<set-?>");
            this.incrementBy = number;
        }

        @NotNull
        public final String getIncrementPattern() {
            return this.incrementPattern;
        }

        public final void setIncrementPattern(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.incrementPattern = string;
        }

        @NotNull
        public final String date(@NotNull String dateFormat) {
            Intrinsics.checkNotNullParameter((Object)dateFormat, (String)"dateFormat");
            String string = new SimpleDateFormat(dateFormat).format(this.date);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }

        public static /* synthetic */ String date$default(TemplateFormatter templateFormatter, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = "yyyy-MM-dd";
            }
            return templateFormatter.date(string);
        }

        @NotNull
        public final String increment(@NotNull Number start, @NotNull Number step, @NotNull String pattern) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)step, (String)"step");
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            this.incrementStart = start;
            this.incrementBy = step;
            this.incrementPattern = pattern;
            return "$INCREMENT_LOCATION$";
        }

        public TemplateFormatter() {
            this(null, 1, null);
        }
    }
}

