/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.orm.gui;

import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.help.JpaHelpConstants;
import com.intellij.jpa.jpb.model.ui.component.TextFieldWithAutoCompletionWithPopupButton;
import com.intellij.jpa.jpb.model.ui.dialog.HDialogWrapper;
import com.intellij.jpa.jpb.model.ui.renderer.JavaTypeCellRender;
import com.intellij.liquibase.core.msg.LiquibaseResourceBundle;
import com.intellij.liquibase.orm.LiquibaseDataTypeManager;
import com.intellij.liquibase.orm.config.DatabaseInfo;
import com.intellij.liquibase.orm.config.DatabaseMigrationConfig;
import com.intellij.liquibase.orm.config.DatabaseMigrationState;
import com.intellij.liquibase.orm.config.MappingType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.table.ComboBoxTableCellEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0004\u0019\u001a\u001b\u001cB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0006H\u0014J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0014R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/liquibase/orm/gui/UnknownMappingTypesDialog;", "Lcom/intellij/jpa/jpb/model/ui/dialog/HDialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "types", "", "", "dbType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;)V", "getTypes", "()Ljava/util/Collection;", "getDbType", "()Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "typesTable", "Lcom/intellij/ui/table/TableView;", "Lcom/intellij/liquibase/orm/config/MappingType;", "createCenterPanel", "Ljavax/swing/JComponent;", "getHelpId", "doValidate", "Lcom/intellij/openapi/ui/ValidationInfo;", "commit", "", "TypeParameterColumnInfo", "TargetTypeColumnInfo", "TargetTypeCellEditor", "JavaTypeColumnInfo", "intellij.liquibase.orm"})
@SourceDebugExtension(value={"SMAP\nUnknownMappingTypesDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnknownMappingTypesDialog.kt\ncom/intellij/liquibase/orm/gui/UnknownMappingTypesDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n1586#2:192\n1661#2,3:193\n2792#2,3:197\n1#3:196\n*S KotlinDebug\n*F\n+ 1 UnknownMappingTypesDialog.kt\ncom/intellij/liquibase/orm/gui/UnknownMappingTypesDialog\n*L\n57#1:192\n57#1:193,3\n110#1:197,3\n*E\n"})
public final class UnknownMappingTypesDialog
extends HDialogWrapper {
    @NotNull
    private final Collection<String> types;
    @NotNull
    private final DbType dbType;
    @NotNull
    private final TableView<MappingType> typesTable;

    public UnknownMappingTypesDialog(@NotNull Project project, @NotNull Collection<String> types, @NotNull DbType dbType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        super(project);
        this.types = types;
        this.dbType = dbType;
        this.typesTable = new TableView();
        this.isCtrlEnterCommitShortcut = true;
        this.setTitle(LiquibaseResourceBundle.message((String)"undefined.mapping.detected.title", (Object[])new Object[0]));
        this.getOKAction().putValue("Name", LiquibaseResourceBundle.message((String)"save.and.run.generation", (Object[])new Object[0]));
        this.init();
    }

    @NotNull
    public final Collection<String> getTypes() {
        return this.types;
    }

    @NotNull
    public final DbType getDbType() {
        return this.dbType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected JComponent createCenterPanel() {
        BorderLayoutPanel borderLayoutPanel;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Project project = this.project;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Set<String> allDataTypes = LiquibaseDataTypeManager.Companion.getInstance(project).getAllDbTargetTypes(this.dbType);
        Object object = new ColumnInfo[3];
        object[0] = new JavaTypeColumnInfo();
        Project project2 = this.project;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        object[1] = new TargetTypeColumnInfo(project2, allDataTypes);
        object[2] = new TypeParameterColumnInfo();
        this.typesTable.setModelAndUpdateColumns(new ListTableModel(object));
        this.typesTable.setSelectionMode(0);
        this.typesTable.setAutoResizeMode(3);
        this.typesTable.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)200, (int)-1));
        this.typesTable.setRowHeight(JBUI.scale((int)32));
        object = this.types;
        ListTableModel listTableModel = this.typesTable.getListTableModel();
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void t;
            MappingType mappingType;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            MappingType $this$createCenterPanel_u24lambda_u240_u240 = mappingType = new MappingType();
            boolean bl2 = false;
            $this$createCenterPanel_u24lambda_u240_u240.setJavaClass((String)t);
            $this$createCenterPanel_u24lambda_u240_u240.setSqlType(null);
            $this$createCenterPanel_u24lambda_u240_u240.setSqlTypeParameter(MappingType.SqlTypeParameter.NOTHING);
            collection.add(mappingType);
        }
        listTableModel.setItems((List)destination$iv$iv);
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)((JTable)this.typesTable)).disableAddAction().disableUpDownActions().disableRemoveAction().createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        JPanel tableDecorator = jPanel;
        BorderLayoutPanel $this$createCenterPanel_u24lambda_u241 = borderLayoutPanel = new BorderLayoutPanel(10, 4);
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u241.addToTop((Component)new JBLabel(LiquibaseResourceBundle.message((String)"undefined.mapping.detected.description", (Object[])new Object[0])));
        $this$createCenterPanel_u24lambda_u241.addToCenter((Component)tableDecorator);
        $this$createCenterPanel_u24lambda_u241.setPreferredSize(new Dimension(800, 300));
        return (JComponent)borderLayoutPanel;
    }

    @NotNull
    protected String getHelpId() {
        return JpaHelpConstants.PluginDoc.INSTANCE.getCustomTypeMappings();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        List list = this.typesTable.getListTableModel().getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        List mappingTypes = list;
        for (MappingType mappingType : mappingTypes) {
            Object[] objectArray = (Object[])mappingType.getSqlType();
            if (!(objectArray == null || StringsKt.isBlank((CharSequence)objectArray))) continue;
            objectArray = new Object[1];
            String string = mappingType.getJavaClass();
            if (string == null) {
                string = "";
            }
            objectArray[0] = string;
            return new ValidationInfo(LiquibaseResourceBundle.message((String)"target.type.is.empty", (Object[])objectArray));
        }
        return null;
    }

    protected void commit() {
        Object v2;
        String dbTypeId;
        DatabaseMigrationState databaseMigrationState;
        List mappingTypes;
        block6: {
            List list = this.typesTable.getListTableModel().getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
            mappingTypes = list;
            Project project = this.project;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            databaseMigrationState = DatabaseMigrationConfig.Companion.getInstance(project).getState();
            dbTypeId = DbType.Companion.getMainType(this.dbType).getId();
            Iterable iterable = databaseMigrationState.getDatabaseInfos();
            for (Object t : iterable) {
                DatabaseInfo it = (DatabaseInfo)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)dbTypeId, (Object)it.getDbmsId())) continue;
                v2 = t;
                break block6;
            }
            v2 = null;
        }
        Object databaseInfo = v2;
        if (databaseInfo == null) {
            Object object;
            Object $this$commit_u24lambda_u241 = object = new DatabaseInfo();
            boolean bl = false;
            ((DatabaseInfo)$this$commit_u24lambda_u241).setDbmsId(dbTypeId);
            databaseInfo = object;
            databaseMigrationState.getDatabaseInfos().add((DatabaseInfo)databaseInfo);
        }
        for (MappingType mappingType : mappingTypes) {
            boolean bl;
            block7: {
                String string = mappingType.getSqlType();
                mappingType.setSqlType(string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null);
                Iterable $this$none$iv = ((DatabaseInfo)databaseInfo).getMappingTypes();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        MappingType it = (MappingType)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getJavaClass(), (Object)mappingType.getJavaClass())) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            List<MappingType> list = ((DatabaseInfo)databaseInfo).getMappingTypes();
            Intrinsics.checkNotNull((Object)mappingType);
            list.add(mappingType);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\f\u001a\u0004\u0018\u00010\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/intellij/liquibase/orm/gui/UnknownMappingTypesDialog$JavaTypeColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/liquibase/orm/config/MappingType;", "", "<init>", "()V", "cellRenderer", "Lcom/intellij/jpa/jpb/model/ui/renderer/JavaTypeCellRender;", "getCellRenderer", "()Lcom/intellij/jpa/jpb/model/ui/renderer/JavaTypeCellRender;", "cellRenderer$delegate", "Lkotlin/Lazy;", "valueOf", "item", "getRenderer", "Ljavax/swing/table/TableCellRenderer;", "getPreferredStringValue", "intellij.liquibase.orm"})
    public static final class JavaTypeColumnInfo
    extends ColumnInfo<MappingType, String> {
        @NotNull
        private final Lazy cellRenderer$delegate = LazyKt.lazy(JavaTypeColumnInfo::cellRenderer_delegate$lambda$0);

        public JavaTypeColumnInfo() {
            super(LiquibaseResourceBundle.message((String)"column.name.attribute.type", (Object[])new Object[0]));
        }

        private final JavaTypeCellRender getCellRenderer() {
            Lazy lazy = this.cellRenderer$delegate;
            return (JavaTypeCellRender)lazy.getValue();
        }

        @Nullable
        public String valueOf(@Nullable MappingType item) {
            MappingType mappingType = item;
            return mappingType != null ? mappingType.getJavaClass() : null;
        }

        @NotNull
        public TableCellRenderer getRenderer(@Nullable MappingType item) {
            return (TableCellRenderer)this.getCellRenderer();
        }

        @NotNull
        public String getPreferredStringValue() {
            return "com.example.demo.type.CustomHibernateType";
        }

        private static final JavaTypeCellRender cellRenderer_delegate$lambda$0() {
            return new JavaTypeCellRender();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J4\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/liquibase/orm/gui/UnknownMappingTypesDialog$TargetTypeCellEditor;", "Ljavax/swing/AbstractCellEditor;", "Ljavax/swing/table/TableCellEditor;", "project", "Lcom/intellij/openapi/project/Project;", "dataTypes", "", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;)V", "sqlTypeField", "Lcom/intellij/jpa/jpb/model/ui/component/TextFieldWithAutoCompletionWithPopupButton;", "getCellEditorValue", "", "getTableCellEditorComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "isSelected", "", "row", "", "column", "intellij.liquibase.orm"})
    public static final class TargetTypeCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        @NotNull
        private TextFieldWithAutoCompletionWithPopupButton sqlTypeField;

        /*
         * WARNING - void declaration
         */
        public TargetTypeCellEditor(@NotNull Project project, @NotNull Set<String> dataTypes) {
            void $this$sqlTypeField_u24lambda_u241;
            TextFieldWithAutoCompletionWithPopupButton textFieldWithAutoCompletionWithPopupButton;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(dataTypes, (String)"dataTypes");
            TextFieldWithAutoCompletionWithPopupButton textFieldWithAutoCompletionWithPopupButton2 = textFieldWithAutoCompletionWithPopupButton = new TextFieldWithAutoCompletionWithPopupButton(project, TargetTypeCellEditor::sqlTypeField$lambda$0);
            TargetTypeCellEditor targetTypeCellEditor = this;
            boolean bl = false;
            $this$sqlTypeField_u24lambda_u241.setAutoCompletionItems((Collection)dataTypes);
            targetTypeCellEditor.sqlTypeField = textFieldWithAutoCompletionWithPopupButton;
        }

        @Override
        @NotNull
        public Object getCellEditorValue() {
            return this.sqlTypeField.getText();
        }

        @Override
        @NotNull
        public Component getTableCellEditorComponent(@Nullable JTable table, @Nullable Object value, boolean isSelected, int row, int column) {
            Object object = value;
            if (object == null || (object = object.toString()) == null) {
                object = "";
            }
            this.sqlTypeField.setText((String)object);
            return (Component)this.sqlTypeField;
        }

        private static final Unit sqlTypeField$lambda$0(EditorEx editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            editor.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(JBColor.border()), BorderFactory.createEmptyBorder(4, 0, 0, 0)));
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016J\u001c\u0010\u0014\u001a\u00020\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u00022\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/intellij/liquibase/orm/gui/UnknownMappingTypesDialog$TargetTypeColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/liquibase/orm/config/MappingType;", "", "project", "Lcom/intellij/openapi/project/Project;", "dataTypes", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;)V", "cellEditor", "Lcom/intellij/liquibase/orm/gui/UnknownMappingTypesDialog$TargetTypeCellEditor;", "getCellEditor", "()Lcom/intellij/liquibase/orm/gui/UnknownMappingTypesDialog$TargetTypeCellEditor;", "cellEditor$delegate", "Lkotlin/Lazy;", "valueOf", "item", "isCellEditable", "", "setValue", "", "value", "getEditor", "Ljavax/swing/table/TableCellEditor;", "intellij.liquibase.orm"})
    public static final class TargetTypeColumnInfo
    extends ColumnInfo<MappingType, String> {
        @NotNull
        private final Lazy cellEditor$delegate;

        public TargetTypeColumnInfo(@NotNull Project project, @NotNull Set<String> dataTypes) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(dataTypes, (String)"dataTypes");
            super(LiquibaseResourceBundle.message((String)"column.name.target.type", (Object[])new Object[0]));
            this.cellEditor$delegate = LazyKt.lazy(() -> TargetTypeColumnInfo.cellEditor_delegate$lambda$0(project, dataTypes));
        }

        private final TargetTypeCellEditor getCellEditor() {
            Lazy lazy = this.cellEditor$delegate;
            return (TargetTypeCellEditor)lazy.getValue();
        }

        @Nullable
        public String valueOf(@Nullable MappingType item) {
            MappingType mappingType = item;
            return mappingType != null ? mappingType.getSqlType() : null;
        }

        public boolean isCellEditable(@Nullable MappingType item) {
            return true;
        }

        public void setValue(@Nullable MappingType item, @Nullable String value) {
            block0: {
                MappingType mappingType = item;
                if (mappingType == null) break block0;
                mappingType.setSqlType(value);
            }
        }

        @NotNull
        public TableCellEditor getEditor(@Nullable MappingType item) {
            return this.getCellEditor();
        }

        private static final TargetTypeCellEditor cellEditor_delegate$lambda$0(Project $project, Set $dataTypes) {
            return new TargetTypeCellEditor($project, $dataTypes);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u001c\u0010\n\u001a\u00020\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00022\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/liquibase/orm/gui/UnknownMappingTypesDialog$TypeParameterColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/liquibase/orm/config/MappingType;", "Lcom/intellij/liquibase/orm/config/MappingType$SqlTypeParameter;", "<init>", "()V", "valueOf", "item", "isCellEditable", "", "setValue", "", "value", "getEditor", "Ljavax/swing/table/TableCellEditor;", "intellij.liquibase.orm"})
    public static final class TypeParameterColumnInfo
    extends ColumnInfo<MappingType, MappingType.SqlTypeParameter> {
        public TypeParameterColumnInfo() {
            super(LiquibaseResourceBundle.message((String)"column.name.type.parameter", (Object[])new Object[0]));
        }

        @Nullable
        public MappingType.SqlTypeParameter valueOf(@Nullable MappingType item) {
            MappingType mappingType = item;
            return mappingType != null ? mappingType.getSqlTypeParameter() : null;
        }

        public boolean isCellEditable(@Nullable MappingType item) {
            return true;
        }

        public void setValue(@Nullable MappingType item, @Nullable MappingType.SqlTypeParameter value) {
            block0: {
                MappingType mappingType = item;
                if (mappingType == null) break block0;
                mappingType.setSqlTypeParameter(value);
            }
        }

        @NotNull
        public TableCellEditor getEditor(@Nullable MappingType item) {
            ComboBoxTableCellEditor comboBoxTableCellEditor = ComboBoxTableCellEditor.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)comboBoxTableCellEditor, (String)"INSTANCE");
            return (TableCellEditor)comboBoxTableCellEditor;
        }
    }
}

