/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.orm.gui.entity;

import com.intellij.jpa.jpb.model.backend.ed.indexing.CustomTypeModel;
import com.intellij.jpa.jpb.model.backend.ed.indexing.JpaConverterModel;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.liquibase.ns.PhysicalNamingStrategy;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.reference.PossiblyPkTableEntityAttribute;
import com.intellij.jpa.jpb.model.service.JpabGeneratorManager;
import com.intellij.jpa.jpb.model.ui.SSwingUtilKt;
import com.intellij.jpa.jpb.model.ui.component.ComboBoxEditor;
import com.intellij.jpa.jpb.model.ui.component.DbTypeField;
import com.intellij.jpa.jpb.model.ui.ptable.PTableRenderUtils;
import com.intellij.jpa.jpb.model.ui.swing.JpbAbstractTableModel;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.liquibase.core.msg.LiquibaseResourceBundle;
import com.intellij.liquibase.orm.ddl.DbMappingSettings;
import com.intellij.liquibase.orm.gui.entity.AttributeValuesTable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.swing.CellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\u0018\u0000 G2\u00020\u0001:\u0004GHIJB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u0010J\b\u0010(\u001a\u00020$H\u0002J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001a0*H\u0002J \u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u00102\u0006\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010\u0010J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0013H\u0002J\u0012\u00103\u001a\u00020.2\b\u00104\u001a\u0004\u0018\u000105H\u0002J$\u00106\u001a\u0004\u0018\u00010\u00102\u0006\u0010,\u001a\u00020\u00102\u0006\u00107\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u000108H\u0003J\u0018\u00109\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u00102\u0006\u0010:\u001a\u00020;H\u0002J$\u0010<\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001d\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\b\b\u0001\u0010@\u001a\u00020\u0010H\u0003J\u001a\u0010A\u001a\u00020\u00102\b\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010B\u001a\u00020\u0010H\u0002J\u0010\u0010C\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u0013H\u0002J\u000e\u0010D\u001a\b\u0012\u0004\u0012\u00020.0*H\u0002J\b\u0010E\u001a\u00020\u0007H\u0002J\u000e\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001b\u0010\u001d\u001a\u00020\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b\u001f\u0010 \u00a8\u0006K"}, d2={"Lcom/intellij/liquibase/orm/gui/entity/AttributeValuesTable;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "dbTypeField", "Lcom/intellij/jpa/jpb/model/ui/component/DbTypeField;", "trackId", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jpa/jpb/model/ui/component/DbTypeField;Z)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDbTypeField", "()Lcom/intellij/jpa/jpb/model/ui/component/DbTypeField;", "uuidValues", "", "", "allAttributes", "", "Lcom/intellij/jpa/jpb/model/model/EntityAttribute;", "getAllAttributes", "()Ljava/util/List;", "setAllAttributes", "(Ljava/util/List;)V", "model", "Lcom/intellij/jpa/jpb/model/ui/swing/JpbAbstractTableModel;", "Lcom/intellij/liquibase/orm/gui/entity/AttributeValuesTable$TableAttribute;", "getModel", "()Lcom/intellij/jpa/jpb/model/ui/swing/JpbAbstractTableModel;", "table", "Lcom/intellij/ui/table/JBTable;", "getTable", "()Lcom/intellij/ui/table/JBTable;", "table$delegate", "Lkotlin/Lazy;", "prepareData", "", "entity", "Lcom/intellij/jpa/jpb/model/model/Entity;", "tableName", "clearTable", "getMandatoryAndOtherAttributes", "", "getCorrectValue", "nameColumn", "type", "Lcom/intellij/liquibase/orm/gui/entity/AttributeValuesTable$ValueType;", "inputValue", "getDatatype", "Lcom/intellij/jpa/jpb/model/model/Datatype;", "attribute", "getValueType", "datatype", "Lcom/intellij/jpa/jpb/model/model/Datatypes$BasicDatatype;", "getValueForRenderer", "selectedType", "", "getUuid", "dbType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "getTooltipText", "Ljavax/swing/JTable;", "column", "", "text", "getCorrectUuid", "uuid", "isIdWithSequenceOrAutoStrategy", "getValueTypesForComboBox", "isMySql", "getAllAttributesExceptId", "Companion", "ColumnValueCellRenderer", "ValueType", "TableAttribute", "intellij.liquibase.orm"})
@SourceDebugExtension(value={"SMAP\nAttributeValuesTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttributeValuesTable.kt\ncom/intellij/liquibase/orm/gui/entity/AttributeValuesTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SSwingUtil.kt\ncom/intellij/jpa/jpb/model/ui/SSwingUtilKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,387:1\n1915#2,2:388\n1068#2:400\n1642#2,10:401\n1915#2:411\n1916#2:413\n1652#2:414\n296#2,2:415\n2792#2,3:417\n777#2:420\n873#2,2:421\n777#2:423\n873#2,2:424\n296#2,2:426\n80#3,5:390\n80#3,5:395\n1#4:412\n*S KotlinDebug\n*F\n+ 1 AttributeValuesTable.kt\ncom/intellij/liquibase/orm/gui/entity/AttributeValuesTable\n*L\n114#1:388,2\n205#1:400\n206#1:401,10\n206#1:411\n206#1:413\n206#1:414\n281#1:415,2\n349#1:417,3\n363#1:420\n363#1:421,2\n366#1:423\n366#1:424,2\n145#1:426,2\n122#1:390,5\n128#1:395,5\n206#1:412\n*E\n"})
public final class AttributeValuesTable
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final DbTypeField dbTypeField;
    private final boolean trackId;
    @NotNull
    private final Map<String, String> uuidValues;
    @NotNull
    private List<? extends EntityAttribute> allAttributes;
    @NotNull
    private final JpbAbstractTableModel<TableAttribute> model;
    @NotNull
    private final Lazy table$delegate;
    private static final int COLUMN_SELECTED = 0;
    private static final int COLUMN_NAME = 1;
    private static final int COLUMN_TYPE = 2;
    private static final int COLUMN_VALUE = 3;

    /*
     * WARNING - void declaration
     */
    public AttributeValuesTable(@NotNull Project project, @NotNull DbTypeField dbTypeField, boolean trackId) {
        void $this$_init__u24lambda_u242;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dbTypeField, (String)"dbTypeField");
        super(new BorderLayout());
        this.project = project;
        this.dbTypeField = dbTypeField;
        this.trackId = trackId;
        this.uuidValues = new LinkedHashMap();
        this.allAttributes = CollectionsKt.emptyList();
        Object[] objectArray = new ArrayList();
        this.model = (JpbAbstractTableModel)new JpbAbstractTableModel<TableAttribute>(this, objectArray){
            final /* synthetic */ AttributeValuesTable this$0;
            {
                this.this$0 = $receiver;
                super((Collection)$super_call_param$1);
                this.init();
            }

            protected List<JpbAbstractTableModel.ColumnMetaInfo<TableAttribute, ?>> createColumnMetaInfo() {
                List result = new ArrayList<E>();
                result.add(new JpbAbstractTableModel.EditableColumnMetaInfo(null, arg_0 -> model.1.createColumnMetaInfo$lambda$0((KMutableProperty1)model.createColumnMetaInfo.1.INSTANCE, arg_0), (arg_0, arg_1) -> ((KMutableProperty1)((KMutableProperty1)model.createColumnMetaInfo.3.INSTANCE)).set(arg_0, arg_1), Boolean.TYPE));
                result.add(new JpbAbstractTableModel.ColumnMetaInfo(LiquibaseResourceBundle.message((String)"column.name.name", (Object[])new Object[0]), arg_0 -> model.1.createColumnMetaInfo$lambda$1((KProperty1)model.createColumnMetaInfo.4.INSTANCE, arg_0), String.class));
                result.add(new JpbAbstractTableModel.EditableColumnMetaInfo(LiquibaseResourceBundle.message((String)"column.name.type", (Object[])new Object[0]), arg_0 -> model.1.createColumnMetaInfo$lambda$2((KMutableProperty1)model.createColumnMetaInfo.5.INSTANCE, arg_0), (arg_0, arg_1) -> ((KMutableProperty1)((KMutableProperty1)model.createColumnMetaInfo.7.INSTANCE)).set(arg_0, arg_1), ValueType.class));
                result.add(new JpbAbstractTableModel.EditableColumnMetaInfo(LiquibaseResourceBundle.message((String)"column.name.value", (Object[])new Object[0]), arg_0 -> model.1.createColumnMetaInfo$lambda$3((KMutableProperty1)model.createColumnMetaInfo.8.INSTANCE, arg_0), (arg_0, arg_1) -> ((KMutableProperty1)((KMutableProperty1)model.createColumnMetaInfo.10.INSTANCE)).set(arg_0, arg_1), String.class));
                return result;
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                if (this.this$0.getTable().getValueAt(rowIndex, 2) == ValueType.Null && columnIndex == 3) {
                    return false;
                }
                return super.isCellEditable(rowIndex, columnIndex);
            }

            private static final Boolean createColumnMetaInfo$lambda$0(KMutableProperty1 $tmp0, TableAttribute p0) {
                return (Boolean)((Function1)$tmp0).invoke((Object)p0);
            }

            private static final String createColumnMetaInfo$lambda$1(KProperty1 $tmp0, TableAttribute p0) {
                return (String)((Function1)$tmp0).invoke((Object)p0);
            }

            private static final ValueType createColumnMetaInfo$lambda$2(KMutableProperty1 $tmp0, TableAttribute p0) {
                return (ValueType)((Object)((Function1)$tmp0).invoke((Object)p0));
            }

            private static final String createColumnMetaInfo$lambda$3(KMutableProperty1 $tmp0, TableAttribute p0) {
                return (String)((Function1)$tmp0).invoke((Object)p0);
            }
        };
        this.table$delegate = LazyKt.lazy(() -> AttributeValuesTable.table_delegate$lambda$0(this));
        objectArray = new Integer[]{1, 2, 3};
        Object $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach22 = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            this.getTable().getColumnModel().getColumn(it).setCellRenderer((TableCellRenderer)((Object)new ColumnValueCellRenderer()));
        }
        this.getTable().getColumnModel().getColumn(2).setCellEditor((TableCellEditor)new ComboBoxEditor(arg_0 -> AttributeValuesTable._init_$lambda$1(this, arg_0)));
        Object $i$f$forEach22 = $this$forEach$iv = new DefaultCellEditor(new JTextField());
        TableColumn tableColumn = this.getTable().getColumnModel().getColumn(3);
        boolean bl = false;
        $this$_init__u24lambda_u242.setClickCountToStart(1);
        tableColumn.setCellEditor((TableCellEditor)$this$forEach$iv);
        TableCellEditor tableCellEditor = this.getTable().getColumnModel().getColumn(2).getCellEditor();
        Intrinsics.checkNotNullExpressionValue((Object)tableCellEditor, (String)"getCellEditor(...)");
        CellEditor $this$addEditingStoppedListener$iv = tableCellEditor;
        boolean $i$f$addEditingStoppedListener = false;
        $this$addEditingStoppedListener$iv.addCellEditorListener(new CellEditorListener(this){
            final /* synthetic */ AttributeValuesTable this$0;
            {
                this.this$0 = attributeValuesTable;
            }

            public void editingStopped(ChangeEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ChangeEvent it = e;
                boolean bl = false;
                Object object = this.this$0.getTable().getValueAt(this.this$0.getTable().getSelectedRow(), 0);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                if (!((Boolean)object).booleanValue()) {
                    this.this$0.getTable().setValueAt((Object)true, this.this$0.getTable().getSelectedRow(), 0);
                }
            }

            public void editingCanceled(ChangeEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        });
        TableCellEditor tableCellEditor2 = this.getTable().getColumnModel().getColumn(3).getCellEditor();
        Intrinsics.checkNotNullExpressionValue((Object)tableCellEditor2, (String)"getCellEditor(...)");
        $this$addEditingStoppedListener$iv = tableCellEditor2;
        $i$f$addEditingStoppedListener = false;
        $this$addEditingStoppedListener$iv.addCellEditorListener(new CellEditorListener(this){
            final /* synthetic */ AttributeValuesTable this$0;
            {
                this.this$0 = attributeValuesTable;
            }

            public void editingStopped(ChangeEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ChangeEvent it = e;
                boolean bl = false;
                Object object = this.this$0.getTable().getValueAt(this.this$0.getTable().getSelectedRow(), 0);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                if (!((Boolean)object).booleanValue()) {
                    this.this$0.getTable().setValueAt((Object)true, this.this$0.getTable().getSelectedRow(), 0);
                }
            }

            public void editingCanceled(ChangeEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        });
        TableColumn selected = this.getTable().getColumnModel().getColumn(0);
        selected.setCellEditor(JBTable.createBooleanEditor());
        selected.setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        selected.setMaxWidth(30);
        this.setPreferredSize(new Dimension(500, 210));
        this.setMinimumSize(this.getPreferredSize());
        this.add((Component)new JBScrollPane((Component)this.getTable()), "Center");
        this.dbTypeField.addItemListener(arg_0 -> AttributeValuesTable._init_$lambda$5(this, arg_0));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DbTypeField getDbTypeField() {
        return this.dbTypeField;
    }

    @NotNull
    public final List<EntityAttribute> getAllAttributes() {
        return this.allAttributes;
    }

    public final void setAllAttributes(@NotNull List<? extends EntityAttribute> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.allAttributes = list;
    }

    @NotNull
    public final JpbAbstractTableModel<TableAttribute> getModel() {
        return this.model;
    }

    @NotNull
    public final JBTable getTable() {
        Lazy lazy = this.table$delegate;
        return (JBTable)lazy.getValue();
    }

    public final void prepareData(@Nullable Entity entity, @NotNull String tableName) {
        List list;
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        this.clearTable();
        JpabGeneratorManager generatorManager = JpabGeneratorManager.getInstance((Project)this.project);
        if (entity != null) {
            List list2 = generatorManager.getTableAttributes(entity, (DbType)SSwingUtilKt.getSelectedItemTyped((JComboBox)((JComboBox)this.dbTypeField)));
            Intrinsics.checkNotNull((Object)list2);
            list = list2;
        } else {
            List list3 = generatorManager.getJoinOrCollectionTableAttributes(tableName, true);
            Intrinsics.checkNotNull((Object)list3);
            list = list3;
        }
        this.allAttributes = list;
        this.model.setData((Collection)this.getMandatoryAndOtherAttributes());
    }

    private final void clearTable() {
        this.getTable().removeEditor();
        this.getTable().clearSelection();
        this.model.setData((Collection)SetsKt.emptySet());
    }

    /*
     * WARNING - void declaration
     */
    private final Set<TableAttribute> getMandatoryAndOtherAttributes() {
        void $this$mapNotNullTo$iv$iv;
        if (this.allAttributes.isEmpty()) {
            return SetsKt.emptySet();
        }
        this.getTable().requestFocus();
        Iterable $this$sortedBy$iv = this.getAllAttributesExceptId();
        boolean $i$f$sortedBy = false;
        Iterable $this$mapNotNull$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                EntityAttribute it = (EntityAttribute)a;
                boolean bl = false;
                boolean bl2 = !it.isMandatory();
                it = (EntityAttribute)b;
                Comparable comparable = Boolean.valueOf(bl2);
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Boolean.valueOf(!it.isMandatory()));
            }
        });
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            TableAttribute tableAttribute;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            EntityAttribute entityAttribute = (EntityAttribute)element$iv$iv;
            boolean bl2 = false;
            String column = entityAttribute.getColumn();
            CharSequence charSequence = column;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                tableAttribute = null;
            } else {
                Datatypes.BasicDatatype datatype;
                String string = PhysicalNamingStrategy.Companion.getInstance(this.project).toColumnName(column);
                Intrinsics.checkNotNull((Object)string);
                column = string;
                Datatype datatype2 = this.getDatatype(entityAttribute);
                Datatypes.BasicDatatype basicDatatype = datatype = datatype2 instanceof Datatypes.BasicDatatype ? (Datatypes.BasicDatatype)datatype2 : null;
                ValueType valueType = this.isIdWithSequenceOrAutoStrategy(entityAttribute) ? (this.isMySql() || Intrinsics.areEqual((Object)datatype, (Object)Datatypes.BasicDatatype.UUID) ? this.getValueType(datatype) : ValueType.Sequence) : this.getValueType(datatype);
                tableAttribute = new TableAttribute(entityAttribute.isMandatory(), column, valueType, null);
            }
            if (tableAttribute == null) continue;
            TableAttribute it$iv$iv = tableAttribute;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final String getCorrectValue(@NotNull String nameColumn, @NotNull ValueType type, @Nullable String inputValue) {
        Intrinsics.checkNotNullParameter((Object)nameColumn, (String)"nameColumn");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (inputValue != null && ((CharSequence)inputValue).length() > 0) {
            String string = StringUtil.escapeXmlEntities((String)inputValue);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeXmlEntities(...)");
            return string;
        }
        String value = this.getValueForRenderer(nameColumn, type, inputValue);
        return Intrinsics.areEqual((Object)value, (Object)"''") ? "" : (Intrinsics.areEqual((Object)value, (Object)"' '") ? " " : String.valueOf(value));
    }

    private final Datatype getDatatype(EntityAttribute attribute) {
        Datatype datatype;
        Datatype attrType = attribute.getType();
        CustomTypeModel converter = attribute.getConverter();
        if (attrType instanceof Entity) {
            Datatype datatype2 = ((Entity)attrType).getIdAttribute().getType();
            Intrinsics.checkNotNull((Object)datatype2);
            datatype = datatype2;
        } else if (attribute.isEnum()) {
            Datatypes.BasicDatatype basicDatatype = attribute.getEnumType() == EntityAttribute.EnumType.ORDINAL ? Datatypes.BasicDatatype.Integer : Datatypes.BasicDatatype.String;
            Intrinsics.checkNotNull((Object)basicDatatype);
            datatype = (Datatype)basicDatatype;
        } else if (converter != null && converter instanceof JpaConverterModel) {
            String dbTypeFqn = ((JpaConverterModel)converter).getDbTypeFqn();
            Datatypes.BasicDatatype basicDatatype = Datatypes.BasicDatatype.getInstance((String)dbTypeFqn);
            Intrinsics.checkNotNull((Object)basicDatatype);
            datatype = (Datatype)basicDatatype;
        } else if (attrType instanceof Datatypes.BasicDatatype && ((Datatypes.BasicDatatype)attrType).isPrimitive()) {
            Map primitiveTypes = Datatypes.BasicDatatype.PRIMITIVE_TO_BOXED;
            Intrinsics.checkNotNull((Object)primitiveTypes);
            Object object = MapsKt.getValue((Map)primitiveTypes, (Object)attrType);
            Intrinsics.checkNotNull((Object)object);
            datatype = (Datatype)object;
        } else if (attrType instanceof Datatypes.BasicDatatype && ((Datatypes.BasicDatatype)attrType).isString()) {
            Datatypes.BasicDatatype basicDatatype = Datatypes.BasicDatatype.String;
            Intrinsics.checkNotNullExpressionValue((Object)basicDatatype, (String)"String");
            datatype = (Datatype)basicDatatype;
        } else if (attrType instanceof Datatypes.BasicDatatype && ((Datatypes.BasicDatatype)attrType).isNumber()) {
            Datatypes.BasicDatatype basicDatatype = Datatypes.BasicDatatype.Integer;
            Intrinsics.checkNotNullExpressionValue((Object)basicDatatype, (String)"Integer");
            datatype = (Datatype)basicDatatype;
        } else {
            Intrinsics.checkNotNull((Object)attrType);
            datatype = attrType;
        }
        return datatype;
    }

    private final ValueType getValueType(Datatypes.BasicDatatype datatype) {
        return datatype == null ? ValueType.Null : (Intrinsics.areEqual((Object)datatype, (Object)Datatypes.BasicDatatype.Boolean) ? ValueType.Boolean : (datatype.isString() || Intrinsics.areEqual((Object)datatype, (Object)Datatypes.BasicDatatype.UUID) ? ValueType.String : (datatype.isNumber() ? ValueType.Numeric : (datatype.isDate() ? ValueType.Date : ValueType.Null))));
    }

    @NlsSafe
    private final String getValueForRenderer(String nameColumn, ValueType selectedType, Object inputValue) {
        if (this.allAttributes.isEmpty() || selectedType == ValueType.Null) {
            return null;
        }
        if (inputValue == null || Intrinsics.areEqual((Object)inputValue, (Object)"")) {
            String string;
            Datatypes.BasicDatatype rawType;
            Object v0;
            Object element$iv2;
            block12: {
                Iterable $this$firstOrNull$iv = this.allAttributes;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    EntityAttribute it = (EntityAttribute)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getColumn(), (Object)nameColumn)) continue;
                    v0 = element$iv2;
                    break block12;
                }
                v0 = null;
            }
            EntityAttribute entityAttribute = v0;
            if (entityAttribute == null) {
                return null;
            }
            EntityAttribute entityAttribute2 = entityAttribute;
            DbType dbType = (DbType)SSwingUtilKt.getSelectedItemTyped((JComboBox)((JComboBox)this.dbTypeField));
            if (dbType == null) {
                return null;
            }
            DbType dbType2 = dbType;
            Map<Datatypes.BasicDatatype, String> defaultValues = DbMappingSettings.Companion.getInstance(dbType2, this.project).getDefaultValues();
            if (!this.isMySql() && this.isIdWithSequenceOrAutoStrategy(entityAttribute2) && selectedType == ValueType.Sequence) {
                String name = entityAttribute2.getSequenceOrTableGeneratorName();
                Object object = name;
                return (object == null || object.length() == 0) && JpaUtils.isHibernateProject((Project)this.project, null) ? "hibernate_sequence" : (((object = (CharSequence)name) == null || object.length() == 0) && JpaUtils.isEclipseLinkProject((Project)this.project) && entityAttribute2.getGeneratedStrategy() == EntityAttribute.GeneratedStrategy.SEQUENCE ? "seq_gen" : name);
            }
            if (entityAttribute2.isId() && !Intrinsics.areEqual((Object)entityAttribute2.getType(), (Object)Datatypes.BasicDatatype.UUID) || entityAttribute2 instanceof PossiblyPkTableEntityAttribute) {
                return "/* put " + nameColumn + " here */";
            }
            Datatype attributeType = this.getDatatype(entityAttribute2);
            if (Intrinsics.areEqual((Object)attributeType, (Object)Datatypes.BasicDatatype.UUID) && selectedType == ValueType.String) {
                return this.getUuid(nameColumn, dbType2);
            }
            element$iv2 = entityAttribute2.getType();
            Datatypes.BasicDatatype basicDatatype = rawType = element$iv2 instanceof Datatypes.BasicDatatype ? (Datatypes.BasicDatatype)element$iv2 : null;
            if (rawType != null && entityAttribute2.getConverter() == null && defaultValues.containsKey(rawType)) {
                string = (String)MapsKt.getValue(defaultValues, (Object)rawType);
            } else if (defaultValues.containsKey(attributeType)) {
                Intrinsics.checkNotNull((Object)attributeType, (String)"null cannot be cast to non-null type com.intellij.jpa.jpb.model.model.Datatypes.BasicDatatype");
                string = (String)MapsKt.getValue(defaultValues, (Object)((Datatypes.BasicDatatype)attributeType));
            } else {
                string = null;
            }
            String defaultValue = string;
            return selectedType == this.getValueType(attributeType instanceof Datatypes.BasicDatatype ? (Datatypes.BasicDatatype)attributeType : null) || selectedType.getDatatype() == null ? defaultValue : (String)MapsKt.getValue(defaultValues, (Object)selectedType.getDatatype());
        }
        return inputValue.toString();
    }

    private final String getUuid(String nameColumn, DbType dbType) {
        if (this.uuidValues.containsKey(nameColumn)) {
            String oldUuid = (String)MapsKt.getValue(this.uuidValues, (Object)nameColumn);
            return this.getCorrectUuid(dbType, oldUuid);
        }
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String newUuid = string;
        this.uuidValues.put(nameColumn, newUuid);
        return this.getCorrectUuid(dbType, newUuid);
    }

    @Nls
    private final String getTooltipText(JTable table, int column, @Nls String text) {
        int columnWidth = table.getColumnModel().getColumn(column).getWidth();
        return table.getFontMetrics(table.getFont()).stringWidth(text) > columnWidth ? text : null;
    }

    private final String getCorrectUuid(DbType dbType, String uuid) {
        return Intrinsics.areEqual((Object)dbType, (Object)DbType.ORACLE) || Intrinsics.areEqual((Object)dbType, (Object)DbType.ORACLE_SID) ? StringsKt.replace$default((String)uuid, (String)"-", (String)"", (boolean)false, (int)4, null) : uuid;
    }

    private final boolean isIdWithSequenceOrAutoStrategy(EntityAttribute attribute) {
        Boolean bl = EntityUtil.isIdAttrWithSequenceOrAutoStrategy((EntityAttribute)attribute, (Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"isIdAttrWithSequenceOrAutoStrategy(...)");
        return bl;
    }

    private final Set<ValueType> getValueTypesForComboBox() {
        Set values;
        block9: {
            block8: {
                boolean bl;
                block7: {
                    values = CollectionsKt.toSet((Iterable)((Iterable)ValueType.getEntries()));
                    if (!this.trackId || this.isMySql()) break block8;
                    Iterable $this$none$iv = this.allAttributes;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            EntityAttribute it = (EntityAttribute)element$iv;
                            boolean bl2 = false;
                            if (!this.isIdWithSequenceOrAutoStrategy(it)) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                }
                if (!bl) break block9;
            }
            return SetsKt.minus((Set)values, (Object)((Object)ValueType.Sequence));
        }
        return values;
    }

    private final boolean isMySql() {
        DbType dbType = (DbType)SSwingUtilKt.getSelectedItemTyped((JComboBox)((JComboBox)this.dbTypeField));
        return Intrinsics.areEqual((Object)dbType, (Object)DbType.MYSQL) || Intrinsics.areEqual((Object)dbType, (Object)DbType.MYSQL_51);
    }

    /*
     * WARNING - void declaration
     */
    private final List<EntityAttribute> getAllAttributesExceptId() {
        List list;
        if (this.trackId) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.allAttributes;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                EntityAttribute attr = (EntityAttribute)element$iv$iv;
                boolean bl = false;
                if (!(!attr.isId() || attr.getGeneratedStrategy() != EntityAttribute.GeneratedStrategy.IDENTITY || attr instanceof PossiblyPkTableEntityAttribute)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            Iterable $this$filter$iv = this.allAttributes;
            boolean $i$f$filter = false;
            Iterable $this$filterTo$iv$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                EntityAttribute attr = (EntityAttribute)element$iv$iv;
                boolean bl = false;
                if (!(!attr.isId() && !(attr instanceof PossiblyPkTableEntityAttribute))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private static final JBTable table_delegate$lambda$0(AttributeValuesTable this$0) {
        JBTable jBTable;
        JBTable $this$table_delegate_u24lambda_u240_u240 = jBTable = new JBTable((TableModel)this$0.model);
        boolean bl = false;
        $this$table_delegate_u24lambda_u240_u240.setRowHeight(JBUI.scale((int)32));
        $this$table_delegate_u24lambda_u240_u240.setVisibleRowCount(JBUI.scale((int)8));
        return jBTable;
    }

    private static final Set _init_$lambda$1(AttributeValuesTable this$0, int it) {
        return this$0.getValueTypesForComboBox();
    }

    private static final void _init_$lambda$5(AttributeValuesTable this$0, ItemEvent event) {
        if (event.getStateChange() == 2) {
            return;
        }
        List list = this$0.model.getData();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getData(...)");
        List data = list;
        for (TableAttribute attribute : data) {
            EntityAttribute entityAttribute;
            Object v1;
            block3: {
                Iterable $this$firstOrNull$iv = this$0.allAttributes;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    EntityAttribute it = (EntityAttribute)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getColumn(), (Object)attribute.getName())) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            if ((EntityAttribute)v1 == null || !this$0.isIdWithSequenceOrAutoStrategy(entityAttribute)) continue;
            int rowIndex = data.indexOf(attribute);
            Datatype $i$f$firstOrNull = this$0.getDatatype(entityAttribute);
            Datatypes.BasicDatatype datatype = $i$f$firstOrNull instanceof Datatypes.BasicDatatype ? (Datatypes.BasicDatatype)$i$f$firstOrNull : null;
            ValueType valueType = this$0.isMySql() || Intrinsics.areEqual((Object)datatype, (Object)Datatypes.BasicDatatype.UUID) ? this$0.getValueType(datatype) : ValueType.Sequence;
            this$0.getTable().setValueAt((Object)valueType, rowIndex, 2);
            break;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/liquibase/orm/gui/entity/AttributeValuesTable$ColumnValueCellRenderer;", "Lcom/intellij/ui/ColoredTableCellRenderer;", "<init>", "(Lcom/intellij/liquibase/orm/gui/entity/AttributeValuesTable;)V", "customizeCellRenderer", "", "table", "Ljavax/swing/JTable;", "value", "", "selected", "", "hasFocus", "row", "", "column", "intellij.liquibase.orm"})
    public final class ColumnValueCellRenderer
    extends ColoredTableCellRenderer {
        protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Object object = table.getValueAt(row, 0);
            Boolean bl = object instanceof Boolean ? (Boolean)object : null;
            if (bl == null) {
                return;
            }
            boolean selectedValue = bl;
            SimpleTextAttributes textStyle = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            switch (column) {
                case 3: {
                    SimpleColoredComponent simpleColoredComponent;
                    Object nameColumn = table.getValueAt(row, 1);
                    Object type = table.getValueAt(row, 2);
                    if (!(nameColumn instanceof String) || !(type instanceof ValueType)) break;
                    String valueRenderer = String.valueOf(AttributeValuesTable.this.getValueForRenderer((String)nameColumn, (ValueType)((Object)type), value));
                    String abbreviatedText = PTableRenderUtils.getAbbreviatedText((JTable)table, (int)column, (String)valueRenderer, null);
                    this.setToolTipText(AttributeValuesTable.this.getTooltipText(table, column, valueRenderer));
                    if (!selectedValue) {
                        this.append(abbreviatedText, textStyle);
                        simpleColoredComponent = Unit.INSTANCE;
                        break;
                    }
                    SimpleColoredComponent simpleColoredComponent2 = this.append(abbreviatedText);
                    simpleColoredComponent = simpleColoredComponent2;
                    Intrinsics.checkNotNullExpressionValue((Object)simpleColoredComponent2, (String)"append(...)");
                    break;
                }
                case 1: 
                case 2: {
                    SimpleColoredComponent simpleColoredComponent;
                    if (!selectedValue) {
                        this.append(String.valueOf(value), textStyle);
                        simpleColoredComponent = Unit.INSTANCE;
                        break;
                    }
                    SimpleColoredComponent simpleColoredComponent3 = this.append(String.valueOf(value));
                    simpleColoredComponent = simpleColoredComponent3;
                    Intrinsics.checkNotNullExpressionValue((Object)simpleColoredComponent3, (String)"append(...)");
                }
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/liquibase/orm/gui/entity/AttributeValuesTable$Companion;", "", "<init>", "()V", "COLUMN_SELECTED", "", "COLUMN_NAME", "COLUMN_TYPE", "COLUMN_VALUE", "intellij.liquibase.orm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\t\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0010\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/intellij/liquibase/orm/gui/entity/AttributeValuesTable$TableAttribute;", "", "selected", "", "name", "", "type", "Lcom/intellij/liquibase/orm/gui/entity/AttributeValuesTable$ValueType;", "value", "<init>", "(ZLjava/lang/String;Lcom/intellij/liquibase/orm/gui/entity/AttributeValuesTable$ValueType;Ljava/lang/String;)V", "getSelected", "()Z", "setSelected", "(Z)V", "getName", "()Ljava/lang/String;", "getType", "()Lcom/intellij/liquibase/orm/gui/entity/AttributeValuesTable$ValueType;", "setType", "(Lcom/intellij/liquibase/orm/gui/entity/AttributeValuesTable$ValueType;)V", "getValue", "setValue", "(Ljava/lang/String;)V", "intellij.liquibase.orm"})
    public static final class TableAttribute {
        private boolean selected;
        @NotNull
        private final String name;
        @NotNull
        private ValueType type;
        @Nullable
        private String value;

        public TableAttribute(boolean selected, @NotNull String name, @NotNull ValueType type, @Nullable String value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.selected = selected;
            this.name = name;
            this.type = type;
            this.value = value;
        }

        public final boolean getSelected() {
            return this.selected;
        }

        public final void setSelected(boolean bl) {
            this.selected = bl;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final ValueType getType() {
            return this.type;
        }

        public final void setType(@NotNull ValueType valueType) {
            Intrinsics.checkNotNullParameter((Object)((Object)valueType), (String)"<set-?>");
            this.type = valueType;
        }

        @Nullable
        public final String getValue() {
            return this.value;
        }

        public final void setValue(@Nullable String string) {
            this.value = string;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/liquibase/orm/gui/entity/AttributeValuesTable$ValueType;", "", "attrName", "", "datatype", "Lcom/intellij/jpa/jpb/model/model/Datatypes$BasicDatatype;", "<init>", "(Ljava/lang/String;ILjava/lang/String;Lcom/intellij/jpa/jpb/model/model/Datatypes$BasicDatatype;)V", "getAttrName", "()Ljava/lang/String;", "getDatatype", "()Lcom/intellij/jpa/jpb/model/model/Datatypes$BasicDatatype;", "Null", "String", "Numeric", "Date", "Boolean", "Computed", "Sequence", "intellij.liquibase.orm"})
    public static final class ValueType
    extends Enum<ValueType> {
        @NotNull
        private final String attrName;
        @Nullable
        private final Datatypes.BasicDatatype datatype;
        public static final /* enum */ ValueType Null = new ValueType("Null", 0, "value", null, 2, null);
        public static final /* enum */ ValueType String = new ValueType("value", Datatypes.BasicDatatype.String);
        public static final /* enum */ ValueType Numeric = new ValueType("valueNumeric", Datatypes.BasicDatatype.Integer);
        public static final /* enum */ ValueType Date = new ValueType("valueDate", Datatypes.BasicDatatype.Date);
        public static final /* enum */ ValueType Boolean = new ValueType("valueBoolean", Datatypes.BasicDatatype.Boolean);
        public static final /* enum */ ValueType Computed = new ValueType("Computed", 5, "valueComputed", null, 2, null);
        public static final /* enum */ ValueType Sequence = new ValueType("Sequence", 6, "valueSequenceNext", null, 2, null);
        private static final /* synthetic */ ValueType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ValueType(String attrName, Datatypes.BasicDatatype datatype) {
            this.attrName = attrName;
            this.datatype = datatype;
        }

        /* synthetic */ ValueType(String string, int n, String string2, Datatypes.BasicDatatype basicDatatype, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                basicDatatype = null;
            }
            this(string2, basicDatatype);
        }

        @NotNull
        public final String getAttrName() {
            return this.attrName;
        }

        @Nullable
        public final Datatypes.BasicDatatype getDatatype() {
            return this.datatype;
        }

        public static ValueType[] values() {
            return (ValueType[])$VALUES.clone();
        }

        public static ValueType valueOf(String value) {
            return Enum.valueOf(ValueType.class, value);
        }

        @NotNull
        public static EnumEntries<ValueType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = valueTypeArray = new ValueType[]{ValueType.Null, ValueType.String, ValueType.Numeric, ValueType.Date, ValueType.Boolean, ValueType.Computed, ValueType.Sequence};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

