/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.orm.mapping;

import com.intellij.jpa.jpb.model.backend.ed.ddl.DbDialect;
import com.intellij.jpa.jpb.model.backend.ed.ddl.PostgresDbDialect;
import com.intellij.jpa.jpb.model.backend.ed.indexing.CustomTypeModel;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.core.model.dbtype.PostgresType;
import com.intellij.jpa.jpb.model.db.HibernateSqlType;
import com.intellij.jpa.jpb.model.db.HibernateTypes;
import com.intellij.jpa.jpb.model.db.VladmihalceaHibernateTypes;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.liquibase.orm.mapping.ReMappingSettings;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 22\u00020\u0001:\u00012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100\u001a2\u0006\u0010!\u001a\u00020\u0010H\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010\u00102\u0006\u0010!\u001a\u00020\u0010H\u0002J\u0010\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0016J\u001a\u0010,\u001a\u0014\u0012\u0004\u0012\u00020-\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100.0\u000fH\u0016J\u0012\u0010/\u001a\u0004\u0018\u00010\u00102\u0006\u00100\u001a\u000201H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00170\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R&\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u001a0\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0013R\u0014\u0010\u001c\u001a\u00020\u001dX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00063"}, d2={"Lcom/intellij/liquibase/orm/mapping/PostgresReMappingSettings;", "Lcom/intellij/liquibase/orm/mapping/ReMappingSettings;", "project", "Lcom/intellij/openapi/project/Project;", "dbType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/PostgresType;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jpa/jpb/model/core/model/dbtype/PostgresType;)V", "isHibernateProject", "", "isHibernate6Project", "hasVladMihalceaHibernateTypes", "vladmihalceaHibernateTypes", "Lcom/intellij/jpa/jpb/model/db/VladmihalceaHibernateTypes;", "mappingTypes", "", "", "Lcom/intellij/jpa/jpb/model/model/Datatypes$BasicDatatype;", "getMappingTypes", "()Ljava/util/Map;", "mappingTypes$delegate", "Lkotlin/Lazy;", "sqlTypeToJdbcTypeCode", "Lcom/intellij/jpa/jpb/model/db/HibernateSqlType;", "getSqlTypeToJdbcTypeCode", "sqlSynonymTypes", "", "getSqlSynonymTypes", "maxDecimalPrecision", "", "getMaxDecimalPrecision", "()I", "getSqlTypeSynonyms", "sqlType", "getJavaType", "Lcom/intellij/jpa/jpb/model/model/Datatype;", "column", "Lliquibase/structure/core/Column;", "getTargetArrayType", "isLobStringType", "dataType", "Lliquibase/structure/core/DataType;", "getDbDialect", "Lcom/intellij/jpa/jpb/model/backend/ed/ddl/DbDialect;", "getTemporalTypeMappings", "Lcom/intellij/jpa/jpb/model/model/EntityAttribute$TemporalType;", "", "getConverterJavaType", "foundTypeModel", "Lcom/intellij/jpa/jpb/model/backend/ed/indexing/CustomTypeModel;", "Companion", "intellij.liquibase.orm"})
@SourceDebugExtension(value={"SMAP\nPostgresReMappingSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostgresReMappingSettings.kt\ncom/intellij/liquibase/orm/mapping/PostgresReMappingSettings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,197:1\n1586#2:198\n1661#2,3:199\n*S KotlinDebug\n*F\n+ 1 PostgresReMappingSettings.kt\ncom/intellij/liquibase/orm/mapping/PostgresReMappingSettings\n*L\n121#1:198\n121#1:199,3\n*E\n"})
public final class PostgresReMappingSettings
extends ReMappingSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isHibernateProject;
    private final boolean isHibernate6Project;
    private final boolean hasVladMihalceaHibernateTypes;
    @NotNull
    private final VladmihalceaHibernateTypes vladmihalceaHibernateTypes;
    @NotNull
    private final Lazy mappingTypes$delegate;
    @NotNull
    private final Map<String, HibernateSqlType> sqlTypeToJdbcTypeCode;
    private final int maxDecimalPrecision;
    @NotNull
    private static final Datatypes.BasicDatatype[] EXCLUDE_ARRAY_TYPES;

    public PostgresReMappingSettings(@NotNull Project project, @NotNull PostgresType dbType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        super(project, (DbType)dbType);
        this.isHibernateProject = JpaUtils.isHibernateProject((Project)project, null);
        this.isHibernate6Project = JpaUtils.isHibernate6Project((Project)project, null);
        this.hasVladMihalceaHibernateTypes = JpaUtils.hasVladMihalceaHibernateTypes((Project)project);
        this.vladmihalceaHibernateTypes = VladmihalceaHibernateTypes.Companion.getInstance(project);
        this.mappingTypes$delegate = LazyKt.lazy(() -> PostgresReMappingSettings.mappingTypes_delegate$lambda$0(this));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"json", (Object)HibernateSqlType.JSON), TuplesKt.to((Object)"xml", (Object)HibernateSqlType.SQLXML)};
        this.sqlTypeToJdbcTypeCode = MapsKt.mapOf((Pair[])pairArray);
        this.maxDecimalPrecision = 131089;
    }

    @Override
    @NotNull
    public Map<String, Datatypes.BasicDatatype> getMappingTypes() {
        Lazy lazy = this.mappingTypes$delegate;
        return (Map)lazy.getValue();
    }

    @Override
    @NotNull
    public Map<String, HibernateSqlType> getSqlTypeToJdbcTypeCode() {
        return this.sqlTypeToJdbcTypeCode;
    }

    @Override
    @NotNull
    public Map<String, Collection<String>> getSqlSynonymTypes() {
        Pair[] pairArray = new Pair[19];
        pairArray[0] = TuplesKt.to((Object)"bigint", (Object)CollectionsKt.listOf((Object)"int8"));
        pairArray[1] = TuplesKt.to((Object)"bigserial", (Object)CollectionsKt.listOf((Object)"serial8"));
        pairArray[2] = TuplesKt.to((Object)"boolean", (Object)CollectionsKt.listOf((Object)"bool"));
        Object[] objectArray = new String[]{"character varying", "citext"};
        pairArray[3] = TuplesKt.to((Object)"varchar", (Object)CollectionsKt.listOf((Object[])objectArray));
        pairArray[4] = TuplesKt.to((Object)"text", (Object)CollectionsKt.listOf((Object)"citext"));
        objectArray = new String[]{"character", "bpchar"};
        pairArray[5] = TuplesKt.to((Object)"char", (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"double precision", "float8", "float"};
        pairArray[6] = TuplesKt.to((Object)"double", (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"int", "int4"};
        pairArray[7] = TuplesKt.to((Object)"integer", (Object)CollectionsKt.listOf((Object[])objectArray));
        pairArray[8] = TuplesKt.to((Object)"json", (Object)CollectionsKt.listOf((Object)"jsonb"));
        pairArray[9] = TuplesKt.to((Object)"numeric", (Object)CollectionsKt.listOf((Object)"decimal"));
        pairArray[10] = TuplesKt.to((Object)"real", (Object)CollectionsKt.listOf((Object)"float4"));
        pairArray[11] = TuplesKt.to((Object)"smallint", (Object)CollectionsKt.listOf((Object)"int2"));
        pairArray[12] = TuplesKt.to((Object)"smallserial", (Object)CollectionsKt.listOf((Object)"serial2"));
        pairArray[13] = TuplesKt.to((Object)"serial", (Object)CollectionsKt.listOf((Object)"serial4"));
        pairArray[14] = TuplesKt.to((Object)"time with time zone", (Object)CollectionsKt.listOf((Object)"timetz"));
        pairArray[15] = TuplesKt.to((Object)"time without time zone", (Object)CollectionsKt.listOf((Object)"time"));
        pairArray[16] = TuplesKt.to((Object)"timestamp with time zone", (Object)CollectionsKt.listOf((Object)"timestamptz"));
        pairArray[17] = TuplesKt.to((Object)"timestamp without time zone", (Object)CollectionsKt.listOf((Object)"timestamp"));
        objectArray = new String[]{"binary", "binary varying", "longvarbinary"};
        pairArray[18] = TuplesKt.to((Object)"bytea", (Object)CollectionsKt.listOf((Object[])objectArray));
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    public int getMaxDecimalPrecision() {
        return this.maxDecimalPrecision;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<String> getSqlTypeSynonyms(@NotNull String sqlType) {
        Intrinsics.checkNotNullParameter((Object)sqlType, (String)"sqlType");
        if (StringsKt.endsWith$default((String)sqlType, (String)"[]", (boolean)false, (int)2, null)) {
            void $this$mapTo$iv$iv;
            Collection<String> sqlTypeSynonyms = super.getSqlTypeSynonyms(StringsKt.substringBefore$default((String)sqlType, (String)"[]", null, (int)2, null));
            Iterable $this$map$iv = sqlTypeSynonyms;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((String)it + "[]");
            }
            return (List)destination$iv$iv;
        }
        return super.getSqlTypeSynonyms(sqlType);
    }

    @Override
    @Nullable
    public Datatype getJavaType(@NotNull Column column) {
        Datatypes.BasicDatatype arrayType;
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Datatype javaType = super.getJavaType(column);
        if (javaType != null) {
            return javaType;
        }
        DataType dataType = column.getType();
        String sqlType = dataType.getTypeName();
        Intrinsics.checkNotNull((Object)sqlType);
        if (StringsKt.startsWith((String)sqlType, (String)"timestamp(", (boolean)true)) {
            return (Datatype)this.findMappingType(StringsKt.substringBefore$default((String)sqlType, (char)'(', null, (int)2, null) + StringsKt.substringAfter$default((String)sqlType, (char)')', null, (int)2, null));
        }
        String targetArrayType = this.getTargetArrayType(sqlType);
        if (targetArrayType != null && (arrayType = this.findMappingTypeWithSynonyms(targetArrayType)) != null && !ArraysKt.contains((Object[])EXCLUDE_ARRAY_TYPES, (Object)arrayType)) {
            return (Datatype)Datatypes.BasicDatatype.createUnsafe((String)("java.util.List<" + arrayType.getFqn() + ">"));
        }
        return null;
    }

    private final String getTargetArrayType(String sqlType) {
        String string;
        if (!JpaUtils.isHibernate_6_1_Project((Project)this.getProject())) {
            return null;
        }
        int arrayDefIdx = StringsKt.indexOf$default((CharSequence)sqlType, (String)"[]", (int)0, (boolean)false, (int)6, null);
        if (arrayDefIdx == -1) {
            string = null;
        } else {
            String string2 = sqlType.substring(0, arrayDefIdx);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        }
        return string;
    }

    @Override
    public boolean isLobStringType(@NotNull DataType dataType) {
        String string;
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
        Object[] objectArray = new String[]{"text", "varchar", "character varying", "char", "citext", "character"};
        String string2 = dataType.getTypeName();
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        return ArraysKt.contains((Object[])objectArray, (Object)string) && JpaUtils.isHibernate6Project((Project)this.getProject(), null) ? false : super.isLobStringType(dataType);
    }

    @Override
    @NotNull
    public DbDialect getDbDialect() {
        DbDialect dbDialect = PostgresDbDialect.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)dbDialect, (String)"INSTANCE");
        return dbDialect;
    }

    @Override
    @NotNull
    public Map<EntityAttribute.TemporalType, String[]> getTemporalTypeMappings() {
        Pair[] pairArray = new Pair[3];
        String[] stringArray = new String[]{"date"};
        pairArray[0] = TuplesKt.to((Object)EntityAttribute.TemporalType.DATE, (Object)stringArray);
        stringArray = new String[]{"time", "time with time zone", "timetz"};
        pairArray[1] = TuplesKt.to((Object)EntityAttribute.TemporalType.TIME, (Object)stringArray);
        stringArray = new String[]{"timestamp", "timestamp with time zone", "timestamptz"};
        pairArray[2] = TuplesKt.to((Object)EntityAttribute.TemporalType.TIMESTAMP, (Object)stringArray);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @Nullable
    public String getConverterJavaType(@NotNull CustomTypeModel foundTypeModel) {
        Intrinsics.checkNotNullParameter((Object)foundTypeModel, (String)"foundTypeModel");
        PsiClass psiClass = foundTypeModel.getTypeClass();
        if (Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)VladmihalceaHibernateTypes.Companion.getInstance(this.getProject()).getPostgreSQLTSVectorType().getFqn())) {
            return Datatypes.BasicDatatype.String.getFqn();
        }
        return super.getConverterJavaType(foundTypeModel);
    }

    private static final Map mappingTypes_delegate$lambda$0(PostgresReMappingSettings this$0) {
        Object object = new Pair[]{TuplesKt.to((Object)"bigint", (Object)Datatypes.BasicDatatype.Long), TuplesKt.to((Object)"bigserial", (Object)Datatypes.BasicDatatype.Long), TuplesKt.to((Object)"boolean", (Object)Datatypes.BasicDatatype.Boolean), TuplesKt.to((Object)"bytea", (Object)Datatypes.BasicDatatype.PByteArray), TuplesKt.to((Object)"varchar", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"char", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"date", (Object)Datatypes.BasicDatatype.LocalDate), TuplesKt.to((Object)"double", (Object)Datatypes.BasicDatatype.Double), TuplesKt.to((Object)"integer", (Object)Datatypes.BasicDatatype.Integer), TuplesKt.to((Object)"money", (Object)Datatypes.BasicDatatype.BigDecimal), TuplesKt.to((Object)"numeric", (Object)Datatypes.BasicDatatype.BigDecimal), TuplesKt.to((Object)"real", (Object)Datatypes.BasicDatatype.Float), TuplesKt.to((Object)"smallint", (Object)Datatypes.BasicDatatype.Short), TuplesKt.to((Object)"smallserial", (Object)Datatypes.BasicDatatype.Short), TuplesKt.to((Object)"serial", (Object)Datatypes.BasicDatatype.Integer), TuplesKt.to((Object)"text", (Object)(this$0.isHibernateProject && !this$0.isHibernate6Project ? HibernateTypes.INSTANCE.getTextType() : Datatypes.BasicDatatype.String)), TuplesKt.to((Object)"oid", (Object)Datatypes.BasicDatatype.String), TuplesKt.to((Object)"time", (Object)Datatypes.BasicDatatype.LocalTime), TuplesKt.to((Object)"time with time zone", (Object)Datatypes.BasicDatatype.OffsetTime), TuplesKt.to((Object)"timestamp", (Object)Datatypes.BasicDatatype.Instant), TuplesKt.to((Object)"timestamp with time zone", (Object)Datatypes.BasicDatatype.OffsetDateTime), TuplesKt.to((Object)"uuid", (Object)Datatypes.BasicDatatype.UUID), TuplesKt.to((Object)"year", (Object)Datatypes.BasicDatatype.Integer)};
        Object $this$mappingTypes_delegate_u24lambda_u240_u240 = object = MapsKt.mutableMapOf((Pair[])object);
        boolean bl = false;
        if (this$0.hasVladMihalceaHibernateTypes) {
            $this$mappingTypes_delegate_u24lambda_u240_u240.put("tsvector", this$0.vladmihalceaHibernateTypes.getPostgreSQLTSVectorType());
            $this$mappingTypes_delegate_u24lambda_u240_u240.put("citext", this$0.vladmihalceaHibernateTypes.getPostgreSQLCITextType());
            $this$mappingTypes_delegate_u24lambda_u240_u240.put("hstore", this$0.vladmihalceaHibernateTypes.getPostgreSQLHStoreType());
            $this$mappingTypes_delegate_u24lambda_u240_u240.put("int4range", this$0.vladmihalceaHibernateTypes.getPostgreSQLRangeType());
            $this$mappingTypes_delegate_u24lambda_u240_u240.put("int8range", this$0.vladmihalceaHibernateTypes.getPostgreSQLRangeType());
            $this$mappingTypes_delegate_u24lambda_u240_u240.put("numrange", this$0.vladmihalceaHibernateTypes.getPostgreSQLRangeType());
            $this$mappingTypes_delegate_u24lambda_u240_u240.put("tsrange", this$0.vladmihalceaHibernateTypes.getPostgreSQLRangeType());
            $this$mappingTypes_delegate_u24lambda_u240_u240.put("tstzrange", this$0.vladmihalceaHibernateTypes.getPostgreSQLRangeType());
            $this$mappingTypes_delegate_u24lambda_u240_u240.put("daterange", this$0.vladmihalceaHibernateTypes.getPostgreSQLRangeType());
            $this$mappingTypes_delegate_u24lambda_u240_u240.put("boolean[]", this$0.vladmihalceaHibernateTypes.getBooleanArrayType());
            $this$mappingTypes_delegate_u24lambda_u240_u240.put("date[]", this$0.vladmihalceaHibernateTypes.getDateArrayType());
            $this$mappingTypes_delegate_u24lambda_u240_u240.put("decimal[]", this$0.vladmihalceaHibernateTypes.getDecimalArrayType());
            $this$mappingTypes_delegate_u24lambda_u240_u240.put("float8[]", this$0.vladmihalceaHibernateTypes.getDoubleArrayType());
            $this$mappingTypes_delegate_u24lambda_u240_u240.put("integer[]", this$0.vladmihalceaHibernateTypes.getIntArrayType());
            $this$mappingTypes_delegate_u24lambda_u240_u240.put("bigint[]", this$0.vladmihalceaHibernateTypes.getLongArrayType());
            $this$mappingTypes_delegate_u24lambda_u240_u240.put("text[]", this$0.vladmihalceaHibernateTypes.getStringArrayType());
            $this$mappingTypes_delegate_u24lambda_u240_u240.put("uuid[]", this$0.vladmihalceaHibernateTypes.getUUIDArrayType());
            $this$mappingTypes_delegate_u24lambda_u240_u240.put("timestamp[]", this$0.vladmihalceaHibernateTypes.getTimestampArrayType());
            $this$mappingTypes_delegate_u24lambda_u240_u240.put("interval", this$0.vladmihalceaHibernateTypes.getPostgreSQLIntervalType());
            $this$mappingTypes_delegate_u24lambda_u240_u240.put("inet", this$0.vladmihalceaHibernateTypes.getPostgreSQLInetType());
            $this$mappingTypes_delegate_u24lambda_u240_u240.put("json", this$0.vladmihalceaHibernateTypes.getJsonNodeBinaryType());
        }
        if (this$0.isHibernate6Project) {
            $this$mappingTypes_delegate_u24lambda_u240_u240.put("xml", HibernateTypes.INSTANCE.getMapStringToObject());
            $this$mappingTypes_delegate_u24lambda_u240_u240.put("json", HibernateTypes.INSTANCE.getMapStringToObject());
            $this$mappingTypes_delegate_u24lambda_u240_u240.put("inet", Datatypes.BasicDatatype.InetAddress);
        }
        return object;
    }

    static {
        Datatypes.BasicDatatype[] basicDatatypeArray = new Datatypes.BasicDatatype[]{Datatypes.BasicDatatype.PByteArray, Datatypes.BasicDatatype.ByteArray};
        EXCLUDE_ARRAY_TYPES = basicDatatypeArray;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/liquibase/orm/mapping/PostgresReMappingSettings$Companion;", "", "<init>", "()V", "EXCLUDE_ARRAY_TYPES", "", "Lcom/intellij/jpa/jpb/model/model/Datatypes$BasicDatatype;", "kotlin.jvm.PlatformType", "[Lcom/intellij/jpa/jpb/model/model/Datatypes$BasicDatatype;", "intellij.liquibase.orm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

