/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.containers.ContainerUtil;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigKey;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.processor.handler.EqualsAndHashCodeToStringHandler;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightModifierList;
import de.plushnikov.intellij.plugin.psi.LombokLightParameter;
import de.plushnikov.intellij.plugin.quickfix.PsiQuickFixFactory;
import de.plushnikov.intellij.plugin.thirdparty.LombokAddNullAnnotations;
import de.plushnikov.intellij.plugin.thirdparty.LombokCopyableAnnotations;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import de.plushnikov.intellij.plugin.util.PsiMethodUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EqualsAndHashCodeProcessor
extends AbstractClassProcessor {
    private static final String EQUALS_METHOD_NAME = "equals";
    private static final String HASH_CODE_METHOD_NAME = "hashCode";
    private static final String CAN_EQUAL_METHOD_NAME = "canEqual";
    private static final List<String> ALL_NAMES = List.of("equals", "hashCode", "canEqual");
    private static final String INCLUDE_ANNOTATION_METHOD = "replaces";
    private static final int PRIME_FOR_HASHCODE = 59;
    private static final int PRIME_FOR_TRUE = 79;
    private static final int PRIME_FOR_FALSE = 97;
    private static final int PRIME_FOR_NULL = 43;

    public EqualsAndHashCodeProcessor() {
        super((Class<? extends PsiElement>)PsiMethod.class, "lombok.EqualsAndHashCode");
    }

    @Override
    protected Collection<String> getNamesOfPossibleGeneratedElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(0);
        }
        if (psiAnnotation == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(1);
        }
        return ALL_NAMES;
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemSink problemSink) {
        if (psiAnnotation == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(2);
        }
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(3);
        }
        if (problemSink == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(4);
        }
        EqualsAndHashCodeProcessor.validateAnnotationOnRightType(psiClass, problemSink);
        if (problemSink.success()) {
            EqualsAndHashCodeProcessor.validateExistingMethods(psiClass, problemSink);
        }
        if (problemSink.deepValidation()) {
            Collection<String> excludeProperty = PsiAnnotationUtil.getAnnotationValues(psiAnnotation, "exclude", String.class, List.of());
            Collection<String> ofProperty = PsiAnnotationUtil.getAnnotationValues(psiAnnotation, "of", String.class, List.of());
            if (!excludeProperty.isEmpty() && !ofProperty.isEmpty()) {
                problemSink.addWarningMessage("inspection.message.exclude.are.mutually.exclusive.exclude.parameter.will.be.ignored", new Object[0]).withLocalQuickFixes(() -> PsiQuickFixFactory.createChangeAnnotationParameterFix(psiAnnotation, "exclude", null));
            } else {
                EqualsAndHashCodeProcessor.validateExcludeParam(psiClass, problemSink, psiAnnotation, excludeProperty);
            }
            EqualsAndHashCodeProcessor.validateOfParam(psiClass, problemSink, psiAnnotation, ofProperty);
            this.validateCallSuperParamIntern(psiAnnotation, psiClass, problemSink);
            EqualsAndHashCodeProcessor.validateCallSuperParamForObject(psiAnnotation, psiClass, problemSink);
        }
        return problemSink.success();
    }

    private void validateCallSuperParamIntern(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiAnnotation == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(5);
        }
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(7);
        }
        this.validateCallSuperParam(psiAnnotation, psiClass, builder, () -> PsiQuickFixFactory.createChangeAnnotationParameterFix(psiAnnotation, "callSuper", "false"), () -> PsiQuickFixFactory.createChangeAnnotationParameterFix(psiAnnotation, "callSuper", "true"));
    }

    void validateCallSuperParamExtern(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiAnnotation == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(8);
        }
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(9);
        }
        if (builder == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(10);
        }
        this.validateCallSuperParam(psiAnnotation, psiClass, builder, () -> PsiQuickFixFactory.createAddAnnotationFix(psiClass, "lombok.EqualsAndHashCode", "callSuper = true"));
    }

    private void validateCallSuperParam(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemSink builder, Supplier<LocalQuickFix> ... quickFixes) {
        String configProperty;
        Boolean declaredBooleanAnnotationValue;
        if (psiAnnotation == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(11);
        }
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(12);
        }
        if (builder == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(13);
        }
        if (null == (declaredBooleanAnnotationValue = PsiAnnotationUtil.getDeclaredBooleanAnnotationValue(psiAnnotation, "callSuper")) && !"CALL".equalsIgnoreCase(configProperty = this.configDiscovery.getStringLombokConfigProperty(ConfigKey.EQUALSANDHASHCODE_CALL_SUPER, psiClass)) && !"SKIP".equalsIgnoreCase(configProperty) && PsiClassUtil.hasSuperClass(psiClass) && !EqualsAndHashCodeProcessor.hasOneOfMethodsDefined(psiClass)) {
            builder.addWarningMessage("inspection.message.generating.equals.hashcode.implementation", new Object[0]).withLocalQuickFixes(quickFixes);
        }
    }

    private static void validateCallSuperParamForObject(PsiAnnotation psiAnnotation, PsiClass psiClass, ProblemSink builder) {
        boolean callSuperProperty = PsiAnnotationUtil.getBooleanAnnotationValue(psiAnnotation, "callSuper", false);
        if (callSuperProperty && !PsiClassUtil.hasSuperClass(psiClass)) {
            builder.addErrorMessage("inspection.message.generating.equals.hashcode.with.super.call", new Object[0]).withLocalQuickFixes(() -> PsiQuickFixFactory.createChangeAnnotationParameterFix(psiAnnotation, "callSuper", "false"), () -> PsiQuickFixFactory.createChangeAnnotationParameterFix(psiAnnotation, "callSuper", null));
        }
    }

    private static void validateAnnotationOnRightType(@NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(14);
        }
        if (builder == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(15);
        }
        if (psiClass.isAnnotationType() || psiClass.isInterface() || psiClass.isEnum() || psiClass.isRecord()) {
            builder.addErrorMessage("inspection.message.equals.and.hashcode.only.supported.on.class.type", new Object[0]).withLocalQuickFixes(() -> PsiQuickFixFactory.createDeleteAnnotationFix(psiClass, "lombok.EqualsAndHashCode"));
            builder.markFailed();
        }
    }

    private static void validateExistingMethods(@NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(16);
        }
        if (builder == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(17);
        }
        if (EqualsAndHashCodeProcessor.hasOneOfMethodsDefined(psiClass)) {
            builder.addWarningMessage("inspection.message.not.generating.equals.hashcode", new Object[0]);
            builder.markFailed();
        }
    }

    private static boolean hasOneOfMethodsDefined(@NotNull PsiClass psiClass) {
        Collection<PsiMethod> classMethodsIntern;
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(18);
        }
        return PsiMethodUtil.hasMethodByName(classMethodsIntern = PsiClassUtil.collectClassMethodsIntern(psiClass), EQUALS_METHOD_NAME, 1) || PsiMethodUtil.hasMethodByName(classMethodsIntern, HASH_CODE_METHOD_NAME, 0);
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target, @Nullable String nameHint) {
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(19);
        }
        if (psiAnnotation == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(20);
        }
        if (target == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(21);
        }
        target.addAll(this.createEqualAndHashCode(psiClass, psiAnnotation));
    }

    Collection<PsiMethod> createEqualAndHashCode(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(22);
        }
        if (psiAnnotation == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(23);
        }
        if (EqualsAndHashCodeProcessor.hasOneOfMethodsDefined(psiClass)) {
            return Collections.emptyList();
        }
        boolean shouldGenerateCanEqual = EqualsAndHashCodeProcessor.shouldGenerateCanEqual(psiClass);
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>(3);
        result.add(this.createEqualsMethod(psiClass, psiAnnotation, shouldGenerateCanEqual));
        Collection<PsiMethod> classMethods = PsiClassUtil.collectClassMethodsIntern(psiClass);
        if (shouldGenerateCanEqual && !PsiMethodUtil.hasMethodByName(classMethods, CAN_EQUAL_METHOD_NAME, 1)) {
            result.add(EqualsAndHashCodeProcessor.createCanEqualMethod(psiClass, psiAnnotation));
        }
        result.add(this.createHashCodeMethod(psiClass, psiAnnotation));
        return result;
    }

    private static boolean shouldGenerateCanEqual(@NotNull PsiClass psiClass) {
        boolean isNotDirectDescendantOfObject;
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(24);
        }
        if (isNotDirectDescendantOfObject = PsiClassUtil.hasSuperClass(psiClass)) {
            return true;
        }
        boolean isFinal = psiClass.hasModifierProperty("final") || PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.Value") && PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.experimental.NonFinal");
        return !isFinal;
    }

    @NotNull
    private PsiMethod createEqualsMethod(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, boolean hasCanEqualMethod) {
        PsiManager psiManager;
        LombokLightMethodBuilder methodBuilder;
        LombokLightParameter parameter;
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(25);
        }
        if (psiAnnotation == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(26);
        }
        if (null != (parameter = (methodBuilder = new LombokLightMethodBuilder(psiManager = psiClass.getManager(), EQUALS_METHOD_NAME).withModifier("public").withMethodReturnType((PsiType)PsiTypes.booleanType()).withContainingClass(psiClass).withNavigationElement((PsiElement)psiAnnotation).withFinalParameter("o", (PsiType)PsiType.getJavaLangObject((PsiManager)psiManager, (GlobalSearchScope)psiClass.getResolveScope()))).getParameterList().getParameter(0))) {
            LombokAddNullAnnotations.createRelevantNullableAnnotation(psiClass, parameter);
            EqualsAndHashCodeProcessor.copyOnXAnnotationsForFirstParam(psiAnnotation, parameter);
        }
        methodBuilder.withRelatedMembers(m -> {
            Collection<EqualsAndHashCodeToStringHandler.MemberInfo> memberInfos = EqualsAndHashCodeProcessor.collectEqualsAndHashcodeMemberInfo(m);
            return ContainerUtil.map(memberInfos, EqualsAndHashCodeToStringHandler.MemberInfo::getField);
        });
        methodBuilder.withBodyText(m -> {
            PsiClass containingClass = m.getContainingClass();
            PsiAnnotation anno = (PsiAnnotation)m.getNavigationElement();
            Collection<EqualsAndHashCodeToStringHandler.MemberInfo> memberInfos = EqualsAndHashCodeProcessor.collectEqualsAndHashcodeMemberInfo(m);
            return this.createEqualsBlockString(containingClass, anno, hasCanEqualMethod, memberInfos);
        });
        LombokLightMethodBuilder lombokLightMethodBuilder = methodBuilder;
        if (lombokLightMethodBuilder == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(27);
        }
        return lombokLightMethodBuilder;
    }

    @NotNull
    private static Collection<EqualsAndHashCodeToStringHandler.MemberInfo> collectEqualsAndHashcodeMemberInfo(LombokLightMethodBuilder m) {
        PsiClass containingClass = m.getContainingClass();
        PsiAnnotation anno = (PsiAnnotation)m.getNavigationElement();
        Collection<EqualsAndHashCodeToStringHandler.MemberInfo> collection = EqualsAndHashCodeToStringHandler.filterMembers(containingClass, anno, true, INCLUDE_ANNOTATION_METHOD, null, "lombok.EqualsAndHashCode.Include", "lombok.EqualsAndHashCode.Exclude");
        if (collection == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(28);
        }
        return collection;
    }

    @NotNull
    private PsiMethod createHashCodeMethod(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(29);
        }
        if (psiAnnotation == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(30);
        }
        PsiManager psiManager = psiClass.getManager();
        LombokLightMethodBuilder lombokLightMethodBuilder = new LombokLightMethodBuilder(psiManager, HASH_CODE_METHOD_NAME).withModifier("public").withMethodReturnType((PsiType)PsiTypes.intType()).withContainingClass(psiClass).withNavigationElement((PsiElement)psiAnnotation).withRelatedMembers(m -> {
            Collection<EqualsAndHashCodeToStringHandler.MemberInfo> memberInfos = EqualsAndHashCodeProcessor.collectEqualsAndHashcodeMemberInfo(m);
            return ContainerUtil.map(memberInfos, EqualsAndHashCodeToStringHandler.MemberInfo::getField);
        }).withBodyText(m -> {
            PsiClass containingClass = m.getContainingClass();
            PsiAnnotation anno = (PsiAnnotation)m.getNavigationElement();
            Collection<EqualsAndHashCodeToStringHandler.MemberInfo> memberInfos = EqualsAndHashCodeProcessor.collectEqualsAndHashcodeMemberInfo(m);
            return this.createHashcodeBlockString(containingClass, anno, memberInfos);
        });
        if (lombokLightMethodBuilder == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(31);
        }
        return lombokLightMethodBuilder;
    }

    @NotNull
    private static PsiMethod createCanEqualMethod(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(32);
        }
        if (psiAnnotation == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(33);
        }
        PsiManager psiManager = psiClass.getManager();
        String blockText = String.format("return other instanceof %s;", PsiTypesUtil.getClassType((PsiClass)psiClass).getCanonicalText());
        LombokLightMethodBuilder methodBuilder = new LombokLightMethodBuilder(psiManager, CAN_EQUAL_METHOD_NAME).withModifier("protected").withMethodReturnType((PsiType)PsiTypes.booleanType()).withContainingClass(psiClass).withNavigationElement((PsiElement)psiAnnotation).withFinalParameter("other", (PsiType)PsiType.getJavaLangObject((PsiManager)psiManager, (GlobalSearchScope)psiClass.getResolveScope()));
        LombokLightParameter parameter = methodBuilder.getParameterList().getParameter(0);
        if (null != parameter) {
            LombokAddNullAnnotations.createRelevantNullableAnnotation(psiClass, parameter);
            EqualsAndHashCodeProcessor.copyOnXAnnotationsForFirstParam(psiAnnotation, parameter);
        }
        methodBuilder.withBodyText(blockText);
        LombokLightMethodBuilder lombokLightMethodBuilder = methodBuilder;
        if (lombokLightMethodBuilder == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(34);
        }
        return lombokLightMethodBuilder;
    }

    private static void copyOnXAnnotationsForFirstParam(@NotNull PsiAnnotation psiAnnotation, @NotNull LombokLightParameter lightParameter) {
        if (psiAnnotation == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(35);
        }
        if (lightParameter == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(36);
        }
        LombokLightModifierList methodParameterModifierList = lightParameter.getModifierList();
        LombokCopyableAnnotations.copyOnXAnnotations(psiAnnotation, (PsiModifierList)methodParameterModifierList, "onParam");
    }

    @NotNull
    private String createEqualsBlockString(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, boolean hasCanEqualMethod, Collection<EqualsAndHashCodeToStringHandler.MemberInfo> memberInfos) {
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(37);
        }
        if (psiAnnotation == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(38);
        }
        boolean callSuper = this.readCallSuperAnnotationOrConfigProperty(psiAnnotation, psiClass, ConfigKey.EQUALSANDHASHCODE_CALL_SUPER);
        boolean doNotUseGetters = this.readAnnotationOrConfigProperty(psiAnnotation, psiClass, "doNotUseGetters", ConfigKey.EQUALSANDHASHCODE_DO_NOT_USE_GETTERS);
        String canonicalClassName = PsiTypesUtil.getClassType((PsiClass)psiClass).getCanonicalText();
        String canonicalWildcardClassName = PsiClassUtil.getWildcardClassType(psiClass).getCanonicalText();
        StringBuilder builder = new StringBuilder();
        builder.append("if (o == this) return true;\n");
        builder.append("if (!(o instanceof ").append(canonicalClassName).append(")) return false;\n");
        builder.append("final ").append(canonicalWildcardClassName).append(" other = (").append(canonicalWildcardClassName).append(")o;\n");
        if (hasCanEqualMethod) {
            builder.append("if (!other.canEqual((java.lang.Object)this)) return false;\n");
        }
        if (callSuper) {
            builder.append("if (!super.equals(o)) return false;\n");
        }
        for (EqualsAndHashCodeToStringHandler.MemberInfo memberInfo : memberInfos) {
            String memberAccessor = EqualsAndHashCodeToStringHandler.getMemberAccessorName(memberInfo, doNotUseGetters, psiClass);
            PsiType memberType = memberInfo.getType();
            if (memberType instanceof PsiPrimitiveType) {
                if (PsiTypes.floatType().equals((Object)memberType)) {
                    builder.append("if (java.lang.Float.compare(this.").append(memberAccessor).append(", other.").append(memberAccessor).append(") != 0) return false;\n");
                    continue;
                }
                if (PsiTypes.doubleType().equals((Object)memberType)) {
                    builder.append("if (java.lang.Double.compare(this.").append(memberAccessor).append(", other.").append(memberAccessor).append(") != 0) return false;\n");
                    continue;
                }
                builder.append("if (this.").append(memberAccessor).append(" != other.").append(memberAccessor).append(") return false;\n");
                continue;
            }
            if (memberType instanceof PsiArrayType) {
                PsiType componentType = ((PsiArrayType)memberType).getComponentType();
                if (componentType instanceof PsiPrimitiveType) {
                    builder.append("if (!java.util.Arrays.equals(this.").append(memberAccessor).append(", other.").append(memberAccessor).append(")) return false;\n");
                    continue;
                }
                builder.append("if (!java.util.Arrays.deepEquals(this.").append(memberAccessor).append(", other.").append(memberAccessor).append(")) return false;\n");
                continue;
            }
            String memberName = memberInfo.getName();
            builder.append("final java.lang.Object this$").append(memberName).append(" = this.").append(memberAccessor).append(";\n");
            builder.append("final java.lang.Object other$").append(memberName).append(" = other.").append(memberAccessor).append(";\n");
            builder.append("if (this$").append(memberName).append(" == null ? other$").append(memberName).append(" != null : !this$").append(memberName).append(".equals(other$").append(memberName).append(")) return false;\n");
        }
        builder.append("return true;\n");
        String string = builder.toString();
        if (string == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(39);
        }
        return string;
    }

    @NotNull
    private String createHashcodeBlockString(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, Collection<EqualsAndHashCodeToStringHandler.MemberInfo> memberInfos) {
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(40);
        }
        if (psiAnnotation == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(41);
        }
        boolean callSuper = this.readCallSuperAnnotationOrConfigProperty(psiAnnotation, psiClass, ConfigKey.EQUALSANDHASHCODE_CALL_SUPER);
        boolean doNotUseGetters = this.readAnnotationOrConfigProperty(psiAnnotation, psiClass, "doNotUseGetters", ConfigKey.EQUALSANDHASHCODE_DO_NOT_USE_GETTERS);
        StringBuilder builder = new StringBuilder();
        if (!memberInfos.isEmpty()) {
            builder.append("final int PRIME = ").append(59).append(";\n");
        }
        builder.append("int result = ");
        if (callSuper) {
            builder.append("super.hashCode();\n");
        } else {
            builder.append("1;\n");
        }
        for (EqualsAndHashCodeToStringHandler.MemberInfo memberInfo : memberInfos) {
            String memberAccessor = EqualsAndHashCodeToStringHandler.getMemberAccessorName(memberInfo, doNotUseGetters, psiClass);
            Object memberName = memberInfo.getMethod() == null ? memberInfo.getName() : "$" + memberInfo.getName();
            PsiType classFieldType = memberInfo.getType();
            if (classFieldType instanceof PsiPrimitiveType) {
                if (PsiTypes.booleanType().equals((Object)classFieldType)) {
                    builder.append("result = result * PRIME + (this.").append(memberAccessor).append(" ? ").append(79).append(" : ").append(97).append(");\n");
                    continue;
                }
                if (PsiTypes.longType().equals((Object)classFieldType)) {
                    builder.append("final long $").append((String)memberName).append(" = this.").append(memberAccessor).append(";\n");
                    builder.append("result = result * PRIME + (int)($").append((String)memberName).append(" >>> 32 ^ $").append((String)memberName).append(");\n");
                    continue;
                }
                if (PsiTypes.floatType().equals((Object)classFieldType)) {
                    builder.append("result = result * PRIME + java.lang.Float.floatToIntBits(this.").append(memberAccessor).append(");\n");
                    continue;
                }
                if (PsiTypes.doubleType().equals((Object)classFieldType)) {
                    builder.append("final long $").append((String)memberName).append(" = java.lang.Double.doubleToLongBits(this.").append(memberAccessor).append(");\n");
                    builder.append("result = result * PRIME + (int)($").append((String)memberName).append(" >>> 32 ^ $").append((String)memberName).append(");\n");
                    continue;
                }
                builder.append("result = result * PRIME + this.").append(memberAccessor).append(";\n");
                continue;
            }
            if (classFieldType instanceof PsiArrayType) {
                PsiType componentType = ((PsiArrayType)classFieldType).getComponentType();
                if (componentType instanceof PsiPrimitiveType) {
                    builder.append("result = result * PRIME + java.util.Arrays.hashCode(this.").append(memberAccessor).append(");\n");
                    continue;
                }
                builder.append("result = result * PRIME + java.util.Arrays.deepHashCode(this.").append(memberAccessor).append(");\n");
                continue;
            }
            builder.append("final java.lang.Object $").append((String)memberName).append(" = this.").append(memberAccessor).append(";\n");
            builder.append("result = result * PRIME + ($").append((String)memberName).append(" == null ? 43 : $").append((String)memberName).append(".hashCode());\n");
        }
        builder.append("return result;\n");
        String string = builder.toString();
        if (string == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(42);
        }
        return string;
    }

    @Override
    @NotNull
    public Collection<PsiAnnotation> collectProcessedAnnotations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(43);
        }
        Collection<PsiAnnotation> result = super.collectProcessedAnnotations(psiClass);
        this.addFieldsAnnotation(result, psiClass, "lombok.EqualsAndHashCode.Include", "lombok.EqualsAndHashCode.Exclude");
        Collection<PsiAnnotation> collection = result;
        if (collection == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(44);
        }
        return collection;
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        PsiClass containingClass;
        if (psiField == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(45);
        }
        if (psiAnnotation == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(46);
        }
        if (null != (containingClass = psiField.getContainingClass())) {
            String psiFieldName = psiField.getName();
            if (EqualsAndHashCodeToStringHandler.filterMembers(containingClass, psiAnnotation, true, INCLUDE_ANNOTATION_METHOD, null, "lombok.EqualsAndHashCode.Include", "lombok.EqualsAndHashCode.Exclude").stream().map(EqualsAndHashCodeToStringHandler.MemberInfo::getName).anyMatch(psiFieldName::equals)) {
                return LombokPsiElementUsage.READ;
            }
        }
        return LombokPsiElementUsage.NONE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 27, 28, 31, 34, 39, 42, 44 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 20: 
            case 23: 
            case 26: 
            case 30: 
            case 33: 
            case 35: 
            case 38: 
            case 41: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemSink";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 39: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/EqualsAndHashCodeProcessor";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lightParameter";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/EqualsAndHashCodeProcessor";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createEqualsMethod";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "collectEqualsAndHashcodeMemberInfo";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createHashCodeMethod";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createCanEqualMethod";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createEqualsBlockString";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "createHashcodeBlockString";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProcessedAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNamesOfPossibleGeneratedElements";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "validateCallSuperParamIntern";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "validateCallSuperParamExtern";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "validateCallSuperParam";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "validateAnnotationOnRightType";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "validateExistingMethods";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "hasOneOfMethodsDefined";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "generatePsiElements";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createEqualAndHashCode";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "shouldGenerateCanEqual";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createEqualsMethod";
                break;
            }
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 39: 
            case 42: 
            case 44: {
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createHashCodeMethod";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createCanEqualMethod";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "copyOnXAnnotationsForFirstParam";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createEqualsBlockString";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createHashcodeBlockString";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "collectProcessedAnnotations";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 27, 28, 31, 34, 39, 42, 44 -> new IllegalStateException(string);
        };
    }
}

