/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GrRemoveModifierFix;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\"\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0000\u001a,\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u00022\b\b\u0001\u0010\u0010\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0000\u001a0\u0010\u0011\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\u0012\u001a\u00020\u00022\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0001H\u0000\u001a:\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u001a\u0014\u0010 \u001a\u00020!*\u00020\"2\u0006\u0010#\u001a\u00020\u001bH\u0000\"\u001c\u0010\u0000\u001a\r\u0012\t\u0012\u00070\u0002\u00a2\u0006\u0002\b\u00030\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006$"}, d2={"VARIABLE_MODIFIERS", "", "", "Lcom/intellij/openapi/util/NlsSafe;", "getVARIABLE_MODIFIERS", "()Ljava/util/Set;", "checkVariableModifiers", "", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "variableDeclaration", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrVariableDeclaration;", "checkModifierIsNotAllowed", "modifierList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/GrModifierList;", "modifier", "message", "checkTupleVariableIsNotAllowed", "errorMessage", "allowedTokens", "Lcom/intellij/psi/tree/IElementType;", "registerLocalFix", "Lcom/intellij/lang/annotation/AnnotationBuilder;", "annotationBuilder", "fix", "Lcom/intellij/codeInspection/LocalQuickFix;", "place", "Lcom/intellij/psi/PsiElement;", "problemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "range", "Lcom/intellij/openapi/util/TextRange;", "createDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "Lcom/intellij/lang/annotation/Annotation;", "element", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\norg/jetbrains/plugins/groovy/annotator/UtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public final class UtilKt {
    @NotNull
    private static final Set<String> VARIABLE_MODIFIERS;

    @NotNull
    public static final Set<String> getVARIABLE_MODIFIERS() {
        return VARIABLE_MODIFIERS;
    }

    public static final void checkVariableModifiers(@NotNull AnnotationHolder holder, @NotNull GrVariableDeclaration variableDeclaration) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)variableDeclaration, (String)"variableDeclaration");
        GrModifierList grModifierList = variableDeclaration.getModifierList();
        Intrinsics.checkNotNullExpressionValue((Object)grModifierList, (String)"getModifierList(...)");
        GrModifierList modifierList = grModifierList;
        Intrinsics.checkNotNullExpressionValue((Object)GrModifier.GROOVY_MODIFIERS, (String)"GROOVY_MODIFIERS");
        for (String modifier : GrModifier.GROOVY_MODIFIERS) {
            if (VARIABLE_MODIFIERS.contains(modifier)) continue;
            Intrinsics.checkNotNull((Object)modifier);
            Object[] objectArray = new Object[]{modifier};
            String string = GroovyBundle.message("variable.cannot.be", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            UtilKt.checkModifierIsNotAllowed(modifierList, modifier, string, holder);
        }
    }

    public static final void checkModifierIsNotAllowed(@NotNull GrModifierList modifierList, @GrModifier.GrModifierConstant @NotNull String modifier, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)modifierList, (String)"modifierList");
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Object[] objectArray = new Object[]{modifier};
        String string = GroovyBundle.message("modifier.0.not.allowed", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        UtilKt.checkModifierIsNotAllowed(modifierList, modifier, string, holder);
    }

    public static final void checkModifierIsNotAllowed(@NotNull GrModifierList modifierList, @GrModifier.GrModifierConstant @NotNull String modifier, @InspectionMessage @NotNull String message, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)modifierList, (String)"modifierList");
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiElement psiElement = modifierList.getModifier(modifier);
        if (psiElement == null) {
            return;
        }
        PsiElement modifierElement = psiElement;
        AnnotationBuilder annotationBuilder = holder.newAnnotation(HighlightSeverity.ERROR, message).range(modifierElement);
        Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder, (String)"range(...)");
        AnnotationBuilder builder = annotationBuilder;
        Object[] objectArray = new Object[]{modifier};
        GrRemoveModifierFix fix = new GrRemoveModifierFix(modifier, GroovyBundle.message("remove.modifier", objectArray));
        LocalQuickFix localQuickFix = (LocalQuickFix)fix;
        TextRange textRange = modifierElement.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        builder = UtilKt.registerLocalFix(builder, localQuickFix, modifierElement, message, ProblemHighlightType.ERROR, textRange);
        builder.create();
    }

    public static final void checkTupleVariableIsNotAllowed(@NotNull GrVariableDeclaration variableDeclaration, @NotNull AnnotationHolder holder, @InspectionMessage @NotNull String errorMessage, @NotNull Set<? extends IElementType> allowedTokens) {
        Intrinsics.checkNotNullParameter((Object)variableDeclaration, (String)"variableDeclaration");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter(allowedTokens, (String)"allowedTokens");
        if (!variableDeclaration.isTuple()) {
            return;
        }
        GrModifierList grModifierList = variableDeclaration.getModifierList();
        Intrinsics.checkNotNullExpressionValue((Object)grModifierList, (String)"getModifierList(...)");
        GrModifierList list = grModifierList;
        PsiElement last = PsiUtil.skipWhitespacesAndComments(list.getLastChild(), false);
        if (last != null) {
            IElementType iElementType = last.getNode().getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
            IElementType type = iElementType;
            if (!allowedTokens.contains(type)) {
                holder.newAnnotation(HighlightSeverity.ERROR, errorMessage).range((PsiElement)list).create();
            }
        } else {
            holder.newAnnotation(HighlightSeverity.ERROR, errorMessage).range((PsiElement)list).create();
        }
    }

    @NotNull
    public static final AnnotationBuilder registerLocalFix(@NotNull AnnotationBuilder annotationBuilder, @NotNull LocalQuickFix fix, @NotNull PsiElement place, @InspectionMessage @NotNull String message, @NotNull ProblemHighlightType problemHighlightType, @NotNull TextRange range) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)annotationBuilder, (String)"annotationBuilder");
        Intrinsics.checkNotNullParameter((Object)fix, (String)"fix");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)problemHighlightType, (String)"problemHighlightType");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        InspectionManager manager = InspectionManager.getInstance((Project)place.getProject());
        boolean bl2 = bl = !place.getTextRange().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = place.getContainingFile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = string;
            throw new AssertionError((Object)string2);
        }
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor(place, place, message, problemHighlightType, true, new LocalQuickFix[0]);
        Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
        ProblemDescriptor descriptor = problemDescriptor;
        AnnotationBuilder annotationBuilder2 = annotationBuilder.newLocalQuickFix(fix, descriptor).range(range).registerFix();
        Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder2, (String)"registerFix(...)");
        return annotationBuilder2;
    }

    @NotNull
    public static final ProblemDescriptor createDescriptor(@NotNull Annotation $this$createDescriptor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)$this$createDescriptor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ProblemDescriptor problemDescriptor = InspectionManager.getInstance((Project)element.getProject()).createProblemDescriptor(element, element, $this$createDescriptor.getMessage(), $this$createDescriptor.getHighlightType(), true, new LocalQuickFix[0]);
        Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
        return problemDescriptor;
    }

    static {
        Object[] objectArray = new String[]{"def", "final"};
        VARIABLE_MODIFIERS = SetsKt.setOf((Object[])objectArray);
    }
}

