/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.debugger;

import com.intellij.execution.Executor;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.JavaProgramPatcher;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerCoreKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.debugger.GroovyDebuggerSettings;

final class GroovyHotSwapper
extends JavaProgramPatcher {
    private static final Logger LOG = Logger.getInstance(GroovyHotSwapper.class);
    private static final String GROOVY_HOTSWAP_AGENT_PATH = "groovy.hotswap.agent.path";
    private static final Pattern SPRING_LOADED_PATTERN = Pattern.compile("-javaagent:.+springloaded-[^/\\\\]+\\.jar");

    GroovyHotSwapper() {
    }

    private static boolean containsGroovyClasses(Project project) {
        return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> CachedValueProvider.Result.create((Object)FileTypeIndex.containsFileOfType((FileType)GroovyFileType.GROOVY_FILE_TYPE, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static boolean hasSpringLoadedReloader(JavaParameters javaParameters) {
        for (String param : javaParameters.getVMParametersList().getParameters()) {
            if (!SPRING_LOADED_PATTERN.matcher(param).matches()) continue;
            return true;
        }
        return false;
    }

    public void patchJavaParameters(Executor executor, RunProfile configuration, JavaParameters javaParameters) {
        String agentPath;
        JdkVersionDetector.JdkVersionInfo info;
        JavaSdkVersion version;
        LanguageLevel level;
        Module module;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!executor.getId().equals("Debug")) {
            return;
        }
        if (!GroovyDebuggerSettings.getInstance().ENABLE_GROOVY_HOTSWAP) {
            return;
        }
        if (GroovyHotSwapper.hasSpringLoadedReloader(javaParameters)) {
            return;
        }
        if (!(configuration instanceof RunConfiguration)) {
            return;
        }
        Project project = ((RunConfiguration)configuration).getProject();
        if (project == null) {
            return;
        }
        if (!LanguageLevelProjectExtension.getInstance((Project)project).getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_5)) {
            return;
        }
        if (configuration instanceof ModuleBasedConfiguration && (module = ((ModuleBasedConfiguration)configuration).getConfigurationModule().getModule()) != null && !(level = LanguageLevelUtil.getEffectiveLanguageLevel((Module)module)).isAtLeast(LanguageLevel.JDK_1_5)) {
            return;
        }
        Sdk jdk = javaParameters.getJdk();
        if (jdk != null && (version = JavaSdk.getInstance().getVersion(jdk)) != null && !version.isAtLeast(JavaSdkVersion.JDK_1_8) && jdk.getHomePath() != null && (info = JdkVersionDetector.getInstance().detectJdkVersionInfo(jdk.getHomePath())) != null && info.variant == JdkVersionDetector.Variant.IBM) {
            LOG.info("Due to old IBM JDK peculiarities (IDEA-59070) we don't add Groovy agent when running applications under it");
            return;
        }
        if (!project.isDefault() && GroovyHotSwapper.containsGroovyClasses(project) && (agentPath = GroovyHotSwapper.prepareAgentPath()) != null) {
            javaParameters.getVMParametersList().add("-javaagent:" + agentPath);
        }
    }

    @Nullable
    private static String prepareAgentPath() {
        String agentJarPath = GroovyHotSwapper.getAgentJarPath();
        if (agentJarPath == null) {
            return null;
        }
        if (!Files.isRegularFile(Path.of(agentJarPath, new String[0]), new LinkOption[0])) {
            LOG.error("Groovy hotswap agent is not found at: " + agentJarPath);
            return null;
        }
        String agentPath = JavaExecutionUtil.handleSpacesInAgentPath((String)agentJarPath, (String)"groovyHotSwap", (String)GROOVY_HOTSWAP_AGENT_PATH);
        if (agentPath == null) {
            LOG.error("Unable to handle spaces in path for groovy hotswap agent: " + agentJarPath);
            return null;
        }
        if (!Files.isRegularFile(Path.of(agentPath, new String[0]), new LinkOption[0])) {
            LOG.error("Groovy hotswap agent is not found (after handling spaces) at: " + agentPath + ". original jar path (existing): " + agentJarPath);
            return null;
        }
        return agentPath;
    }

    @Nullable
    private static String getAgentJarPath() {
        if (PluginManagerCore.isRunningFromSources()) {
            return Path.of(PathManager.getCommunityHomePath(), "plugins", "groovy", "hotswap", "gragent.jar").toString();
        }
        Path groovyPluginDist = PluginManagerCoreKt.getPluginDistDirByClass(GroovyHotSwapper.class);
        if (groovyPluginDist == null) {
            LOG.error("Failed to find groovy plugin dist directory");
            return null;
        }
        return groovyPluginDist.resolve("lib").resolve("agent").resolve("gragent.jar").toString();
    }
}

