/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style.inference.driver;

import com.intellij.lang.jvm.JvmParameter;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.style.inference.InferenceProcessUtilKt;
import org.jetbrains.plugins.groovy.intentions.style.inference.SignatureInferenceContext;
import org.jetbrains.plugins.groovy.intentions.style.inference.driver.BoundConstraint;
import org.jetbrains.plugins.groovy.intentions.style.inference.driver.InferenceDriverUtilKt;
import org.jetbrains.plugins.groovy.intentions.style.inference.driver.TypeUsageInformation;
import org.jetbrains.plugins.groovy.intentions.style.inference.driver.TypeUsageInformationBuilder;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyReference;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrOperatorExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCandidate;
import org.jetbrains.plugins.groovy.lang.resolve.api.PsiCallParameter;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.InferenceKt;
import org.jetbrains.plugins.groovy.lang.resolve.references.GrIndexPropertyReference;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 O2\u00020\u0001:\u0001OB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\b\u0002\u0010\u0012\u001a\f\u0012\u0004\u0012\u00020\u00140\u0013j\u0002`\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001a\u0010\u001f\u001a\u0010\u0012\f\u0012\n !*\u0004\u0018\u00010\u001b0\u001b0 *\u00020\u001bH\u0002J\u0018\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001bH\u0002J%\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0&2\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001bH\u0082\u0010J\u0010\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020/H\u0002J\u0018\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020/2\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u00102\u001a\b\u0012\u0004\u0012\u0002030\u00132\b\u0010+\u001a\u0004\u0018\u000103H\u0002J\u0010\u00104\u001a\u00020\u000f2\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020\u000f2\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020\u000f2\u0006\u0010+\u001a\u000203H\u0016J&\u0010>\u001a\f\u0012\u0004\u0012\u00020\u00140\u0013j\u0002`\u00152\b\u0010+\u001a\u0004\u0018\u00010?2\b\u0010@\u001a\u0004\u0018\u00010AH\u0002J\u001c\u0010B\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020\u00032\f\u0010D\u001a\b\u0012\u0004\u0012\u00020F0EJ\b\u0010G\u001a\u00020\u000fH\u0002J\u0018\u0010H\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010I\u001a\u00020JH\u0002J\u000e\u0010K\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010L\u001a\u00020\u000f2\u0006\u0010+\u001a\u000203H\u0002J\u0006\u0010M\u001a\u00020NR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006P"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/style/inference/driver/RecursiveMethodAnalyzer;", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyRecursiveElementVisitor;", "method", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "signatureInferenceContext", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/SignatureInferenceContext;", "<init>", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;Lorg/jetbrains/plugins/groovy/intentions/style/inference/SignatureInferenceContext;)V", "getMethod", "()Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "builder", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/driver/TypeUsageInformationBuilder;", "getBuilder", "()Lorg/jetbrains/plugins/groovy/intentions/style/inference/driver/TypeUsageInformationBuilder;", "processMethod", "", "result", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "processReceiverConstraints", "candidate", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyMethodCandidate;", "processArgumentConstraints", "parameterType", "Lcom/intellij/psi/PsiType;", "argument", "resolveResult", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyMethodResult;", "flattenComponents", "", "kotlin.jvm.PlatformType", "processRequiredParameters", "lowerType", "upperType", "coherentDeepComponentType", "Lkotlin/Pair;", "visitCallExpression", "callExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "visitAssignmentExpression", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrAssignmentExpression;", "processSetter", "setterReference", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyReference;", "processFieldAssignment", "fieldReference", "unwrapElvisExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "visitReturnStatement", "returnStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/branch/GrReturnStatement;", "visitVariableDeclaration", "variableDeclaration", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrVariableDeclaration;", "visitForInClause", "forInClause", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/clauses/GrForInClause;", "visitExpression", "extractArguments", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrIndexProperty;", "reference", "Lorg/jetbrains/plugins/groovy/lang/resolve/references/GrIndexPropertyReference;", "visitOuterCalls", "originalMethod", "calls", "", "Lcom/intellij/psi/PsiReference;", "processCallInitializers", "processOuterArgument", "parameter", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/params/GrParameter;", "runAnalyzer", "processExitExpression", "buildUsageInformation", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/driver/TypeUsageInformation;", "Companion", "intellij.groovy"})
@SourceDebugExtension(value={"SMAP\nRecursiveMethodAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecursiveMethodAnalyzer.kt\norg/jetbrains/plugins/groovy/intentions/style/inference/driver/RecursiveMethodAnalyzer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,390:1\n1#2:391\n1#2:403\n1#2:435\n12033#3,10:392\n14060#3:402\n14061#3:404\n12043#3:405\n11705#3:420\n12052#3,3:421\n1391#4:406\n1480#4,5:407\n1391#4:412\n1480#4,5:413\n1642#4,10:424\n1915#4:434\n1916#4:436\n1652#4:437\n1915#4,2:438\n37#5,2:418\n66#6,2:440\n*S KotlinDebug\n*F\n+ 1 RecursiveMethodAnalyzer.kt\norg/jetbrains/plugins/groovy/intentions/style/inference/driver/RecursiveMethodAnalyzer\n*L\n53#1:403\n294#1:435\n53#1:392,10\n53#1:402\n53#1:404\n53#1:405\n292#1:420\n292#1:421,3\n68#1:406\n68#1:407,5\n223#1:412\n223#1:413,5\n294#1:424,10\n294#1:434\n294#1:436\n294#1:437\n297#1:438,2\n289#1:418,2\n381#1:440,2\n*E\n"})
public final class RecursiveMethodAnalyzer
extends GroovyRecursiveElementVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GrMethod method;
    @NotNull
    private final TypeUsageInformationBuilder builder;

    public RecursiveMethodAnalyzer(@NotNull GrMethod method, @NotNull SignatureInferenceContext signatureInferenceContext) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)signatureInferenceContext, (String)"signatureInferenceContext");
        this.method = method;
        this.builder = new TypeUsageInformationBuilder(this.method, signatureInferenceContext);
    }

    @NotNull
    public final GrMethod getMethod() {
        return this.method;
    }

    @NotNull
    public final TypeUsageInformationBuilder getBuilder() {
        return this.builder;
    }

    /*
     * WARNING - void declaration
     */
    private final void processMethod(GroovyResolveResult result2, List<? extends Argument> arguments2) {
        GroovyMethodResult groovyMethodResult = result2 instanceof GroovyMethodResult ? (GroovyMethodResult)result2 : null;
        if (groovyMethodResult == null) {
            return;
        }
        GroovyMethodResult methodResult = groovyMethodResult;
        GroovyMethodCandidate candidate = methodResult.getCandidate();
        if (candidate != null) {
            this.processReceiverConstraints(candidate);
            ArgumentMapping<PsiCallParameter> argumentMapping = candidate.getArgumentMapping();
            if (argumentMapping == null || (argumentMapping = argumentMapping.getExpectedTypes()) == null) {
                return;
            }
            ArgumentMapping<PsiCallParameter> expectedTypes = argumentMapping;
            Iterator iterator2 = expectedTypes.iterator();
            while (iterator2.hasNext()) {
                Pair pair = (Pair)iterator2.next();
                PsiType type = (PsiType)pair.component1();
                Argument argument = (Argument)pair.component2();
                this.processArgumentConstraints(type, argument, methodResult);
            }
        } else {
            List list3;
            void $this$mapNotNullTo$iv$iv;
            PsiMethod $this$processMethod_u24lambda_u240 = methodResult.getElement();
            boolean bl = false;
            PsiMethod psiMethod = $this$processMethod_u24lambda_u240 instanceof GrGdkMethod ? ((GrGdkMethod)$this$processMethod_u24lambda_u240).getStaticMethod() : $this$processMethod_u24lambda_u240;
            Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"run(...)");
            PsiMethod method = psiMethod;
            JvmParameter[] jvmParameterArray = method.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)jvmParameterArray, (String)"getParameters(...)");
            Object[] $this$mapNotNull$iv = jvmParameterArray;
            boolean $i$f$mapNotNull = false;
            Object[] objectArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                PsiType it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                boolean bl2 = false;
                JvmParameter it = (JvmParameter)element$iv$iv;
                boolean bl3 = false;
                JvmType jvmType = it.getType();
                if ((jvmType instanceof PsiType ? (PsiType)jvmType : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List it = list3 = (List)destination$iv$iv;
            boolean bl5 = false;
            List list2 = it.size() == arguments2.size() ? list3 : null;
            if (list2 == null) {
                return;
            }
            List parameterTypes = list2;
            for (List list3 : CollectionsKt.zip((Iterable)parameterTypes, (Iterable)arguments2)) {
                PsiType type = (PsiType)list3.component1();
                Argument argument = (Argument)list3.component2();
                this.processArgumentConstraints(type, argument, methodResult);
            }
        }
    }

    static /* synthetic */ void processMethod$default(RecursiveMethodAnalyzer recursiveMethodAnalyzer, GroovyResolveResult groovyResolveResult, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        recursiveMethodAnalyzer.processMethod(groovyResolveResult, list);
    }

    private final void processReceiverConstraints(GroovyMethodCandidate candidate) {
        PsiType psiType = InferenceDriverUtilKt.smartReceiver(candidate);
        if (psiType == null || (psiType = InferenceProcessUtilKt.typeParameter(psiType)) == null) {
            return;
        }
        PsiType receiverTypeParameter = psiType;
        PsiType psiType2 = InferenceDriverUtilKt.smartContainingType(candidate);
        if (psiType2 == null) {
            return;
        }
        PsiType containingType = psiType2;
        this.builder.generateRequiredTypes((PsiTypeParameter)receiverTypeParameter, containingType, BoundConstraint.ContainMarker.UPPER);
    }

    /*
     * WARNING - void declaration
     */
    private final void processArgumentConstraints(PsiType parameterType, Argument argument, GroovyMethodResult resolveResult) {
        Object object;
        if (argument instanceof ExpressionArgument) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = this.unwrapElvisExpression(((ExpressionArgument)argument).getExpression());
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                GrExpression it = (GrExpression)element$iv$iv;
                boolean bl = false;
                SignatureInferenceContext $this$processArgumentConstraints_u24lambda_u240_u240 = this.builder.getSignatureInferenceContext();
                boolean bl2 = false;
                PsiType psiType = $this$processArgumentConstraints_u24lambda_u240_u240.staticType(it);
                Object object2 = psiType;
                if (psiType == null || (object2 = this.flattenComponents((PsiType)object2)) == null) {
                    object2 = CollectionsKt.emptyList();
                }
                Object list$iv$iv = object2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            object = (List)destination$iv$iv;
        } else {
            object = argument.getType();
            if (object == null || (object = this.flattenComponents((PsiType)object)) == null) {
                object = CollectionsKt.emptyList();
            }
        }
        List argumentTypes = CollectionsKt.filterNotNull((Iterable)object);
        Lazy erasureSubstitutor = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> RecursiveMethodAnalyzer.processArgumentConstraints$lambda$1(resolveResult));
        PsiSubstitutor psiSubstitutor = resolveResult.getSubstitutor();
        Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"getSubstitutor(...)");
        PsiSubstitutor callContextSubstitutor = psiSubstitutor;
        for (PsiType argtype : argumentTypes) {
            PsiType $this$processArgumentConstraints_u24lambda_u242 = callContextSubstitutor.substitute(parameterType);
            boolean bl = false;
            PsiType upperType = Intrinsics.areEqual((Object)argtype, (Object)$this$processArgumentConstraints_u24lambda_u242) ? callContextSubstitutor.substitute(((PsiSubstitutor)erasureSubstitutor.getValue()).substitute(parameterType)) : $this$processArgumentConstraints_u24lambda_u242;
            Intrinsics.checkNotNull((Object)upperType);
            this.processRequiredParameters(argtype, upperType);
        }
    }

    private final Iterable<PsiType> flattenComponents(PsiType $this$flattenComponents) {
        Iterable iterable;
        if ($this$flattenComponents instanceof PsiIntersectionType) {
            PsiType[] psiTypeArray = ((PsiIntersectionType)$this$flattenComponents).getConjuncts();
            Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"getConjuncts(...)");
            iterable = ArraysKt.asIterable((Object[])psiTypeArray);
        } else {
            iterable = CollectionsKt.listOf((Object)$this$flattenComponents);
        }
        return iterable;
    }

    private final void processRequiredParameters(PsiType lowerType, PsiType upperType) {
        SignatureInferenceContext $this$processRequiredParameters_u24lambda_u240 = this.builder.getSignatureInferenceContext();
        boolean bl = false;
        Pair<PsiType, PsiType> pair = this.coherentDeepComponentType(lowerType, upperType);
        PsiType unwrappedLowerType = (PsiType)pair.component1();
        PsiType unwrappedUpperType = (PsiType)pair.component2();
        Ref.ObjectRef currentLowerType = new Ref.ObjectRef();
        PsiClassType psiClassType = unwrappedLowerType instanceof PsiClassType ? (PsiClassType)unwrappedLowerType : null;
        if (psiClassType == null) {
            return;
        }
        currentLowerType.element = psiClassType;
        Ref.BooleanRef firstVisit = new Ref.BooleanRef();
        firstVisit.element = true;
        PsiClass psiClass = ((PsiClassType)currentLowerType.element).resolve();
        if (psiClass == null || (psiClass = psiClass.getContext()) == null) {
            return;
        }
        PsiClass context = psiClass;
        unwrappedUpperType.accept((PsiTypeVisitor)new PsiTypeVisitor<Unit>((Ref.ObjectRef<PsiClassType>)currentLowerType, $this$processRequiredParameters_u24lambda_u240, (PsiElement)context, firstVisit, this){
            final /* synthetic */ Ref.ObjectRef<PsiClassType> $currentLowerType;
            final /* synthetic */ SignatureInferenceContext $this_with;
            final /* synthetic */ PsiElement $context;
            final /* synthetic */ Ref.BooleanRef $firstVisit;
            final /* synthetic */ RecursiveMethodAnalyzer this$0;
            {
                this.$currentLowerType = $currentLowerType;
                this.$this_with = $this_with;
                this.$context = $context;
                this.$firstVisit = $firstVisit;
                this.this$0 = $receiver;
            }

            public final void visitClassParameters(PsiClassType currentUpperType) {
                Object v1;
                Object object;
                block4: {
                    Object[] lowerTypeParameter;
                    Intrinsics.checkNotNullParameter((Object)currentUpperType, (String)"currentUpperType");
                    Object object2 = lowerTypeParameter = InferenceProcessUtilKt.typeParameter((PsiType)this.$currentLowerType.element);
                    if (lowerTypeParameter == null || (object2 = object2.getExtendsListTypes()) == null || (object2 = ArraysKt.asList((Object[])object2)) == null) {
                        object2 = CollectionsKt.listOf((Object)this.$currentLowerType.element);
                    }
                    Object candidateLowerTypes = object2;
                    Iterable iterable = (Iterable)candidateLowerTypes;
                    PsiElement psiElement = this.$context;
                    object = iterable;
                    Iterator<T> iterator2 = object.iterator();
                    while (iterator2.hasNext()) {
                        T t = iterator2.next();
                        PsiClassType lowerType = (PsiClassType)t;
                        boolean bl = false;
                        if (!(TypesUtil.canAssign((PsiType)currentUpperType.rawType(), (PsiType)lowerType.rawType(), psiElement, GrTypeConverter.Position.METHOD_PARAMETER) == ConversionResult.OK)) continue;
                        v1 = t;
                        break block4;
                    }
                    v1 = null;
                }
                PsiClassType psiClassType = v1;
                if (psiClassType == null) {
                    return;
                }
                PsiClassType matchedLowerBound = psiClassType;
                int n = currentUpperType.getParameters().length;
                for (int classParameterIndex = 0; classParameterIndex < n; ++classParameterIndex) {
                    object = ArraysKt.getOrNull((Object[])this.$this_with.getTypeArguments(matchedLowerBound), (int)classParameterIndex);
                    if ((object instanceof PsiClassType ? (PsiClassType)object : null) == null) continue;
                    this.$currentLowerType.element = this.$currentLowerType.element;
                    PsiType psiType = this.$this_with.getTypeArguments(currentUpperType)[classParameterIndex];
                    if (psiType == null) continue;
                    Unit cfr_ignored_0 = (Unit)psiType.accept((PsiTypeVisitor)this);
                }
            }

            public void visitClassType(PsiClassType classType) {
                Intrinsics.checkNotNullParameter((Object)classType, (String)"classType");
                PsiTypeParameter lowerTypeParameter = InferenceProcessUtilKt.typeParameter((PsiType)this.$currentLowerType.element);
                PsiTypeParameter upperTypeParameter = InferenceProcessUtilKt.typeParameter((PsiType)classType);
                if (this.$firstVisit.element) {
                    if (!Intrinsics.areEqual((Object)classType, (Object)InferenceDriverUtilKt.getJavaLangObject(this.$context)) && lowerTypeParameter != null) {
                        this.this$0.getBuilder().generateRequiredTypes(lowerTypeParameter, (PsiType)classType, BoundConstraint.ContainMarker.UPPER);
                    }
                    if (upperTypeParameter != null) {
                        this.this$0.getBuilder().generateRequiredTypes(upperTypeParameter, (PsiType)this.$currentLowerType.element, BoundConstraint.ContainMarker.LOWER);
                    }
                } else {
                    if (lowerTypeParameter != null) {
                        this.this$0.getBuilder().generateRequiredTypes(lowerTypeParameter, (PsiType)classType, BoundConstraint.ContainMarker.EQUAL);
                    }
                    if (upperTypeParameter != null) {
                        this.this$0.getBuilder().generateRequiredTypes(upperTypeParameter, (PsiType)this.$currentLowerType.element, BoundConstraint.ContainMarker.EQUAL);
                    }
                }
                this.$firstVisit.element = false;
                this.visitClassParameters(classType);
                super.visitClassType(classType);
            }

            /*
             * WARNING - void declaration
             */
            public void visitIntersectionType(PsiIntersectionType intersectionType) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)intersectionType, (String)"intersectionType");
                boolean memorizedFirstVisit = this.$firstVisit.element;
                PsiType[] psiTypeArray = intersectionType.getConjuncts();
                Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"getConjuncts(...)");
                Object[] objectArray = psiTypeArray;
                Ref.BooleanRef booleanRef = this.$firstVisit;
                boolean $i$f$forEach = false;
                for (void element$iv : $this$forEach$iv) {
                    PsiType it = (PsiType)element$iv;
                    boolean bl = false;
                    booleanRef.element = memorizedFirstVisit;
                    it.accept((PsiTypeVisitor)this);
                }
            }

            public void visitWildcardType(PsiWildcardType wildcardType) {
                Intrinsics.checkNotNullParameter((Object)wildcardType, (String)"wildcardType");
                PsiType psiType = wildcardType.getBound();
                PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
                if (psiClassType == null) {
                    return;
                }
                PsiClassType bound = psiClassType;
                PsiTypeParameter lowerTypeParameter = InferenceProcessUtilKt.typeParameter((PsiType)this.$currentLowerType.element);
                PsiTypeParameter upperTypeParameter = InferenceProcessUtilKt.typeParameter((PsiType)bound);
                if (wildcardType.isExtends()) {
                    if (lowerTypeParameter != null) {
                        this.this$0.getBuilder().generateRequiredTypes(lowerTypeParameter, (PsiType)bound, BoundConstraint.ContainMarker.UPPER);
                    }
                    if (upperTypeParameter != null) {
                        this.this$0.getBuilder().generateRequiredTypes(upperTypeParameter, (PsiType)this.$currentLowerType.element, BoundConstraint.ContainMarker.LOWER);
                    }
                } else if (wildcardType.isSuper()) {
                    if (lowerTypeParameter != null) {
                        this.this$0.getBuilder().generateRequiredTypes(lowerTypeParameter, (PsiType)bound, BoundConstraint.ContainMarker.LOWER);
                    }
                    if (upperTypeParameter != null) {
                        this.this$0.getBuilder().generateRequiredTypes(upperTypeParameter, (PsiType)this.$currentLowerType.element, BoundConstraint.ContainMarker.UPPER);
                    }
                }
                this.visitClassParameters(bound);
                super.visitWildcardType(wildcardType);
            }

            public void visitPrimitiveType(PsiPrimitiveType primitiveType) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)primitiveType, (String)"primitiveType");
                    PsiClassType psiClassType = primitiveType.getBoxedType(this.$context);
                    if (psiClassType == null) break block0;
                    Unit cfr_ignored_0 = (Unit)psiClassType.accept((PsiTypeVisitor)this);
                }
            }
        });
    }

    private final Pair<PsiType, PsiType> coherentDeepComponentType(PsiType lowerType, PsiType upperType) {
        RecursiveMethodAnalyzer recursiveMethodAnalyzer = this;
        while (lowerType instanceof PsiArrayType && upperType instanceof PsiArrayType) {
            PsiType psiType;
            PsiType psiType2;
            RecursiveMethodAnalyzer recursiveMethodAnalyzer2 = recursiveMethodAnalyzer;
            Intrinsics.checkNotNullExpressionValue((Object)((PsiArrayType)lowerType).getComponentType(), (String)"getComponentType(...)");
            Intrinsics.checkNotNullExpressionValue((Object)((PsiArrayType)upperType).getComponentType(), (String)"getComponentType(...)");
            recursiveMethodAnalyzer = recursiveMethodAnalyzer2;
            lowerType = psiType2;
            upperType = psiType;
        }
        return TuplesKt.to((Object)lowerType, (Object)upperType);
    }

    @Override
    public void visitCallExpression(@NotNull GrCallExpression callExpression) {
        Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
        if (CollectionsKt.contains((Iterable)this.builder.getSignatureInferenceContext().getIgnored(), (Object)callExpression.resolveMethod())) {
            return;
        }
        GroovyResolveResult groovyResolveResult = callExpression.advancedResolve();
        Intrinsics.checkNotNullExpressionValue((Object)groovyResolveResult, (String)"advancedResolve(...)");
        RecursiveMethodAnalyzer.processMethod$default(this, groovyResolveResult, null, 2, null);
        this.builder.addConstrainingExpression(callExpression);
        super.visitCallExpression(callExpression);
    }

    @Override
    public void visitAssignmentExpression(@NotNull GrAssignmentExpression expression) {
        GroovyReference lValueReference;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.builder.addConstrainingExpression(expression);
        GrExpression grExpression = expression.getLValue();
        GrReferenceExpression grReferenceExpression = grExpression instanceof GrReferenceExpression ? (GrReferenceExpression)grExpression : null;
        GroovyReference groovyReference = lValueReference = grReferenceExpression != null ? grReferenceExpression.getLValueReference() : null;
        if (lValueReference != null) {
            this.processSetter(lValueReference);
            this.processFieldAssignment(lValueReference, expression);
        }
        super.visitAssignmentExpression(expression);
    }

    private final void processSetter(GroovyReference setterReference) {
        GroovyResolveResult groovyResolveResult = setterReference.advancedResolve();
        GroovyMethodResult groovyMethodResult = groovyResolveResult instanceof GroovyMethodResult ? (GroovyMethodResult)groovyResolveResult : null;
        if (groovyMethodResult == null) {
            return;
        }
        GroovyMethodResult accessorResult = groovyMethodResult;
        RecursiveMethodAnalyzer.processMethod$default(this, accessorResult, null, 2, null);
    }

    private final void processFieldAssignment(GroovyReference fieldReference, GrAssignmentExpression expression) {
        PsiElement psiElement = fieldReference.resolve();
        GrField grField = psiElement instanceof GrField ? (GrField)psiElement : null;
        if (grField == null) {
            return;
        }
        GrField fieldResult = grField;
        PsiType psiType = fieldResult.getType();
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
        PsiType leftType = psiType;
        List<GrExpression> rightExpressions = this.unwrapElvisExpression(expression.getRValue());
        for (GrExpression rightExpression : rightExpressions) {
            PsiType rightType;
            SignatureInferenceContext $this$processFieldAssignment_u24lambda_u240 = this.builder.getSignatureInferenceContext();
            boolean bl = false;
            if ($this$processFieldAssignment_u24lambda_u240.staticType(rightExpression) == null) continue;
            this.processRequiredParameters(rightType, leftType);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<GrExpression> unwrapElvisExpression(GrExpression expression) {
        List list;
        GrExpression grExpression = expression;
        if (grExpression == null) {
            list = CollectionsKt.emptyList();
        } else if (grExpression instanceof GrConditionalExpression) {
            void $this$flatMapTo$iv$iv;
            Object[] objectArray = new GrExpression[]{((GrConditionalExpression)expression).getThenBranch(), ((GrConditionalExpression)expression).getElseBranch()};
            Iterable $this$flatMap$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                GrExpression it = (GrExpression)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = this.unwrapElvisExpression(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.listOf((Object)expression);
        }
        return list;
    }

    @Override
    public void visitReturnStatement(@NotNull GrReturnStatement returnStatement) {
        Intrinsics.checkNotNullParameter((Object)returnStatement, (String)"returnStatement");
        GrExpression grExpression = returnStatement.getReturnValue();
        if (grExpression != null) {
            GrExpression grExpression2;
            GrExpression $this$visitReturnStatement_u24lambda_u240 = grExpression2 = grExpression;
            boolean bl = false;
            this.processExitExpression($this$visitReturnStatement_u24lambda_u240);
        }
        super.visitReturnStatement(returnStatement);
    }

    @Override
    public void visitVariableDeclaration(@NotNull GrVariableDeclaration variableDeclaration) {
        Intrinsics.checkNotNullParameter((Object)variableDeclaration, (String)"variableDeclaration");
        GrVariable[] grVariableArray = variableDeclaration.getVariables();
        Intrinsics.checkNotNullExpressionValue((Object)grVariableArray, (String)"getVariables(...)");
        for (GrVariable variable : grVariableArray) {
            PsiType initializerType;
            GrExpression initializer;
            if (variable.getInitializerGroovy() == null) continue;
            SignatureInferenceContext $this$visitVariableDeclaration_u24lambda_u240 = this.builder.getSignatureInferenceContext();
            boolean bl = false;
            if ($this$visitVariableDeclaration_u24lambda_u240.staticType(initializer) == null) continue;
            PsiType psiType = variable.getType();
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
            this.processRequiredParameters(initializerType, psiType);
        }
        super.visitVariableDeclaration(variableDeclaration);
    }

    @Override
    public void visitForInClause(@NotNull GrForInClause forInClause) {
        Intrinsics.checkNotNullParameter((Object)forInClause, (String)"forInClause");
        SignatureInferenceContext $this$visitForInClause_u24lambda_u240 = this.builder.getSignatureInferenceContext();
        boolean bl = false;
        GrExpression grExpression = forInClause.getIteratedExpression();
        PsiType rightType = grExpression != null ? $this$visitForInClause_u24lambda_u240.staticType(grExpression) : null;
        PsiTypeParameter rightTypeParameter = InferenceProcessUtilKt.typeParameter(rightType);
        if (rightType != null && rightTypeParameter != null) {
            GroovyPsiElementFactory $this$visitForInClause_u24lambda_u241 = GroovyPsiElementFactory.getInstance(forInClause.getProject());
            boolean bl2 = false;
            PsiClassType psiClassType = $this$visitForInClause_u24lambda_u241.createTypeByFQClassName("java.lang.Iterable");
            Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"createTypeByFQClassName(...)");
            PsiClassType iterable = psiClassType;
            PsiClassType psiClassType2 = $this$visitForInClause_u24lambda_u241.createTypeByFQClassName("java.util.Map");
            Intrinsics.checkNotNullExpressionValue((Object)psiClassType2, (String)"createTypeByFQClassName(...)");
            PsiClassType map2 = psiClassType2;
            Pair pair = TuplesKt.to((Object)iterable, (Object)map2);
            PsiClassType iterable2 = (PsiClassType)pair.component1();
            PsiClassType map3 = (PsiClassType)pair.component2();
            if (TypesUtil.canAssign((PsiType)map3, rightType, forInClause, GrTypeConverter.Position.METHOD_PARAMETER) == ConversionResult.OK) {
                this.processRequiredParameters(rightType, (PsiType)map3);
            } else {
                this.processRequiredParameters(rightType, (PsiType)iterable2);
            }
        }
        super.visitForInClause(forInClause);
    }

    @Override
    public void visitExpression(@NotNull GrExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        ProgressManager.checkCanceled();
        if (expression instanceof GrOperatorExpression && this.builder.getSignatureInferenceContext().getAllowedToResolveOperators()) {
            GroovyResolveResult operatorMethodResolveResult;
            GroovyCallReference groovyCallReference = ((GrOperatorExpression)expression).getReference();
            GroovyResolveResult groovyResolveResult = operatorMethodResolveResult = groovyCallReference != null ? groovyCallReference.advancedResolve() : null;
            if (operatorMethodResolveResult != null) {
                RecursiveMethodAnalyzer.processMethod$default(this, operatorMethodResolveResult, null, 2, null);
            }
            this.builder.addConstrainingExpression(expression);
        }
        if (expression instanceof GrIndexProperty && this.builder.getSignatureInferenceContext().getAllowedToResolveOperators()) {
            Object object;
            GroovyMethodCallReference groovyMethodCallReference;
            Object object2 = ((GrIndexProperty)expression).getLValueReference();
            if (object2 != null && (object2 = object2.advancedResolve()) != null) {
                Object $this$visitExpression_u24lambda_u240 = object2;
                boolean bl = false;
                groovyMethodCallReference = ((GrIndexProperty)expression).getLValueReference();
                List<Argument> lValueArguments = this.extractArguments((GrIndexProperty)expression, groovyMethodCallReference instanceof GrIndexPropertyReference ? (GrIndexPropertyReference)groovyMethodCallReference : null);
                this.processMethod((GroovyResolveResult)$this$visitExpression_u24lambda_u240, lValueArguments);
            }
            if ((object = ((GrIndexProperty)expression).getRValueReference()) != null && (object = object.advancedResolve()) != null) {
                Object $this$visitExpression_u24lambda_u241 = object;
                boolean bl = false;
                List<Argument> rValueArguments = $this$visitExpression_u24lambda_u241.getElement() instanceof GrGdkMethod ? this.extractArguments((GrIndexProperty)expression, (groovyMethodCallReference = ((GrIndexProperty)expression).getRValueReference()) instanceof GrIndexPropertyReference ? (GrIndexPropertyReference)groovyMethodCallReference : null) : this.extractArguments(null, (groovyMethodCallReference = ((GrIndexProperty)expression).getRValueReference()) instanceof GrIndexPropertyReference ? (GrIndexPropertyReference)groovyMethodCallReference : null);
                this.processMethod((GroovyResolveResult)$this$visitExpression_u24lambda_u241, rValueArguments);
            }
        }
        super.visitExpression(expression);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Argument> extractArguments(GrIndexProperty expression, GrIndexPropertyReference reference) {
        Argument[] argumentArray;
        SpreadBuilder spreadBuilder;
        block6: {
            block5: {
                ExpressionArgument expressionArgument;
                SpreadBuilder spreadBuilder2 = spreadBuilder = new SpreadBuilder(2);
                GrExpression grExpression = expression;
                if (grExpression != null && (grExpression = grExpression.getInvokedExpression()) != null) {
                    void $this$extractArguments_u24lambda_u240;
                    GrExpression grExpression2 = grExpression;
                    SpreadBuilder spreadBuilder3 = spreadBuilder2;
                    boolean bl = false;
                    expressionArgument = new ExpressionArgument((GrExpression)$this$extractArguments_u24lambda_u240);
                    spreadBuilder2 = spreadBuilder3;
                } else {
                    expressionArgument = null;
                }
                spreadBuilder2.add(expressionArgument);
                argumentArray = reference;
                if (argumentArray == null || (argumentArray = argumentArray.getArguments()) == null) break block5;
                Collection $this$toTypedArray$iv = (Collection)argumentArray;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                argumentArray = thisCollection$iv.toArray(new Argument[0]);
                if (argumentArray != null) break block6;
            }
            argumentArray = new Argument[]{};
        }
        spreadBuilder.addSpread((Object)argumentArray);
        return CollectionsKt.listOfNotNull((Object[])spreadBuilder.toArray((Object[])new Argument[spreadBuilder.size()]));
    }

    /*
     * WARNING - void declaration
     */
    public final void visitOuterCalls(@NotNull GrMethod originalMethod, @NotNull Collection<? extends PsiReference> calls) {
        void $this$mapNotNullTo$iv$iv;
        Iterator it;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)originalMethod, (String)"originalMethod");
        Intrinsics.checkNotNullParameter(calls, (String)"calls");
        GrParameter[] grParameterArray = originalMethod.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)grParameterArray, (String)"getParameters(...)");
        Object[] $this$map$iv = grParameterArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            GrParameter grParameter = (GrParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        Iterable iterable = (List)destination$iv$iv;
        GrParameter[] grParameterArray2 = this.method.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)grParameterArray2, (String)"getParameters(...)");
        Map mapping = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)iterable, (Object[])grParameterArray2));
        this.processCallInitializers();
        Iterable $this$mapNotNull$iv = calls;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Object destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            PsiElement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            PsiReference it2 = (PsiReference)element$iv$iv;
            boolean bl2 = false;
            if (it2.getElement().getParent() == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        for (PsiElement outerCall : (List)destination$iv$iv2) {
            ArgumentMapping<PsiCallParameter> argumentMapping;
            Object candidate;
            destination$iv$iv2 = InferenceProcessUtilKt.properResolve(outerCall);
            Object object = destination$iv$iv2 instanceof GroovyMethodResult ? (GroovyMethodResult)destination$iv$iv2 : null;
            if (object == null) continue;
            if ((object = object.getCandidate()) == null || (candidate = object).getArgumentMapping() == null) continue;
            Iterable $this$forEach$iv = argumentMapping.getArguments();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                GrParameter param;
                Argument argument = (Argument)element$iv;
                boolean bl = false;
                Map map2 = mapping;
                PsiCallParameter psiCallParameter = argumentMapping.targetParameter(argument);
                if ((GrParameter)map2.get(psiCallParameter != null && (psiCallParameter = psiCallParameter.getPsi()) != null ? psiCallParameter.getName() : null) == null) continue;
                this.processOuterArgument(argument, param);
            }
        }
    }

    private final void processCallInitializers() {
        GrParameter[] grParameterArray = this.method.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)grParameterArray, (String)"getParameters(...)");
        for (GrParameter parameter : grParameterArray) {
            GrExpression grExpression = parameter.getInitializerGroovy();
            if (grExpression == null || (grExpression = grExpression.getType()) == null) continue;
            GrExpression initializerType = grExpression;
            PsiType psiType = parameter.getType();
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
            Companion.induceDeepConstraints(psiType, (PsiType)initializerType, this.builder, this.method, BoundConstraint.ContainMarker.INHABIT);
        }
    }

    private final void processOuterArgument(Argument argument, GrParameter parameter) {
        PsiType psiType;
        if (argument instanceof ExpressionArgument) {
            SignatureInferenceContext $this$processOuterArgument_u24lambda_u240 = this.builder.getSignatureInferenceContext();
            boolean bl = false;
            psiType = $this$processOuterArgument_u24lambda_u240.staticType(((ExpressionArgument)argument).getExpression());
        } else {
            psiType = argument.getType();
        }
        if (psiType == null) {
            return;
        }
        PsiType argtype = psiType;
        PsiTypeParameter psiTypeParameter = InferenceProcessUtilKt.typeParameter(argtype);
        if (psiTypeParameter == null || (psiTypeParameter = InferenceProcessUtilKt.upperBound(psiTypeParameter)) == null) {
            psiTypeParameter = argtype;
        }
        PsiTypeParameter correctArgumentType = psiTypeParameter;
        PsiType psiType2 = parameter.getType();
        Intrinsics.checkNotNullExpressionValue((Object)psiType2, (String)"getType(...)");
        Companion.induceDeepConstraints(psiType2, (PsiType)correctArgumentType, this.builder, this.method, BoundConstraint.ContainMarker.INHABIT);
    }

    public final void runAnalyzer(@NotNull GrMethod method) {
        block1: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            method.accept(this);
            Object object2 = method.getBlock();
            if (object2 == null || (object2 = object2.getStatements()) == null || (object2 = (GrStatement)ArraysKt.lastOrNull((Object[])object2)) == null) break block1;
            Object $this$runAnalyzer_u24lambda_u240 = object = object2;
            boolean bl = false;
            GrExpression grExpression = $this$runAnalyzer_u24lambda_u240 instanceof GrExpression ? (GrExpression)$this$runAnalyzer_u24lambda_u240 : null;
            if (grExpression != null) {
                this.processExitExpression(grExpression);
            }
        }
    }

    private final void processExitExpression(GrExpression expression) {
        block4: {
            GrMethod grMethod;
            block6: {
                block5: {
                    GrMethod grMethod2;
                    if (!this.builder.getSignatureInferenceContext().getAllowedToProcessReturnType()) break block4;
                    PsiElement $this$parentOfType_u24default$iv = expression;
                    boolean withSelf$iv = false;
                    boolean $i$f$parentOfType = false;
                    grMethod = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, GrMethod.class, (boolean)true);
                    if (grMethod == null || (grMethod = grMethod.getReturnType()) == null) break block5;
                    GrMethod it = grMethod2 = grMethod;
                    boolean bl = false;
                    grMethod = !Intrinsics.areEqual((Object)it, (Object)PsiTypes.nullType()) && !Intrinsics.areEqual((Object)it, (Object)PsiTypes.voidType()) ? grMethod2 : null;
                    if (grMethod != null) break block6;
                }
                return;
            }
            GrMethod returnType = grMethod;
            this.builder.addConstrainingExpression(expression);
            PsiTypeParameter psiTypeParameter = InferenceProcessUtilKt.typeParameter(expression.getType());
            if (psiTypeParameter == null) {
                return;
            }
            PsiTypeParameter typeParameter = psiTypeParameter;
            this.builder.generateRequiredTypes(typeParameter, (PsiType)returnType, BoundConstraint.ContainMarker.UPPER);
        }
    }

    @NotNull
    public final TypeUsageInformation buildUsageInformation() {
        return this.builder.build();
    }

    private static final PsiSubstitutor processArgumentConstraints$lambda$1(GroovyMethodResult $resolveResult) {
        PsiMethod psiMethod = $resolveResult.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"getElement(...)");
        return Companion.methodTypeParametersErasureSubstitutor(psiMethod);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/style/inference/driver/RecursiveMethodAnalyzer$Companion;", "", "<init>", "()V", "induceDeepConstraints", "", "leftType", "Lcom/intellij/psi/PsiType;", "rightType", "builder", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/driver/TypeUsageInformationBuilder;", "method", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "targetMarker", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/driver/BoundConstraint$ContainMarker;", "methodTypeParametersErasureSubstitutor", "Lcom/intellij/psi/PsiSubstitutor;", "Lcom/intellij/psi/PsiMethod;", "intellij.groovy"})
    @SourceDebugExtension(value={"SMAP\nRecursiveMethodAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecursiveMethodAnalyzer.kt\norg/jetbrains/plugins/groovy/intentions/style/inference/driver/RecursiveMethodAnalyzer$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,390:1\n11705#2:391\n12052#2,3:392\n11705#2:397\n12052#2,3:398\n11705#2:403\n12052#2,3:404\n37#3,2:395\n37#3,2:401\n37#3,2:407\n*S KotlinDebug\n*F\n+ 1 RecursiveMethodAnalyzer.kt\norg/jetbrains/plugins/groovy/intentions/style/inference/driver/RecursiveMethodAnalyzer$Companion\n*L\n350#1:391\n350#1:392,3\n366#1:397\n366#1:398,3\n368#1:403\n368#1:404,3\n357#1:395,2\n367#1:401,2\n369#1:407,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final void induceDeepConstraints(@NotNull PsiType leftType, @NotNull PsiType rightType, @NotNull TypeUsageInformationBuilder builder, @NotNull GrMethod method, @NotNull BoundConstraint.ContainMarker targetMarker) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            PsiType[] rightTypeArguments;
            Object[] objectArray;
            PsiTypeParameter rightBound;
            PsiTypeParameter psiTypeParameter;
            PsiTypeParameter leftBound;
            PsiTypeParameter psiTypeParameter2;
            Intrinsics.checkNotNullParameter((Object)leftType, (String)"leftType");
            Intrinsics.checkNotNullParameter((Object)rightType, (String)"rightType");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)((Object)targetMarker), (String)"targetMarker");
            SignatureInferenceContext $this$induceDeepConstraints_u24lambda_u240 = builder.getSignatureInferenceContext();
            boolean bl = false;
            PsiTypeParameter[] psiTypeParameterArray = method.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)psiTypeParameterArray, (String)"getTypeParameters(...)");
            Set variableParameters = ArraysKt.toSet((Object[])psiTypeParameterArray);
            PsiTypeParameter leftTypeParameter = InferenceProcessUtilKt.typeParameter(leftType);
            PsiTypeParameter rightTypeParameter = InferenceProcessUtilKt.typeParameter(rightType);
            if (leftTypeParameter != null && rightTypeParameter != null && variableParameters.contains(rightTypeParameter)) {
                TypeUsageInformationBuilder $this$induceDeepConstraints_u24lambda_u240_u240 = builder;
                boolean bl2 = false;
                $this$induceDeepConstraints_u24lambda_u240_u240.addDependentType(leftTypeParameter);
                $this$induceDeepConstraints_u24lambda_u240_u240.addDependentType(rightTypeParameter);
                PsiClassType[] psiClassTypeArray = rightTypeParameter.getExtendsListTypes();
                Intrinsics.checkNotNullExpressionValue((Object)psiClassTypeArray, (String)"getExtendsListTypes(...)");
                ArraysKt.firstOrNull((Object[])psiClassTypeArray);
            } else if (leftTypeParameter != null) {
                builder.generateRequiredTypes(leftTypeParameter, rightType, targetMarker);
            }
            if (leftType instanceof PsiArrayType && rightType instanceof PsiArrayType) {
                PsiType psiType = ((PsiArrayType)leftType).getComponentType();
                Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getComponentType(...)");
                PsiType psiType2 = ((PsiArrayType)rightType).getComponentType();
                Intrinsics.checkNotNullExpressionValue((Object)psiType2, (String)"getComponentType(...)");
                Companion.induceDeepConstraints(psiType, psiType2, builder, method, targetMarker);
            }
            if ((psiTypeParameter2 = leftTypeParameter) == null || (psiTypeParameter2 = InferenceProcessUtilKt.upperBound(psiTypeParameter2)) == null) {
                psiTypeParameter2 = leftBound = leftType;
            }
            if ((psiTypeParameter = rightTypeParameter) == null || (psiTypeParameter = InferenceProcessUtilKt.upperBound(psiTypeParameter)) == null) {
                psiTypeParameter = rightBound = rightType;
            }
            if ((objectArray = leftBound instanceof PsiClassType ? (Object[])leftBound : null) == null || (objectArray = $this$induceDeepConstraints_u24lambda_u240.getTypeArguments((PsiClassType)objectArray)) == null) {
                return;
            }
            Object[] leftTypeArguments = objectArray;
            PsiType[] psiTypeArray = rightBound instanceof PsiClassType ? (PsiType[])rightBound : null;
            if (psiTypeArray == null || (psiTypeArray = $this$induceDeepConstraints_u24lambda_u240.getTypeArguments((PsiClassType)psiTypeArray)) == null) {
                return;
            }
            Object $this$map$iv = rightTypeArguments = psiTypeArray;
            boolean $i$f$map = false;
            PsiType[] psiTypeArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((PsiType[])$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                Object object;
                void it;
                void item$iv$iv;
                void var23_25 = item$iv$iv = $this$mapTo$iv$iv[j];
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                PsiTypeParameter typeParameter = InferenceProcessUtilKt.typeParameter((PsiType)it);
                if (it == null) {
                    PsiWildcardType psiWildcardType = PsiWildcardType.createUnbounded((PsiManager)method.getManager());
                    Intrinsics.checkNotNullExpressionValue((Object)psiWildcardType, (String)"createUnbounded(...)");
                    object = (PsiType)psiWildcardType;
                } else {
                    object = typeParameter != null && !variableParameters.contains(typeParameter) ? InferenceProcessUtilKt.upperBound(typeParameter) : it;
                }
                collection.add(object);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Object[] rangedRightTypeArguments = thisCollection$iv.toArray(new PsiType[0]);
            for (Pair pair : ArraysKt.zip((Object[])leftTypeArguments, (Object[])rangedRightTypeArguments)) {
                PsiType leftTypeArgument = (PsiType)pair.component1();
                PsiType rightTypeArgument = (PsiType)pair.component2();
                if (leftTypeArgument == null) continue;
                Companion.induceDeepConstraints(leftTypeArgument, rightTypeArgument, builder, method, targetMarker);
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final PsiSubstitutor methodTypeParametersErasureSubstitutor(@NotNull PsiMethod method) {
            void $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            PsiTypeParameter[] typeParameters;
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            PsiTypeParameter[] psiTypeParameterArray = method.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)psiTypeParameterArray, (String)"getTypeParameters(...)");
            PsiTypeParameter[] $this$map$iv = typeParameters = psiTypeParameterArray;
            boolean $i$f$map = false;
            PsiTypeParameter[] psiTypeParameterArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo22 = false;
            int n = ((void)$this$mapTo$iv$iv2).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var12_18 = item$iv$iv = $this$mapTo$iv$iv2[j];
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(InferenceProcessUtilKt.upperBound((PsiTypeParameter)it));
            }
            List bounds = (List)destination$iv$iv;
            PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"EMPTY");
            Collection $this$toTypedArray$iv = bounds;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            PsiSubstitutor draftSubstitutor = InferenceKt.putAll(psiSubstitutor, typeParameters, thisCollection$iv.toArray(new PsiType[0]));
            PsiTypeParameter[] $this$map$iv2 = typeParameters;
            boolean $i$f$map2 = false;
            PsiTypeParameter[] $i$f$mapTo22 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.length);
            boolean $i$f$mapTo = false;
            int n2 = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n2; ++j) {
                void it;
                void item$iv$iv;
                void var14_24 = item$iv$iv = $this$mapTo$iv$iv[j];
                collection = destination$iv$iv2;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(InferenceProcessUtilKt.recursiveSubstitute$default(draftSubstitutor, (PsiType)InferenceKt.type((PsiClass)it), 0, 2, null));
            }
            List completeBounds = (List)destination$iv$iv2;
            PsiSubstitutor psiSubstitutor2 = PsiSubstitutor.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor2, (String)"EMPTY");
            Collection $this$toTypedArray$iv2 = completeBounds;
            boolean $i$f$toTypedArray2 = false;
            Collection thisCollection$iv2 = $this$toTypedArray$iv2;
            return InferenceKt.putAll(psiSubstitutor2, typeParameters, thisCollection$iv2.toArray(new PsiType[0]));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

