/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceExpressionReferenceKt;
import org.jetbrains.plugins.groovy.lang.resolve.GrReferenceResolveRunner;
import org.jetbrains.plugins.groovy.lang.resolve.GrResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyCachingReference;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolveKind;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0014J*\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H$\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionReference;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyCachingReference;", "Lorg/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl;", "ref", "<init>", "(Lorg/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrReferenceExpressionImpl;)V", "doResolve", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "incomplete", "", "doResolveNonStatic", "buildProcessor", "Lorg/jetbrains/plugins/groovy/lang/resolve/GrResolverProcessor;", "name", "", "place", "Lcom/intellij/psi/PsiElement;", "kinds", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolveKind;", "intellij.groovy.psi"})
public abstract class GrReferenceExpressionReference
extends GroovyCachingReference<GrReferenceExpressionImpl> {
    public GrReferenceExpressionReference(@NotNull GrReferenceExpressionImpl ref2) {
        Intrinsics.checkNotNullParameter((Object)ref2, (String)"ref");
        super((PsiElement)ref2);
    }

    @Override
    @NotNull
    public Collection<GroovyResolveResult> doResolve(boolean incomplete) {
        if (!(!incomplete)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Collection<GroovyResolveResult> collection = ((GrReferenceExpressionImpl)this.getElement()).getStaticReference().resolve(incomplete);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"resolve(...)");
        Collection<GroovyResolveResult> staticResults = collection;
        if (!staticResults.isEmpty()) {
            return staticResults;
        }
        return this.doResolveNonStatic();
    }

    @NotNull
    protected Collection<GroovyResolveResult> doResolveNonStatic() {
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        GrReferenceExpressionImpl expression = (GrReferenceExpressionImpl)psiElement;
        String string = expression.getReferenceName();
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String name = string;
        Set<GroovyResolveKind> kinds = GrReferenceExpressionReferenceKt.resolveKinds(expression);
        GrResolverProcessor<?> processor = this.buildProcessor(name, expression, kinds);
        new GrReferenceResolveRunner(expression, processor).resolveReferenceExpression();
        return processor.getResults();
    }

    @NotNull
    protected abstract GrResolverProcessor<?> buildProcessor(@NotNull String var1, @NotNull PsiElement var2, @NotNull Set<? extends GroovyResolveKind> var3);
}

