/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.GroovyApplicabilityProvider;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.resolve.api.Applicability;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J$\u0010\b\u001a\u0004\u0018\u00010\t2\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/ConstructorMapApplicabilityProvider;", "Lorg/jetbrains/plugins/groovy/extensions/GroovyApplicabilityProvider;", "<init>", "()V", "isConstructor", "", "method", "Lcom/intellij/psi/PsiMethod;", "isApplicable", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Applicability;", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "hasOtherMapConstructor", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nConstructorMapApplicabilityProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstructorMapApplicabilityProvider.kt\norg/jetbrains/plugins/groovy/lang/resolve/ConstructorMapApplicabilityProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,41:1\n3938#2:42\n4474#2,2:43\n*S KotlinDebug\n*F\n+ 1 ConstructorMapApplicabilityProvider.kt\norg/jetbrains/plugins/groovy/lang/resolve/ConstructorMapApplicabilityProvider\n*L\n31#1:42\n31#1:43,2\n*E\n"})
public class ConstructorMapApplicabilityProvider
extends GroovyApplicabilityProvider {
    public boolean isConstructor(@NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return method.isConstructor();
    }

    @Nullable
    public Applicability isApplicable(@NotNull List<? extends Argument> arguments2, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!this.isConstructor(method)) {
            return null;
        }
        PsiParameter[] psiParameterArray = method.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
        PsiParameter[] parameters = psiParameterArray;
        if (!(parameters.length == 0)) {
            return null;
        }
        Argument argument = (Argument)CollectionsKt.singleOrNull(arguments2);
        if (argument == null) {
            return null;
        }
        Argument argument2 = argument;
        PsiType argumentType = argument2.getType();
        return InheritanceUtil.isInheritor((PsiType)argumentType, (String)"java.util.Map") && !this.hasOtherMapConstructor(method) ? Applicability.applicable : Applicability.inapplicable;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasOtherMapConstructor(PsiMethod method) {
        boolean bl;
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        PsiClass containingClass = psiClass;
        PsiMethod[] psiMethodArray = containingClass.getConstructors();
        if (psiMethodArray != null) {
            void $this$filterTo$iv$iv;
            PsiMethod[] $this$filter$iv = psiMethodArray;
            boolean $i$f$filter = false;
            PsiMethod[] psiMethodArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                boolean bl2;
                void element$iv$iv;
                void constructor = element$iv$iv = $this$filterTo$iv$iv[j];
                boolean bl3 = false;
                PsiParameter[] psiParameterArray = constructor.getParameterList().getParameters();
                PsiType psiType = psiParameterArray != null && (psiParameterArray = (PsiParameter[])ArraysKt.singleOrNull((Object[])psiParameterArray)) != null ? psiParameterArray.getType() : null;
                PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
                if (psiClassType == null) {
                    bl2 = false;
                } else {
                    PsiClassType argumentType = psiClassType;
                    boolean isSubtypeOfMap = InheritanceUtil.isInheritor((PsiType)((PsiType)argumentType), (String)"java.util.Map");
                    if (isSubtypeOfMap) {
                        return true;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)GroovyPsiElementFactory.getInstance(method.getProject()).createTypeByFQClassName("java.util.Map"), (String)"createTypeByFQClassName(...)");
                    Object object = argumentType.resolve();
                    if (object == null || (object = object.getQualifiedName()) == null) {
                        bl2 = false;
                    } else {
                        PsiClassType map2;
                        Object argumentQualifiedName = object;
                        return InheritanceUtil.isInheritor((PsiType)((PsiType)map2), (String)argumentQualifiedName);
                    }
                }
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            bl = !((Collection)((List)destination$iv$iv)).isEmpty();
        } else {
            bl = false;
        }
        return bl;
    }
}

