/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.util.LazyKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.CallSignature;
import org.jetbrains.plugins.groovy.lang.resolve.api.PsiCallParameter;
import org.jetbrains.plugins.groovy.lang.resolve.impl.ArgumentsKt;
import org.jetbrains.plugins.groovy.lang.resolve.impl.PsiCallParameterImpl;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ(\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a2\u0010\u0010\u001b\u001a\f\u0012\u0004\u0012\u00020\u001c0\u0011j\u0002`\u001d2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0006\u0010\u001e\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u000b\u0010\rR!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00118VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/impl/MethodSignature;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/CallSignature;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/PsiCallParameter;", "method", "Lcom/intellij/psi/PsiMethod;", "substitutor", "Lcom/intellij/psi/PsiSubstitutor;", "context", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiMethod;Lcom/intellij/psi/PsiSubstitutor;Lcom/intellij/psi/PsiElement;)V", "isVararg", "", "()Z", "isVararg$delegate", "Lkotlin/Lazy;", "parameters", "", "getParameters", "()Ljava/util/List;", "parameters$delegate", "returnType", "Lcom/intellij/psi/PsiType;", "getReturnType", "()Lcom/intellij/psi/PsiType;", "applyTo", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/ArgumentMapping;", "arguments", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "originalMethod", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nMethodSignature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MethodSignature.kt\norg/jetbrains/plugins/groovy/lang/resolve/impl/MethodSignature\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,47:1\n11705#2:48\n12052#2,3:49\n*S KotlinDebug\n*F\n+ 1 MethodSignature.kt\norg/jetbrains/plugins/groovy/lang/resolve/impl/MethodSignature\n*L\n25#1:48\n25#1:49,3\n*E\n"})
public final class MethodSignature
implements CallSignature<PsiCallParameter> {
    @NotNull
    private final PsiMethod method;
    @NotNull
    private final PsiSubstitutor substitutor;
    @NotNull
    private final Lazy isVararg$delegate;
    @NotNull
    private final Lazy parameters$delegate;

    public MethodSignature(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)substitutor, (String)"substitutor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.method = method;
        this.substitutor = substitutor;
        this.isVararg$delegate = LazyKt.lazyPub(() -> MethodSignature.isVararg_delegate$lambda$0(this));
        this.parameters$delegate = LazyKt.lazyPub(() -> MethodSignature.parameters_delegate$lambda$0(this, context));
    }

    @Override
    public boolean isVararg() {
        Lazy lazy = this.isVararg$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    @NotNull
    public List<PsiCallParameter> getParameters() {
        Lazy lazy = this.parameters$delegate;
        return (List)lazy.getValue();
    }

    @Override
    @Nullable
    public PsiType getReturnType() {
        if (this.method.isConstructor()) {
            PsiClass psiClass = this.method.getContainingClass();
            if (psiClass == null) {
                return null;
            }
            PsiClass clazz = psiClass;
            return (PsiType)GroovyPsiElementFactory.getInstance(this.method.getProject()).createType(clazz, PsiSubstitutor.EMPTY);
        }
        return this.substitutor.substitute(PsiUtil.getSmartReturnType(this.method));
    }

    @Override
    @NotNull
    public ArgumentMapping<PsiCallParameter> applyTo(@NotNull List<? extends Argument> arguments2, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return ArgumentsKt.argumentMapping(this, arguments2, context);
    }

    @NotNull
    public final PsiMethod originalMethod() {
        return this.method;
    }

    private static final boolean isVararg_delegate$lambda$0(MethodSignature this$0) {
        return PsiUtilKt.isEffectivelyVarArgs(this$0.method);
    }

    /*
     * WARNING - void declaration
     */
    private static final List parameters_delegate$lambda$0(MethodSignature this$0, PsiElement $context) {
        void $this$mapTo$iv$iv;
        PsiParameter[] psiParameterArray = this$0.method.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
        Object[] $this$map$iv = psiParameterArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void psi;
            PsiParameter psiParameter = (PsiParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)psi);
            collection.add(new PsiCallParameterImpl((PsiParameter)psi, this$0.substitutor, $context));
        }
        return (List)destination$iv$iv;
    }
}

