/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors.inference;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrLiteralClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GrConstraintFormula;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSession;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000f0\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/TypeConstraint;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/GrConstraintFormula;", "leftType", "Lcom/intellij/psi/PsiType;", "rightType", "context", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiType;Lcom/intellij/psi/PsiType;Lcom/intellij/psi/PsiElement;)V", "reduce", "", "session", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/GroovyInferenceSession;", "constraints", "", "Lcom/intellij/psi/impl/source/resolve/graphInference/constraints/ConstraintFormula;", "intellij.groovy.psi"})
public final class TypeConstraint
extends GrConstraintFormula {
    @NotNull
    private final PsiType leftType;
    @Nullable
    private final PsiType rightType;
    @NotNull
    private final PsiElement context;

    public TypeConstraint(@NotNull PsiType leftType, @Nullable PsiType rightType, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)leftType, (String)"leftType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.leftType = leftType;
        this.rightType = rightType;
        this.context = context;
    }

    @Override
    public boolean reduce(@NotNull GroovyInferenceSession session, @NotNull List<? super ConstraintFormula> constraints) {
        PsiType psiType;
        PsiType argType;
        Intrinsics.checkNotNullParameter((Object)((Object)session), (String)"session");
        Intrinsics.checkNotNullParameter(constraints, (String)"constraints");
        PsiType psiType2 = this.rightType;
        if (psiType2 == null) {
            PsiType psiType3 = PsiTypes.nullType();
            psiType2 = psiType3;
            Intrinsics.checkNotNullExpressionValue((Object)psiType3, (String)"nullType(...)");
        }
        if ((argType = psiType2) instanceof GrTupleType && (psiType = TypesUtil.rawWildcard(argType, this.context)) == null) {
            psiType = argType = argType;
        }
        if (!(argType instanceof GrLiteralClassType)) {
            PsiType psiType4 = PsiUtil.captureToplevelWildcards((PsiType)argType, (PsiElement)this.context);
            Intrinsics.checkNotNullExpressionValue((Object)psiType4, (String)"captureToplevelWildcards(...)");
            argType = psiType4;
        }
        if (argType instanceof GrMapType && session.getSkipClosureBlock()) {
            PsiClassType psiClassType = TypesUtil.createTypeByFQClassName("java.util.Map", this.context);
            Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"createTypeByFQClassName(...)");
            argType = (PsiType)psiClassType;
        }
        PsiType t = session.getContextSubstitutor().substitute(session.substituteWithInferenceVariables(this.leftType));
        PsiType s = session.getContextSubstitutor().substitute(session.substituteWithInferenceVariables(argType));
        constraints.add((ConstraintFormula)new TypeCompatibilityConstraint(t, s));
        return true;
    }
}

