/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.typing;

import com.intellij.psi.PsiType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyIndexPropertyUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCallReference;
import org.jetbrains.plugins.groovy.lang.typing.DefaultMethodCallTypeCalculatorKt;
import org.jetbrains.plugins.groovy.lang.typing.GrTypeCalculator;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/groovy/lang/typing/DefaultIndexAccessTypeCalculator;", "Lorg/jetbrains/plugins/groovy/lang/typing/GrTypeCalculator;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrIndexProperty;", "<init>", "()V", "getType", "Lcom/intellij/psi/PsiType;", "expression", "fromGetAtCall", "intellij.groovy.psi"})
public final class DefaultIndexAccessTypeCalculator
implements GrTypeCalculator<GrIndexProperty> {
    @Override
    @Nullable
    public PsiType getType(@NotNull GrIndexProperty expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        PsiType psiType = GroovyIndexPropertyUtil.getArrayClassType(expression);
        if (psiType == null && (psiType = GroovyIndexPropertyUtil.getSimpleArrayAccessType(expression)) == null) {
            psiType = this.fromGetAtCall(expression);
        }
        return psiType;
    }

    private final PsiType fromGetAtCall(GrIndexProperty expression) {
        GroovyMethodCallReference groovyMethodCallReference = expression.getRValueReference();
        if (groovyMethodCallReference == null) {
            return null;
        }
        GroovyMethodCallReference reference = groovyMethodCallReference;
        GroovyResolveResult groovyResolveResult = reference.advancedResolve();
        Intrinsics.checkNotNullExpressionValue((Object)groovyResolveResult, (String)"advancedResolve(...)");
        return DefaultMethodCallTypeCalculatorKt.getTypeFromResult(groovyResolveResult, reference.getArguments(), expression);
    }
}

