/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.typing;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTraitType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.lang.typing.GrTypeCalculator;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/groovy/lang/typing/DefaultSafeCastTypeCalculator;", "Lorg/jetbrains/plugins/groovy/lang/typing/GrTypeCalculator;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrSafeCastExpression;", "<init>", "()V", "getType", "Lcom/intellij/psi/PsiType;", "expression", "getTypeFromRawCollectionCast", "getTraitType", "intellij.groovy.psi"})
public final class DefaultSafeCastTypeCalculator
implements GrTypeCalculator<GrSafeCastExpression> {
    @Override
    @Nullable
    public PsiType getType(@NotNull GrSafeCastExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        GrTypeElement grTypeElement = expression.getCastTypeElement();
        if (grTypeElement == null) {
            return null;
        }
        GrTypeElement typeElement = grTypeElement;
        PsiType psiType = this.getTypeFromRawCollectionCast(expression);
        if (psiType == null && (psiType = this.getTraitType(expression)) == null) {
            PsiType psiType2 = typeElement.getType();
            psiType = psiType2;
            Intrinsics.checkNotNullExpressionValue((Object)psiType2, (String)"getType(...)");
        }
        return psiType;
    }

    private final PsiType getTypeFromRawCollectionCast(GrSafeCastExpression expression) {
        GrTypeElement grTypeElement = expression.getCastTypeElement();
        PsiType psiType = grTypeElement != null ? grTypeElement.getType() : null;
        PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        if (psiClassType == null) {
            return null;
        }
        PsiClassType castType = psiClassType;
        if (!InheritanceUtil.isInheritor((PsiType)((PsiType)castType), (String)"java.util.Collection")) {
            return null;
        }
        if (PsiUtil.extractIterableTypeParameter((PsiType)((PsiType)castType), (boolean)false) != null) {
            return null;
        }
        PsiClass psiClass = castType.resolve();
        if (psiClass == null) {
            return null;
        }
        PsiClass resolved = psiClass;
        PsiTypeParameter[] psiTypeParameterArray = resolved.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeParameterArray, (String)"getTypeParameters(...)");
        PsiTypeParameter psiTypeParameter = (PsiTypeParameter)ArraysKt.singleOrNull((Object[])psiTypeParameterArray);
        if (psiTypeParameter == null) {
            return null;
        }
        PsiTypeParameter typeParameter = psiTypeParameter;
        PsiType psiType2 = TypesUtil.getItemType(expression.getOperand().getType());
        if (psiType2 == null) {
            return null;
        }
        PsiType itemType = psiType2;
        Map substitutionMap = MapsKt.mapOf((Pair)TuplesKt.to((Object)typeParameter, (Object)itemType));
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression.getProject());
        PsiSubstitutor psiSubstitutor = factory.createSubstitutor(substitutionMap);
        Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"createSubstitutor(...)");
        PsiSubstitutor substitutor = psiSubstitutor;
        return (PsiType)factory.createType(resolved, substitutor);
    }

    private final PsiType getTraitType(GrSafeCastExpression expression) {
        GrTypeElement grTypeElement = expression.getCastTypeElement();
        PsiType psiType = grTypeElement != null ? grTypeElement.getType() : null;
        PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        if (psiClassType == null) {
            return null;
        }
        PsiClassType castType = psiClassType;
        PsiType exprType = expression.getOperand().getType();
        if (!(exprType instanceof PsiClassType) && !(exprType instanceof GrTraitType)) {
            return null;
        }
        PsiClass psiClass = castType.resolve();
        if (psiClass == null) {
            return null;
        }
        PsiClass resolved = psiClass;
        if (!GrTraitUtil.isTrait(resolved)) {
            return null;
        }
        return GrTraitType.createTraitType(exprType, CollectionsKt.listOf((Object)castType));
    }
}

