/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.transformations.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.refactoring.rename.GrRenameHelper;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/groovy/transformations/impl/DefaultRenameHelper;", "Lorg/jetbrains/plugins/groovy/refactoring/rename/GrRenameHelper;", "<init>", "()V", "getNewMemberName", "", "member", "Lcom/intellij/psi/PsiMember;", "newOriginalName", "isQualificationNeeded", "", "manager", "Lcom/intellij/psi/PsiManager;", "before", "Lcom/intellij/psi/PsiElement;", "after", "intellij.groovy"})
public final class DefaultRenameHelper
implements GrRenameHelper {
    @Override
    @Nullable
    public String getNewMemberName(@NotNull PsiMember member, @NotNull String newOriginalName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Intrinsics.checkNotNullParameter((Object)newOriginalName, (String)"newOriginalName");
        if (!(member instanceof GrAccessorMethod)) {
            return null;
        }
        if (((GrAccessorMethod)member).isSetter()) {
            string = GroovyPropertyUtils.getSetterName(newOriginalName);
        } else {
            String string2 = ((GrAccessorMethod)member).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            string = GroovyPropertyUtils.getAccessorName(StringsKt.startsWith$default((String)string2, (String)"is", (boolean)false, (int)2, null) ? "is" : "get", newOriginalName);
        }
        return string;
    }

    @Override
    public boolean isQualificationNeeded(@NotNull PsiManager manager, @NotNull PsiElement before, @NotNull PsiElement after) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        return before instanceof GrAccessorMethod && (!(after instanceof GrAccessorMethod) || !manager.areElementsEquivalent((PsiElement)((GrAccessorMethod)before).getProperty(), (PsiElement)((GrAccessorMethod)after).getProperty()));
    }
}

