/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.JvmMainMethodSearcher;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u001b\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aR\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/groovy/util/GroovyMainMethodSearcher;", "Lcom/intellij/psi/util/JvmMainMethodSearcher;", "<init>", "()V", "mainComparator", "Ljava/util/Comparator;", "Lcom/intellij/psi/PsiMethod;", "Lkotlin/Comparator;", "compareParameters", "", "leftParameterList", "Lcom/intellij/psi/PsiParameterList;", "rightParameterList", "getParameterPriority", "parameter", "Lcom/intellij/psi/PsiParameter;", "getMainCandidateComparator", "instanceMainMethodsEnabled", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "inheritedStaticMainEnabled", "findMainMethodsInClassByName", "", "aClass", "Lcom/intellij/psi/PsiClass;", "(Lcom/intellij/psi/PsiClass;)[Lcom/intellij/psi/PsiMethod;", "intellij.groovy.psi"})
public final class GroovyMainMethodSearcher
extends JvmMainMethodSearcher {
    @NotNull
    public static final GroovyMainMethodSearcher INSTANCE = new GroovyMainMethodSearcher();
    @NotNull
    private static final Comparator<PsiMethod> mainComparator = GroovyMainMethodSearcher::mainComparator$lambda$0;

    private GroovyMainMethodSearcher() {
    }

    private final int compareParameters(PsiParameterList leftParameterList, PsiParameterList rightParameterList) {
        int rightParametersCount;
        int leftParametersCount = leftParameterList.getParametersCount();
        if (leftParametersCount < (rightParametersCount = rightParameterList.getParametersCount())) {
            return -1;
        }
        if (leftParametersCount > rightParametersCount) {
            return 1;
        }
        if (leftParametersCount != 1) {
            return 0;
        }
        PsiParameter psiParameter = leftParameterList.getParameters()[0];
        Intrinsics.checkNotNullExpressionValue((Object)psiParameter, (String)"get(...)");
        int leftParameter = this.getParameterPriority(psiParameter);
        PsiParameter psiParameter2 = rightParameterList.getParameters()[0];
        Intrinsics.checkNotNullExpressionValue((Object)psiParameter2, (String)"get(...)");
        int rightParameter = this.getParameterPriority(psiParameter2);
        return Intrinsics.compare((int)leftParameter, (int)rightParameter);
    }

    private final int getParameterPriority(PsiParameter parameter) {
        if (!(parameter instanceof GrParameter)) {
            return 0;
        }
        PsiType groovyType = ((GrParameter)parameter).getTypeGroovy();
        return TypeUtils.isJavaLangObject((PsiType)groovyType) || groovyType == null ? 1 : (JvmMainMethodSearcher.isJavaLangStringArray((PsiParameter)parameter) ? 2 : 0);
    }

    @NotNull
    protected Comparator<PsiMethod> getMainCandidateComparator() {
        return mainComparator;
    }

    public boolean instanceMainMethodsEnabled(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        return GroovyConfigUtils.getInstance().isVersionAtLeast(psiElement, "5.0") && Intrinsics.areEqual((Object)psiElement.getLanguage(), (Object)((Object)GroovyLanguage.INSTANCE));
    }

    protected boolean inheritedStaticMainEnabled(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        return GroovyConfigUtils.getInstance().isVersionAtLeast(psiElement, "5.0");
    }

    @NotNull
    public PsiMethod[] findMainMethodsInClassByName(@NotNull PsiClass aClass) {
        Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
        if (aClass instanceof GrTypeDefinition) {
            PsiMethod[] psiMethodArray = ((GrTypeDefinition)aClass).findCodeMethodsByName("main", true);
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findCodeMethodsByName(...)");
            return psiMethodArray;
        }
        PsiMethod[] psiMethodArray = aClass.findMethodsByName("main", true);
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findMethodsByName(...)");
        return psiMethodArray;
    }

    private static final int mainComparator$lambda$0(PsiMethod o1, PsiMethod o2) {
        PsiParameterList psiParameterList = o1.getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"getParameterList(...)");
        PsiParameterList o1ParameterList = psiParameterList;
        PsiParameterList psiParameterList2 = o2.getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterList2, (String)"getParameterList(...)");
        PsiParameterList o2ParameterList = psiParameterList2;
        int parametersComparison = INSTANCE.compareParameters(o2ParameterList, o1ParameterList);
        if (parametersComparison != 0) {
            return parametersComparison;
        }
        boolean isO1Static = o1.hasModifierProperty("static");
        boolean isO2Static = o2.hasModifierProperty("static");
        return Boolean.compare(isO2Static, isO1Static);
    }
}

