/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesUtilService;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.PropertyKeyIndex;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J&\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/lang/properties/PropertiesUtilServiceImpl;", "Lcom/intellij/lang/properties/PropertiesUtilService;", "<init>", "()V", "getResourceBundle", "Lcom/intellij/lang/properties/ResourceBundle;", "file", "Lcom/intellij/lang/properties/psi/impl/PropertiesFileImpl;", "shouldReadIndex", "", "getProperties", "Ljava/util/stream/Stream;", "Lcom/intellij/lang/properties/psi/Property;", "key", "", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "intellij.properties.backend.psi"})
public final class PropertiesUtilServiceImpl
implements PropertiesUtilService {
    @NotNull
    public ResourceBundle getResourceBundle(@NotNull PropertiesFileImpl file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ResourceBundle resourceBundle = PropertiesImplUtil.getResourceBundle((PropertiesFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)resourceBundle, (String)"getResourceBundle(...)");
        return resourceBundle;
    }

    public boolean shouldReadIndex() {
        return true;
    }

    @NotNull
    public Stream<Property> getProperties(@NotNull String key, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Stream<Property> stream = PropertyKeyIndex.getInstance().getProperties(key, project, scope).stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
        return stream;
    }
}

