/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gateway.eel;

import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.gateway.eel.GatewayIjentDeployingStrategy;
import com.intellij.gateway.eel.descriptors.GatewaySshEelDescriptor;
import com.intellij.gateway.eel.descriptors.GatewaySshEelMachine;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelMachine;
import com.intellij.platform.eel.provider.EelMachineResolver;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.platform.ijent.tcp.IjentIsolatedTcpDeployingStrategy;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.util.ui.EDT;
import com.jetbrains.gateway.GatewayBundle;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0002\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u0016J\f\u0010\u0017\u001a\u00020\n*\u00020\u0018H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R3\u0010\b\u001a'\u0012\u000e\u0012\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\f\u0012\u000e\u0012\f0\r\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\f0\t\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/gateway/eel/GatewayTcpEelMachineResolver;", "Lcom/intellij/platform/eel/provider/EelMachineResolver;", "<init>", "()V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "resolvedMachineCache", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/intellij/gateway/eel/descriptors/GatewaySshEelMachine;", "getResolvedEelMachine", "Lcom/intellij/platform/eel/EelMachine;", "eelDescriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "resolveEelMachine", "(Lcom/intellij/platform/eel/EelDescriptor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resolveEelMachineByInternalName", "internalName", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toInternalName", "Lcom/intellij/gateway/eel/descriptors/GatewaySshEelDescriptor;", "ScopeHolder", "Companion", "intellij.gateway.eel"})
@SourceDebugExtension(value={"SMAP\nGatewayTcpEelMachineResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GatewayTcpEelMachineResolver.kt\ncom/intellij/gateway/eel/GatewayTcpEelMachineResolver\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,80:1\n13#2:81\n*S KotlinDebug\n*F\n+ 1 GatewayTcpEelMachineResolver.kt\ncom/intellij/gateway/eel/GatewayTcpEelMachineResolver\n*L\n32#1:81\n*E\n"})
public final class GatewayTcpEelMachineResolver
implements EelMachineResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<String, GatewaySshEelMachine> resolvedMachineCache;
    @NotNull
    private static final Logger LOG;

    public GatewayTcpEelMachineResolver() {
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap(...)");
        this.resolvedMachineCache = concurrentMap;
    }

    private final CoroutineScope getCoroutineScope() {
        return ScopeHolder.Companion.instance().getCoroutineScope();
    }

    @Nullable
    public EelMachine getResolvedEelMachine(@NotNull EelDescriptor eelDescriptor) {
        EelMachine eelMachine;
        GatewaySshEelMachine machine;
        Intrinsics.checkNotNullParameter((Object)eelDescriptor, (String)"eelDescriptor");
        GatewaySshEelDescriptor gatewaySshEelDescriptor = eelDescriptor instanceof GatewaySshEelDescriptor ? (GatewaySshEelDescriptor)eelDescriptor : null;
        if (gatewaySshEelDescriptor == null) {
            return null;
        }
        GatewaySshEelDescriptor tcpDescriptor = gatewaySshEelDescriptor;
        GatewaySshEelMachine gatewaySshEelMachine = machine = (GatewaySshEelMachine)((Object)this.resolvedMachineCache.get(this.toInternalName(tcpDescriptor)));
        if (gatewaySshEelMachine != null) {
            return (EelMachine)gatewaySshEelMachine;
        }
        LOG.error("Resolved machine not found for " + tcpDescriptor + ". For now it will be resolved");
        if (EDT.isCurrentThreadEdt()) {
            ModalTaskOwner modalTaskOwner = ModalTaskOwner.guess();
            Intrinsics.checkNotNullExpressionValue((Object)modalTaskOwner, (String)"guess(...)");
            eelMachine = (EelMachine)TasksKt.runWithModalProgressBlocking$default((ModalTaskOwner)modalTaskOwner, (String)GatewayBundle.INSTANCE.message("ssh.ijent.resolve.machine", new Object[0]), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super EelMachine>, Object>(this, tcpDescriptor, null){
                int label;
                final /* synthetic */ GatewayTcpEelMachineResolver this$0;
                final /* synthetic */ GatewaySshEelDescriptor $tcpDescriptor;
                {
                    this.this$0 = $receiver;
                    this.$tcpDescriptor = $tcpDescriptor;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.this$0.resolveEelMachine((EelDescriptor)this.$tcpDescriptor, (Continuation<? super EelMachine>)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super EelMachine> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)4, null);
        } else {
            eelMachine = (EelMachine)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super EelMachine>, Object>(this, tcpDescriptor, null){
                int label;
                final /* synthetic */ GatewayTcpEelMachineResolver this$0;
                final /* synthetic */ GatewaySshEelDescriptor $tcpDescriptor;
                {
                    this.this$0 = $receiver;
                    this.$tcpDescriptor = $tcpDescriptor;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.this$0.resolveEelMachine((EelDescriptor)this.$tcpDescriptor, (Continuation<? super EelMachine>)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super EelMachine> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
        return eelMachine;
    }

    @Nullable
    public Object resolveEelMachine(@NotNull EelDescriptor eelDescriptor, @NotNull Continuation<? super EelMachine> $completion) {
        GatewaySshEelDescriptor gatewaySshEelDescriptor = eelDescriptor instanceof GatewaySshEelDescriptor ? (GatewaySshEelDescriptor)eelDescriptor : null;
        if (gatewaySshEelDescriptor == null) {
            return null;
        }
        GatewaySshEelDescriptor descriptor = gatewaySshEelDescriptor;
        return this.resolveEelMachineByInternalName("ssh-" + descriptor.getSshConfigId(), $completion);
    }

    @Nullable
    public Object resolveEelMachineByInternalName(@NotNull String internalName, @NotNull Continuation<? super EelMachine> $completion) {
        if (!StringsKt.startsWith$default((String)internalName, (String)"ssh", (boolean)false, (int)2, null)) {
            return null;
        }
        String sshConfigId = StringsKt.drop((String)StringsKt.substringAfter$default((String)internalName, (String)"ssh", null, (int)2, null), (int)1);
        SshConfigManager sshConfigManager = SshConfigManager.getInstance(null);
        Intrinsics.checkNotNullExpressionValue((Object)sshConfigManager, (String)"getInstance(...)");
        SshConfigManager sshManager = sshConfigManager;
        SshConfig sshConfig = sshManager.findConfigById(sshConfigId);
        if (sshConfig == null) {
            return null;
        }
        SshConfig config = sshConfig;
        GatewaySshEelMachine machine = this.resolvedMachineCache.computeIfAbsent(internalName, arg_0 -> GatewayTcpEelMachineResolver.resolveEelMachineByInternalName$lambda$1(arg_0 -> GatewayTcpEelMachineResolver.resolveEelMachineByInternalName$lambda$0(sshConfigId, this, config, arg_0), arg_0));
        return machine;
    }

    private final String toInternalName(GatewaySshEelDescriptor $this$toInternalName) {
        return "ssh-" + $this$toInternalName.getSshConfigId();
    }

    private static final IjentIsolatedTcpDeployingStrategy resolveEelMachineByInternalName$lambda$0$0(GatewayTcpEelMachineResolver this$0, SshConfig $config) {
        return new GatewayIjentDeployingStrategy(this$0.getCoroutineScope(), $config);
    }

    private static final GatewaySshEelMachine resolveEelMachineByInternalName$lambda$0(String $sshConfigId, GatewayTcpEelMachineResolver this$0, SshConfig $config, String it) {
        return new GatewaySshEelMachine($sshConfigId, this$0.getCoroutineScope(), (Function0<? extends IjentIsolatedTcpDeployingStrategy>)((Function0)() -> GatewayTcpEelMachineResolver.resolveEelMachineByInternalName$lambda$0$0(this$0, $config)));
    }

    private static final GatewaySshEelMachine resolveEelMachineByInternalName$lambda$1(Function1 $tmp0, Object p0) {
        return (GatewaySshEelMachine)((Object)$tmp0.invoke(p0));
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GatewayTcpEelMachineResolver.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/gateway/eel/GatewayTcpEelMachineResolver$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gateway.eel"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Service
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/gateway/eel/GatewayTcpEelMachineResolver$ScopeHolder;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "Companion", "intellij.gateway.eel"})
    private static final class ScopeHolder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final CoroutineScope coroutineScope;

        public ScopeHolder(@NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            this.coroutineScope = coroutineScope;
        }

        @NotNull
        public final CoroutineScope getCoroutineScope() {
            return this.coroutineScope;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/gateway/eel/GatewayTcpEelMachineResolver$ScopeHolder$Companion;", "", "<init>", "()V", "instance", "Lcom/intellij/gateway/eel/GatewayTcpEelMachineResolver$ScopeHolder;", "intellij.gateway.eel"})
        @SourceDebugExtension(value={"SMAP\nGatewayTcpEelMachineResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GatewayTcpEelMachineResolver.kt\ncom/intellij/gateway/eel/GatewayTcpEelMachineResolver$ScopeHolder$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,80:1\n42#2,3:81\n*S KotlinDebug\n*F\n+ 1 GatewayTcpEelMachineResolver.kt\ncom/intellij/gateway/eel/GatewayTcpEelMachineResolver$ScopeHolder$Companion\n*L\n24#1:81,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ScopeHolder instance() {
                boolean $i$f$service = false;
                Class<ScopeHolder> serviceClass$iv = ScopeHolder.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                return (ScopeHolder)object;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

