/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sybase.introspector;

import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector;
import com.intellij.database.dialects.sybase.generator.AseNamingService;
import com.intellij.database.dialects.sybase.introspector.AseIntroQueries;
import com.intellij.database.dialects.sybase.model.AseArgument;
import com.intellij.database.dialects.sybase.model.AseForeignKey;
import com.intellij.database.dialects.sybase.model.AseFunction;
import com.intellij.database.dialects.sybase.model.AseGrantsHolder;
import com.intellij.database.dialects.sybase.model.AseLikeTable;
import com.intellij.database.dialects.sybase.model.AseMajorObject;
import com.intellij.database.dialects.sybase.model.AseProcedureGroup;
import com.intellij.database.dialects.sybase.model.AseSchema;
import com.intellij.database.dialects.sybase.model.AseSchemaObject;
import com.intellij.database.dialects.sybase.model.AseTable;
import com.intellij.database.dialects.sybase.model.AseTableColumn;
import com.intellij.database.dialects.sybase.model.AseTrigger;
import com.intellij.database.dialects.sybase.model.properties.AseObjectGrant;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.util.Version;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u00c0\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\t\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0017\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u001a\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001b\u001a\u00020\u0012H\u0002\u001a\u0018\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u0012H\u0002\u001a:\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&H\u0002\u001a\u0018\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0012H\u0000\u001a\u0018\u0010+\u001a\u00020\u00042\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0012H\u0000\u001a\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002\u001a\u0016\u00102\u001a\u0004\u0018\u000103*\u0002042\u0006\u00105\u001a\u00020\u0012H\u0002\u001a\u0016\u00106\u001a\u0004\u0018\u00010/*\u0002042\u0006\u00105\u001a\u00020\u0012H\u0002\u001a\u001c\u00107\u001a\u000208*\n\u0012\u0006\b\u0001\u0012\u000208092\u0006\u0010\u001a\u001a\u00020\u000fH\u0002\u001a\u0014\u0010:\u001a\u00020-*\n\u0012\u0006\b\u0001\u0012\u00020;09H\u0002\u001a\u0016\u0010<\u001a\u00020-*\u00020=2\b\u0010>\u001a\u0004\u0018\u00010?H\u0002\u001a\u001e\u0010@\u001a\u0004\u0018\u00010A*\u0002042\u0006\u0010B\u001a\u00020C2\u0006\u0010\u001b\u001a\u00020\u0012H\u0002\u001a\u001e\u0010D\u001a\u0004\u0018\u00010\u000f2\b\u0010E\u001a\u0004\u0018\u00010\u000f2\b\u0010F\u001a\u0004\u0018\u00010\u000fH\u0002\u001a\u0012\u0010I\u001a\u00020\u00192\b\u0010J\u001a\u0004\u0018\u00010KH\u0002\u001a\u001e\u0010L\u001a\u00020-2\u0006\u0010M\u001a\u00020N2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020Q0PH\u0002\u001a\u0014\u0010R\u001a\u0004\u0018\u00010S2\b\u0010T\u001a\u0004\u0018\u00010)H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010G\u001a\u00020HX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "COLUMN_BITS1_IDENTITY", "", "COLUMN_BITS1_NULLABLE", "COLUMN_BITS2_COMPUTED", "COLUMN_BITS2_OUTPUT", "INDEX_BITS1_PRIMARY", "INDEX_BITS1_CLUSTERED", "INDEX_BITS1_UNIQUE", "INDEX_BITS2_NAME_SURROGATE", "INDEX_BITS2_KEY", "EXACT_LENGTH_TYPES", "", "", "CHARACTER_TYPES", "", "", "CHARACTER_TYPES_16", "TYPE_SUBSTITUTION", "catalogPrefix", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "detectSurrogateName", "", "name", "id", "fixFloatPrecision", "type_name", "length", "makeDataType", "Lcom/intellij/database/model/DataType;", "typeName", "precision", "scale", "variable", "ver", "Lcom/intellij/database/util/Version;", "peek16", "array", "", "offset", "peek16BigEndian", "assignForeignKeyColumns", "", "foreignKey", "Lcom/intellij/database/dialects/sybase/model/AseForeignKey;", "columnPositions", "", "findObjectById", "Lcom/intellij/database/dialects/sybase/model/AseMajorObject;", "Lcom/intellij/database/dialects/sybase/model/AseSchema;", "objectId", "findForeignKeyById", "createOrGetByName", "Lcom/intellij/database/dialects/sybase/model/AseArgument;", "Lcom/intellij/database/model/families/ModFamily;", "finish", "Lcom/intellij/database/model/basic/BasicModElement;", "addEvent", "Lcom/intellij/database/dialects/sybase/model/AseTrigger;", "event", "Lcom/intellij/database/model/TrigEvent;", "findTableOrView", "Lcom/intellij/database/dialects/sybase/model/AseLikeTable;", "code", "", "joinSourceTextParts", "text1", "text2", "SYBASE_INTERNAL_REMARK_PATTERN", "Lkotlin/text/Regex;", "canCheckOutdated", "e", "Lcom/intellij/database/model/basic/BasicElement;", "applyGrants", "holder", "Lcom/intellij/database/dialects/sybase/model/AseGrantsHolder;", "grants", "", "Lcom/intellij/database/dialects/sybase/introspector/AseIntroQueries$OneGrant;", "toBitSet", "Ljava/util/BitSet;", "bytes", "intellij.database.dialects.sybase"})
@SourceDebugExtension(value={"SMAP\nAseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AseIntrospector.kt\ncom/intellij/database/dialects/sybase/introspector/AseIntrospectorKt\n+ 2 NumberFun.kt\ncom/intellij/database/util/common/NumberFun\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,983:1\n42#2:984\n36#2:985\n42#2:988\n36#2:989\n296#3,2:986\n*S KotlinDebug\n*F\n+ 1 AseIntrospector.kt\ncom/intellij/database/dialects/sybase/introspector/AseIntrospectorKt\n*L\n847#1:984\n847#1:985\n981#1:988\n981#1:989\n893#1:986,2\n*E\n"})
public final class AseIntrospectorKt {
    @NotNull
    private static final Logger LOG;
    private static final short COLUMN_BITS1_IDENTITY = 128;
    private static final short COLUMN_BITS1_NULLABLE = 8;
    private static final short COLUMN_BITS2_COMPUTED = 16;
    private static final short COLUMN_BITS2_OUTPUT = 2;
    private static final short INDEX_BITS1_PRIMARY = 2048;
    private static final short INDEX_BITS1_CLUSTERED = 16;
    private static final short INDEX_BITS1_UNIQUE = 2;
    private static final short INDEX_BITS2_NAME_SURROGATE = 8;
    private static final short INDEX_BITS2_KEY = 2;
    @NotNull
    private static final Set<String> EXACT_LENGTH_TYPES;
    @NotNull
    private static final Map<String, Integer> CHARACTER_TYPES;
    @NotNull
    private static final Map<String, Integer> CHARACTER_TYPES_16;
    @NotNull
    private static final Map<String, String> TYPE_SUBSTITUTION;
    @NotNull
    private static final Regex SYBASE_INTERNAL_REMARK_PATTERN;

    private static final String catalogPrefix(BasicDatabase database) {
        Object object;
        if (database.isCurrent()) {
            object = "dbo";
        } else {
            String string = database.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            object = AseNamingService.INSTANCE.enquote(string, database.getKind()) + ".dbo";
        }
        return object;
    }

    private static final boolean detectSurrogateName(String name2, int id) {
        if (name2 == null) {
            return false;
        }
        String idStr = "_" + id;
        return name2.length() > idStr.length() && StringsKt.endsWith$default((String)name2, (String)idStr, (boolean)false, (int)2, null);
    }

    private static final int fixFloatPrecision(String type_name, int length) {
        if (Intrinsics.areEqual((Object)"float", (Object)type_name)) {
            switch (length) {
                case 8: {
                    return 22;
                }
                case 4: {
                    return 15;
                }
            }
        }
        return length;
    }

    private static final DataType makeDataType(String typeName, int length, short precision, short scale, boolean variable, Version ver) {
        DataType dataType;
        if (typeName == null) {
            DataType dataType2 = DataType.UNKNOWN;
            Intrinsics.checkNotNullExpressionValue((Object)dataType2, (String)"UNKNOWN");
            return dataType2;
        }
        boolean exactLength = EXACT_LENGTH_TYPES.contains(typeName);
        int p = 0;
        short s = 0;
        LengthUnit u = null;
        int[] nArray = new int[]{16};
        Map<String, Integer> charTypes = ver.isOrGreater(nArray) ? CHARACTER_TYPES_16 : CHARACTER_TYPES;
        if (length == 0 && precision == 0 || !variable && !exactLength) {
            p = -1;
            s = 0;
            LengthUnit lengthUnit = LengthUnit.NONE;
            Intrinsics.checkNotNullExpressionValue((Object)lengthUnit, (String)"NONE");
            u = lengthUnit;
        } else if (precision > 0) {
            p = precision;
            s = scale;
            LengthUnit lengthUnit = LengthUnit.DIGIT;
            Intrinsics.checkNotNullExpressionValue((Object)lengthUnit, (String)"DIGIT");
            u = lengthUnit;
        } else if (exactLength) {
            s = 0;
            Integer lenFix = charTypes.get(typeName);
            if (lenFix != null) {
                p = length / lenFix;
                LengthUnit lengthUnit = LengthUnit.CHAR;
                Intrinsics.checkNotNullExpressionValue((Object)lengthUnit, (String)"CHAR");
                u = lengthUnit;
            } else {
                LengthUnit lengthUnit;
                p = AseIntrospectorKt.fixFloatPrecision(typeName, length);
                if (length > 0) {
                    LengthUnit lengthUnit2 = LengthUnit.BYTE;
                    lengthUnit = lengthUnit2;
                    Intrinsics.checkNotNullExpressionValue((Object)lengthUnit2, (String)"BYTE");
                } else {
                    LengthUnit lengthUnit3 = LengthUnit.NONE;
                    lengthUnit = lengthUnit3;
                    Intrinsics.checkNotNullExpressionValue((Object)lengthUnit3, (String)"NONE");
                }
                u = lengthUnit;
            }
        } else {
            p = -1;
            s = 0;
            LengthUnit lengthUnit = LengthUnit.NONE;
            Intrinsics.checkNotNullExpressionValue((Object)lengthUnit, (String)"NONE");
            u = lengthUnit;
        }
        try {
            String string = TYPE_SUBSTITUTION.get(typeName);
            if (string == null) {
                string = typeName;
            }
            dataType = DataTypeFactory.of(null, (String)string, (int)p, (int)s, (LengthUnit)u, null, (boolean)false, (boolean)false);
            Intrinsics.checkNotNull((Object)dataType);
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = e.getClass().getName();
            }
            String exceptionMessage = string;
            LOG.warn("Failed to handle data type " + typeName + " with length " + length + " precision " + precision + " scale " + scale + ": " + exceptionMessage);
            DataType dataType3 = DataType.UNKNOWN;
            Intrinsics.checkNotNull((Object)dataType3);
            dataType = dataType3;
        }
        DataType dt = dataType;
        return dt;
    }

    /*
     * WARNING - void declaration
     */
    public static final short peek16(@NotNull byte[] array, int offset) {
        void $this$and$iv;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        byte b1 = array[offset];
        byte b2 = array[offset + 1];
        byte by = b1;
        int that$iv = 255;
        boolean $i$f$and = false;
        void $this$toUnsignedInt$iv$iv = $this$and$iv;
        boolean $i$f$toUnsignedInt = false;
        return (short)((b2 & 0xFF) << 8 | (byte)(Byte.toUnsignedInt((byte)$this$toUnsignedInt$iv$iv) & that$iv));
    }

    public static final short peek16BigEndian(@NotNull byte[] array, int offset) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        int highByte = array[offset] & 0xFF;
        int lowByte = array[offset + 1] & 0xFF;
        return (short)(highByte << 8 | lowByte);
    }

    private static final void assignForeignKeyColumns(AseForeignKey foreignKey, short[] columnPositions) {
        AseTable table = foreignKey.getTable();
        int n = columnPositions.length;
        ArrayList<Object> names = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            AseTable aseTable = table;
            Intrinsics.checkNotNull((Object)aseTable);
            AseTableColumn column = (AseTableColumn)aseTable.getColumns().getByNaturalPosition(columnPositions[i]);
            Object object = column;
            if (object == null || (object = object.getRealName()) == null) continue;
            Object name2 = object;
            names.add(name2);
        }
        foreignKey.setColNames(names);
    }

    private static final AseMajorObject findObjectById(AseSchema $this$findObjectById, int objectId) {
        AseMajorObject aseMajorObject = (AseMajorObject)$this$findObjectById.getTables().getByObjectId(objectId);
        if (aseMajorObject == null && (aseMajorObject = (AseMajorObject)$this$findObjectById.getViews().getByObjectId(objectId)) == null && (aseMajorObject = (AseMajorObject)$this$findObjectById.getFunctions().getByObjectId(objectId)) == null) {
            aseMajorObject = (AseMajorObject)$this$findObjectById.getProcedureGroups().getByObjectId(objectId);
        }
        return aseMajorObject;
    }

    private static final AseForeignKey findForeignKeyById(AseSchema $this$findForeignKeyById, int objectId) {
        long id = objectId;
        for (AseTable table : $this$findForeignKeyById.getTables()) {
            for (AseForeignKey fk : table.getForeignKeys()) {
                if (fk.getObjectId() != id) continue;
                return fk;
            }
        }
        return null;
    }

    private static final AseArgument createOrGetByName(ModFamily<? extends AseArgument> $this$createOrGetByName, String name2) {
        Object v0;
        block3: {
            Iterable $this$firstOrNull$iv = (Iterable)$this$createOrGetByName;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AseArgument it = (AseArgument)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        AseArgument a = v0;
        if (a == null) {
            a = (AseArgument)$this$createOrGetByName.createNewOne();
            ((BasicModNamedElement)a).setName(name2);
        } else {
            a.resetSyncPending();
        }
        return a;
    }

    private static final void finish(ModFamily<? extends BasicModElement> $this$finish) {
        $this$finish.removeSyncPendingChildren();
        $this$finish.sort();
    }

    private static final void addEvent(AseTrigger $this$addEvent, TrigEvent event) {
        if (event == null) {
            return;
        }
        Set set = $this$addEvent.getEvents();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getEvents(...)");
        Set events = set;
        if (events.isEmpty()) {
            $this$addEvent.setEvents(Collections.singleton(event));
        } else if (!events.contains(event)) {
            $this$addEvent.setEvents(SetsKt.plus((Set)events, (Object)event));
        }
    }

    private static final AseLikeTable findTableOrView(AseSchema $this$findTableOrView, char code, int id) {
        return switch (code) {
            case 'T' -> (AseLikeTable)$this$findTableOrView.getTables().getByObjectId(id);
            case 'V' -> (AseLikeTable)$this$findTableOrView.getViews().getByObjectId(id);
            default -> null;
        };
    }

    private static final String joinSourceTextParts(String text1, String text2) {
        CharSequence charSequence;
        return text1 == null ? text2 : (text2 == null ? text1 : (SYBASE_INTERNAL_REMARK_PATTERN.matches(charSequence = (CharSequence)text1) && StringsKt.startsWith$default((String)text2, (String)"CREATE", (boolean)false, (int)2, null) ? text1 + "\n" + text2 : text1 + text2));
    }

    private static final boolean canCheckOutdated(BasicElement e) {
        return e == null || e instanceof AseSchemaObject && !(e instanceof AseFunction) && !(e instanceof AseProcedureGroup) && !(e instanceof AseTrigger) && ((AseSchemaObject)e).getStateNumber() != -1;
    }

    private static final void applyGrants(AseGrantsHolder holder, List<AseIntroQueries.OneGrant> grants) {
        ArrayList<AseObjectGrant> newGrants = new ArrayList<AseObjectGrant>();
        for (AseIntroQueries.OneGrant g : grants) {
            Grants.State state = switch (g.type) {
                case 0 -> Grants.State.GRANT_WITH_GRANT_OPTION;
                case 2 -> Grants.State.REVOKE;
                default -> Grants.State.GRANT;
            };
            long l = g.object_id;
            BitSet bitSet = AseIntrospectorKt.toBitSet(g.columns);
            long l2 = g.user_id;
            String string = g.permission;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"permission");
            AseObjectGrant complete = new AseObjectGrant(l, bitSet, l2, string, state);
            newGrants.add(complete);
        }
        holder.setGrants((Grants<AseObjectGrant>)holder.getGrants().with((Iterable)newGrants));
    }

    /*
     * WARNING - void declaration
     */
    private static final BitSet toBitSet(byte[] bytes) {
        block3: {
            block2: {
                void $this$and$iv;
                if (bytes == null || bytes.length == 0) break block2;
                byte by = bytes[0];
                int that$iv = 1;
                boolean $i$f$and = false;
                void $this$toUnsignedInt$iv$iv = $this$and$iv;
                boolean $i$f$toUnsignedInt = false;
                if ((byte)(Byte.toUnsignedInt((byte)$this$toUnsignedInt$iv$iv) & that$iv) != 1) break block3;
            }
            return null;
        }
        return BitSet.valueOf(bytes);
    }

    public static final /* synthetic */ boolean access$canCheckOutdated(BasicElement e) {
        return AseIntrospectorKt.canCheckOutdated(e);
    }

    public static final /* synthetic */ String access$catalogPrefix(BasicDatabase database) {
        return AseIntrospectorKt.catalogPrefix(database);
    }

    public static final /* synthetic */ void access$applyGrants(AseGrantsHolder holder, List grants) {
        AseIntrospectorKt.applyGrants(holder, grants);
    }

    public static final /* synthetic */ AseArgument access$createOrGetByName(ModFamily $receiver, String name2) {
        return AseIntrospectorKt.createOrGetByName((ModFamily<? extends AseArgument>)$receiver, name2);
    }

    public static final /* synthetic */ AseLikeTable access$findTableOrView(AseSchema $receiver, char code, int id) {
        return AseIntrospectorKt.findTableOrView($receiver, code, id);
    }

    public static final /* synthetic */ AseMajorObject access$findObjectById(AseSchema $receiver, int objectId) {
        return AseIntrospectorKt.findObjectById($receiver, objectId);
    }

    public static final /* synthetic */ DataType access$makeDataType(String typeName, int length, short precision, short scale, boolean variable, Version ver) {
        return AseIntrospectorKt.makeDataType(typeName, length, precision, scale, variable, ver);
    }

    public static final /* synthetic */ void access$finish(ModFamily $receiver) {
        AseIntrospectorKt.finish((ModFamily<? extends BasicModElement>)$receiver);
    }

    public static final /* synthetic */ boolean access$detectSurrogateName(String name2, int id) {
        return AseIntrospectorKt.detectSurrogateName(name2, id);
    }

    public static final /* synthetic */ void access$assignForeignKeyColumns(AseForeignKey foreignKey, short[] columnPositions) {
        AseIntrospectorKt.assignForeignKeyColumns(foreignKey, columnPositions);
    }

    public static final /* synthetic */ AseForeignKey access$findForeignKeyById(AseSchema $receiver, int objectId) {
        return AseIntrospectorKt.findForeignKeyById($receiver, objectId);
    }

    public static final /* synthetic */ void access$addEvent(AseTrigger $receiver, TrigEvent event) {
        AseIntrospectorKt.addEvent($receiver, event);
    }

    public static final /* synthetic */ String access$joinSourceTextParts(String text1, String text2) {
        return AseIntrospectorKt.joinSourceTextParts(text1, text2);
    }

    static {
        Logger logger = Logger.getInstance(BaseMultiDatabaseIntrospector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Object[] objectArray = new String[]{"char", "nchar", "unichar", "varchar", "nvarchar", "univarchar", "binary", "float", "numeric", "decimal"};
        EXACT_LENGTH_TYPES = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"char", (Object)1), TuplesKt.to((Object)"varchar", (Object)1), TuplesKt.to((Object)"unichar", (Object)2), TuplesKt.to((Object)"univarchar", (Object)2), TuplesKt.to((Object)"nchar", (Object)3), TuplesKt.to((Object)"nvarchar", (Object)3), TuplesKt.to((Object)"sysname", (Object)1), TuplesKt.to((Object)"longsysname", (Object)1)};
        CHARACTER_TYPES = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"unichar", (Object)2), TuplesKt.to((Object)"univarchar", (Object)2)};
        CHARACTER_TYPES_16 = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"usmallint", (Object)"unsigned smallint"), TuplesKt.to((Object)"uint", (Object)"unsigned int"), TuplesKt.to((Object)"ubigint", (Object)"unsigned bigint")};
        TYPE_SUBSTITUTION = MapsKt.mapOf((Pair[])objectArray);
        SYBASE_INTERNAL_REMARK_PATTERN = new Regex("^/\\*[^/]+?\\*/\\s*$");
    }
}

