/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.terminal;

import com.intellij.cwm.plugin.following.ClientFollowMeManager;
import com.intellij.execution.ExecutionBundle;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.rd.RdEventSource;
import com.intellij.openapi.rd.SourceExKt;
import com.intellij.terminal.TerminalTitle;
import com.intellij.terminal.TerminalTitleListener;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.ui.content.Content;
import com.intellij.util.ApplicationKt;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.TerminalResizeListener;
import com.jediterm.terminal.ui.JediTermWidget;
import com.jetbrains.codeWithMe.model.RdTerminalSession;
import com.jetbrains.codeWithMe.model.RdTerminalSessionOrigin;
import com.jetbrains.codeWithMe.model.RdTerminalSize;
import com.jetbrains.codeWithMe.model.RdTerminalTitle;
import com.jetbrains.codeWithMe.model.SessionPortForwarding;
import com.jetbrains.codeWithMe.model.TerminalModel;
import com.jetbrains.codeWithMe.model.TerminalModel_GeneratedKt;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.codeWithMe.focus.UserFocusManager;
import com.jetbrains.rd.platform.codeWithMe.permissions.TerminalAccessLevel;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rdserver.core.RemoteClientSessionListener;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import com.jetbrains.rdserver.permissions.ClientPermissionManager;
import com.jetbrains.rdserver.portForwarding.utils.PortForwardingSessionData;
import com.jetbrains.rdserver.portForwarding.utils.PortForwardingSessionUtils;
import com.jetbrains.rdserver.terminal.BackendTerminalHost;
import com.jetbrains.rdserver.terminal.BackendTerminalManager;
import com.jetbrains.rdserver.terminal.BackendTtyConnector;
import com.jetbrains.rdserver.ui.converters.TerminalWidgetConverterKt;
import com.jetbrains.rdserver.unattendedHost.status.UnattendedHostActivityTracker;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;
import org.jetbrains.plugins.terminal.ui.TerminalContainer;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 22\u00020\u0001:\u0003234B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\bJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016J\u0014\u0010\u001e\u001a\u00020\u001f*\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0014\u0010#\u001a\u00020$*\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J$\u0010(\u001a\u00020\u001d*\u00020\"2\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001f0*H\u0002J\f\u0010,\u001a\u00020\u001a*\u00020\u0018H\u0002J\u0018\u0010-\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010.\u001a\u00020/H\u0002J \u00100\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010.\u001a\u00020/2\u0006\u00101\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/jetbrains/rdserver/terminal/BackendTerminalHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "<init>", "(Lcom/intellij/openapi/client/ClientProjectSession;)V", "bindSessions", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "terminalToolWindowPortLabel", "terminalModel", "Lcom/jetbrains/codeWithMe/model/TerminalModel;", "getTerminalModel", "()Lcom/jetbrains/codeWithMe/model/TerminalModel;", "newlineByte", "", "setupPortForwarding", "Lcom/jetbrains/codeWithMe/model/SessionPortForwarding;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "connector", "Lcom/jetbrains/rdserver/terminal/BackendTtyConnector;", "widget", "Lorg/jetbrains/plugins/terminal/ShellTerminalWidget;", "isSessionBound", "", "sessionId", "bind", "", "fromTerminalTitle", "Lcom/jetbrains/codeWithMe/model/RdTerminalTitle;", "Lcom/jetbrains/codeWithMe/model/RdTerminalTitle$Companion;", "terminalTitle", "Lcom/intellij/terminal/TerminalTitle;", "fromTerminalSize", "Lcom/jetbrains/codeWithMe/model/RdTerminalSize;", "Lcom/jetbrains/codeWithMe/model/RdTerminalSize$Companion;", "termSize", "Lcom/jediterm/core/util/TermSize;", "bindTerminalTitle", "property", "Lcom/jetbrains/rd/util/reactive/IProperty;", "hasRunningCommandsErrorAlreadyReported", "hasRunningCommandsSafe", "syncTerminalSize", "model", "Lcom/jetbrains/codeWithMe/model/RdTerminalSession;", "syncTerminalScrolling", "id", "Companion", "MyProtocolListener", "MyRemoteClientListener", "intellij.terminal.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendTerminalHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendTerminalHost.kt\ncom/jetbrains/rdserver/terminal/BackendTerminalHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,311:1\n23#2:312\n13#2:313\n1807#3,3:314\n*S KotlinDebug\n*F\n+ 1 BackendTerminalHost.kt\ncom/jetbrains/rdserver/terminal/BackendTerminalHost\n*L\n90#1:312\n242#1:313\n177#1:314,3\n*E\n"})
public final class BackendTerminalHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private final HashSet<String> bindSessions;
    @NotNull
    private final String terminalToolWindowPortLabel;
    private final byte newlineByte;
    private boolean hasRunningCommandsErrorAlreadyReported;

    public BackendTerminalHost(@NotNull ClientProjectSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.bindSessions = new HashSet();
        this.terminalToolWindowPortLabel = "terminalToolWindowPort";
        this.newlineByte = (byte)10;
    }

    private final TerminalModel getTerminalModel() {
        return TerminalModel_GeneratedKt.getTerminalModel((Solution)RemoteSessionKt.getProtocolModel((ClientProjectSession)this.session));
    }

    private final SessionPortForwarding setupPortForwarding(Lifetime lifetime, BackendTtyConnector connector, ShellTerminalWidget widget) {
        Long l;
        try {
            Object object = widget.getProcessTtyConnector();
            l = object != null && (object = object.getProcess()) != null ? Long.valueOf(((Process)object).pid()) : null;
        }
        catch (UnsupportedOperationException ignored) {
            l = null;
        }
        Long shellPid = l;
        if (shellPid == null) {
            BackendTerminalHost $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(BackendTerminalHost.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("shell pid is null -> port forwarding will not work");
            return null;
        }
        PortForwardingSessionData portForwardingSessionData = PortForwardingSessionUtils.INSTANCE.setupPortForwardingSession(lifetime, this.session.getAppSession(), shellPid.longValue(), this.terminalToolWindowPortLabel, false);
        if (portForwardingSessionData == null) {
            return null;
        }
        PortForwardingSessionData sessionAndPortsWatcher = portForwardingSessionData;
        connector.getOutput().advise(lifetime, arg_0 -> BackendTerminalHost.setupPortForwarding$lambda$0(this, sessionAndPortsWatcher, arg_0));
        return sessionAndPortsWatcher.getSession();
    }

    public final boolean isSessionBound(@NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        return this.bindSessions.contains(sessionId);
    }

    public final void bind(@NotNull ShellTerminalWidget widget, @NotNull BackendTtyConnector connector) {
        RdTerminalSession sessionModel;
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        String string = connector.getSessionId();
        if (string == null) {
            return;
        }
        String sessionId = string;
        if (ClientPermissionManager.Companion.getInstance(this.session).getTerminalAccess() == TerminalAccessLevel.Disabled) {
            return;
        }
        Lifetime lifetime = RLifetimeKt.intersect((Lifetime)this.getServiceLifetime(), (Lifetime)connector.getLifetime());
        RdTerminalSession existingTerminalSession = (RdTerminalSession)this.getTerminalModel().getSessions().get((Object)sessionId);
        RdTerminalSession rdTerminalSession = existingTerminalSession;
        if (rdTerminalSession == null) {
            RdTerminalSession rdTerminalSession2;
            RdTerminalSession $this$bind_u24lambda_u240 = rdTerminalSession2 = new RdTerminalSession(RdTerminalSessionOrigin.Host, null);
            boolean bl = false;
            IProperty iProperty = $this$bind_u24lambda_u240.getTitle();
            TerminalTitle terminalTitle = widget.getTerminalTitle();
            Intrinsics.checkNotNullExpressionValue((Object)terminalTitle, (String)"getTerminalTitle(...)");
            iProperty.set((Object)this.fromTerminalTitle(RdTerminalTitle.Companion, terminalTitle));
            ((Map)this.getTerminalModel().getSessions()).put(sessionId, $this$bind_u24lambda_u240);
            rdTerminalSession = sessionModel = rdTerminalSession2;
        }
        if (existingTerminalSession != null && this.bindSessions.contains(sessionId)) {
            return;
        }
        this.bindSessions.add(sessionId);
        widget.getTerminalTitle().change(BackendTerminalHost::bind$lambda$1);
        TerminalTitle terminalTitle = widget.getTerminalTitle();
        Intrinsics.checkNotNullExpressionValue((Object)terminalTitle, (String)"getTerminalTitle(...)");
        this.bindTerminalTitle(terminalTitle, lifetime, (IProperty<RdTerminalTitle>)sessionModel.getTitle());
        TerminalContainer terminalContainer = TerminalToolWindowManager.getInstance((Project)widget.getProject()).getContainer(widget.asNewWidget());
        if (terminalContainer != null) {
            TerminalContainer it = terminalContainer;
            boolean bl = false;
            Content content = it.getContent();
            Intrinsics.checkNotNullExpressionValue((Object)content, (String)"getContent(...)");
            Content content2 = content;
            PropertyChangeListener listener = arg_0 -> BackendTerminalHost.bind$lambda$2$0(widget, arg_0);
            content2.addPropertyChangeListener(listener);
            lifetime.onTermination(() -> BackendTerminalHost.bind$lambda$2$1(content2, listener));
        }
        connector.getClosed().advise(lifetime, arg_0 -> BackendTerminalHost.bind$lambda$3(sessionModel, arg_0));
        if (this.session.isController()) {
            BoolPropertyExKt.whenTrue((IViewable)((IViewable)sessionModel.getClosed()), (Lifetime)lifetime, arg_0 -> BackendTerminalHost.bind$lambda$4(connector, arg_0));
        }
        sessionModel.getInput().advise(lifetime, arg_0 -> BackendTerminalHost.bind$lambda$5(this, widget, connector, arg_0));
        LifetimeDefinition initialSyncLifetimeDef = lifetime.createNested();
        Lifetime initialSyncLifetime = initialSyncLifetimeDef.getLifetime();
        BoolPropertyExKt.whenTrue((IViewable)((IViewable)sessionModel.getOutputConnected()), (Lifetime)initialSyncLifetime, arg_0 -> BackendTerminalHost.bind$lambda$6(this, sessionModel, widget, connector, lifetime, initialSyncLifetimeDef, arg_0));
        SessionPortForwarding terminalSessionPortForwarding = this.setupPortForwarding(connector.getLifetime(), connector, widget);
        sessionModel.getPortForwardingSession().set((Object)terminalSessionPortForwarding);
        this.syncTerminalSize(widget, sessionModel);
        this.syncTerminalScrolling(widget, sessionModel, sessionId);
    }

    private final RdTerminalTitle fromTerminalTitle(RdTerminalTitle.Companion $this$fromTerminalTitle, TerminalTitle terminalTitle) {
        String string = terminalTitle.getUserDefinedTitle();
        String string2 = terminalTitle.getApplicationTitle();
        String string3 = terminalTitle.getDefaultTitle();
        if (string3 == null) {
            String string4 = ExecutionBundle.message((String)"terminal.default.title", (Object[])new Object[0]);
            string3 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        }
        return new RdTerminalTitle(string, string2, string3);
    }

    private final RdTerminalSize fromTerminalSize(RdTerminalSize.Companion $this$fromTerminalSize, TermSize termSize) {
        return new RdTerminalSize(termSize.getColumns(), termSize.getRows());
    }

    private final void bindTerminalTitle(TerminalTitle $this$bindTerminalTitle, Lifetime lifetime, IProperty<RdTerminalTitle> property) {
        property.set((Object)this.fromTerminalTitle(RdTerminalTitle.Companion, $this$bindTerminalTitle));
        SourceExKt.advise((ISource)((ISource)property), (Lifetime)lifetime, (arg_0, arg_1) -> BackendTerminalHost.bindTerminalTitle$lambda$0($this$bindTerminalTitle, arg_0, arg_1));
        $this$bindTerminalTitle.addTitleListener(new TerminalTitleListener(this, property){
            final /* synthetic */ BackendTerminalHost this$0;
            final /* synthetic */ IProperty<RdTerminalTitle> $property;
            {
                this.this$0 = $receiver;
                this.$property = $property;
            }

            public void onTitleChanged(TerminalTitle terminalTitle) {
                Intrinsics.checkNotNullParameter((Object)terminalTitle, (String)"terminalTitle");
                RdTerminalTitle rdTerminalTitle = BackendTerminalHost.access$fromTerminalTitle(this.this$0, RdTerminalTitle.Companion, terminalTitle);
                ApplicationKt.getApplication().invokeLater(() -> bindTerminalTitle.2.onTitleChanged$lambda$0(this.$property, rdTerminalTitle));
            }

            private static final void onTitleChanged$lambda$0(IProperty $property, RdTerminalTitle $rdTerminalTitle) {
                $property.set((Object)$rdTerminalTitle);
            }
        }, LifetimeDisposableExKt.createNestedDisposable((Lifetime)lifetime, (String)"backend terminal host"));
    }

    private final boolean hasRunningCommandsSafe(ShellTerminalWidget $this$hasRunningCommandsSafe) {
        try {
            return $this$hasRunningCommandsSafe.hasRunningCommands();
        }
        catch (Throwable ex) {
            if (!this.hasRunningCommandsErrorAlreadyReported) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(BackendTerminalHost.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn(ex);
                this.hasRunningCommandsErrorAlreadyReported = true;
            }
            return false;
        }
    }

    private final void syncTerminalSize(ShellTerminalWidget widget, RdTerminalSession model) {
        if (model.getOrigin() == RdTerminalSessionOrigin.Client) {
            SourceExKt.advise((ISource)((ISource)model.getSize()), (Lifetime)this.getServiceLifetime(), (arg_0, arg_1) -> BackendTerminalHost.syncTerminalSize$lambda$0(widget, arg_0, arg_1));
        } else {
            IOptProperty iOptProperty = model.getSize();
            TermSize termSize = widget.getTerminal().getSize();
            Intrinsics.checkNotNullExpressionValue((Object)termSize, (String)"getSize(...)");
            iOptProperty.set((Object)this.fromTerminalSize(RdTerminalSize.Companion, termSize));
            TerminalResizeListener resizeListener2 = new TerminalResizeListener(model, this, widget){
                final /* synthetic */ RdTerminalSession $model;
                final /* synthetic */ BackendTerminalHost this$0;
                final /* synthetic */ ShellTerminalWidget $widget;
                {
                    this.$model = $model;
                    this.this$0 = $receiver;
                    this.$widget = $widget;
                }

                public void onResize(TermSize oldTermSize, TermSize newTermSize) {
                    Intrinsics.checkNotNullParameter((Object)oldTermSize, (String)"oldTermSize");
                    Intrinsics.checkNotNullParameter((Object)newTermSize, (String)"newTermSize");
                    IOptProperty iOptProperty = this.$model.getSize();
                    TermSize termSize = this.$widget.getTerminal().getSize();
                    Intrinsics.checkNotNullExpressionValue((Object)termSize, (String)"getSize(...)");
                    iOptProperty.set((Object)BackendTerminalHost.access$fromTerminalSize(this.this$0, RdTerminalSize.Companion, termSize));
                }
            };
            widget.getTerminal().addResizeListener(resizeListener2);
            this.getServiceLifetime().onTermination(() -> BackendTerminalHost.syncTerminalSize$lambda$1(widget, resizeListener2));
        }
    }

    private final void syncTerminalScrolling(ShellTerminalWidget widget, RdTerminalSession model, String id) {
        BoundedRangeModel boundedRangeModel = widget.getTerminalPanel().getVerticalScrollModel();
        Intrinsics.checkNotNullExpressionValue((Object)boundedRangeModel, (String)"getVerticalScrollModel(...)");
        BoundedRangeModel verticalScrollModel = boundedRangeModel;
        ClientFollowMeManager followMeManager = ClientFollowMeManager.Companion.getInstance(this.session);
        verticalScrollModel.addChangeListener(arg_0 -> BackendTerminalHost.syncTerminalScrolling$lambda$0(followMeManager, model, verticalScrollModel, arg_0));
        SourceExKt.advise((ISource)((ISource)model.getScroll()), (Lifetime)this.getServiceLifetime(), (arg_0, arg_1) -> BackendTerminalHost.syncTerminalScrolling$lambda$1(followMeManager, verticalScrollModel, id, arg_0, arg_1));
    }

    private static final Unit setupPortForwarding$lambda$0(BackendTerminalHost this$0, PortForwardingSessionData $sessionAndPortsWatcher, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.contains(this$0.newlineByte)) {
            $sessionAndPortsWatcher.getWatcher().resetDelay();
        }
        return Unit.INSTANCE;
    }

    private static final void bind$lambda$2$0(ShellTerminalWidget $widget, PropertyChangeEvent event) {
        if (Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"displayName")) {
            Project project = $widget.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            UserFocusManager.Companion.getInstance(project).updateCurrentFocus();
        }
    }

    private static final Unit bind$lambda$2$1(Content $content, PropertyChangeListener $listener) {
        $content.removePropertyChangeListener($listener);
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$6$0(BackendTerminalHost this$0, RdTerminalSession $sessionModel, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (ClientPermissionManager.Companion.getInstance(this$0.session).getTerminalAccess() != TerminalAccessLevel.Disabled) {
            $sessionModel.getOutput().fire((Object)it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$1(TerminalTitle.State $this$change) {
        Intrinsics.checkNotNullParameter((Object)$this$change, (String)"$this$change");
        $this$change.setTrackTerminalApplicationTitleChanges(Boolean.valueOf(true));
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$3(RdTerminalSession $sessionModel, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $sessionModel.getClosed().set((Object)true);
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$4(BackendTtyConnector $connector, Lifetime it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $connector.getConnector().close();
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$5(BackendTerminalHost this$0, ShellTerminalWidget $widget, BackendTtyConnector $connector, List bytes) {
        boolean bl;
        byte[] byteArray;
        block7: {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            TerminalAccessLevel accessLevel = ClientPermissionManager.Companion.getInstance(this$0.session).getTerminalAccess();
            if (accessLevel != TerminalAccessLevel.FullAccess) {
                return Unit.INSTANCE;
            }
            if (this$0.session.isController()) {
                UnattendedHostActivityTracker.Companion.getInstance().controllerActivity();
            }
            byteArray = CollectionsKt.toByteArray((Collection)bytes);
            Iterable $this$any$iv = bytes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    byte it = ((Number)element$iv).byteValue();
                    boolean bl2 = false;
                    if (!(it == 13)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        boolean enterPressed = bl && !this$0.hasRunningCommandsSafe($widget);
        $connector.write(byteArray);
        if (enterPressed) {
            $widget.handleEnterPressed();
        } else {
            $widget.handleAnyKeyPressed();
        }
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$6(BackendTerminalHost this$0, RdTerminalSession $sessionModel, ShellTerminalWidget $widget, BackendTtyConnector $connector, Lifetime $lifetime, LifetimeDefinition $initialSyncLifetimeDef, Lifetime it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (ClientPermissionManager.Companion.getInstance(this$0.session).getTerminalAccess() != TerminalAccessLevel.Disabled) {
            $sessionModel.getInitialState().set((Object)TerminalWidgetConverterKt.createScreenStateModel((JediTermWidget)((JediTermWidget)$widget)));
        }
        $connector.getOutput().advise($lifetime, arg_0 -> BackendTerminalHost.bind$lambda$6$0(this$0, $sessionModel, arg_0));
        LifetimeDefinition.terminate$default((LifetimeDefinition)$initialSyncLifetimeDef, (boolean)false, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit bindTerminalTitle$lambda$0$0(RdTerminalTitle $title, TerminalTitle.State $this$change) {
        Intrinsics.checkNotNullParameter((Object)$this$change, (String)"$this$change");
        RdTerminalTitle rdTerminalTitle = $title;
        $this$change.setUserDefinedTitle(rdTerminalTitle != null ? rdTerminalTitle.getUserDefinedTitle() : null);
        return Unit.INSTANCE;
    }

    private static final Unit bindTerminalTitle$lambda$0(TerminalTitle $this_bindTerminalTitle, RdTerminalTitle title, RdEventSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (source == RdEventSource.Local) {
            return Unit.INSTANCE;
        }
        $this_bindTerminalTitle.change(arg_0 -> BackendTerminalHost.bindTerminalTitle$lambda$0$0(title, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit syncTerminalSize$lambda$0(ShellTerminalWidget $widget, RdTerminalSize clientSize, RdEventSource source) {
        Intrinsics.checkNotNullParameter((Object)clientSize, (String)"clientSize");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (source == RdEventSource.Local || clientSize.getWidth() == 0 || clientSize.getHeight() == 0) {
            return Unit.INSTANCE;
        }
        int width = clientSize.getWidth() > 0 ? clientSize.getWidth() : $widget.getTerminal().getTerminalWidth();
        int height = clientSize.getHeight() > 0 ? clientSize.getHeight() : $widget.getTerminal().getTerminalHeight();
        TermSize termSize = new TermSize(width, height);
        $widget.getTerminal().resize(termSize, RequestOrigin.User);
        $widget.getTtyConnector().resize(termSize);
        return Unit.INSTANCE;
    }

    private static final Unit syncTerminalSize$lambda$1(ShellTerminalWidget $widget, syncTerminalSize.resizeListener.1 $resizeListener) {
        $widget.getTerminal().removeResizeListener((TerminalResizeListener)$resizeListener);
        return Unit.INSTANCE;
    }

    private static final void syncTerminalScrolling$lambda$0(ClientFollowMeManager $followMeManager, RdTerminalSession $model, BoundedRangeModel $verticalScrollModel, ChangeEvent it) {
        if ($followMeManager.isFollowingHost()) {
            $model.getScroll().set((Object)$verticalScrollModel.getValue());
        }
    }

    private static final Unit syncTerminalScrolling$lambda$1(ClientFollowMeManager $followMeManager, BoundedRangeModel $verticalScrollModel, String $id, int clientScroll, RdEventSource origin) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        if (origin != RdEventSource.Remote) {
            return Unit.INSTANCE;
        }
        if ($followMeManager.isFollowedByHost()) {
            $verticalScrollModel.setValue(clientScroll);
        }
        for (ClientProjectSession followerSession : $followMeManager.getFollowerSessions()) {
            if (followerSession.isLocal()) continue;
            RdTerminalSession followerTerminalSessionModel = (RdTerminalSession)Companion.getInstance(followerSession).getTerminalModel().getSessions().get((Object)$id);
            RdTerminalSession rdTerminalSession = followerTerminalSessionModel;
            if (rdTerminalSession == null || (rdTerminalSession = rdTerminalSession.getScroll()) == null) continue;
            rdTerminalSession.set((Object)clientScroll);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ RdTerminalTitle access$fromTerminalTitle(BackendTerminalHost $this, RdTerminalTitle.Companion $receiver, TerminalTitle terminalTitle) {
        return $this.fromTerminalTitle($receiver, terminalTitle);
    }

    public static final /* synthetic */ RdTerminalSize access$fromTerminalSize(BackendTerminalHost $this, RdTerminalSize.Companion $receiver, TermSize termSize) {
        return $this.fromTerminalSize($receiver, termSize);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/terminal/BackendTerminalHost$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rdserver/terminal/BackendTerminalHost;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "intellij.terminal.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendTerminalHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendTerminalHost.kt\ncom/jetbrains/rdserver/terminal/BackendTerminalHost$Companion\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n*L\n1#1,311:1\n23#2:312\n*S KotlinDebug\n*F\n+ 1 BackendTerminalHost.kt\ncom/jetbrains/rdserver/terminal/BackendTerminalHost$Companion\n*L\n40#1:312\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BackendTerminalHost getInstance(@NotNull ClientProjectSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ClientSession $this$service$iv = (ClientSession)session;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(BackendTerminalHost.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
            }
            return (BackendTerminalHost)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdserver/terminal/BackendTerminalHost$MyProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/codeWithMe/model/TerminalModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.terminal.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendTerminalHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendTerminalHost.kt\ncom/jetbrains/rdserver/terminal/BackendTerminalHost$MyProtocolListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,311:1\n777#2:312\n873#2,2:313\n*S KotlinDebug\n*F\n+ 1 BackendTerminalHost.kt\ncom/jetbrains/rdserver/terminal/BackendTerminalHost$MyProtocolListener\n*L\n54#1:312\n54#1:313,2\n*E\n"})
    public static final class MyProtocolListener
    implements SolutionExtListener<TerminalModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull TerminalModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            model.getSessions().view(lifetime, (arg_0, arg_1, arg_2) -> MyProtocolListener.extensionCreated$lambda$0(session, arg_0, arg_1, arg_2));
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit extensionCreated$lambda$0(ClientProjectSession $session, Lifetime lifetime, String sessionId, RdTerminalSession terminalSession) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            Intrinsics.checkNotNullParameter((Object)terminalSession, (String)"terminalSession");
            if (terminalSession.getOrigin() == RdTerminalSessionOrigin.Host) {
                return Unit.INSTANCE;
            }
            TerminalAccessLevel accessLevel = ClientPermissionManager.Companion.getInstance($session).getTerminalAccess();
            if (accessLevel != TerminalAccessLevel.FullAccess) {
                return Unit.INSTANCE;
            }
            Set set = TerminalToolWindowManager.getInstance((Project)$session.getProject()).getTerminalWidgets();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getTerminalWidgets(...)");
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TerminalWidget it = (TerminalWidget)element$iv$iv;
                boolean bl = false;
                if (!(ShellTerminalWidget.asShellJediTermWidget((TerminalWidget)it) != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List widgets = (List)destination$iv$iv;
            for (TerminalWidget widget : widgets) {
                BackendTtyConnector connector;
                TtyConnector ttyConnector = widget.getTtyConnector();
                BackendTtyConnector backendTtyConnector = ttyConnector instanceof BackendTtyConnector ? (BackendTtyConnector)ttyConnector : null;
                if (backendTtyConnector == null || !Intrinsics.areEqual((Object)(connector = backendTtyConnector).getSessionId(), (Object)sessionId)) continue;
                BackendTerminalHost backendTerminalHost = Companion.getInstance($session);
                ShellTerminalWidget shellTerminalWidget = ShellTerminalWidget.asShellJediTermWidget((TerminalWidget)widget);
                Intrinsics.checkNotNull((Object)shellTerminalWidget);
                backendTerminalHost.bind(shellTerminalWidget, connector);
                return Unit.INSTANCE;
            }
            BackendTerminalManager.Companion.getInstance($session.getProject()).createWidgetForSpecificId(sessionId, null, terminalSession.getShellCommand());
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdserver/terminal/BackendTerminalHost$MyRemoteClientListener;", "Lcom/jetbrains/rdserver/core/RemoteClientSessionListener;", "<init>", "()V", "projectSessionInitialized", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "intellij.terminal.backend.split"})
    public static final class MyRemoteClientListener
    implements RemoteClientSessionListener {
        public void projectSessionInitialized(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            BackendTerminalManager.Companion.getInstance(session.getProject()).connectClientToAllTerminals(session);
        }
    }
}

