/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.debugger.impl.rpc;

import com.intellij.ide.rpc.FrontendDocumentId;
import com.intellij.platform.debugger.impl.rpc.LanguageDto;
import com.intellij.platform.debugger.impl.rpc.XDebugSessionApi;
import com.intellij.platform.debugger.impl.rpc.XDebugSessionDataId;
import com.intellij.platform.debugger.impl.rpc.XDebugSessionId;
import com.intellij.platform.debugger.impl.rpc.XDebuggerEditorsProviderId;
import com.intellij.platform.debugger.impl.rpc.XExecutionStackId;
import com.intellij.platform.debugger.impl.rpc.XExecutionStacksEvent;
import com.intellij.platform.debugger.impl.rpc.XExpressionDocumentDto;
import com.intellij.platform.debugger.impl.rpc.XExpressionDto;
import com.intellij.platform.debugger.impl.rpc.XSmartStepIntoTargetDto;
import com.intellij.platform.debugger.impl.rpc.XSmartStepIntoTargetId;
import com.intellij.platform.debugger.impl.rpc.XSourcePositionDto;
import com.intellij.platform.debugger.impl.rpc.XStackFrameId;
import com.intellij.platform.debugger.impl.rpc.XSuspendContextId;
import com.intellij.platform.project.ProjectId;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=3, xi=48)
@ApiStatus.Internal
public final class XDebugSessionApiClientStub
implements XDebugSessionApi {
    @NotNull
    private Function3<String, Object[], Continuation<Object>, Object> invocationHandler;

    public XDebugSessionApiClientStub(@NotNull Function3<? super String, ? super Object[], ? super Continuation<Object>, ? extends Object> invocationHandler) {
        Intrinsics.checkNotNullParameter(invocationHandler, (String)"invocationHandler");
        this.invocationHandler = invocationHandler;
    }

    @NotNull
    public final Function3<String, Object[], Continuation<Object>, Object> getInvocationHandler() {
        return this.invocationHandler;
    }

    @Override
    @Nullable
    public final Object createDocument(@NotNull FrontendDocumentId frontendDocumentId, @NotNull XDebugSessionId sessionId, @NotNull XExpressionDto expression, @Nullable XSourcePositionDto sourcePosition, @NotNull EvaluationMode evaluationMode, @NotNull Continuation<? super XExpressionDocumentDto> $completion) {
        Object[] objectArray = new Object[]{frontendDocumentId, sessionId, expression, sourcePosition, evaluationMode};
        return this.invocationHandler.invoke((Object)"createDocument", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object supportedLanguages(@NotNull ProjectId projectId, @NotNull XDebuggerEditorsProviderId editorsProviderId, @Nullable XSourcePositionDto sourcePositionDto, @NotNull Continuation<? super List<LanguageDto>> $completion) {
        Object[] objectArray = new Object[]{projectId, editorsProviderId, sourcePositionDto};
        return this.invocationHandler.invoke((Object)"supportedLanguages", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object getAlternativeSourceKindFlow(@NotNull XDebugSessionId sessionId, @NotNull Continuation<? super Flow<Boolean>> $completion) {
        Object[] objectArray = new Object[]{sessionId};
        return this.invocationHandler.invoke((Object)"getAlternativeSourceKindFlow", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object resume(@NotNull XDebugSessionId sessionId, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{sessionId};
        return this.invocationHandler.invoke((Object)"resume", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object pause(@NotNull XDebugSessionId sessionId, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{sessionId};
        return this.invocationHandler.invoke((Object)"pause", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object stepOver(@NotNull XDebugSessionId sessionId, boolean ignoreBreakpoints, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{sessionId, Boxing.boxBoolean((boolean)ignoreBreakpoints)};
        return this.invocationHandler.invoke((Object)"stepOver", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object stepOut(@NotNull XDebugSessionId sessionId, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{sessionId};
        return this.invocationHandler.invoke((Object)"stepOut", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object stepInto(@NotNull XDebugSessionId sessionId, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{sessionId};
        return this.invocationHandler.invoke((Object)"stepInto", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object smartStepInto(@NotNull XSmartStepIntoTargetId smartStepTargetId, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{smartStepTargetId};
        return this.invocationHandler.invoke((Object)"smartStepInto", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object smartStepIntoEmpty(@NotNull XDebugSessionId sessionId, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{sessionId};
        return this.invocationHandler.invoke((Object)"smartStepIntoEmpty", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object computeSmartStepTargets(@NotNull XDebugSessionId sessionId, @NotNull Continuation<? super List<XSmartStepIntoTargetDto>> $completion) {
        Object[] objectArray = new Object[]{sessionId};
        return this.invocationHandler.invoke((Object)"computeSmartStepTargets", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object computeStepTargets(@NotNull XDebugSessionId sessionId, @NotNull Continuation<? super List<XSmartStepIntoTargetDto>> $completion) {
        Object[] objectArray = new Object[]{sessionId};
        return this.invocationHandler.invoke((Object)"computeStepTargets", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object forceStepInto(@NotNull XDebugSessionId sessionId, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{sessionId};
        return this.invocationHandler.invoke((Object)"forceStepInto", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object runToPosition(@NotNull XDebugSessionId sessionId, @NotNull XSourcePositionDto sourcePositionDto, boolean ignoreBreakpoints, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{sessionId, sourcePositionDto, Boxing.boxBoolean((boolean)ignoreBreakpoints)};
        return this.invocationHandler.invoke((Object)"runToPosition", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object triggerUpdate(@NotNull XDebugSessionId sessionId, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{sessionId};
        return this.invocationHandler.invoke((Object)"triggerUpdate", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object setCurrentStackFrame(@NotNull XDebugSessionId sessionId, @NotNull XExecutionStackId executionStackId, @NotNull XStackFrameId frameId, boolean isTopFrame, boolean changedByUser, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{sessionId, executionStackId, frameId, Boxing.boxBoolean((boolean)isTopFrame), Boxing.boxBoolean((boolean)changedByUser)};
        return this.invocationHandler.invoke((Object)"setCurrentStackFrame", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object computeExecutionStacks(@NotNull XSuspendContextId suspendContextId, @NotNull Continuation<? super Flow<? extends XExecutionStacksEvent>> $completion) {
        Object[] objectArray = new Object[]{suspendContextId};
        return this.invocationHandler.invoke((Object)"computeExecutionStacks", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object computeRunningExecutionStacks(@NotNull XDebugSessionId sessionId, @NotNull Continuation<? super Flow<? extends XExecutionStacksEvent>> $completion) {
        Object[] objectArray = new Object[]{sessionId};
        return this.invocationHandler.invoke((Object)"computeRunningExecutionStacks", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object muteBreakpoints(@NotNull XDebugSessionDataId sessionDataId, boolean muted, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{sessionDataId, Boxing.boxBoolean((boolean)muted)};
        return this.invocationHandler.invoke((Object)"muteBreakpoints", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object getUiUpdateEventsFlow(@NotNull XDebugSessionId sessionId, @NotNull Continuation<? super Flow<Unit>> $completion) {
        Object[] objectArray = new Object[]{sessionId};
        return this.invocationHandler.invoke((Object)"getUiUpdateEventsFlow", (Object)objectArray, $completion);
    }
}

