/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml;

import com.intellij.platform.ml.MutableEnvironment;
import com.intellij.platform.ml.MutableEnvironmentKt;
import com.intellij.platform.ml.Tier;
import com.intellij.platform.ml.TierInstance;
import com.intellij.platform.ml.TierKt;
import com.intellij.platform.ml.environment.Environment;
import com.intellij.platform.ml.environment.EnvironmentKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00100\r\"\b\b\u0000\u0010\u0010*\u00020\u0007\"\b\b\u0001\u0010\u0011*\u00020\u0007*\b\u0012\u0004\u0012\u0002H\u00100\u00062\u0006\u0010\u0012\u001a\u0002H\u0011H\u0082\u0004\u00a2\u0006\u0002\u0010\u0013J%\u0010\u0014\u001a\u0002H\u0010\"\b\b\u0000\u0010\u0010*\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0006H\u0016\u00a2\u0006\u0002\u0010\u0016J-\u0010\u0017\u001a\u00020\u0018\"\b\b\u0000\u0010\u0010*\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00062\u0006\u0010\u0019\u001a\u0002H\u0010H\u0016\u00a2\u0006\u0002\u0010\u001aR\u001e\u0010\u0004\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/platform/ml/TierInstanceStorage;", "Lcom/intellij/platform/ml/MutableEnvironment;", "<init>", "()V", "instances", "", "Lcom/intellij/platform/ml/Tier;", "", "tiers", "", "getTiers", "()Ljava/util/Set;", "tierInstances", "Lcom/intellij/platform/ml/TierInstance;", "getTierInstances", "withUnsafe", "T", "P", "value", "(Lcom/intellij/platform/ml/Tier;Ljava/lang/Object;)Lcom/intellij/platform/ml/TierInstance;", "getInstance", "tier", "(Lcom/intellij/platform/ml/Tier;)Ljava/lang/Object;", "putTierInstance", "", "instance", "(Lcom/intellij/platform/ml/Tier;Ljava/lang/Object;)V", "Companion", "intellij.platform.ml"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTierInstanceStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TierInstanceStorage.kt\ncom/intellij/platform/ml/TierInstanceStorage\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,69:1\n129#2:70\n158#2,3:71\n*S KotlinDebug\n*F\n+ 1 TierInstanceStorage.kt\ncom/intellij/platform/ml/TierInstanceStorage\n*L\n21#1:70\n21#1:71,3\n*E\n"})
public final class TierInstanceStorage
implements MutableEnvironment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Tier<?>, Object> instances = new LinkedHashMap();

    @Override
    @NotNull
    public Set<Tier<?>> getTiers() {
        return this.instances.keySet();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<TierInstance<?>> getTierInstances() {
        void $this$mapTo$iv$iv;
        Map<Tier<?>, Object> $this$map$iv = this.instances;
        boolean $i$f$map = false;
        Map<Tier<?>, Object> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Tier tier = (Tier)entry.getKey();
            Object tierInstance = entry.getValue();
            collection.add(this.withUnsafe(tier, tierInstance));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final <T, P> TierInstance<T> withUnsafe(Tier<T> $this$withUnsafe, P value) {
        Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type T of com.intellij.platform.ml.TierInstanceStorage.withUnsafe");
        return TierKt.with($this$withUnsafe, value);
    }

    @Override
    @NotNull
    public <T> T getInstance(@NotNull Tier<T> tier) {
        Object tierInstance;
        Intrinsics.checkNotNullParameter(tier, (String)"tier");
        Object object = tierInstance = this.instances.get(tier);
        if (object == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of com.intellij.platform.ml.TierInstanceStorage.getInstance");
        return (T)object;
    }

    @Override
    public <T> void putTierInstance(@NotNull Tier<T> tier, @NotNull T instance) {
        Intrinsics.checkNotNullParameter(tier, (String)"tier");
        Intrinsics.checkNotNullParameter(instance, (String)"instance");
        if (!(!this.contains(tier))) {
            boolean bl = false;
            String string = "Tier " + tier + " is already registered in the storage. Old value: '" + this.instances.get(tier) + "', new value: '" + instance + "'";
            throw new IllegalArgumentException(string.toString());
        }
        this.instances.put(tier, instance);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/ml/TierInstanceStorage$Companion;", "", "<init>", "()V", "copyOf", "Lcom/intellij/platform/ml/TierInstanceStorage;", "environment", "Lcom/intellij/platform/ml/environment/Environment;", "joined", "environments", "", "intellij.platform.ml"})
    @SourceDebugExtension(value={"SMAP\nTierInstanceStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TierInstanceStorage.kt\ncom/intellij/platform/ml/TierInstanceStorage$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1915#2,2:70\n1915#2:72\n1915#2,2:73\n1916#2:75\n*S KotlinDebug\n*F\n+ 1 TierInstanceStorage.kt\ncom/intellij/platform/ml/TierInstanceStorage$Companion\n*L\n48#1:70,2\n59#1:72\n60#1:73,2\n59#1:75\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TierInstanceStorage copyOf(@NotNull Environment environment) {
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            TierInstanceStorage storage = new TierInstanceStorage();
            Iterable $this$forEach$iv = environment.getTiers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Tier it = (Tier)element$iv;
                boolean bl = false;
                com.intellij.platform.ml.TierInstanceStorage$Companion.copyOf$putInstance(storage, environment, it);
            }
            return storage;
        }

        @NotNull
        public final Environment joined(@NotNull Iterable<? extends Environment> environments) {
            Intrinsics.checkNotNullParameter(environments, (String)"environments");
            TierInstanceStorage commonStorage = new TierInstanceStorage();
            Iterable<? extends Environment> $this$forEach$iv = environments;
            boolean $i$f$forEach = false;
            Iterator<? extends Environment> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Environment element$iv;
                Environment environment = element$iv = iterator.next();
                boolean bl = false;
                Iterable $this$forEach$iv2 = environment.getTiers();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Tier tier = (Tier)element$iv2;
                    boolean bl2 = false;
                    com.intellij.platform.ml.TierInstanceStorage$Companion.joined$putCapturingType(commonStorage, tier, environment);
                }
            }
            return commonStorage;
        }

        private static final <T> void copyOf$putInstance(TierInstanceStorage storage, Environment $environment, Tier<T> tier) {
            MutableEnvironmentKt.set(storage, tier, EnvironmentKt.get($environment, tier));
        }

        private static final <T> void joined$putCapturingType(TierInstanceStorage commonStorage, Tier<T> tier, Environment environment) {
            MutableEnvironmentKt.set(commonStorage, tier, EnvironmentKt.get(environment, tier));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

