/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.ir;

import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.rml.dfa.ir.IrLocationKind;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u000e\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002BI\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\r\u00a2\u0006\u0004\b\u000e\u0010\u000fB\u0011\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u0011J\u0012\u0010\u001f\u001a\n  *\u0004\u0018\u00010\u00040\u0004H\u0096\u0080\u0004J\u0006\u0010!\u001a\u00020\u0004J\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u0004\u0018\u00010\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u0000H\u0096\u0082\u0004J\u0014\u0010'\u001a\u00020#2\b\u0010&\u001a\u0004\u0018\u00010(H\u0096\u0082\u0004J\u000e\u0010)\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0000J\u0016\u0010)\u001a\u00020#2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0006J\n\u0010+\u001a\u00020\u0006H\u0096\u0080\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001d\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00000\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006,"}, d2={"Lcom/intellij/rml/dfa/ir/IrLocation;", "", "Lcom/intellij/openapi/util/UserDataHolderBase;", "filePath", "", "offset1", "", "offset2", "line", "col", "kind", "Lcom/intellij/rml/dfa/ir/IrLocationKind;", "locations", "", "<init>", "(Ljava/lang/String;IIIILcom/intellij/rml/dfa/ir/IrLocationKind;Ljava/util/Collection;)V", "name", "(Ljava/lang/String;)V", "getFilePath", "()Ljava/lang/String;", "getOffset1", "()I", "getOffset2", "getLine", "getCol", "getKind", "()Lcom/intellij/rml/dfa/ir/IrLocationKind;", "containedLocations", "", "getContainedLocations", "()Ljava/util/Map;", "toString", "kotlin.jvm.PlatformType", "toLongString", "isStub", "", "getLocationByType", "compareTo", "other", "equals", "", "contains", "offset", "hashCode", "intellij.rml.dfa"})
@SourceDebugExtension(value={"SMAP\nIrLocation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrLocation.kt\ncom/intellij/rml/dfa/ir/IrLocation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1220#2,2:76\n1249#2,4:78\n1915#2,2:82\n*S KotlinDebug\n*F\n+ 1 IrLocation.kt\ncom/intellij/rml/dfa/ir/IrLocation\n*L\n28#1:76,2\n28#1:78,4\n63#1:82,2\n*E\n"})
public final class IrLocation
extends UserDataHolderBase
implements Comparable<IrLocation> {
    @NotNull
    private final String filePath;
    private final int offset1;
    private final int offset2;
    private final int line;
    private final int col;
    @NotNull
    private final IrLocationKind kind;
    @NotNull
    private final Map<IrLocationKind, IrLocation> containedLocations;

    /*
     * WARNING - void declaration
     */
    public IrLocation(@NotNull String filePath, int offset1, int offset2, int line, int col, @NotNull IrLocationKind kind, @NotNull Collection<IrLocation> locations) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter(locations, (String)"locations");
        this.filePath = filePath;
        this.offset1 = offset1;
        this.offset2 = offset2;
        this.line = line;
        this.col = col;
        this.kind = kind;
        IrLocation irLocation = this;
        if (!locations.isEmpty()) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            Iterable iterable = locations;
            IrLocation irLocation2 = irLocation;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void var11_12 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                IrLocation irLocation3 = (IrLocation)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                map2.put(it.kind, element$iv$iv);
            }
            map = destination$iv$iv;
            irLocation = irLocation2;
        } else {
            map = MapsKt.emptyMap();
        }
        irLocation.containedLocations = map;
    }

    public /* synthetic */ IrLocation(String string, int n, int n2, int n3, int n4, IrLocationKind irLocationKind, Collection collection, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 0x20) != 0) {
            irLocationKind = IrLocationKind.UNSPECIFIED;
        }
        if ((n5 & 0x40) != 0) {
            collection = CollectionsKt.emptyList();
        }
        this(string, n, n2, n3, n4, irLocationKind, collection);
    }

    @NotNull
    public final String getFilePath() {
        return this.filePath;
    }

    public final int getOffset1() {
        return this.offset1;
    }

    public final int getOffset2() {
        return this.offset2;
    }

    public final int getLine() {
        return this.line;
    }

    public final int getCol() {
        return this.col;
    }

    @NotNull
    public final IrLocationKind getKind() {
        return this.kind;
    }

    public IrLocation(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(name, -1, -1, -1, -1, null, null, 96, null);
    }

    @NotNull
    public final Map<IrLocationKind, IrLocation> getContainedLocations() {
        return this.containedLocations;
    }

    public String toString() {
        return this.offset1 == -1 ? new File(this.filePath).getName() : new File(this.filePath).getName() + ":" + this.line + ":" + this.col + "-" + (this.col + this.offset2 - this.offset1);
    }

    @NotNull
    public final String toLongString() {
        return this.offset1 == -1 ? this.filePath : this.filePath + ":" + this.line + ":" + this.col + "-" + (this.col + this.offset2 - this.offset1);
    }

    public final boolean isStub() {
        return this.offset1 == -1;
    }

    @Nullable
    public final IrLocation getLocationByType(@NotNull IrLocationKind kind) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        if (this.kind == kind) {
            return this;
        }
        IrLocation irLocation = this.containedLocations.get((Object)kind);
        return irLocation != null ? irLocation.getLocationByType(kind) : null;
    }

    @Override
    public int compareTo(@NotNull IrLocation other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int fileComparison = this.filePath.compareTo(other.filePath);
        return fileComparison != 0 ? fileComparison : this.offset1 - other.offset1;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof IrLocation && Intrinsics.areEqual((Object)this.filePath, (Object)((IrLocation)other).filePath) && this.offset1 == ((IrLocation)other).offset1 && this.offset2 == ((IrLocation)other).offset2 && this.kind == ((IrLocation)other).kind && Intrinsics.areEqual(this.containedLocations, ((IrLocation)other).containedLocations);
    }

    public final boolean contains(@NotNull IrLocation other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)this.filePath, (Object)other.filePath) && this.offset1 <= other.offset1 && other.offset2 <= this.offset2;
    }

    public final boolean contains(@NotNull String filePath, int offset) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return Intrinsics.areEqual((Object)this.filePath, (Object)filePath) && this.offset1 <= offset && offset <= this.offset2;
    }

    public int hashCode() {
        int result = 0;
        result = this.filePath.hashCode();
        result = 31 * result + this.offset1;
        result = 31 * result + this.offset2;
        result = 31 * result + this.kind.ordinal();
        Iterable $this$forEach$iv = this.containedLocations.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            IrLocationKind kind = (IrLocationKind)((Object)entry.getKey());
            IrLocation location = (IrLocation)entry.getValue();
            result = 31 * result + kind.ordinal();
            result = 31 * result + location.hashCode();
        }
        return result;
    }
}

