/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction.features.history;

import com.intellij.filePrediction.features.history.FileHistoryManager;
import com.intellij.filePrediction.features.history.FileHistoryPersistence;
import com.intellij.filePrediction.features.history.FilePredictionNGramFeatures;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0003\u0019\u001a\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002J\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/filePrediction/features/history/FileHistoryManagerWrapper;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "lazyManager", "Lkotlin/Lazy;", "Lcom/intellij/filePrediction/features/history/FileHistoryManager;", "getManagerIfInitialized", "calcNGramFeatures", "Lcom/intellij/filePrediction/features/history/FilePredictionNGramFeatures;", "candidates", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "calcNextFileProbability", "", "file", "onFileOpened", "", "onProjectClosed", "dispose", "Companion", "ProjectClosureListener", "EditorManagerListener", "intellij.platform.ml.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nFileHistoryManagerWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHistoryManagerWrapper.kt\ncom/intellij/filePrediction/features/history/FileHistoryManagerWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1586#2:78\n1661#2,3:79\n*S KotlinDebug\n*F\n+ 1 FileHistoryManagerWrapper.kt\ncom/intellij/filePrediction/features/history/FileHistoryManagerWrapper\n*L\n37#1:78\n37#1:79,3\n*E\n"})
public final class FileHistoryManagerWrapper
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final Lazy<FileHistoryManager> lazyManager;
    private static final int MAX_NGRAM_SEQUENCE = 3;

    public FileHistoryManagerWrapper(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"NextFilePrediction");
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createSequentialApplicationPoolExecutor(...)");
        this.executor = executorService;
        this.lazyManager = LazyKt.lazy(() -> FileHistoryManagerWrapper.lazyManager$lambda$0(this));
    }

    private final FileHistoryManager getManagerIfInitialized() {
        return this.lazyManager.isInitialized() ? (FileHistoryManager)this.lazyManager.getValue() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FilePredictionNGramFeatures calcNGramFeatures(@NotNull List<? extends VirtualFile> candidates) {
        FilePredictionNGramFeatures filePredictionNGramFeatures;
        FileHistoryManager managerIfInitialized;
        Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
        FileHistoryManager fileHistoryManager = managerIfInitialized = this.getManagerIfInitialized();
        if (fileHistoryManager != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = candidates;
            FileHistoryManager fileHistoryManager2 = fileHistoryManager;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getUrl());
            }
            filePredictionNGramFeatures = fileHistoryManager2.calcNGramFeatures((List)destination$iv$iv);
        } else {
            filePredictionNGramFeatures = null;
        }
        return filePredictionNGramFeatures;
    }

    public final double calcNextFileProbability(@NotNull VirtualFile file) {
        double d;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileHistoryManager fileHistoryManager = this.getManagerIfInitialized();
        if (fileHistoryManager != null) {
            String string = file.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            d = fileHistoryManager.calcNextFileProbability(string);
        } else {
            d = 0.0;
        }
        return d;
    }

    private final void onFileOpened(VirtualFile file) {
        if (ProjectManagerImpl.Companion.isLight(this.project)) {
            return;
        }
        this.executor.submit(() -> FileHistoryManagerWrapper.onFileOpened$lambda$0(this, file));
    }

    private final void onProjectClosed(Project project) {
        block0: {
            FileHistoryManager fileHistoryManager = this.getManagerIfInitialized();
            if (fileHistoryManager == null) break block0;
            fileHistoryManager.saveFileHistoryAsync(project);
        }
    }

    public void dispose() {
        this.executor.shutdown();
    }

    private static final FileHistoryManager lazyManager$lambda$0(FileHistoryManagerWrapper this$0) {
        return new FileHistoryManager(FileHistoryPersistence.INSTANCE.loadNGrams(this$0.project, 3));
    }

    private static final void onFileOpened$lambda$0$0(FileHistoryManagerWrapper this$0, VirtualFile $file) {
        FileHistoryManager fileHistoryManager = (FileHistoryManager)this$0.lazyManager.getValue();
        String string = $file.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        fileHistoryManager.onFileOpened(string);
    }

    private static final void onFileOpened$lambda$0(FileHistoryManagerWrapper this$0, VirtualFile $file) {
        BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this$0, () -> FileHistoryManagerWrapper.onFileOpened$lambda$0$0(this$0, $file));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/filePrediction/features/history/FileHistoryManagerWrapper$Companion;", "", "<init>", "()V", "MAX_NGRAM_SEQUENCE", "", "getInstance", "Lcom/intellij/filePrediction/features/history/FileHistoryManagerWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceIfCreated", "intellij.platform.ml.impl"})
    @SourceDebugExtension(value={"SMAP\nFileHistoryManagerWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHistoryManagerWrapper.kt\ncom/intellij/filePrediction/features/history/FileHistoryManagerWrapper$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,77:1\n30#2,2:78\n58#2:80\n*S KotlinDebug\n*F\n+ 1 FileHistoryManagerWrapper.kt\ncom/intellij/filePrediction/features/history/FileHistoryManagerWrapper$Companion\n*L\n24#1:78,2\n25#1:80\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FileHistoryManagerWrapper getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<FileHistoryManagerWrapper> serviceClass$iv = FileHistoryManagerWrapper.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (FileHistoryManagerWrapper)object;
        }

        @Nullable
        public final FileHistoryManagerWrapper getInstanceIfCreated(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project;
            boolean $i$f$serviceIfCreated = false;
            return (FileHistoryManagerWrapper)$this$serviceIfCreated$iv.getServiceIfCreated(FileHistoryManagerWrapper.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/filePrediction/features/history/FileHistoryManagerWrapper$EditorManagerListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "<init>", "()V", "selectionChanged", "", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "intellij.platform.ml.impl"})
    public static final class EditorManagerListener
    implements FileEditorManagerListener {
        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            VirtualFile virtualFile = event.getNewFile();
            if (virtualFile == null) {
                return;
            }
            VirtualFile newFile = virtualFile;
            Project project = event.getManager().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Companion.getInstance(project).onFileOpened(newFile);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/filePrediction/features/history/FileHistoryManagerWrapper$ProjectClosureListener;", "Lcom/intellij/openapi/project/ProjectCloseListener;", "<init>", "()V", "projectClosing", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ml.impl"})
    public static final class ProjectClosureListener
    implements ProjectCloseListener {
        public void projectClosing(@NotNull Project project) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                FileHistoryManagerWrapper fileHistoryManagerWrapper = Companion.getInstanceIfCreated(project);
                if (fileHistoryManagerWrapper == null) break block0;
                fileHistoryManagerWrapper.onProjectClosed(project);
            }
        }
    }
}

