/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.toolwindow;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.logging.LogConsoleBase;
import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.devkit.actions.CleanupEventsTestSchemeAction;
import com.intellij.internal.statistic.devkit.actions.ConfigureEventsSchemeFileAction;
import com.intellij.internal.statistic.devkit.actions.GenerateEventsScheme;
import com.intellij.internal.statistic.devkit.actions.OpenEventLogFileAction;
import com.intellij.internal.statistic.devkit.actions.OpenEventsSchemeFileAction;
import com.intellij.internal.statistic.devkit.actions.RecordStateStatisticsEventLogAction;
import com.intellij.internal.statistic.devkit.actions.ShowChangedStateEventsAction;
import com.intellij.internal.statistic.devkit.actions.UpdateEventsSchemeAction;
import com.intellij.internal.statistic.devkit.actions.scheme.AddGroupToTestSchemeAction;
import com.intellij.internal.statistic.devkit.actions.scheme.EditEventsTestSchemeAction;
import com.intellij.internal.statistic.devkit.toolwindow.StatisticsEventLogConsole;
import com.intellij.internal.statistic.devkit.toolwindow.StatisticsEventLogFormatter;
import com.intellij.internal.statistic.devkit.toolwindow.StatisticsEventLogMessageBuilder;
import com.intellij.internal.statistic.devkit.toolwindow.StatisticsEventLogToolWindow;
import com.intellij.internal.statistic.devkit.toolwindow.StatisticsLogFilterModel;
import com.intellij.internal.statistic.devkit.toolwindow.StatisticsMultilineLogToggleAction;
import com.intellij.internal.statistic.eventLog.EventLogListenersManager;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogListener;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.JBColor;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogToolWindow;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "recorderId", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "consoleLog", "Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogConsole;", "messageBuilder", "Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogMessageBuilder;", "eventLogListener", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogListener;", "createActionToolbar", "Ljavax/swing/JComponent;", "createFilter", "Lcom/intellij/ui/FilterComponent;", "model", "Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsLogFilterModel;", "dispose", "", "Companion", "intellij.platform.statistics.devkit"})
@SourceDebugExtension(value={"SMAP\nStatisticsEventLogToolWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatisticsEventLogToolWindow.kt\ncom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogToolWindow\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,142:1\n42#2,3:143\n42#2,3:146\n*S KotlinDebug\n*F\n+ 1 StatisticsEventLogToolWindow.kt\ncom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogToolWindow\n*L\n70#1:143,3\n107#1:146,3\n*E\n"})
public final class StatisticsEventLogToolWindow
extends SimpleToolWindowPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String recorderId;
    @NotNull
    private final StatisticsEventLogConsole consoleLog;
    @NotNull
    private final StatisticsEventLogMessageBuilder messageBuilder;
    @NotNull
    private final StatisticsEventLogListener eventLogListener;
    @NotNull
    private static final Set<ValidationResultType> rejectedValidationTypes;
    @NotNull
    private static final Set<String> alertEvents;

    public StatisticsEventLogToolWindow(@NotNull Project project, @NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        super(false, true);
        this.recorderId = recorderId;
        this.messageBuilder = new StatisticsEventLogMessageBuilder();
        StatisticsLogFilterModel model = new StatisticsLogFilterModel();
        StatisticsEventLogFormatter logFormatter = new StatisticsEventLogFormatter(model);
        this.consoleLog = new StatisticsEventLogConsole(project, model, this.recorderId, logFormatter);
        this.eventLogListener = new StatisticsEventLogListener(){

            public void onLogEvent(LogEvent validatedEvent, String rawEventId, Map<String, ? extends Object> rawData) {
                Intrinsics.checkNotNullParameter((Object)validatedEvent, (String)"validatedEvent");
                ApplicationManager.getApplication().invokeLater(() -> 1.onLogEvent$lambda$0(this, validatedEvent, rawEventId, rawData));
            }

            private static final void onLogEvent$lambda$0(StatisticsEventLogToolWindow this$0, LogEvent $validatedEvent, String $rawEventId, Map $rawData) {
                String message = this$0.messageBuilder.buildLogMessage($validatedEvent, $rawEventId, $rawData);
                this$0.consoleLog.addLogLine(message);
            }
        };
        JPanel topPanel = new JPanel(new FlowLayout(0, 5, 0));
        topPanel.add((Component)this.createFilter(project, model));
        topPanel.add(this.createActionToolbar());
        topPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, JBColor.border()));
        this.add(topPanel, "North");
        this.setContent(this.consoleLog.getComponent());
        DefaultActionGroup verticalActionGroup = new DefaultActionGroup();
        AnAction[] anActionArray = this.consoleLog.getConsoleNotNull().createConsoleActions();
        Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"createConsoleActions(...)");
        verticalActionGroup.addAll((Collection)ArraysKt.toList((Object[])anActionArray));
        verticalActionGroup.add((AnAction)new StatisticsMultilineLogToggleAction(this.consoleLog));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("FusEventLogToolWindow", (ActionGroup)verticalActionGroup, false);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar verticalToolbar = actionToolbar;
        verticalToolbar.setTargetComponent((JComponent)((Object)this));
        this.setToolbar(verticalToolbar.getComponent());
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.consoleLog));
        boolean $i$f$service = false;
        Class<EventLogListenersManager> serviceClass$iv = EventLogListenersManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ((EventLogListenersManager)object).subscribe(this.eventLogListener, this.recorderId);
    }

    private final JComponent createActionToolbar() {
        DefaultActionGroup topToolbarActions = new DefaultActionGroup();
        topToolbarActions.add((AnAction)new RecordStateStatisticsEventLogAction(this.recorderId, false));
        topToolbarActions.add((AnAction)new ShowChangedStateEventsAction(this.recorderId));
        topToolbarActions.add((AnAction)new OpenEventLogFileAction(this.recorderId));
        topToolbarActions.addSeparator(StatisticsBundle.message((String)"stats.events.scheme", (Object[])new Object[0]));
        topToolbarActions.add((AnAction)new ConfigureEventsSchemeFileAction(this.recorderId));
        topToolbarActions.add((AnAction)new UpdateEventsSchemeAction(this.recorderId));
        topToolbarActions.add((AnAction)new OpenEventsSchemeFileAction(this.recorderId));
        topToolbarActions.addSeparator(StatisticsBundle.message((String)"stats.events.test.scheme", (Object[])new Object[0]));
        topToolbarActions.add((AnAction)new AddGroupToTestSchemeAction(this.recorderId));
        topToolbarActions.add((AnAction)new CleanupEventsTestSchemeAction(this.recorderId));
        topToolbarActions.add((AnAction)new EditEventsTestSchemeAction(this.recorderId));
        topToolbarActions.add((AnAction)new GenerateEventsScheme(this.recorderId));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("FusEventLogToolWindow", (ActionGroup)topToolbarActions, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar toolbar = actionToolbar;
        toolbar.setShowSeparatorTitles(true);
        toolbar.setTargetComponent((JComponent)((Object)this));
        JComponent jComponent = toolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    private final FilterComponent createFilter(Project project, StatisticsLogFilterModel model) {
        return new FilterComponent(project, model){
            final /* synthetic */ Project $project;
            final /* synthetic */ StatisticsLogFilterModel $model;
            {
                this.$project = $project;
                this.$model = $model;
                super("STATISTICS_EVENT_LOG_FILTER_HISTORY", 5);
            }

            public void filter() {
                String string = LogConsoleBase.getApplyingFilterTitle();
                Task.Backgroundable task2 = new Task.Backgroundable(this.$project, this.$model, this, string){
                    final /* synthetic */ StatisticsLogFilterModel $model;
                    final /* synthetic */ createFilter.1 this$0;
                    {
                        this.$model = $model;
                        this.this$0 = $receiver;
                        super($project, $super_call_param$1);
                    }

                    public void run(ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        String string = this.this$0.getFilter();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFilter(...)");
                        this.$model.updateCustomFilter(string);
                    }
                };
                ProgressManager.getInstance().run((Task)task2);
            }
        };
    }

    public void dispose() {
        boolean $i$f$service = false;
        Class<EventLogListenersManager> serviceClass$iv = EventLogListenersManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ((EventLogListenersManager)object).unsubscribe(this.eventLogListener, this.recorderId);
    }

    static {
        Object[] objectArray = new ValidationResultType[]{ValidationResultType.REJECTED, ValidationResultType.INCORRECT_RULE, ValidationResultType.UNDEFINED_RULE, ValidationResultType.UNREACHABLE_METADATA, ValidationResultType.UNREACHABLE_METADATA_OBSOLETE, ValidationResultType.PERFORMANCE_ISSUE, ValidationResultType.REQUIRED_FIELD_MISSED, ValidationResultType.DICTIONARY_NOT_FOUND, ValidationResultType.GENERAL_DICTIONARY_ERROR};
        rejectedValidationTypes = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"validation.too_many_events.alert", "validation.too_many_events"};
        alertEvents = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogToolWindow$Companion;", "", "<init>", "()V", "rejectedValidationTypes", "", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationResultType;", "getRejectedValidationTypes$annotations", "getRejectedValidationTypes", "()Ljava/util/Set;", "alertEvents", "", "getAlertEvents", "intellij.platform.statistics.devkit"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<ValidationResultType> getRejectedValidationTypes() {
            return rejectedValidationTypes;
        }

        public static /* synthetic */ void getRejectedValidationTypes$annotations() {
        }

        @NotNull
        public final Set<String> getAlertEvents() {
            return alertEvents;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

