/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.core.linemarker;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ConstantFunction;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.List;
import javax.swing.Icon;

public final class SimpleLineMarker {
    public static LineMarkerInfo<PsiElement> create(PsiElement element, PsiElement target, Icon icon, @NlsContexts.Tooltip String tooltip) {
        List targets = ContainerUtil.createMaybeSingletonList((Object)target);
        return SimpleLineMarker.create(element, icon, tooltip, targets);
    }

    public static LineMarkerInfo<PsiElement> create(PsiElement element, Icon icon, @NlsContexts.Tooltip String tooltip, List<? extends PsiElement> targets) {
        PsiElement correctElement = SimpleLineMarker.getCorrectTargetElement(element);
        ConstantFunction converter = new ConstantFunction(targets);
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)icon, (NotNullFunction)converter);
        builder.setTarget((Object)correctElement);
        builder.setTooltipText(tooltip);
        builder.setAlignment(GutterIconRenderer.Alignment.LEFT);
        return builder.createLineMarkerInfo(correctElement);
    }

    private static PsiElement getCorrectTargetElement(PsiElement element) {
        if (element.getFirstChild() == null) {
            return element;
        }
        if (element instanceof XmlElement) {
            XmlToken tokenOfType = XmlUtil.getTokenOfType((PsiElement)element, (IElementType)XmlTokenType.XML_NAME);
            if (tokenOfType == null) {
                tokenOfType = XmlUtil.getTokenOfType((PsiElement)element, (IElementType)XmlTokenType.XML_TAG_NAME);
            }
            return tokenOfType;
        }
        return element;
    }
}

