/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.generator;

import com.google.common.collect.ComparisonChain;
import com.intellij.java.JavaBundle;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.generator.InsertPosition;
import com.intellij.jpa.jpb.model.generator.JpabObjectMethodsTemplatesManager;
import com.intellij.jpa.jpb.model.model.EmbeddedID;
import com.intellij.jpa.jpb.model.model.EntityKey;
import com.intellij.jpa.jpb.model.model.SourceLanguage;
import com.intellij.jpa.jpb.model.reference.TemplateHelper;
import com.intellij.jpa.jpb.model.util.HEditorUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.generate.GenerationUtil;
import org.jetbrains.java.generate.element.ElementUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ,2\u00020\u0001:\u0001,B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\n\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u0002J \u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u0018\u0010$\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\n\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0012\u0010'\u001a\u00020\u001f2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J\b\u0010*\u001a\u00020+H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/jpa/jpb/model/generator/JpabToStringGenerator;", "", "project", "Lcom/intellij/openapi/project/Project;", "psiClass", "Lcom/intellij/psi/PsiClass;", "keyFields", "", "Lcom/intellij/jpa/jpb/model/model/EntityKey;", "fields", "Lcom/intellij/psi/PsiField;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiClass;Ljava/util/List;Ljava/util/List;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "classPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "templateHelper", "Lcom/intellij/jpa/jpb/model/reference/TemplateHelper;", "factory", "Lcom/intellij/psi/PsiElementFactory;", "javaCodeStyleManager", "Lcom/intellij/psi/codeStyle/JavaCodeStyleManager;", "codeStyleManager", "Lcom/intellij/psi/codeStyle/CodeStyleManager;", "embeddedID", "Lcom/intellij/jpa/jpb/model/model/EmbeddedID;", "initEmbeddedId", "write", "", "askToRemove", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "insertPosition", "Lcom/intellij/jpa/jpb/model/generator/InsertPosition;", "checkForEmbeddedId", "generateToSting", "Lcom/intellij/psi/PsiElement;", "deleteExistingMethod", "existingMethod", "Lcom/intellij/psi/PsiMethod;", "getToStringSignature", "Lcom/intellij/psi/util/MethodSignature;", "Companion", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nJpabToStringGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpabToStringGenerator.kt\ncom/intellij/jpa/jpb/model/generator/JpabToStringGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n296#2,2:153\n1391#2:155\n1480#2,5:156\n1807#2,3:161\n*S KotlinDebug\n*F\n+ 1 JpabToStringGenerator.kt\ncom/intellij/jpa/jpb/model/generator/JpabToStringGenerator\n*L\n39#1:153,2\n105#1:155\n105#1:156,5\n108#1:161,3\n*E\n"})
public final class JpabToStringGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final List<EntityKey> keyFields;
    @NotNull
    private final List<PsiField> fields;
    @NotNull
    private final SmartPsiElementPointer<PsiClass> classPointer;
    @NotNull
    private final TemplateHelper templateHelper;
    @NotNull
    private final PsiElementFactory factory;
    @NotNull
    private final JavaCodeStyleManager javaCodeStyleManager;
    @NotNull
    private final CodeStyleManager codeStyleManager;
    @Nullable
    private final EmbeddedID embeddedID;
    @NotNull
    public static final String EMBEDDED = "embedded";
    @NotNull
    public static final String ENTITY_NAME = "entityName";
    @NotNull
    private static final Logger LOG;

    public JpabToStringGenerator(@NotNull Project project, @NotNull PsiClass psiClass, @NotNull List<? extends EntityKey> keyFields, @NotNull List<? extends PsiField> fields) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Intrinsics.checkNotNullParameter(keyFields, (String)"keyFields");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        this.project = project;
        this.keyFields = keyFields;
        this.fields = fields;
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)psiClass));
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        this.classPointer = smartPsiElementPointer;
        Object t = TemplateHelper.Companion.getInstance((PsiElement)psiClass);
        Intrinsics.checkNotNull(t);
        this.templateHelper = (TemplateHelper)t;
        PsiElementFactory psiElementFactory = JavaPsiFacade.getElementFactory((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementFactory, (String)"getElementFactory(...)");
        this.factory = psiElementFactory;
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)javaCodeStyleManager, (String)"getInstance(...)");
        this.javaCodeStyleManager = javaCodeStyleManager;
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleManager, (String)"getInstance(...)");
        this.codeStyleManager = codeStyleManager;
        this.embeddedID = this.initEmbeddedId();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final EmbeddedID initEmbeddedId() {
        Object v0;
        block3: {
            Iterable $this$firstOrNull$iv = this.keyFields;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                EntityKey it = (EntityKey)element$iv;
                boolean bl = false;
                if (!(it instanceof EmbeddedID)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        EntityKey entityKey = v0;
        if (entityKey == null) {
            return null;
        }
        EntityKey key = entityKey;
        if (CollectionsKt.contains((Iterable)this.fields, (Object)key.getIdMembers().get(0))) {
            return (EmbeddedID)key;
        }
        return null;
    }

    public final void write(boolean askToRemove, @NotNull Editor editor, @NotNull InsertPosition insertPosition) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)insertPosition), (String)"insertPosition");
        PsiClass psiClass = (PsiClass)this.classPointer.getElement();
        if (psiClass == null) {
            return;
        }
        PsiClass psiClass2 = psiClass;
        Ref.ObjectRef existingMethod = new Ref.ObjectRef();
        existingMethod.element = MethodSignatureUtil.findMethodBySignature((PsiClass)psiClass2, (MethodSignature)this.getToStringSignature(), (boolean)false);
        if (existingMethod.element != null && !this.templateHelper.isMethodPhysical((PsiMethod)existingMethod.element)) {
            existingMethod.element = null;
        }
        this.checkForEmbeddedId(editor, InsertPosition.Last);
        Ref.BooleanRef deleteExisting = new Ref.BooleanRef();
        if (askToRemove) {
            deleteExisting.element = this.deleteExistingMethod((PsiMethod)existingMethod.element);
            if (existingMethod.element != null && !deleteExisting.element) {
                return;
            }
        }
        WriteCommandAction.runWriteCommandAction((Project)this.project, () -> JpabToStringGenerator.write$lambda$0(deleteExisting, askToRemove, existingMethod, this, editor, psiClass2, insertPosition));
    }

    public static /* synthetic */ void write$default(JpabToStringGenerator jpabToStringGenerator, boolean bl, Editor editor, InsertPosition insertPosition, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        jpabToStringGenerator.write(bl, editor, insertPosition);
    }

    private final void checkForEmbeddedId(Editor editor, InsertPosition insertPosition) {
        EmbeddedID embeddedID = this.embeddedID;
        if (embeddedID == null || (embeddedID = embeddedID.getKeyClass()) == null) {
            return;
        }
        EmbeddedID embClass = embeddedID;
        PsiMethod existingMethod = MethodSignatureUtil.findMethodBySignature((PsiClass)embClass, (MethodSignature)this.getToStringSignature(), (boolean)false);
        if (existingMethod == null) {
            boolean isGenerate;
            Object[] objectArray = new Object[1];
            String string = embClass.getName();
            if (string == null) {
                string = "";
            }
            objectArray[0] = string;
            boolean bl = isGenerate = Messages.showYesNoDialog((Project)this.project, (String)JpaModelBundle.message("generate.tostring.composite.warning", objectArray), (String)JavaBundle.message((String)"generate.tostring.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
            if (isGenerate) {
                List list = CollectionsKt.emptyList();
                PsiField[] psiFieldArray = embClass.getAllFields();
                Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getAllFields(...)");
                new JpabToStringGenerator(this.project, (PsiClass)embClass, list, ArraysKt.toList((Object[])psiFieldArray)).write(false, editor, insertPosition);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final PsiElement generateToSting() {
        Object object;
        Map field;
        boolean useAccessors;
        List selectedFields;
        HashMap contextMap;
        PsiClass psiClass;
        block8: {
            void $this$flatMapTo$iv$iv;
            PsiClass psiClass2 = (PsiClass)this.classPointer.getElement();
            if (psiClass2 == null) {
                return null;
            }
            psiClass = psiClass2;
            contextMap = new HashMap();
            selectedFields = new ArrayList();
            Iterable $this$flatMap$iv = this.keyFields;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                EntityKey it = (EntityKey)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getIdMembers();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List idFields = (List)destination$iv$iv;
            selectedFields.addAll((Collection)this.fields);
            CollectionsKt.sortWith((List)selectedFields, (arg_0, arg_1) -> JpabToStringGenerator.generateToSting$lambda$2((arg_0, arg_1) -> JpabToStringGenerator.generateToSting$lambda$1(idFields, arg_0, arg_1), arg_0, arg_1));
            Iterable $this$any$iv = selectedFields;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiField it = (PsiField)element$iv;
                    boolean bl = false;
                    if (!(psiClass instanceof PsiClassImpl && it.hasModifierProperty("private") && !Intrinsics.areEqual((Object)it.getContainingClass(), (Object)psiClass))) continue;
                    v1 = true;
                    break block8;
                }
                v1 = useAccessors = false;
            }
        }
        if (this.embeddedID != null) {
            field = this.embeddedID.getIdMembers().get(0);
            TypeIntrinsics.asMutableCollection((Object)selectedFields).remove(field);
            Map map = contextMap;
            object = EMBEDDED;
            Object e = ElementUtils.getOnlyAsFieldAndMethodElements((Collection)CollectionsKt.listOf((Object)field), (Collection)CollectionsKt.emptyList(), (boolean)useAccessors).get(0);
            map.put(object, e);
        }
        field = contextMap;
        String string = ENTITY_NAME;
        String string2 = psiClass.getName();
        if (string2 == null) {
            return null;
        }
        object = string2;
        field.put(string, object);
        Collection collection = selectedFields;
        Collection collection2 = SetsKt.emptySet();
        Map map = new LinkedHashMap();
        Map map2 = contextMap;
        SourceLanguage sourceLanguage = SourceLanguage.from((PsiElement)psiClass);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sourceLanguage), (String)"from(...)");
        String methodText = GenerationUtil.velocityGenerateCode((PsiClass)psiClass, (Collection)collection, (Collection)collection2, (Map)map, (Map)map2, (String)JpabObjectMethodsTemplatesManager.INSTANCE.getToStringTemplate(sourceLanguage).getTemplate(), (int)0, (boolean)false, (boolean)useAccessors);
        Intrinsics.checkNotNull((Object)methodText);
        PsiElement psiElement = this.templateHelper.createMethodFromText(methodText, psiClass);
        if (psiElement == null) {
            return null;
        }
        return psiElement;
    }

    private final boolean deleteExistingMethod(PsiMethod existingMethod) {
        PsiClass psiClass = (PsiClass)this.classPointer.getElement();
        if (psiClass == null) {
            return false;
        }
        PsiClass psiClass2 = psiClass;
        if (existingMethod != null) {
            Object[] objectArray = new Object[1];
            String string = psiClass2.getQualifiedName();
            if (string == null) {
                string = "";
            }
            objectArray[0] = string;
            String string2 = JpaModelBundle.message("generate.tostring.already.defined.warning", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            String text = string2;
            return Messages.showYesNoDialog((Project)this.project, (String)text, (String)JpaModelBundle.message("generate.tostring.already.defined.title", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
        }
        return false;
    }

    private final MethodSignature getToStringSignature() {
        MethodSignature methodSignature = MethodSignatureUtil.createMethodSignature((String)"toString", (PsiType[])PsiType.EMPTY_ARRAY, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)methodSignature, (String)"createMethodSignature(...)");
        return methodSignature;
    }

    private static final void write$lambda$0(Ref.BooleanRef $deleteExisting, boolean $askToRemove, Ref.ObjectRef $existingMethod, JpabToStringGenerator this$0, Editor $editor, PsiClass $psiClass, InsertPosition $insertPosition) {
        if ($deleteExisting.element && $askToRemove && $existingMethod.element != null) {
            this$0.templateHelper.deleteMethod((PsiMethod)$existingMethod.element);
        }
        try {
            if ($existingMethod.element == null || !((PsiMethod)$existingMethod.element).isPhysical()) {
                Editor editor;
                PsiElement psiElement = this$0.generateToSting();
                if (psiElement == null) {
                    return;
                }
                PsiElement method = psiElement;
                Editor $this$write_u24lambda_u240_u240 = editor = $editor;
                boolean bl = false;
                Project project = $this$write_u24lambda_u240_u240.getProject();
                Intrinsics.checkNotNull((Object)project);
                PsiElement psiElement2 = CodeStyleManager.getInstance((Project)project).reformat(method);
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"reformat(...)");
                PsiElement element = psiElement2;
                int caretOffset = HEditorUtil.Companion.getCaretOffset($psiClass, $editor, $insertPosition);
                PsiElement psiElement3 = this$0.templateHelper.addElementToClass($psiClass, element, caretOffset);
                if (psiElement3 != null) {
                    element = psiElement3;
                    PsiElement psiElement4 = this$0.templateHelper.shortenReferences(element);
                    if (psiElement4 != null) {
                        element = psiElement4;
                        this$0.templateHelper.trimSpaces(element);
                        $this$write_u24lambda_u240_u240.getCaretModel().moveToOffset(element.getTextOffset());
                        $this$write_u24lambda_u240_u240.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                    }
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static final int generateToSting$lambda$1(List $idFields, PsiField o1, PsiField o2) {
        return ComparisonChain.start().compareTrueFirst($idFields.contains(o1), $idFields.contains(o2)).result();
    }

    private static final int generateToSting$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    static {
        Logger logger = Logger.getInstance(JpabToStringGenerator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/jpa/jpb/model/generator/JpabToStringGenerator$Companion;", "", "<init>", "()V", "EMBEDDED", "", "ENTITY_NAME", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.javaee.jpa.jpb.model"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

