/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.ptable;

import com.intellij.jpa.jpb.model.ui.SSwingUtilKt;
import com.intellij.jpa.jpb.model.ui.ptable.GroupPanel;
import com.intellij.jpa.jpb.model.ui.ptable.PNameRenderer;
import com.intellij.jpa.jpb.model.ui.ptable.PTable;
import com.intellij.jpa.jpb.model.ui.ptable.PTableCellRenderer;
import com.intellij.jpa.jpb.model.ui.ptable.PTableItem;
import com.intellij.jpa.jpb.model.ui.ptable.PTableRenderUtils;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0016\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J<\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0011H\u0014J&\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014J$\u0010\u001c\u001a\u00020\u00142\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014J\u001e\u0010\u001d\u001a\u00020\u00142\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\b\b\u0001\u0010\u001e\u001a\u00020\u001fH\u0014J\u0018\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0011H\u0016J$\u0010#\u001a\u00020\u000e2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0011H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/jpa/jpb/model/ui/ptable/GroupRenderer;", "Lcom/intellij/jpa/jpb/model/ui/ptable/PTableCellRenderer;", "Lcom/intellij/jpa/jpb/model/ui/ptable/PNameRenderer;", "<init>", "()V", "myPanel", "Lcom/intellij/jpa/jpb/model/ui/ptable/GroupPanel;", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "hasFocus", "row", "", "column", "customizeCellRenderer", "", "Lcom/intellij/jpa/jpb/model/ui/ptable/PTable;", "item", "Lcom/intellij/jpa/jpb/model/ui/ptable/PTableItem;", "selected", "col", "getIconForTableItem", "Ljavax/swing/Icon;", "setIcon", "setText", "abbreviatedText", "", "hitTestStarIcon", "x", "y", "hitTestTreeNodeIcon", "Companion", "intellij.javaee.jpa.jpb.model.ui"})
public class GroupRenderer
extends PTableCellRenderer
implements PNameRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GroupPanel myPanel = new GroupPanel();
    private static final int BEFORE_STAR_SPACING = SSwingUtilKt.getScaled(2);

    public GroupRenderer() {
        this.myPanel.add((Component)((Object)this), "Center");
    }

    @Override
    @NotNull
    public Component getTableCellRendererComponent(@NotNull JTable table, @NotNull Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.myPanel.setBackground(this.getBackground());
        return this.myPanel;
    }

    protected void customizeCellRenderer(@NotNull PTable table, @NotNull PTableItem<?> item, boolean selected, boolean hasFocus, int row, int col) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        Intrinsics.checkNotNullParameter(item, (String)"item");
        if (item.getParent() != null) {
            PTableItem pTableItem = item.getParent();
            Intrinsics.checkNotNull((Object)pTableItem);
            string = pTableItem.getChildLabel(item);
        } else {
            string = item.getName();
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String text = string2;
        String abbreviatedText = PTableRenderUtils.getAbbreviatedText((JTable)((Object)table), col, text, item);
        this.myPanel.setTooltipProvider((Function0<String>)((Function0)() -> GroupRenderer.customizeCellRenderer$lambda$0(item, text, abbreviatedText)));
        this.setText(item, abbreviatedText);
        this.setIcon(item, selected, hasFocus);
        this.setPaintFocusBorder(false);
        this.setFocusBorderAroundIcon(true);
    }

    @Nullable
    protected Icon getIconForTableItem(@NotNull PTableItem<?> item, boolean selected, boolean hasFocus) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        if (item.hasChildren()) {
            return UIUtil.getTreeNodeIcon((boolean)item.isExpanded(), (boolean)selected, (boolean)hasFocus);
        }
        return null;
    }

    protected void setIcon(@NotNull PTableItem<?> item, boolean selected, boolean hasFocus) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        Icon icon = this.getIconForTableItem(item, selected, hasFocus);
        int indent = 0;
        int textGap = 0;
        if (icon == null) {
            if (PTableRenderUtils.getDepth(item) > 0) {
                indent = PTableRenderUtils.getIconWithSpacingWidth(item);
            }
            textGap = 0;
        } else {
            indent = PTableRenderUtils.getBeforeIconSpacing(PTableRenderUtils.getDepth(item), icon.getIconWidth());
            textGap = PTableRenderUtils.getAfterIconSpacing(icon.getIconWidth());
        }
        super.setIcon(icon);
        this.setIconTextGap(textGap);
        this.setIpad((Insets)JBUI.insetsLeft((int)indent));
    }

    protected void setText(@NotNull PTableItem<?> item, @Nls @NotNull String abbreviatedText) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)abbreviatedText, (String)"abbreviatedText");
        this.append(abbreviatedText, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    @Override
    public boolean hitTestStarIcon(int x, int y) {
        return false;
    }

    public boolean hitTestTreeNodeIcon(@NotNull PTableItem<?> item, int x, int y) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        Icon icon = UIUtil.getTreeNodeIcon((boolean)item.isExpanded(), (boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getTreeNodeIcon(...)");
        Icon icon2 = icon;
        int beforeIcon = BEFORE_STAR_SPACING + PTableRenderUtils.getBeforeIconSpacing(PTableRenderUtils.getDepth(item), icon2.getIconWidth());
        return x >= beforeIcon && x <= beforeIcon + icon2.getIconWidth();
    }

    private static final String customizeCellRenderer$lambda$0(PTableItem $item, String $text, String $abbreviatedText) {
        CharSequence charSequence = $item.getTooltipText();
        return !(charSequence == null || charSequence.length() == 0) ? $item.getTooltipText() : (!Intrinsics.areEqual((Object)$text, (Object)$abbreviatedText) ? $text : null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/jpa/jpb/model/ui/ptable/GroupRenderer$Companion;", "", "<init>", "()V", "BEFORE_STAR_SPACING", "", "intellij.javaee.jpa.jpb.model.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

